/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mm.opensdk.modelmsg;

import android.os.Bundle;
import com.tencent.mm.opensdk.modelmsg.WXMediaMessage;
import com.tencent.mm.opensdk.utils.Log;
import java.io.File;

public class WXVideoFileObject
implements WXMediaMessage.IMediaObject {
    private static final String TAG = "MicroMsg.SDK.WXVideoFileObject";
    private static final int FILE_SIZE_LIMIT = 0xA00000;
    public String filePath;

    public WXVideoFileObject() {
        this.filePath = null;
    }

    public WXVideoFileObject(String string) {
        this.filePath = string;
    }

    @Override
    public void serialize(Bundle bundle) {
        bundle.putString("_wxvideofileobject_filePath", this.filePath);
    }

    @Override
    public void unserialize(Bundle bundle) {
        this.filePath = bundle.getString("_wxvideofileobject_filePath");
    }

    @Override
    public int type() {
        return 38;
    }

    @Override
    public boolean checkArgs() {
        if (this.filePath == null || this.filePath.length() == 0) {
            Log.e(TAG, "checkArgs fail, filePath is null");
            return false;
        }
        if (this.getFileSize(this.filePath) > 0xA00000) {
            Log.e(TAG, "checkArgs fail, video file size is too large");
            return false;
        }
        return true;
    }

    private int getFileSize(String object) {
        if (object == null || ((String)object).length() == 0) {
            return 0;
        }
        if (!((File)(object = new File((String)object))).exists()) {
            return 0;
        }
        return (int)((File)object).length();
    }
}

