/*
 * Decompiled with CFR 0.152.
 */
package tinker.net.dongliu.apk.parser.struct.resource;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import tinker.net.dongliu.apk.parser.struct.StringPool;
import tinker.net.dongliu.apk.parser.struct.resource.ResourcePackage;
import tinker.net.dongliu.apk.parser.utils.ResourceLoader;

public class ResourceTable {
    private Map<Short, ResourcePackage> packageMap = new HashMap<Short, ResourcePackage>();
    private Map<String, ResourcePackage> packageNameMap = new HashMap<String, ResourcePackage>();
    private ByteBuffer buffer;
    private StringPool stringPool;
    private long fileSize;
    public static Map<Integer, String> sysStyle = ResourceLoader.loadSystemStyles();

    public void addPackage(ResourcePackage resourcePackage) {
        this.packageMap.put(resourcePackage.getId(), resourcePackage);
        this.packageNameMap.put(resourcePackage.getName(), resourcePackage);
    }

    public Map<String, ResourcePackage> getPackageNameMap() {
        return this.packageNameMap;
    }

    public ResourcePackage getPackage(short id) {
        return this.packageMap.get(id);
    }

    public StringPool getStringPool() {
        return this.stringPool;
    }

    public void setStringPool(StringPool stringPool) {
        this.stringPool = stringPool;
    }

    public void setFileSize(long size) {
        this.fileSize = size;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public ByteBuffer getBuffers() {
        return this.buffer;
    }

    public void setBuffers(ByteBuffer buffers) {
        this.buffer = buffers;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ResourceTable) {
            ResourceTable oldResourceTable = (ResourceTable)object;
            if (this.fileSize != oldResourceTable.getFileSize()) {
                System.out.println("ApkParser: resources.arsc is not equal, reason: file size is changed");
                return false;
            }
            if (!this.stringPool.equals(oldResourceTable.getStringPool())) {
                System.out.println("ApkParser: resources.arsc is not equal, reason: string pool is changed");
                return false;
            }
            Map<String, ResourcePackage> oldPackageNameMap = oldResourceTable.getPackageNameMap();
            if (this.packageNameMap.size() != oldPackageNameMap.size()) {
                System.out.println("ApkParser: resources.arsc is not equal, reason: package size is changed");
                return false;
            }
            for (String packageName : this.packageNameMap.keySet()) {
                if (!oldPackageNameMap.containsKey(packageName)) {
                    System.out.println("ApkParser: resources.arsc is not equal, reason: package name is not the same");
                    return false;
                }
                if (this.packageNameMap.get(packageName).equals(oldPackageNameMap.get(packageName))) continue;
                System.out.println("ApkParser: resources.arsc is not equal, reason: package is not equal");
                return false;
            }
            return true;
        }
        return false;
    }
}

