/*
 * Decompiled with CFR 0.152.
 */
package tinker.net.dongliu.apk.parser.struct.resource;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import tinker.net.dongliu.apk.parser.struct.StringPool;
import tinker.net.dongliu.apk.parser.struct.resource.PackageHeader;
import tinker.net.dongliu.apk.parser.struct.resource.Type;
import tinker.net.dongliu.apk.parser.struct.resource.TypeSpec;

public class ResourcePackage {
    private String name;
    private short id;
    private StringPool typeStringPool;
    private StringPool keyStringPool;
    private Map<Short, TypeSpec> typeSpecMap = new HashMap<Short, TypeSpec>();
    private Map<String, TypeSpec> typeSpecNameMap = new HashMap<String, TypeSpec>();
    private Map<Short, List<Type>> typesMap = new HashMap<Short, List<Type>>();
    private Map<String, List<Type>> typesNameMap = new HashMap<String, List<Type>>();

    public ResourcePackage(PackageHeader header) {
        this.name = header.getName();
        this.id = (short)header.getId();
    }

    public void addTypeSpec(TypeSpec typeSpec) {
        this.typeSpecMap.put(typeSpec.getId(), typeSpec);
        this.typeSpecNameMap.put(typeSpec.getName(), typeSpec);
    }

    public Map<String, TypeSpec> getTypeSpecNameMap() {
        return this.typeSpecNameMap;
    }

    public Map<String, List<Type>> getTypesNameMap() {
        return this.typesNameMap;
    }

    public TypeSpec getTypeSpec(Short id) {
        return this.typeSpecMap.get(id);
    }

    public void addType(Type type) {
        List<Type> types = this.typesMap.get(type.getId());
        if (types == null) {
            types = new ArrayList<Type>();
            this.typesMap.put(type.getId(), types);
            this.typesNameMap.put(type.getName(), types);
        }
        types.add(type);
    }

    public List<Type> getTypes(Short id) {
        return this.typesMap.get(id);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public short getId() {
        return this.id;
    }

    public void setId(short id) {
        this.id = id;
    }

    public StringPool getTypeStringPool() {
        return this.typeStringPool;
    }

    public void setTypeStringPool(StringPool typeStringPool) {
        this.typeStringPool = typeStringPool;
    }

    public StringPool getKeyStringPool() {
        return this.keyStringPool;
    }

    public void setKeyStringPool(StringPool keyStringPool) {
        this.keyStringPool = keyStringPool;
    }

    public Map<Short, TypeSpec> getTypeSpecMap() {
        return this.typeSpecMap;
    }

    public void setTypeSpecMap(Map<Short, TypeSpec> typeSpecMap) {
        this.typeSpecMap = typeSpecMap;
    }

    public Map<Short, List<Type>> getTypesMap() {
        return this.typesMap;
    }

    public void setTypesMap(Map<Short, List<Type>> typesMap) {
        this.typesMap = typesMap;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ResourcePackage) {
            ResourcePackage oldResourcePackage = (ResourcePackage)object;
            if (!this.name.equals(oldResourcePackage.getName())) {
                return false;
            }
            if (!this.typeStringPool.equals(oldResourcePackage.getTypeStringPool())) {
                return false;
            }
            if (!this.keyStringPool.equals(oldResourcePackage.getKeyStringPool())) {
                return false;
            }
            Map<String, TypeSpec> oldTypeSpecNameMap = oldResourcePackage.getTypeSpecNameMap();
            if (this.typeSpecNameMap.size() != oldTypeSpecNameMap.size()) {
                return false;
            }
            for (String typeName : this.typeSpecNameMap.keySet()) {
                if (!oldTypeSpecNameMap.containsKey(typeName)) {
                    return false;
                }
                if (this.typeSpecNameMap.get(typeName).equals(oldTypeSpecNameMap.get(typeName))) continue;
                return false;
            }
            Map<String, List<Type>> oldTypesNameMap = oldResourcePackage.getTypesNameMap();
            if (this.typesNameMap.size() != oldTypesNameMap.size()) {
                return false;
            }
            for (String typeName : this.typesNameMap.keySet()) {
                if (!oldTypesNameMap.containsKey(typeName)) {
                    return false;
                }
                List<Type> oldTypeList = oldTypesNameMap.get(typeName);
                List<Type> newTypeList = this.typesNameMap.get(typeName);
                if (oldTypeList.size() != newTypeList.size()) {
                    return false;
                }
                HashSet<Type> foundTypes = new HashSet<Type>();
                for (Type type : oldTypeList) {
                    boolean found = false;
                    for (Type newType : newTypeList) {
                        if (foundTypes.contains(newType) || !type.equals(newType)) continue;
                        foundTypes.add(newType);
                        found = true;
                        break;
                    }
                    if (found) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }
}

