/*
 * Decompiled with CFR 0.152.
 */
package tinker.net.dongliu.apk.parser.struct;

import java.util.Locale;
import tinker.net.dongliu.apk.parser.struct.StringPool;
import tinker.net.dongliu.apk.parser.struct.resource.ResourceTable;
import tinker.net.dongliu.apk.parser.utils.ParseUtils;

public abstract class ResourceValue {
    protected final int value;
    protected int size;
    protected short dataType;

    protected ResourceValue(int value) {
        this.value = value;
    }

    public int getSize() {
        return this.size;
    }

    public short getDataType() {
        return this.dataType;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setDataType(short dataType) {
        this.dataType = dataType;
    }

    public abstract String toStringValue();

    public static ResourceValue decimal(int value) {
        return new DecimalResourceValue(value);
    }

    public static ResourceValue floatValue(int rawValue, float value) {
        return new FloatResourceValue(rawValue, value);
    }

    public static ResourceValue hexadecimal(int value) {
        return new HexadecimalResourceValue(value);
    }

    public static ResourceValue bool(int value) {
        return new BooleanResourceValue(value);
    }

    public static ResourceValue string(int value, StringPool stringPool) {
        return new StringResourceValue(value, stringPool);
    }

    public static ResourceValue reference(int value, ResourceTable resourceTable, Locale locale) {
        return new ReferenceResourceValue(value, resourceTable, locale);
    }

    public static ResourceValue nullValue() {
        return NullResourceValue.instance;
    }

    public static ResourceValue rgb(int value, int len) {
        return new RGBResourceValue(value, len);
    }

    public static ResourceValue dimension(int value) {
        return new DimensionValue(value);
    }

    public static ResourceValue fraction(int value) {
        return new FractionValue(value);
    }

    public static ResourceValue raw(int value, short type) {
        return new RawValue(value, type);
    }

    private static class RawValue
    extends ResourceValue {
        private final short dataType;

        private RawValue(int value, short dataType) {
            super(value);
            this.dataType = dataType;
        }

        @Override
        public String toStringValue() {
            return "{" + this.dataType + ":" + ((long)this.value & 0xFFFFFFFFL) + "}";
        }
    }

    private static class FractionValue
    extends ResourceValue {
        private FractionValue(int value) {
            super(value);
        }

        @Override
        public String toStringValue() {
            String pstr;
            short type = (short)(this.value & 0xF);
            switch (type) {
                case 0: {
                    pstr = "%";
                    break;
                }
                case 1: {
                    pstr = "%p";
                    break;
                }
                default: {
                    pstr = "unknown type:0x" + Integer.toHexString(type);
                }
            }
            float f = Float.intBitsToFloat(this.value >> 4);
            return f + pstr;
        }
    }

    private static class DimensionValue
    extends ResourceValue {
        private DimensionValue(int value) {
            super(value);
        }

        @Override
        public String toStringValue() {
            String unitStr;
            short unit = (short)(this.value & 0xFF);
            switch (unit) {
                case 5: {
                    unitStr = "mm";
                    break;
                }
                case 0: {
                    unitStr = "px";
                    break;
                }
                case 1: {
                    unitStr = "dp";
                    break;
                }
                case 2: {
                    unitStr = "sp";
                    break;
                }
                case 3: {
                    unitStr = "pt";
                    break;
                }
                case 4: {
                    unitStr = "in";
                    break;
                }
                default: {
                    unitStr = "unknown unit:0x" + Integer.toHexString(unit);
                }
            }
            return (this.value >> 8) + unitStr;
        }
    }

    private static class RGBResourceValue
    extends ResourceValue {
        private final int len;

        private RGBResourceValue(int value, int len) {
            super(value);
            this.len = len;
        }

        @Override
        public String toStringValue() {
            StringBuilder sb = new StringBuilder();
            for (int i = this.len / 2 - 1; i >= 0; --i) {
                sb.append(Integer.toHexString(this.value >> i * 8 & 0xFF));
            }
            return sb.toString();
        }
    }

    private static class NullResourceValue
    extends ResourceValue {
        private static final NullResourceValue instance = new NullResourceValue();

        private NullResourceValue() {
            super(-1);
        }

        @Override
        public String toStringValue() {
            return "";
        }
    }

    public static class ReferenceResourceValue
    extends ResourceValue {
        private final ResourceTable resourceTable;
        private final Locale locale;

        private ReferenceResourceValue(int value, ResourceTable resourceTable, Locale locale) {
            super(value);
            this.resourceTable = resourceTable;
            this.locale = locale;
        }

        public String toString() {
            return this.toStringRepresent(false);
        }

        @Override
        public String toStringValue() {
            return this.toStringRepresent(true);
        }

        private String toStringRepresent(boolean fetchRealValue) {
            long resourceId = this.getReferenceResourceId();
            return ParseUtils.getResourceById(resourceId, this.resourceTable, this.locale, fetchRealValue);
        }

        public long getReferenceResourceId() {
            return (long)this.value & 0xFFFFFFFFL;
        }
    }

    private static class StringResourceValue
    extends ResourceValue {
        private final StringPool stringPool;

        private StringResourceValue(int value, StringPool stringPool) {
            super(value);
            this.stringPool = stringPool;
        }

        @Override
        public String toStringValue() {
            if (this.value >= 0) {
                return this.stringPool.get(this.value);
            }
            return null;
        }
    }

    private static class BooleanResourceValue
    extends ResourceValue {
        private BooleanResourceValue(int value) {
            super(value);
        }

        @Override
        public String toStringValue() {
            return String.valueOf(this.value != 0);
        }
    }

    private static class HexadecimalResourceValue
    extends ResourceValue {
        private HexadecimalResourceValue(int value) {
            super(value);
        }

        @Override
        public String toStringValue() {
            return "0x" + Integer.toHexString(this.value);
        }
    }

    private static class FloatResourceValue
    extends ResourceValue {
        private final float mValue;

        private FloatResourceValue(int rawValue, float value) {
            super(rawValue);
            this.mValue = value;
        }

        @Override
        public String toStringValue() {
            return String.valueOf(this.mValue);
        }
    }

    private static class DecimalResourceValue
    extends ResourceValue {
        private DecimalResourceValue(int value) {
            super(value);
        }

        @Override
        public String toStringValue() {
            return String.valueOf(this.value);
        }
    }
}

