/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.trace;

import com.android.build.gradle.AppExtension;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.LibraryExtension;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import org.gradle.api.Project;

public class TraceClassLoader {
    public static URLClassLoader getClassLoader(Project project, Collection<File> inputFiles) throws MalformedURLException {
        ImmutableList.Builder urls = new ImmutableList.Builder();
        File androidJar = TraceClassLoader.getAndroidJar(project);
        if (androidJar != null) {
            urls.add((Object)androidJar.toURI().toURL());
        }
        for (File inputFile : inputFiles) {
            urls.add((Object)inputFile.toURI().toURL());
        }
        ImmutableList urlImmutableList = urls.build();
        URL[] classLoaderUrls = (URL[])urlImmutableList.toArray((Object[])new URL[urlImmutableList.size()]);
        return new URLClassLoader(classLoaderUrls);
    }

    private static File getAndroidJar(Project project) {
        BaseExtension extension = null;
        if (project.getPlugins().hasPlugin("com.android.application")) {
            extension = (BaseExtension)project.getExtensions().findByType(AppExtension.class);
        } else if (project.getPlugins().hasPlugin("com.android.library")) {
            extension = (BaseExtension)project.getExtensions().findByType(LibraryExtension.class);
        }
        if (extension == null) {
            return null;
        }
        String sdkDirectory = extension.getSdkDirectory().getAbsolutePath();
        String compileSdkVersion = extension.getCompileSdkVersion();
        String androidJarPath = (sdkDirectory = sdkDirectory + File.separator + "platforms" + File.separator) + compileSdkVersion + File.separator + "android.jar";
        File androidJar = new File(androidJarPath);
        return androidJar.exists() ? androidJar : null;
    }
}

