/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.trace;

import com.tencent.matrix.javalib.util.FileUtil;
import com.tencent.matrix.javalib.util.Log;
import com.tencent.matrix.javalib.util.Util;
import com.tencent.matrix.plugin.compat.AgpCompat;
import com.tencent.matrix.trace.Configuration;
import com.tencent.matrix.trace.MethodCollector;
import com.tencent.matrix.trace.TraceClassWriter;
import com.tencent.matrix.trace.item.TraceMethod;
import com.tencent.matrix.trace.retrace.MappingCollector;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.AdviceAdapter;
import org.objectweb.asm.util.CheckClassAdapter;

public class MethodTracer {
    private static final String TAG = "Matrix.MethodTracer";
    private static AtomicInteger traceMethodCount = new AtomicInteger();
    private final Configuration configuration;
    private final ConcurrentHashMap<String, TraceMethod> collectedMethodMap;
    private final ConcurrentHashMap<String, String> collectedClassExtendMap;
    private final ExecutorService executor;
    private MappingCollector mappingCollector;
    private volatile boolean traceError = false;

    public MethodTracer(ExecutorService executor, MappingCollector mappingCollector, Configuration config, ConcurrentHashMap<String, TraceMethod> collectedMap, ConcurrentHashMap<String, String> collectedClassExtendMap) {
        this.configuration = config;
        this.mappingCollector = mappingCollector;
        this.executor = executor;
        this.collectedClassExtendMap = collectedClassExtendMap;
        this.collectedMethodMap = collectedMap;
    }

    public void trace(Map<File, File> srcFolderList, Map<File, File> dependencyJarList, ClassLoader classLoader, boolean ignoreCheckClass) throws ExecutionException, InterruptedException {
        LinkedList<Future> futures = new LinkedList<Future>();
        this.traceMethodFromSrc(srcFolderList, futures, classLoader, ignoreCheckClass);
        this.traceMethodFromJar(dependencyJarList, futures, classLoader, ignoreCheckClass);
        for (Future future : futures) {
            future.get();
        }
        if (this.traceError) {
            throw new IllegalArgumentException("something wrong with trace, see detail log before");
        }
        futures.clear();
    }

    private void traceMethodFromSrc(Map<File, File> srcMap, List<Future> futures, final ClassLoader classLoader, final boolean skipCheckClass) {
        if (null != srcMap) {
            for (final Map.Entry<File, File> entry : srcMap.entrySet()) {
                futures.add(this.executor.submit(new Runnable(){

                    @Override
                    public void run() {
                        MethodTracer.this.innerTraceMethodFromSrc((File)entry.getKey(), (File)entry.getValue(), classLoader, skipCheckClass);
                    }
                }));
            }
        }
    }

    private void traceMethodFromJar(Map<File, File> dependencyMap, List<Future> futures, final ClassLoader classLoader, final boolean skipCheckClass) {
        if (null != dependencyMap) {
            for (final Map.Entry<File, File> entry : dependencyMap.entrySet()) {
                futures.add(this.executor.submit(new Runnable(){

                    @Override
                    public void run() {
                        MethodTracer.this.innerTraceMethodFromJar((File)entry.getKey(), (File)entry.getValue(), classLoader, skipCheckClass);
                    }
                }));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerTraceMethodFromSrc(File input, File output, ClassLoader classLoader, boolean ignoreCheckClass) {
        ArrayList<File> classFileList = new ArrayList<File>();
        if (input.isDirectory()) {
            this.listClassFiles(classFileList, input);
        } else {
            classFileList.add(input);
        }
        for (File classFile : classFileList) {
            InputStream is = null;
            FileOutputStream os = null;
            try {
                String changedFileInputFullPath = classFile.getAbsolutePath();
                File changedFileOutput = new File(changedFileInputFullPath.replace(input.getAbsolutePath(), output.getAbsolutePath()));
                if (changedFileOutput.getCanonicalPath().equals(classFile.getCanonicalPath())) {
                    throw new RuntimeException("Input file(" + classFile.getCanonicalPath() + ") should not be same with output!");
                }
                if (!changedFileOutput.exists()) {
                    changedFileOutput.getParentFile().mkdirs();
                }
                changedFileOutput.createNewFile();
                if (MethodCollector.isNeedTraceFile(classFile.getName())) {
                    is = new FileInputStream(classFile);
                    ClassReader classReader = new ClassReader(is);
                    TraceClassWriter classWriter = new TraceClassWriter(2, classLoader);
                    TraceClassAdapter classVisitor = new TraceClassAdapter(AgpCompat.getAsmApi(), (ClassVisitor)classWriter);
                    classReader.accept((ClassVisitor)classVisitor, 8);
                    is.close();
                    byte[] data = classWriter.toByteArray();
                    if (!ignoreCheckClass) {
                        try {
                            ClassReader cr = new ClassReader(data);
                            ClassWriter cw = new ClassWriter(0);
                            CheckClassAdapter check = new CheckClassAdapter((ClassVisitor)cw);
                            cr.accept((ClassVisitor)check, 8);
                        }
                        catch (Throwable e) {
                            System.err.println("trace output ERROR : " + e.getMessage() + ", " + classFile);
                            this.traceError = true;
                        }
                    }
                    os = output.isDirectory() ? new FileOutputStream(changedFileOutput) : new FileOutputStream(output);
                    os.write(data);
                    os.close();
                    continue;
                }
                FileUtil.copyFileUsingStream((File)classFile, (File)changedFileOutput);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"[innerTraceMethodFromSrc] input:%s e:%s", (Object[])new Object[]{input.getName(), e.getMessage()});
                try {
                    Files.copy(input.toPath(), output.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
            finally {
                try {
                    is.close();
                    os.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerTraceMethodFromJar(File input, File output, ClassLoader classLoader, boolean skipCheckClass) {
        block23: {
            ZipOutputStream zipOutputStream = null;
            ZipFile zipFile = null;
            try {
                zipOutputStream = new ZipOutputStream(new FileOutputStream(output));
                zipFile = new ZipFile(input);
                Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                while (enumeration.hasMoreElements()) {
                    InputStream inputStream;
                    ZipEntry zipEntry = enumeration.nextElement();
                    String zipEntryName = zipEntry.getName();
                    if (Util.preventZipSlip((File)output, (String)zipEntryName)) {
                        Log.e((String)TAG, (String)"Unzip entry %s failed!", (Object[])new Object[]{zipEntryName});
                        continue;
                    }
                    if (MethodCollector.isNeedTraceFile(zipEntryName)) {
                        inputStream = zipFile.getInputStream(zipEntry);
                        ClassReader classReader = new ClassReader(inputStream);
                        TraceClassWriter classWriter = new TraceClassWriter(2, classLoader);
                        TraceClassAdapter classVisitor = new TraceClassAdapter(AgpCompat.getAsmApi(), (ClassVisitor)classWriter);
                        classReader.accept((ClassVisitor)classVisitor, 8);
                        byte[] data = classWriter.toByteArray();
                        if (!skipCheckClass) {
                            try {
                                ClassReader r = new ClassReader(data);
                                ClassWriter w = new ClassWriter(0);
                                CheckClassAdapter v = new CheckClassAdapter((ClassVisitor)w);
                                r.accept((ClassVisitor)v, 8);
                            }
                            catch (Throwable e) {
                                System.err.println("trace jar output ERROR: " + e.getMessage() + ", " + zipEntryName);
                                this.traceError = true;
                            }
                        }
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(data);
                        ZipEntry newZipEntry = new ZipEntry(zipEntryName);
                        FileUtil.addZipEntry((ZipOutputStream)zipOutputStream, (ZipEntry)newZipEntry, (InputStream)byteArrayInputStream);
                        continue;
                    }
                    inputStream = zipFile.getInputStream(zipEntry);
                    ZipEntry newZipEntry = new ZipEntry(zipEntryName);
                    FileUtil.addZipEntry((ZipOutputStream)zipOutputStream, (ZipEntry)newZipEntry, (InputStream)inputStream);
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"[innerTraceMethodFromJar] input:%s output:%s e:%s", (Object[])new Object[]{input, output, e.getMessage()});
                if (e instanceof ZipException) {
                    e.printStackTrace();
                }
                try {
                    if (input.length() > 0L) {
                        Files.copy(input.toPath(), output.toPath(), StandardCopyOption.REPLACE_EXISTING);
                        break block23;
                    }
                    Log.e((String)TAG, (String)"[innerTraceMethodFromJar] input:%s is empty", (Object[])new Object[]{input});
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
            finally {
                try {
                    if (zipOutputStream != null) {
                        zipOutputStream.finish();
                        zipOutputStream.flush();
                        zipOutputStream.close();
                    }
                    if (zipFile != null) {
                        zipFile.close();
                    }
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)"close stream err!", (Object[])new Object[0]);
                }
            }
        }
    }

    private void listClassFiles(ArrayList<File> classFiles, File folder) {
        File[] files = folder.listFiles();
        if (null == files) {
            Log.e((String)TAG, (String)"[listClassFiles] files is null! %s", (Object[])new Object[]{folder.getAbsolutePath()});
            return;
        }
        for (File file : files) {
            if (file == null) continue;
            if (file.isDirectory()) {
                this.listClassFiles(classFiles, file);
                continue;
            }
            if (null == file || !file.isFile()) continue;
            classFiles.add(file);
        }
    }

    private boolean isActivityOrSubClass(String className, ConcurrentHashMap<String, String> mCollectedClassExtendMap) {
        boolean isActivity;
        boolean bl = isActivity = (className = className.replace(".", "/")).equals("android/app/Activity") || className.equals("android/support/v4/app/FragmentActivity") || className.equals("android/support/v7/app/AppCompatActivity") || className.equals("androidx/appcompat/app/AppCompatActivity");
        if (isActivity) {
            return true;
        }
        if (!mCollectedClassExtendMap.containsKey(className)) {
            return false;
        }
        return this.isActivityOrSubClass(mCollectedClassExtendMap.get(className), mCollectedClassExtendMap);
    }

    private void traceWindowFocusChangeMethod(MethodVisitor mv, String classname) {
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(21, 1);
        mv.visitMethodInsn(184, "com/tencent/matrix/trace/core/AppMethodBeat", "at", "(Landroid/app/Activity;Z)V", false);
    }

    private void insertWindowFocusChangeMethod(ClassVisitor cv, String classname, String superClassName) {
        MethodVisitor methodVisitor = cv.visitMethod(1, "onWindowFocusChanged", "(Z)V", null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(21, 1);
        methodVisitor.visitMethodInsn(183, superClassName, "onWindowFocusChanged", "(Z)V", false);
        this.traceWindowFocusChangeMethod(methodVisitor, classname);
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(2, 2);
        methodVisitor.visitEnd();
    }

    private class TraceMethodAdapter
    extends AdviceAdapter {
        private final String methodName;
        private final String name;
        private final String className;
        private final boolean hasWindowFocusMethod;
        private final boolean isNeedTrace;
        private final boolean isActivityOrSubClass;

        protected TraceMethodAdapter(int api, MethodVisitor mv, int access, String name, String desc, String className, boolean hasWindowFocusMethod, boolean isActivityOrSubClass, boolean isNeedTrace) {
            super(api, mv, access, name, desc);
            TraceMethod traceMethod = TraceMethod.create(0, access, className, name, desc);
            this.methodName = traceMethod.getMethodName();
            this.hasWindowFocusMethod = hasWindowFocusMethod;
            this.className = className;
            this.name = name;
            this.isActivityOrSubClass = isActivityOrSubClass;
            this.isNeedTrace = isNeedTrace;
        }

        protected void onMethodEnter() {
            TraceMethod traceMethod = (TraceMethod)MethodTracer.this.collectedMethodMap.get(this.methodName);
            if (traceMethod != null) {
                traceMethodCount.incrementAndGet();
                this.mv.visitLdcInsn((Object)traceMethod.id);
                this.mv.visitMethodInsn(184, "com/tencent/matrix/trace/core/AppMethodBeat", "i", "(I)V", false);
                if (this.checkNeedTraceWindowFocusChangeMethod(traceMethod)) {
                    MethodTracer.this.traceWindowFocusChangeMethod(this.mv, this.className);
                }
            }
        }

        protected void onMethodExit(int opcode) {
            TraceMethod traceMethod = (TraceMethod)MethodTracer.this.collectedMethodMap.get(this.methodName);
            if (traceMethod != null) {
                traceMethodCount.incrementAndGet();
                this.mv.visitLdcInsn((Object)traceMethod.id);
                this.mv.visitMethodInsn(184, "com/tencent/matrix/trace/core/AppMethodBeat", "o", "(I)V", false);
            }
        }

        private boolean checkNeedTraceWindowFocusChangeMethod(TraceMethod traceMethod) {
            TraceMethod windowFocusChangeMethod;
            return this.hasWindowFocusMethod && this.isActivityOrSubClass && this.isNeedTrace && (windowFocusChangeMethod = TraceMethod.create(-1, 1, this.className, "onWindowFocusChanged", "(Z)V")).equals(traceMethod);
        }
    }

    private class TraceClassAdapter
    extends ClassVisitor {
        private String className;
        private String superName;
        private boolean isABSClass;
        private boolean hasWindowFocusMethod;
        private boolean isActivityOrSubClass;
        private boolean isNeedTrace;

        TraceClassAdapter(int i, ClassVisitor classVisitor) {
            super(i, classVisitor);
            this.isABSClass = false;
            this.hasWindowFocusMethod = false;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            super.visit(version, access, name, signature, superName, interfaces);
            this.className = name;
            this.superName = superName;
            this.isActivityOrSubClass = MethodTracer.this.isActivityOrSubClass(this.className, MethodTracer.this.collectedClassExtendMap);
            this.isNeedTrace = MethodCollector.isNeedTrace(MethodTracer.this.configuration, this.className, MethodTracer.this.mappingCollector);
            if ((access & 0x400) > 0 || (access & 0x200) > 0) {
                this.isABSClass = true;
            }
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (!this.hasWindowFocusMethod) {
                this.hasWindowFocusMethod = MethodCollector.isWindowFocusChangeMethod(name, desc);
            }
            if (this.isABSClass) {
                return super.visitMethod(access, name, desc, signature, exceptions);
            }
            MethodVisitor methodVisitor = this.cv.visitMethod(access, name, desc, signature, exceptions);
            return new TraceMethodAdapter(this.api, methodVisitor, access, name, desc, this.className, this.hasWindowFocusMethod, this.isActivityOrSubClass, this.isNeedTrace);
        }

        public void visitEnd() {
            if (!this.hasWindowFocusMethod && this.isActivityOrSubClass && this.isNeedTrace) {
                MethodTracer.this.insertWindowFocusChangeMethod(this.cv, this.className, this.superName);
            }
            super.visitEnd();
        }
    }
}

