/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.shrinker;

import java.util.Arrays;
import java.util.List;

public class ProguardStringBuilder {
    private static char[] alphaArray = new char[26];
    private static char[] numberArray = new char[10];
    private static final List<String> WIN_INVALID_FILE_NAME = Arrays.asList("aux", "nul", "prn", "nul", "con", "com1", "com2", "com3", "com4", "com5", "com6", "com7", "com8", "com9", "lpt1", "lpt2", "lpt3", "lpt4", "lpt5", "lpt6", "lpt7", "lpt8", "lpt9");
    private int alphaIndex;
    private int numberIndex;
    private String prefix = "";

    public ProguardStringBuilder() {
        int i = 0;
        for (int alpha = 97; alpha <= 122; alpha = (int)((char)(alpha + 1))) {
            ProguardStringBuilder.alphaArray[i++] = alpha;
        }
        i = 0;
        for (int num = 48; num <= 57; num = (int)((char)(num + 1))) {
            ProguardStringBuilder.numberArray[i++] = num;
        }
    }

    private String getPrefix(int len) {
        if (len == 0) {
            return "" + alphaArray[0];
        }
        if (len == 1) {
            char curChar = this.prefix.charAt(0);
            if (curChar < alphaArray[alphaArray.length - 1]) {
                return "" + (char)(curChar + '\u0001');
            }
            return "" + alphaArray[0] + alphaArray[0];
        }
        char lastChar = this.prefix.charAt(len - 1);
        if (lastChar == alphaArray[alphaArray.length - 1]) {
            return this.prefix.substring(0, len - 1) + numberArray[0];
        }
        if (lastChar == numberArray[numberArray.length - 1]) {
            return this.getPrefix(len - 1) + alphaArray[0];
        }
        return this.prefix.substring(0, len - 1) + (char)(lastChar + '\u0001');
    }

    private void nextTurn() {
        this.alphaIndex = 0;
        this.numberIndex = 0;
        this.prefix = this.getPrefix(this.prefix.length());
    }

    public String generateNextProguard() {
        String result = "";
        if (this.prefix.equals("")) {
            if (this.alphaIndex <= alphaArray.length - 1) {
                result = String.valueOf(alphaArray[this.alphaIndex++]);
            } else {
                this.nextTurn();
                result = this.prefix + alphaArray[this.alphaIndex++];
            }
        } else if (this.alphaIndex <= alphaArray.length - 1) {
            result = this.prefix + alphaArray[this.alphaIndex++];
        } else if (this.numberIndex <= numberArray.length - 1) {
            result = this.prefix + numberArray[this.numberIndex++];
        } else {
            this.nextTurn();
            result = this.prefix + alphaArray[this.alphaIndex++];
        }
        return result;
    }

    public String generateNextProguardFileName() {
        String result = this.generateNextProguard();
        while (WIN_INVALID_FILE_NAME.contains(result.toLowerCase())) {
            result = this.generateNextProguard();
        }
        return result;
    }

    public void reset() {
        this.alphaIndex = 0;
        this.numberIndex = 0;
        this.prefix = "";
    }
}

