/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.plugin.task;

import com.android.build.api.transform.Status;
import com.android.build.gradle.internal.tasks.DexArchiveBuilderTask;
import com.google.common.base.Joiner;
import com.tencent.matrix.javalib.util.Log;
import com.tencent.matrix.plugin.compat.CreationConfig;
import com.tencent.matrix.plugin.task.BaseCreationAction;
import com.tencent.matrix.plugin.trace.MatrixTrace;
import com.tencent.matrix.trace.extension.MatrixTraceExtension;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileType;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.OutputFiles;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.ChangeType;
import org.gradle.work.FileChange;
import org.gradle.work.Incremental;
import org.gradle.work.InputChanges;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 &2\u00020\u0001:\u0002&'B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0007J\u0016\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0014\u0010\u000f\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0006R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00128gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0006R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00128gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0015R\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00130\u00128gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0015\u00a8\u0006("}, d2={"Lcom/tencent/matrix/plugin/task/MatrixTraceTask;", "Lorg/gradle/api/DefaultTask;", "()V", "baseMethodMapFile", "Lorg/gradle/api/file/RegularFileProperty;", "getBaseMethodMapFile", "()Lorg/gradle/api/file/RegularFileProperty;", "blockListFile", "getBlockListFile", "classInputs", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getClassInputs", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "classOutputs", "getClassOutputs", "ignoreMethodMapFileOutput", "getIgnoreMethodMapFileOutput", "mappingDir", "Lorg/gradle/api/provider/Property;", "", "getMappingDir", "()Lorg/gradle/api/provider/Property;", "methodMapFileOutput", "getMethodMapFileOutput", "skipCheckClass", "", "getSkipCheckClass", "traceClassOutputDirectory", "getTraceClassOutputDirectory", "execute", "", "inputChanges", "Lorg/gradle/work/InputChanges;", "wired", "creationConfig", "Lcom/tencent/matrix/plugin/compat/CreationConfig;", "task", "Lcom/android/build/gradle/internal/tasks/DexArchiveBuilderTask;", "Companion", "CreationAction", "matrix-gradle-plugin"})
public abstract class MatrixTraceTask
extends DefaultTask {
    private static final String TAG = "Matrix.TraceTask";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Incremental
    @InputFiles
    @NotNull
    public abstract ConfigurableFileCollection getClassInputs();

    @InputFile
    @Optional
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    @NotNull
    public abstract RegularFileProperty getBaseMethodMapFile();

    @InputFile
    @Optional
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    @NotNull
    public abstract RegularFileProperty getBlockListFile();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getMappingDir();

    @Input
    @NotNull
    public abstract Property<String> getTraceClassOutputDirectory();

    @OutputFiles
    @NotNull
    public abstract ConfigurableFileCollection getClassOutputs();

    @OutputFile
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    @Optional
    @NotNull
    public abstract RegularFileProperty getIgnoreMethodMapFileOutput();

    @OutputFile
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    @Optional
    @NotNull
    public abstract RegularFileProperty getMethodMapFileOutput();

    @Optional
    @NotNull
    public abstract Property<Boolean> getSkipCheckClass();

    @TaskAction
    public final void execute(@NotNull InputChanges inputChanges) {
        Intrinsics.checkNotNullParameter((Object)inputChanges, (String)"inputChanges");
        boolean incremental = inputChanges.isIncremental();
        ConcurrentHashMap changedFiles = new ConcurrentHashMap();
        if (incremental) {
            Iterable iterable = inputChanges.getFileChanges((FileCollection)this.getClassInputs());
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"inputChanges.getFileChanges(classInputs)");
            Iterable $this$forEach$iv = iterable;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FileChange change = (FileChange)element$iv;
                boolean bl = false;
                FileChange fileChange = change;
                Intrinsics.checkNotNullExpressionValue((Object)fileChange, (String)"change");
                if (fileChange.getFileType() == FileType.DIRECTORY) continue;
                Map map = changedFiles;
                File file = change.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"change.file");
                map.put(file, change.getChangeType() == ChangeType.REMOVED ? Status.REMOVED : (change.getChangeType() == ChangeType.MODIFIED ? Status.CHANGED : (change.getChangeType() == ChangeType.ADDED ? Status.ADDED : Status.NOTCHANGED)));
            }
        }
        long start = System.currentTimeMillis();
        try {
            File outputDirectory = new File((String)this.getTraceClassOutputDirectory().get());
            Object object = this.getIgnoreMethodMapFileOutput().getAsFile().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ignoreMethodMapFileOutput.asFile.get()");
            String string = ((File)object).getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ignoreMethodMapFileOutpu\u2026asFile.get().absolutePath");
            Object object2 = this.getMethodMapFileOutput().getAsFile().get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"methodMapFileOutput.asFile.get()");
            String string2 = ((File)object2).getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"methodMapFileOutput.asFile.get().absolutePath");
            Provider provider = this.getBaseMethodMapFile().getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"baseMethodMapFile.asFile");
            File file = (File)provider.getOrNull();
            String string3 = file != null ? file.getAbsolutePath() : null;
            Provider provider2 = this.getBlockListFile().getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"blockListFile.asFile");
            File file2 = (File)provider2.getOrNull();
            String string4 = file2 != null ? file2.getAbsolutePath() : null;
            Object object3 = this.getMappingDir().get();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"mappingDir.get()");
            String string5 = (String)object3;
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
            MatrixTrace matrixTrace = new MatrixTrace(string, string2, string3, string4, string5, project);
            Set set = this.getClassInputs().getFiles();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"classInputs.files");
            Collection collection = set;
            Map map = changedFiles;
            Object object4 = this.getSkipCheckClass().get();
            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"this.skipCheckClass.get()");
            boolean bl = false;
            Function2<? super File, ? super File, ? extends Object> function2 = null;
            Function2<? super File, ? super Map<File, ? extends Status>, ? extends Object> function22 = null;
            Map map2 = new ConcurrentHashMap();
            File file3 = outputDirectory;
            boolean bl2 = (Boolean)object4;
            boolean bl3 = incremental;
            matrixTrace.doTransform(collection, map, map2, bl3, bl2, file3, function22, function2, bl);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        long cost = System.currentTimeMillis() - start;
        Log.i((String)TAG, (String)" Insert matrix trace instrumentations cost time: %sms.", (Object[])new Object[]{cost});
    }

    /*
     * WARNING - void declaration
     */
    public final void wired(@NotNull CreationConfig creationConfig, @NotNull DexArchiveBuilderTask task) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Log.i((String)TAG, (String)("Wiring " + this.getName() + " to task '" + task.getName() + "'."), (Object[])new Object[0]);
        task.dependsOn(new Object[]{this});
        this.getClassInputs().setFrom((Iterable)task.getMixedScopeClasses().getFiles());
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        String traceClassOut = Companion.getTraceClassOut(project, creationConfig);
        Set set = task.getMixedScopeClasses().getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"task.mixedScopeClasses.files");
        Iterable $this$map$iv = set;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v2 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"it");
            File file2 = new File(traceClassOut, MatrixTrace.Companion.appendSuffix((File)v2, "traced"));
            collection.add(file2);
        }
        List outputs = (List)destination$iv$iv;
        this.getClassOutputs().from(new Object[]{outputs});
        task.getMixedScopeClasses().setFrom((Iterable)this.getClassOutputs());
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0002H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0014"}, d2={"Lcom/tencent/matrix/plugin/task/MatrixTraceTask$CreationAction;", "Lorg/gradle/api/Action;", "Lcom/tencent/matrix/plugin/task/MatrixTraceTask;", "Lcom/tencent/matrix/plugin/task/BaseCreationAction;", "creationConfig", "Lcom/tencent/matrix/plugin/compat/CreationConfig;", "extension", "Lcom/tencent/matrix/trace/extension/MatrixTraceExtension;", "(Lcom/tencent/matrix/plugin/compat/CreationConfig;Lcom/tencent/matrix/trace/extension/MatrixTraceExtension;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "execute", "", "task", "matrix-gradle-plugin"})
    public static final class CreationAction
    extends BaseCreationAction<MatrixTraceTask>
    implements Action<MatrixTraceTask> {
        @NotNull
        private final String name;
        @NotNull
        private final Class<MatrixTraceTask> type;
        private final CreationConfig creationConfig;
        private final MatrixTraceExtension extension;

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        @NotNull
        public Class<MatrixTraceTask> getType() {
            return this.type;
        }

        public void execute(@NotNull MatrixTraceTask task) {
            File blackListFile;
            Intrinsics.checkNotNullParameter((Object)((Object)task), (String)"task");
            Project project = this.creationConfig.getProject();
            String variantDirName = this.creationConfig.getVariant().getDirName();
            String mappingOut = Joiner.on((char)File.separatorChar).join((Object)project.getBuildDir(), (Object)"outputs", new Object[]{"mapping", variantDirName});
            String traceClassOut = Companion.getTraceClassOut(project, this.creationConfig);
            File baseMethodMapFile = new File(this.extension.getBaseMethodMapFile());
            if (baseMethodMapFile.exists()) {
                task.getBaseMethodMapFile().set(baseMethodMapFile);
            }
            if ((blackListFile = new File(this.extension.getBlackListFile())).exists()) {
                task.getBlockListFile().set(blackListFile);
            }
            task.getMappingDir().set((Object)mappingOut);
            task.getTraceClassOutputDirectory().set((Object)traceClassOut);
            task.getSkipCheckClass().set((Object)this.extension.isSkipCheckClass());
            task.getIgnoreMethodMapFileOutput().set(new File(mappingOut + "/ignoreMethodMapping.txt"));
            task.getMethodMapFileOutput().set(new File(mappingOut + "/methodMapping.txt"));
        }

        public CreationAction(@NotNull CreationConfig creationConfig, @NotNull MatrixTraceExtension extension) {
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
            super(creationConfig);
            this.creationConfig = creationConfig;
            this.extension = extension;
            this.name = this.computeTaskName("matrix", "Trace");
            this.type = MatrixTraceTask.class;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/tencent/matrix/plugin/task/MatrixTraceTask$Companion;", "", "()V", "TAG", "", "getTraceClassOut", "project", "Lorg/gradle/api/Project;", "creationConfig", "Lcom/tencent/matrix/plugin/compat/CreationConfig;", "matrix-gradle-plugin"})
    public static final class Companion {
        @NotNull
        public final String getTraceClassOut(@NotNull Project project, @NotNull CreationConfig creationConfig) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            String variantDirName = creationConfig.getVariant().getDirName();
            String string = Joiner.on((char)File.separatorChar).join((Object)project.getBuildDir(), (Object)"outputs", new Object[]{"traceClassOut", variantDirName});
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Joiner.on(File.separator\u2026          variantDirName)");
            return string;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

