/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mm.arscutil.data;

import com.tencent.mm.arscutil.data.ResChunk;
import com.tencent.mm.arscutil.data.ResPackage;
import com.tencent.mm.arscutil.data.ResStringBlock;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ResTable
extends ResChunk {
    private int packageCount;
    private ResStringBlock globalStringPool;
    private ResPackage[] packages;

    public int getPackageCount() {
        return this.packageCount;
    }

    public void setPackageCount(int packageCount) {
        this.packageCount = packageCount;
    }

    public ResStringBlock getGlobalStringPool() {
        return this.globalStringPool;
    }

    public void setGlobalStringPool(ResStringBlock globalStringPool) {
        this.globalStringPool = globalStringPool;
    }

    public ResPackage[] getPackages() {
        return this.packages;
    }

    public void setPackages(ResPackage[] packages) {
        this.packages = packages;
    }

    public void refresh() {
        this.recomputeChunkSize();
    }

    private void recomputeChunkSize() {
        this.chunkSize = 0;
        this.chunkSize += this.headSize;
        if (this.globalStringPool != null) {
            this.chunkSize += this.globalStringPool.getChunkSize();
        }
        if (this.packages != null) {
            for (ResPackage resPackage : this.packages) {
                this.chunkSize += resPackage.getChunkSize();
            }
        }
        if (this.chunkSize % 4 != 0) {
            this.chunkPadding = 4 - this.chunkSize % 4;
            this.chunkSize += this.chunkPadding;
        } else {
            this.chunkPadding = 0;
        }
    }

    @Override
    public byte[] toBytes() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.chunkSize);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.clear();
        byteBuffer.putShort(this.type);
        byteBuffer.putShort(this.headSize);
        byteBuffer.putInt(this.chunkSize);
        byteBuffer.putInt(this.packageCount);
        if (this.headPadding > 0) {
            byteBuffer.put(new byte[this.headPadding]);
        }
        if (this.globalStringPool != null) {
            byteBuffer.put(this.globalStringPool.toBytes());
        }
        if (this.packages != null) {
            for (int i = 0; i < this.packages.length; ++i) {
                byteBuffer.put(this.packages[i].toBytes());
            }
        }
        if (this.chunkPadding > 0) {
            byteBuffer.put(new byte[this.chunkPadding]);
        }
        byteBuffer.flip();
        return byteBuffer.array();
    }
}

