/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mm.arscutil;

import com.tencent.matrix.javalib.util.Log;
import com.tencent.mm.arscutil.data.ResChunk;
import com.tencent.mm.arscutil.data.ResEntry;
import com.tencent.mm.arscutil.data.ResPackage;
import com.tencent.mm.arscutil.data.ResStringBlock;
import com.tencent.mm.arscutil.data.ResTable;
import com.tencent.mm.arscutil.data.ResType;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ArscUtil {
    private static final String TAG = "ArscUtil.ArscUtil";

    public static String toUTF16String(byte[] buffer) {
        int index;
        CharBuffer charBuffer = ByteBuffer.wrap(buffer).order(ByteOrder.LITTLE_ENDIAN).asCharBuffer();
        for (index = 0; index < charBuffer.length() && charBuffer.get() != '\u0000'; ++index) {
        }
        charBuffer.limit(index).position(0);
        return charBuffer.toString();
    }

    public static int getPackageId(int resourceId) {
        return (resourceId & 0xFF000000) >> 24;
    }

    public static int getResourceTypeId(int resourceId) {
        return (resourceId & 0xFF0000) >> 16;
    }

    public static int getResourceEntryId(int resourceId) {
        return resourceId & 0xFFFF;
    }

    public static ResPackage findResPackage(ResTable resTable, int packageId) {
        ResPackage resPackage = null;
        for (ResPackage pkg : resTable.getPackages()) {
            if (pkg.getId() != packageId) continue;
            resPackage = pkg;
            break;
        }
        return resPackage;
    }

    public static List<ResType> findResType(ResPackage resPackage, int resourceId) {
        ResType resType = null;
        int typeId = (resourceId & 0xFF0000) >> 16;
        int entryId = resourceId & 0xFFFF;
        ArrayList<ResType> resTypeList = new ArrayList<ResType>();
        List<ResChunk> resTypeArray = resPackage.getResTypeArray();
        if (resTypeArray != null) {
            for (int i = 0; i < resTypeArray.size(); ++i) {
                int offset;
                int entryCount;
                if (resTypeArray.get(i).getType() != 513 || ((ResType)resTypeArray.get(i)).getId() != typeId || entryId >= (entryCount = ((ResType)resTypeArray.get(i)).getEntryCount()) || (offset = ((ResType)resTypeArray.get(i)).getEntryOffsets().get(entryId).intValue()) == -1) continue;
                resType = (ResType)resTypeArray.get(i);
                resTypeList.add(resType);
            }
        }
        return resTypeList;
    }

    public static void removeResource(ResTable resTable, int resourceId, String resourceName) throws IOException {
        ResPackage resPackage = ArscUtil.findResPackage(resTable, ArscUtil.getPackageId(resourceId));
        if (resPackage != null) {
            List<ResType> resTypeList = ArscUtil.findResType(resPackage, resourceId);
            int resNameStringPoolIndex = -1;
            for (ResType resType : resTypeList) {
                int entryId = ArscUtil.getResourceEntryId(resourceId);
                resNameStringPoolIndex = resType.getEntryTable().get(entryId).getStringPoolIndex();
                resType.removeEntry(entryId);
                resType.refresh();
            }
            if (resNameStringPoolIndex != -1) {
                Log.d((String)TAG, (String)"try to remove %s (%H), find resource %s", (Object[])new Object[]{resourceName, resourceId, ResStringBlock.resolveStringPoolEntry(resPackage.getResNamePool().getStrings().get(resNameStringPoolIndex).array(), resPackage.getResNamePool().getCharSet())});
            }
            resPackage.shrinkResNameStringPool();
            resPackage.refresh();
            resTable.refresh();
        }
    }

    public static boolean replaceFileResource(ResTable resTable, int sourceResId, String sourceFile, int targetResId, String targetFile) throws IOException {
        int sourcePkgId = ArscUtil.getPackageId(sourceResId);
        int targetPkgId = ArscUtil.getPackageId(targetResId);
        Log.d((String)TAG, (String)"try to replace %H(%s) with %H(%s)", (Object[])new Object[]{sourceResId, sourceFile, targetResId, targetFile});
        if (sourcePkgId == targetPkgId) {
            ResPackage resPackage = ArscUtil.findResPackage(resTable, sourcePkgId);
            if (resPackage != null) {
                List<ResType> targetResTypeList = ArscUtil.findResType(resPackage, targetResId);
                int targetFileIndex = -1;
                for (ResType targetResType : targetResTypeList) {
                    int entryId = ArscUtil.getResourceEntryId(targetResId);
                    ResEntry resEntry = targetResType.getEntryTable().get(entryId);
                    boolean isComplex = (resEntry.getFlag() & 1) != 0;
                    if (isComplex || resEntry.getResValue() == null || resEntry.getResValue().getDataType() != 3) continue;
                    String filePath = ResStringBlock.resolveStringPoolEntry(resTable.getGlobalStringPool().getStrings().get(resEntry.getResValue().getData()).array(), resTable.getGlobalStringPool().getCharSet());
                    if (filePath.equals(targetFile)) {
                        targetFileIndex = resEntry.getResValue().getData();
                        break;
                    }
                    Log.w((String)TAG, (String)"find target file %s, %s was expected", (Object[])new Object[]{filePath, targetFile});
                }
                if (targetFileIndex == -1) {
                    Log.w((String)TAG, (String)"can not find target file %s in resource %H", (Object[])new Object[]{targetFile, targetResId});
                    return false;
                }
                int sourceFileIndex = -1;
                List<ResType> sourceResTypeList = ArscUtil.findResType(resPackage, sourceResId);
                for (ResType sourceResType : sourceResTypeList) {
                    int entryId = ArscUtil.getResourceEntryId(sourceResId);
                    ResEntry resEntry = sourceResType.getEntryTable().get(entryId);
                    boolean isComplex = (resEntry.getFlag() & 1) != 0;
                    if (isComplex || resEntry.getResValue() == null || resEntry.getResValue().getDataType() != 3) continue;
                    String filePath = ResStringBlock.resolveStringPoolEntry(resTable.getGlobalStringPool().getStrings().get(resEntry.getResValue().getData()).array(), resTable.getGlobalStringPool().getCharSet());
                    if (filePath.equals(sourceFile)) {
                        sourceFileIndex = resEntry.getResValue().getData();
                        resEntry.getResValue().setData(targetFileIndex);
                        sourceResType.refresh();
                        continue;
                    }
                    Log.w((String)TAG, (String)"find source file %s, %s was expected", (Object[])new Object[]{filePath, sourceFile});
                }
                if (sourceFileIndex != -1) {
                    return true;
                }
            }
        } else {
            Log.w((String)TAG, (String)"sourcePkgId %d != targetPkgId %d, quit replace!", (Object[])new Object[]{sourcePkgId, targetPkgId});
        }
        return false;
    }

    public static void replaceResEntryName(ResTable resTable, Map<Integer, String> resIdProguard) {
        HashSet<ResPackage> updatePackages = new HashSet<ResPackage>();
        for (int resId : resIdProguard.keySet()) {
            ResPackage resPackage = ArscUtil.findResPackage(resTable, ArscUtil.getPackageId(resId));
            if (resPackage == null) continue;
            if (resPackage.getResProguardPool() == null) {
                ResStringBlock resProguardBlock = new ResStringBlock();
                resProguardBlock.setType(resPackage.getResNamePool().getType());
                resProguardBlock.setStart(resPackage.getResNamePool().getStart());
                resProguardBlock.setHeadSize(resPackage.getResNamePool().getHeadSize());
                resProguardBlock.setHeadPadding(resPackage.getResNamePool().getHeadPadding());
                resProguardBlock.setChunkPadding(resPackage.getResNamePool().getChunkPadding());
                resProguardBlock.setStyleCount(resPackage.getResNamePool().getStyleCount());
                resProguardBlock.setFlag(resPackage.getResNamePool().getFlag());
                resProguardBlock.setStringStart(resPackage.getResNamePool().getStringStart());
                resProguardBlock.setStyleOffsets(resPackage.getResNamePool().getStyleOffsets());
                resProguardBlock.setStyles(resPackage.getResNamePool().getStyles());
                resProguardBlock.setStrings(new ArrayList<ByteBuffer>());
                resProguardBlock.setStringOffsets(new ArrayList<Integer>());
                resProguardBlock.setStringIndexMap(new HashMap<String, Integer>());
                resPackage.setResProguardPool(resProguardBlock);
            }
            List<ResType> resTypeList = ArscUtil.findResType(resPackage, resId);
            for (ResType resType : resTypeList) {
                int entryId = ArscUtil.getResourceEntryId(resId);
                ResEntry resEntry = resType.getEntryTable().get(entryId);
                resEntry.setEntryName(resIdProguard.get(resId));
                if (resPackage.getResProguardPool().getStringIndexMap().containsKey(resEntry.getEntryName())) continue;
                resPackage.getResProguardPool().getStrings().add(ByteBuffer.wrap(ResStringBlock.encodeStringPoolEntry(resEntry.getEntryName(), resPackage.getResProguardPool().getCharSet())));
                resPackage.getResProguardPool().setStringCount(resPackage.getResProguardPool().getStrings().size());
                resPackage.getResProguardPool().getStringIndexMap().put(resEntry.getEntryName(), resPackage.getResProguardPool().getStringCount() - 1);
            }
            updatePackages.add(resPackage);
        }
        for (ResPackage resPackage : updatePackages) {
            List<ResChunk> resTypeArray = resPackage.getResTypeArray();
            if (resTypeArray != null) {
                for (ResChunk resChunk : resTypeArray) {
                    ResType resType;
                    if (resChunk.getType() != 513) continue;
                    resType = (ResType)resChunk;
                    for (ResEntry resEntry : resType.getEntryTable()) {
                        if (resEntry == null) continue;
                        if (!resPackage.getResProguardPool().getStringIndexMap().containsKey(resEntry.getEntryName())) {
                            resPackage.getResProguardPool().getStrings().add(ByteBuffer.wrap(ResStringBlock.encodeStringPoolEntry(resEntry.getEntryName(), resPackage.getResProguardPool().getCharSet())));
                            resPackage.getResProguardPool().setStringCount(resPackage.getResProguardPool().getStrings().size());
                            resPackage.getResProguardPool().getStringIndexMap().put(resEntry.getEntryName(), resPackage.getResProguardPool().getStringCount() - 1);
                        }
                        resEntry.setStringPoolIndex(resPackage.getResProguardPool().getStringIndexMap().get(resEntry.getEntryName()));
                    }
                }
            }
            resPackage.refresh();
        }
        resTable.refresh();
    }

    public static boolean replaceResFileName(ResTable resTable, int resId, String srcFileName, String targetFileName) {
        Log.d((String)TAG, (String)"try to replace resource (%H) file %s with %s", (Object[])new Object[]{resId, srcFileName, targetFileName});
        ResPackage resPackage = ArscUtil.findResPackage(resTable, ArscUtil.getPackageId(resId));
        boolean result = false;
        if (resPackage != null) {
            List<ResType> resTypeList = ArscUtil.findResType(resPackage, resId);
            for (ResType resType : resTypeList) {
                String filePath;
                int entryId = ArscUtil.getResourceEntryId(resId);
                ResEntry resEntry = resType.getEntryTable().get(entryId);
                if (resEntry.getResValue().getDataType() != 3 || !(filePath = ResStringBlock.resolveStringPoolEntry(resTable.getGlobalStringPool().getStrings().get(resEntry.getResValue().getData()).array(), resTable.getGlobalStringPool().getCharSet())).equals(srcFileName)) continue;
                resTable.getGlobalStringPool().getStrings().set(resEntry.getResValue().getData(), ByteBuffer.wrap(ResStringBlock.encodeStringPoolEntry(targetFileName, resTable.getGlobalStringPool().getCharSet())));
                result = true;
                break;
            }
            if (result) {
                resTable.getGlobalStringPool().refresh();
                resTable.refresh();
            } else {
                Log.w((String)TAG, (String)"srcFile %s not referenced by resource (%H)", (Object[])new Object[]{srcFileName, resId});
            }
        }
        return result;
    }
}

