/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mars.xlog;

import com.tencent.mars.xlog.Log;

public class Xlog
implements Log.LogImp {
    public static final int LEVEL_ALL = 0;
    public static final int LEVEL_VERBOSE = 0;
    public static final int LEVEL_DEBUG = 1;
    public static final int LEVEL_INFO = 2;
    public static final int LEVEL_WARNING = 3;
    public static final int LEVEL_ERROR = 4;
    public static final int LEVEL_FATAL = 5;
    public static final int LEVEL_NONE = 6;
    public static final int AppednerModeAsync = 0;
    public static final int AppednerModeSync = 1;

    public static void open(boolean isLoadLib, int level, int mode, String cacheDir, String logDir, String nameprefix, String pubkey) {
        if (isLoadLib) {
            System.loadLibrary("stlport_shared");
            System.loadLibrary("marsxlog");
        }
        Xlog.appenderOpen(level, mode, cacheDir, logDir, nameprefix, pubkey);
    }

    private static String decryptTag(String tag) {
        return tag;
    }

    @Override
    public void logV(String tag, String filename, String funcname, int line, int pid, long tid, long maintid, String log) {
        Xlog.logWrite2(0, Xlog.decryptTag(tag), filename, funcname, line, pid, tid, maintid, log);
    }

    @Override
    public void logD(String tag, String filename, String funcname, int line, int pid, long tid, long maintid, String log) {
        Xlog.logWrite2(1, Xlog.decryptTag(tag), filename, funcname, line, pid, tid, maintid, log);
    }

    @Override
    public void logI(String tag, String filename, String funcname, int line, int pid, long tid, long maintid, String log) {
        Xlog.logWrite2(2, Xlog.decryptTag(tag), filename, funcname, line, pid, tid, maintid, log);
    }

    @Override
    public void logW(String tag, String filename, String funcname, int line, int pid, long tid, long maintid, String log) {
        Xlog.logWrite2(3, Xlog.decryptTag(tag), filename, funcname, line, pid, tid, maintid, log);
    }

    @Override
    public void logE(String tag, String filename, String funcname, int line, int pid, long tid, long maintid, String log) {
        Xlog.logWrite2(4, Xlog.decryptTag(tag), filename, funcname, line, pid, tid, maintid, log);
    }

    @Override
    public void logF(String tag, String filename, String funcname, int line, int pid, long tid, long maintid, String log) {
        Xlog.logWrite2(5, Xlog.decryptTag(tag), filename, funcname, line, pid, tid, maintid, log);
    }

    public static native void logWrite(XLoggerInfo var0, String var1);

    public static native void logWrite2(int var0, String var1, String var2, String var3, int var4, int var5, long var6, long var8, String var10);

    @Override
    public native int getLogLevel();

    public static native void setLogLevel(int var0);

    public static native void setAppenderMode(int var0);

    public static native void setConsoleLogOpen(boolean var0);

    public static native void setErrLogOpen(boolean var0);

    public static native void appenderOpen(int var0, int var1, String var2, String var3, String var4, String var5);

    @Override
    public native void appenderClose();

    @Override
    public native void appenderFlush(boolean var1);

    static class XLoggerInfo {
        public int level;
        public String tag;
        public String filename;
        public String funcname;
        public int line;
        public long pid;
        public long tid;
        public long maintid;

        XLoggerInfo() {
        }
    }
}

