/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tencentmap.mapsdk.maps.model;

import android.graphics.Color;
import android.os.Parcel;
import com.tencent.tencentmap.mapsdk.maps.model.Animation;
import com.tencent.tencentmap.mapsdk.maps.model.BitmapDescriptor;
import com.tencent.tencentmap.mapsdk.maps.model.BitmapDescriptorFactory;
import com.tencent.tencentmap.mapsdk.maps.model.IndoorInfo;
import com.tencent.tencentmap.mapsdk.maps.model.LatLng;
import com.tencent.tencentmap.mapsdk.maps.model.OverlayLevel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class PolylineOptions {
    private static final int LINE_UNINITIALIZED_WIDTH = -1;
    private static final int LINE_DEFAULT_WIDTH = 9;
    private static final int COLOR_DEFAULT_POLYLINE = Color.argb((int)200, (int)0, (int)163, (int)255);
    private final List<LatLng> listLatLngs;
    private float fwidth = -1.0f;
    private float fBorderWidth;
    private int iStrokeColor;
    private int fIndex = 0;
    private boolean boVisible = true;
    private boolean boIsGeodes = false;
    private boolean boArraw;
    private boolean boIsAbove = false;
    private float alpha = 1.0f;
    private boolean lineCap = true;
    private Animation initAnimation;
    private List<Integer> pattern;
    private int[] iColors = null;
    private int[] iBorderColors = new int[]{-16711936};
    private int[] iIndexs = null;
    private int eraseColor = -7829368;
    private int lineType = 0;
    private BitmapDescriptor mCustomeColorTexture = BitmapDescriptorFactory.fromAsset(sDefaultColorTexture);
    private boolean mAboveMaskLayer = false;
    private boolean mIsRoad = true;
    private BitmapDescriptor mArrowTexture = null;
    private static String sDefaultColorTexture = "color_texture_flat_style.png";
    @Deprecated
    private static String sDefaultArrowTexture;
    private boolean mClickable;
    private ColorType colorType = ColorType.LINE_COLOR_NONE;
    private IndoorInfo mIndoorInfo;
    private int iLevel = OverlayLevel.OverlayLevelAboveRoads;
    private Text mText;
    @Deprecated
    private String strCustomerTextName = sDefaultColorTexture;
    private int mArrowSpacing = 150;

    public PolylineOptions() {
        this.iStrokeColor = COLOR_DEFAULT_POLYLINE;
        this.listLatLngs = new ArrayList<LatLng>();
    }

    @Deprecated
    public void setLatLngs(List<LatLng> listLatlngs) {
        this.latLngs(listLatlngs);
    }

    public PolylineOptions latLngs(List<LatLng> listLatlngs) {
        if (listLatlngs != null) {
            this.listLatLngs.clear();
            this.listLatLngs.addAll(listLatlngs);
        }
        return this;
    }

    public PolylineOptions add(LatLng latlng, LatLng ... args) {
        this.listLatLngs.add(latlng);
        if (args != null) {
            this.add(args);
        }
        return this;
    }

    public PolylineOptions add(LatLng[] latLngs) {
        if (latLngs != null) {
            this.listLatLngs.addAll(Arrays.asList(latLngs));
        }
        return this;
    }

    public PolylineOptions addAll(Iterable<LatLng> latLngs) {
        if (latLngs != null) {
            for (LatLng ll : latLngs) {
                this.add(ll, new LatLng[0]);
            }
        }
        return this;
    }

    public PolylineOptions updatePoints(Iterable<LatLng> latLngs) {
        ArrayList<LatLng> points = new ArrayList<LatLng>();
        if (latLngs != null) {
            for (LatLng p2 : latLngs) {
                points.add(p2);
            }
        }
        this.listLatLngs.clear();
        this.addAll(points);
        return this;
    }

    public PolylineOptions width(float width) {
        if (width < 0.0f) {
            this.fwidth = 9.0f;
        } else {
            if (width > 128.0f) {
                width = 128.0f;
            }
            this.fwidth = width;
        }
        return this;
    }

    public PolylineOptions borderWidth(float borderWidth) {
        this.fBorderWidth = borderWidth < 0.0f ? 1.0f : borderWidth;
        return this;
    }

    public PolylineOptions colorType(ColorType type) {
        this.colorType = type;
        return this;
    }

    public ColorType getColorType() {
        return this.colorType;
    }

    public PolylineOptions color(int i2) {
        this.iStrokeColor = i2;
        return this;
    }

    public PolylineOptions colors(int[] colors, int[] indexes) {
        this.iColors = colors;
        this.iIndexs = indexes;
        return this;
    }

    public PolylineOptions borderColors(int[] borderColors) {
        this.iBorderColors = borderColors;
        return this;
    }

    public PolylineOptions borderColor(int borderColor) {
        this.iBorderColors = new int[]{borderColor};
        return this;
    }

    public PolylineOptions eraseColor(int eraseColor) {
        this.eraseColor = eraseColor;
        return this;
    }

    public int getEraseColor() {
        return this.eraseColor;
    }

    public PolylineOptions zIndex(int zIndex) {
        this.fIndex = Math.max(0, zIndex);
        return this;
    }

    public PolylineOptions indoorInfo(IndoorInfo indoorInfo) {
        if (indoorInfo != null) {
            this.mIndoorInfo = indoorInfo;
            this.boIsAbove = true;
        }
        return this;
    }

    public PolylineOptions visible(boolean visible) {
        this.boVisible = visible;
        return this;
    }

    @Deprecated
    public void setColors(int[] colors, int[] indexes) {
        this.iColors = colors;
        this.iIndexs = indexes;
    }

    private PolylineOptions geodesic(boolean geodesic) {
        this.boIsGeodes = geodesic;
        return this;
    }

    public PolylineOptions arrow(boolean flag) {
        this.boArraw = flag;
        return this;
    }

    public PolylineOptions abovePillar(boolean isAbove) {
        this.boIsAbove = isAbove;
        if (this.mIndoorInfo != null) {
            this.boIsAbove = true;
        }
        return this;
    }

    public PolylineOptions alpha(float a2) {
        this.alpha = a2;
        return this;
    }

    public PolylineOptions lineCap(boolean cap) {
        this.lineCap = cap;
        return this;
    }

    public PolylineOptions animation(Animation a2) {
        this.initAnimation = a2;
        return this;
    }

    public List<LatLng> getPoints() {
        return this.listLatLngs;
    }

    public float getWidth() {
        return this.fwidth;
    }

    public int getColor() {
        return this.iStrokeColor;
    }

    public int[][] getColors() {
        if (this.iColors == null || this.iIndexs == null) {
            return null;
        }
        if (this.iColors.length != this.iIndexs.length) {
            return null;
        }
        int[][] nArray = new int[2][this.iColors.length];
        int[][] mutliColors = nArray;
        nArray[0] = this.iColors;
        mutliColors[1] = this.iIndexs;
        return mutliColors;
    }

    public int getZIndex() {
        return this.fIndex;
    }

    public IndoorInfo getIndoorInfo() {
        return this.mIndoorInfo;
    }

    public boolean isVisible() {
        return this.boVisible;
    }

    private boolean isGeodesic() {
        return this.boIsGeodes;
    }

    public boolean isArrow() {
        return this.boArraw;
    }

    public boolean isAbovePillar() {
        return this.boIsAbove;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public boolean getLineCap() {
        return this.lineCap;
    }

    public Animation getAnimation() {
        return this.initAnimation;
    }

    public int getLineType() {
        return this.lineType;
    }

    @Deprecated
    public PolylineOptions setLineType(int lineType) {
        return this.lineType(lineType);
    }

    public PolylineOptions lineType(int lineType) {
        this.lineType = lineType;
        return this;
    }

    @Deprecated
    public PolylineOptions setColorTexture(String strTextureName) {
        this.strCustomerTextName = strTextureName;
        return this.colorTexture(BitmapDescriptorFactory.fromAsset(strTextureName));
    }

    public PolylineOptions colorTexture(BitmapDescriptor bitmapDescriptor) {
        this.mCustomeColorTexture = bitmapDescriptor;
        this.colorType = ColorType.LINE_COLOR_TEXTURE;
        return this;
    }

    @Deprecated
    public String getTextureName() {
        return this.strCustomerTextName;
    }

    public BitmapDescriptor getColorTexture() {
        return this.mCustomeColorTexture;
    }

    public PolylineOptions aboveMaskLayer(boolean above) {
        this.mAboveMaskLayer = above;
        return this;
    }

    public boolean isAboveMaskLayer() {
        return this.mAboveMaskLayer;
    }

    public PolylineOptions road(boolean isRoad) {
        this.mIsRoad = isRoad;
        return this;
    }

    public boolean isRoad() {
        return this.mIsRoad;
    }

    public PolylineOptions level(int level) {
        if (level < OverlayLevel.OverlayLevelAboveRoads || level > OverlayLevel.OverlayLevelAboveLabels) {
            return this;
        }
        this.iLevel = level;
        return this;
    }

    public int getLevel() {
        return this.iLevel;
    }

    public PolylineOptions arrowTexture(BitmapDescriptor arrowTexture) {
        this.mArrowTexture = arrowTexture;
        return this;
    }

    public PolylineOptions arrowSpacing(int arrowSpacing) {
        this.mArrowSpacing = arrowSpacing;
        return this;
    }

    @Deprecated
    public static void setDefaultArrowTexture(String textureName) {
        sDefaultArrowTexture = textureName;
    }

    @Deprecated
    public static String getsDefaultArrowTexture() {
        return sDefaultArrowTexture;
    }

    public BitmapDescriptor getArrowTexture() {
        return this.mArrowTexture;
    }

    public int getArrowSpacing() {
        return this.mArrowSpacing;
    }

    public PolylineOptions clickable(boolean clickable) {
        this.mClickable = clickable;
        return this;
    }

    public boolean isClickable() {
        return this.mClickable;
    }

    public void writeToParcel(Parcel out, int flags) {
        if (out == null) {
            return;
        }
        out.writeFloat(this.fwidth);
    }

    public List<Integer> getPattern() {
        return this.pattern;
    }

    public PolylineOptions pattern(List<Integer> pattern) {
        this.pattern = pattern;
        return this;
    }

    public float getBorderWidth() {
        return this.fBorderWidth;
    }

    public int[] getBorderColors() {
        return this.iBorderColors;
    }

    public PolylineOptions text(Text text) {
        this.mText = text;
        return this;
    }

    public Text getText() {
        return this.mText;
    }

    public static enum ColorType {
        LINE_COLOR_NONE,
        LINE_COLOR_TEXTURE,
        LINE_COLOR_ARGB;

    }

    public static final class LineType {
        public static final int LINE_TYPE_MULTICOLORLINE = 0;
        public static final int LINE_TYPE_IMAGEINARYLINE = 1;
        public static final int LINE_TYPE_DOTTEDLINE = 2;
    }

    public static final class Colors {
        public static final int GREY = 0;
        public static final int LIGHT_BLUE = 1;
        public static final int RED = 2;
        public static final int YELLOW = 3;
        public static final int GREEN = 4;
        public static final int MID_BLUE = 5;
        public static final int DARK_BLUE = 6;
        public static final int TRANSPARENT = 7;
        public static final int GRAYBLUE = 8;
        public static final int LIVER_RED = 9;
        public static final int DASHED = 33;
        public static final int WHITE_BLUE = 19;
        public static final int LAST_BLUE = 20;
    }

    public static enum TextPriority {
        NORMAL,
        HIGH;

    }

    public static final class SegmentText {
        private final int startIndex;
        private final int endIndex;
        private final String text;

        public SegmentText(int startIndex, int endIndex, String text) {
            this.startIndex = startIndex;
            this.endIndex = endIndex;
            this.text = text;
        }

        public final int getStartIndex() {
            return this.startIndex;
        }

        public final int getEndIndex() {
            return this.endIndex;
        }

        public final String getText() {
            return this.text;
        }
    }

    public static final class Text {
        private final List<SegmentText> mSegmentTexts;
        private Builder mBuilder;

        private Text(Builder builder) {
            this.mSegmentTexts = Collections.unmodifiableList(builder.mTexts);
            this.mBuilder = builder;
        }

        public final List<SegmentText> getSegmentTexts() {
            return this.mSegmentTexts;
        }

        public final int getTextColor() {
            return this.mBuilder.textColor;
        }

        public final void setTextColor(int textColor) {
            this.mBuilder.textColor = textColor;
        }

        public final int getStrokeColor() {
            return this.mBuilder.strokeColor;
        }

        public final void setStrokeColor(int strokeColor) {
            this.mBuilder.strokeColor = strokeColor;
        }

        public final int getTextSize() {
            return this.mBuilder.textSize;
        }

        public final void setTextSize(int textSize) {
            this.mBuilder.textSize = textSize;
        }

        public final TextPriority getPriority() {
            return this.mBuilder.priority;
        }

        public final void setPriority(TextPriority priority) {
            this.mBuilder.priority = priority;
        }

        public static final class Builder {
            private List<SegmentText> mTexts = new ArrayList<SegmentText>();
            private int textColor = -16777216;
            private int strokeColor = -1;
            private int textSize = 14;
            private TextPriority priority = TextPriority.HIGH;

            public Builder(SegmentText segmentText) {
                this.addSegmentText(segmentText);
            }

            public Builder(List<SegmentText> segmentTexts) {
                this.addAllSegmentText(segmentTexts);
            }

            public final Builder addSegmentText(SegmentText segmentText) {
                this.mTexts.add(segmentText);
                return this;
            }

            public final Builder addAllSegmentText(List<SegmentText> segmentTexts) {
                this.mTexts.addAll(segmentTexts);
                return this;
            }

            public final Builder color(int color) {
                this.textColor = color;
                return this;
            }

            public final Builder strokeColor(int color) {
                this.strokeColor = color;
                return this;
            }

            public final Builder size(int size) {
                this.textSize = size;
                return this;
            }

            public final Builder priority(TextPriority priority) {
                this.priority = priority;
                return this;
            }

            public final Text build() {
                return new Text(this);
            }
        }
    }
}

