/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.map.sdk.utilities.heatmap;

import android.graphics.Color;
import java.util.HashMap;

public class Gradient {
    private static final int DEFAULT_COLOR_MAP_SIZE = 1000;
    public final int mColorMapSize;
    public int[] mColors;
    public float[] mStartPoints;

    public Gradient(int[] colors, float[] startPoints) {
        this(colors, startPoints, 1000);
    }

    public Gradient(int[] colors, float[] startPoints, int colorMapSize) {
        if (colors.length != startPoints.length) {
            throw new IllegalArgumentException("colors and startPoints should be same length");
        }
        if (colors.length == 0) {
            throw new IllegalArgumentException("No colors have been defined");
        }
        for (int i2 = 1; i2 < startPoints.length; ++i2) {
            if (!(startPoints[i2] <= startPoints[i2 - 1])) continue;
            throw new IllegalArgumentException("startPoints should be in increasing order");
        }
        this.mColorMapSize = colorMapSize;
        this.mColors = new int[colors.length];
        this.mStartPoints = new float[startPoints.length];
        System.arraycopy(colors, 0, this.mColors, 0, colors.length);
        System.arraycopy(startPoints, 0, this.mStartPoints, 0, startPoints.length);
    }

    private HashMap<Integer, a> generateColorIntervals() {
        int i2;
        HashMap<Integer, a> colorIntervals = new HashMap<Integer, a>();
        if (this.mStartPoints[0] != 0.0f) {
            int initialColor = Color.argb((int)0, (int)Color.red((int)this.mColors[0]), (int)Color.green((int)this.mColors[0]), (int)Color.blue((int)this.mColors[0]));
            colorIntervals.put(0, new a(initialColor, this.mColors[0], (float)this.mColorMapSize * this.mStartPoints[0], 0));
        }
        for (i2 = 1; i2 < this.mColors.length; ++i2) {
            Gradient gradient = this;
            colorIntervals.put((int)((float)this.mColorMapSize * this.mStartPoints[i2 - 1]), gradient.new a(gradient.mColors[i2 - 1], this.mColors[i2], (float)this.mColorMapSize * (this.mStartPoints[i2] - this.mStartPoints[i2 - 1]), 0));
        }
        if (this.mStartPoints[this.mStartPoints.length - 1] != 1.0f) {
            i2 = this.mStartPoints.length - 1;
            Gradient gradient = this;
            colorIntervals.put((int)((float)this.mColorMapSize * this.mStartPoints[i2]), gradient.new a(gradient.mColors[i2], this.mColors[i2], (float)this.mColorMapSize * (1.0f - this.mStartPoints[i2]), 0));
        }
        return colorIntervals;
    }

    public final int[] generateColorMap(double opacity) {
        int i2;
        HashMap<Integer, a> colorIntervals = this.generateColorIntervals();
        int[] colorMap = new int[this.mColorMapSize];
        a interval = colorIntervals.get(0);
        int start = 0;
        for (i2 = 0; i2 < this.mColorMapSize; ++i2) {
            if (colorIntervals.containsKey(i2)) {
                interval = colorIntervals.get(i2);
                start = i2;
            }
            float ratio = (float)(i2 - start) / interval.c;
            colorMap[i2] = Gradient.interpolateColor(interval.a, interval.b, ratio);
        }
        if (opacity != 1.0) {
            for (i2 = 0; i2 < this.mColorMapSize; ++i2) {
                int c2 = colorMap[i2];
                colorMap[i2] = Color.argb((int)((int)((double)Color.alpha((int)c2) * opacity)), (int)Color.red((int)c2), (int)Color.green((int)c2), (int)Color.blue((int)c2));
            }
        }
        return colorMap;
    }

    static int interpolateColor(int color1, int color2, float ratio) {
        int alpha = (int)((float)(Color.alpha((int)color2) - Color.alpha((int)color1)) * ratio + (float)Color.alpha((int)color1));
        float[] hsv1 = new float[3];
        Color.RGBToHSV((int)Color.red((int)color1), (int)Color.green((int)color1), (int)Color.blue((int)color1), (float[])hsv1);
        float[] hsv2 = new float[3];
        Color.RGBToHSV((int)Color.red((int)color2), (int)Color.green((int)color2), (int)Color.blue((int)color2), (float[])hsv2);
        if (hsv1[0] - hsv2[0] > 180.0f) {
            hsv2[0] = hsv2[0] + 360.0f;
        } else if (hsv2[0] - hsv1[0] > 180.0f) {
            hsv1[0] = hsv1[0] + 360.0f;
        }
        float[] result = new float[3];
        for (int i2 = 0; i2 < 3; ++i2) {
            result[i2] = (hsv2[i2] - hsv1[i2]) * ratio + hsv1[i2];
        }
        return Color.HSVToColor((int)alpha, (float[])result);
    }

    final class a {
        final int a;
        final int b;
        final float c;

        private a(int color1, int color2, float duration) {
            this.a = color1;
            this.b = color2;
            this.c = duration;
        }

        /* synthetic */ a(int x1, int x2, float x3, byte by) {
            this(x1, x2, x3);
        }
    }
}

