/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tencentmap.mapsdk.maps;

import android.graphics.SurfaceTexture;
import android.graphics.Typeface;
import android.os.Bundle;
import android.view.Surface;
import android.view.SurfaceHolder;
import com.tencent.map.tools.Callback;
import com.tencent.map.tools.net.AdapterType;
import com.tencent.tencentmap.mapsdk.maps.TencentMap;
import com.tencent.tencentmap.mapsdk.maps.model.MapViewType;
import java.lang.reflect.Field;
import java.util.Arrays;

public final class TencentMapOptions {
    public static final int LOGO_POSITION_BOTTOM_LEFT = 0;
    public static final int LOGO_POSITION_BOTTOM_RIGHT = 1;
    public static final int LOGO_POSITION_TOP_RIGHT = 2;
    public static final int LOGO_POSITION_TOP_LEFT = 3;
    public static final int LOGO_POSITION_BOTTOM_CENTER = 4;
    public static final int LOGO_POSITION_TOP_CENTER = 5;
    public static final int SCALEVIEW_POSITION_BOTTOM_LEFT = 0;
    public static final int SCALEVIEW_POSITION_BOTTOM_RIGHT = 1;
    public static final int SCALEVIEW_POSITION_TOP_RIGHT = 2;
    public static final int SCALEVIEW_POSITION_TOP_LEFT = 3;
    public static final int SCALEVIEW_POSITION_BOTTOM_CENTER = 4;
    public static final int SCALEVIEW_POSITION_TOP_CENTER = 5;
    public static final int ZOOM_POSITION_BOTTOM_LEFT = 0;
    public static final int ZOOM_POSITION_BOTTOM_RIGHT = 1;
    public static final int ZOOM_POSITION_TOP_RIGHT = 2;
    public static final int ZOOM_POSITION_TOP_LEFT = 3;
    private String customAssetsPath;
    private String customLocalPath;
    private boolean isHandDrawMapEnable = false;
    private Object mExtSurface;
    private int mExtSurfaceWidth;
    private int mExtSurfaceHeight;
    private String mSubId;
    private String mSubKey;
    private String mMapKey;
    private boolean isEnableMultipleInfoWindow = false;
    private String[] mDebugTags;
    private String mSatelliteVersion = "0";
    private MapViewType mMapViewType;
    private IMapKernel mMapKernel;
    private Typeface mUserTypeface;
    private int mProtocolFrom;
    private Object mProtocolDataDesc;
    private AdapterType mNetAdapterType = AdapterType.DEFAULT;
    private Bundle mNetParams;
    private String mCustomUserId;
    private Callback<TencentMap> mMapCallback;

    public final String getCustomAssetsPath() {
        return this.customAssetsPath;
    }

    public final void setCustomAssetsPath(String customAssetsPath) {
        this.customAssetsPath = customAssetsPath;
    }

    public final String getCustomLocalPath() {
        return this.customLocalPath;
    }

    public final void setCustomLocalPath(String customLocalPath) {
        this.customLocalPath = customLocalPath;
    }

    public final TencentMapOptions setHandDrawMapEnable(boolean enable) {
        this.isHandDrawMapEnable = enable;
        return this;
    }

    public final boolean isHandDrawMapEnable() {
        return this.isHandDrawMapEnable;
    }

    public final Object getExtSurface() {
        return this.mExtSurface;
    }

    public final void setExtSurface(Object surface) {
        if (!(surface instanceof Surface || surface instanceof SurfaceTexture || surface instanceof SurfaceHolder)) {
            throw new IllegalArgumentException("Parameter Surface should be Surface,SurfaceTexture or SurfaceHolder");
        }
        this.mExtSurface = surface;
    }

    public final void setTypeface(Typeface typeface) {
        this.setTypeface(typeface, false);
    }

    private void setTypeface(Typeface typeface, boolean global) {
        if (typeface == null) {
            return;
        }
        if (global) {
            try {
                Field defTypeface = Typeface.class.getDeclaredField("DEFAULT");
                defTypeface.setAccessible(true);
                defTypeface.set(Typeface.DEFAULT, typeface);
                return;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                noSuchFieldException.printStackTrace();
                return;
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
                return;
            }
        }
        this.mUserTypeface = typeface;
    }

    public final Typeface getTypeface() {
        if (this.mUserTypeface == null) {
            return Typeface.DEFAULT;
        }
        return this.mUserTypeface;
    }

    public final String[] getDebugTags() {
        return this.mDebugTags;
    }

    public final void setExtSurfaceDimension(int width, int height) {
        this.mExtSurfaceWidth = width;
        this.mExtSurfaceHeight = height;
    }

    public final int getExtSurfaceWidth() {
        return this.mExtSurfaceWidth;
    }

    public final int getExtSurfaceHeight() {
        return this.mExtSurfaceHeight;
    }

    public final void setSubInfo(String subKey, String subId) {
        this.mSubKey = subKey != null ? subKey.trim() : "";
        if (subId != null) {
            this.mSubId = subId.trim();
            return;
        }
        this.mSubId = "";
    }

    public final String getSubId() {
        return this.mSubId;
    }

    public final String getSubKey() {
        return this.mSubKey;
    }

    public final void setMapKey(String mapKey) {
        this.mMapKey = mapKey;
    }

    public final String getMapKey() {
        return this.mMapKey;
    }

    public final void openDebugLogByTags(String ... tags) {
        this.mDebugTags = tags;
    }

    public final void setMultipleInfoWindowEnable(boolean isEnable) {
        this.isEnableMultipleInfoWindow = isEnable;
    }

    public final boolean isMultipleInfoWindowEnable() {
        return this.isEnableMultipleInfoWindow;
    }

    public final TencentMapOptions setSatelliteVersion(String version) {
        this.mSatelliteVersion = version;
        return this;
    }

    public final String getSatelliteVersion() {
        return this.mSatelliteVersion;
    }

    public final TencentMapOptions setMapViewType(MapViewType mapViewType) {
        this.mMapViewType = mapViewType;
        return this;
    }

    public final MapViewType getMapViewType() {
        return this.mMapViewType;
    }

    public final TencentMapOptions setMapKernel(IMapKernel kernel) {
        this.mMapKernel = kernel;
        return this;
    }

    public final IMapKernel getMapKernel() {
        return this.mMapKernel;
    }

    public final TencentMapOptions setServiceProtocol(int protocolFrom, Object protocolDataDesc) {
        this.mProtocolFrom = protocolFrom;
        this.mProtocolDataDesc = protocolDataDesc;
        return this;
    }

    public final int getProtocolFrom() {
        return this.mProtocolFrom;
    }

    public final Object getProtocolDataDesc() {
        return this.mProtocolDataDesc;
    }

    public final TencentMapOptions setNetAdapter(AdapterType adapterType, Bundle params) {
        this.mNetAdapterType = adapterType;
        this.mNetParams = params;
        return this;
    }

    public final AdapterType getNetAdapterType() {
        return this.mNetAdapterType;
    }

    public final Bundle getNetParams() {
        return this.mNetParams;
    }

    public final TencentMapOptions setCustomUserID(String cuid) {
        this.mCustomUserId = cuid;
        return this;
    }

    public final String getCustomUserId() {
        return this.mCustomUserId;
    }

    public final TencentMapOptions setGetMapAsync(Callback<TencentMap> callback) {
        this.mMapCallback = callback;
        return this;
    }

    public final Callback<TencentMap> getMapAsyncCallback() {
        return this.mMapCallback;
    }

    public final boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof TencentMapOptions)) {
            return false;
        }
        TencentMapOptions options = (TencentMapOptions)o2;
        if (this.isHandDrawMapEnable != options.isHandDrawMapEnable) {
            return false;
        }
        if (this.mExtSurfaceWidth != options.mExtSurfaceWidth) {
            return false;
        }
        if (this.mExtSurfaceHeight != options.mExtSurfaceHeight) {
            return false;
        }
        if (this.isEnableMultipleInfoWindow != options.isEnableMultipleInfoWindow) {
            return false;
        }
        if (this.mProtocolFrom != options.mProtocolFrom) {
            return false;
        }
        if (this.customAssetsPath != null ? !this.customAssetsPath.equals(options.customAssetsPath) : options.customAssetsPath != null) {
            return false;
        }
        if (this.customLocalPath != null ? !this.customLocalPath.equals(options.customLocalPath) : options.customLocalPath != null) {
            return false;
        }
        if (this.mExtSurface != null ? !this.mExtSurface.equals(options.mExtSurface) : options.mExtSurface != null) {
            return false;
        }
        if (this.mSubId != null ? !this.mSubId.equals(options.mSubId) : options.mSubId != null) {
            return false;
        }
        if (this.mSubKey != null ? !this.mSubKey.equals(options.mSubKey) : options.mSubKey != null) {
            return false;
        }
        if (this.mMapKey != null ? !this.mMapKey.equals(options.mMapKey) : options.mMapKey != null) {
            return false;
        }
        if (!Arrays.equals(this.mDebugTags, options.mDebugTags)) {
            return false;
        }
        if (this.mSatelliteVersion != null ? !this.mSatelliteVersion.equals(options.mSatelliteVersion) : options.mSatelliteVersion != null) {
            return false;
        }
        if (this.mMapViewType != options.mMapViewType) {
            return false;
        }
        if (this.mMapKernel != null ? !this.mMapKernel.equals(options.mMapKernel) : options.mMapKernel != null) {
            return false;
        }
        if (this.mUserTypeface != null ? !this.mUserTypeface.equals((Object)options.mUserTypeface) : options.mUserTypeface != null) {
            return false;
        }
        if (this.mProtocolDataDesc != null ? !this.mProtocolDataDesc.equals(options.mProtocolDataDesc) : options.mProtocolDataDesc != null) {
            return false;
        }
        if (this.mNetAdapterType != options.mNetAdapterType) {
            return false;
        }
        if (this.mNetParams != null ? !this.mNetParams.equals(options.mNetParams) : options.mNetParams != null) {
            return false;
        }
        if (this.mCustomUserId != null ? !this.mCustomUserId.equals(options.mCustomUserId) : options.mCustomUserId != null) {
            return false;
        }
        if (this.mMapCallback != null) {
            return this.mMapCallback.equals(options.mMapCallback);
        }
        return options.mMapCallback == null;
    }

    public final int hashCode() {
        int result = this.customAssetsPath != null ? this.customAssetsPath.hashCode() : 0;
        result = 31 * result + (this.customLocalPath != null ? this.customLocalPath.hashCode() : 0);
        result = 31 * result + (this.isHandDrawMapEnable ? 1 : 0);
        result = 31 * result + (this.mExtSurface != null ? this.mExtSurface.hashCode() : 0);
        result = 31 * result + this.mExtSurfaceWidth;
        result = 31 * result + this.mExtSurfaceHeight;
        result = 31 * result + (this.mSubId != null ? this.mSubId.hashCode() : 0);
        result = 31 * result + (this.mSubKey != null ? this.mSubKey.hashCode() : 0);
        result = 31 * result + (this.mMapKey != null ? this.mMapKey.hashCode() : 0);
        result = 31 * result + (this.isEnableMultipleInfoWindow ? 1 : 0);
        result = 31 * result + Arrays.hashCode(this.mDebugTags);
        result = 31 * result + (this.mSatelliteVersion != null ? this.mSatelliteVersion.hashCode() : 0);
        result = 31 * result + (this.mMapViewType != null ? this.mMapViewType.hashCode() : 0);
        result = 31 * result + (this.mMapKernel != null ? this.mMapKernel.hashCode() : 0);
        result = 31 * result + (this.mUserTypeface != null ? this.mUserTypeface.hashCode() : 0);
        result = 31 * result + this.mProtocolFrom;
        result = 31 * result + (this.mProtocolDataDesc != null ? this.mProtocolDataDesc.hashCode() : 0);
        result = 31 * result + (this.mNetAdapterType != null ? this.mNetAdapterType.hashCode() : 0);
        result = 31 * result + (this.mNetParams != null ? this.mNetParams.hashCode() : 0);
        result = 31 * result + (this.mCustomUserId != null ? this.mCustomUserId.hashCode() : 0);
        return 31 * result + (this.mMapCallback != null ? this.mMapCallback.hashCode() : 0);
    }

    public final String toString() {
        return "{customAssetsPath='" + this.customAssetsPath + '\'' + ", customLocalPath='" + this.customLocalPath + '\'' + ", isHandDrawMapEnable=" + this.isHandDrawMapEnable + ", mExtSurface=" + this.mExtSurface + ", mExtSurfaceWidth=" + this.mExtSurfaceWidth + ", mExtSurfaceHeight=" + this.mExtSurfaceHeight + ", mSubId='" + this.mSubId + '\'' + ", mSubKey='" + this.mSubKey + '\'' + ", mMapKey='" + this.mMapKey + '\'' + ", isEnableMultipleInfoWindow=" + this.isEnableMultipleInfoWindow + ", mDebugTags=" + (this.mDebugTags == null ? "null" : Arrays.asList(this.mDebugTags).toString()) + ", mSatelliteVersion='" + this.mSatelliteVersion + '\'' + ", mMapViewType=" + (Object)((Object)this.mMapViewType) + ", mMapKernel=" + this.mMapKernel + ", mUserTypeface=" + this.mUserTypeface + ", mProtocolFrom=" + this.mProtocolFrom + ", mProtocolDataDesc=" + this.mProtocolDataDesc + ", mNetAdapterType=" + (Object)((Object)this.mNetAdapterType) + ", mNetParams=" + this.mNetParams + ", mCustomUserId='" + this.mCustomUserId + '\'' + ", mMapCallback=" + this.mMapCallback + '}';
    }

    public static interface IMapKernel {
        public String name();
    }
}

