/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tencentmap.mapsdk.maps;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.ViewGroup;
import com.tencent.map.internal.a;
import com.tencent.map.tools.Callback;
import com.tencent.tencentmap.mapsdk.maps.BaseMapView;
import com.tencent.tencentmap.mapsdk.maps.TencentMap;
import com.tencent.tencentmap.mapsdk.maps.TencentMapOptions;

public class MapView
extends BaseMapView {
    private BaseMapView.MapViewProxy mMapDelegate;
    private TencentMapOptions mMapOptions;
    private TencentMap mMap;

    public MapView(@NonNull Context context) {
        this(context, new TencentMapOptions());
    }

    public MapView(@NonNull Context context, TencentMapOptions options) {
        super(context);
        this.mMap = this.getMap(options);
    }

    public MapView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MapView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mMap = this.getMap(new TencentMapOptions());
    }

    private void initMap(TencentMapOptions options) {
        if (this.mMap != null && (this.mMapOptions == options || this.mMapOptions.equals(options))) {
            return;
        }
        if (options == null) {
            options = new TencentMapOptions();
        }
        if (options.getMapViewType() == null) {
            options.setMapViewType(this.getViewType());
        }
        if (options.getMapKernel() == null) {
            options.setMapKernel(this.getMapKernel());
        }
        this.setClickable(true);
        if (this.mMap != null && this.mMapDelegate != null) {
            this.mMapDelegate.onPause();
            this.mMapDelegate.onStop();
            this.mMapDelegate.onDestroy();
            this.mMapDelegate = null;
            this.mMap = null;
        }
        final Callback<TencentMap> mapCallback = options.getMapAsyncCallback();
        if (this.mMapDelegate == null) {
            a wrapper = new a(this.getContext().getApplicationContext(), options);
            if (mapCallback != null) {
                wrapper.a((ViewGroup)this, options, new Callback<BaseMapView.MapViewProxy>(){

                    @Override
                    public final /* synthetic */ void callback(Object object) {
                        BaseMapView.MapViewProxy mapViewProxy = (BaseMapView.MapViewProxy)object;
                        1 var2_3 = this;
                        var2_3.MapView.this.mMapDelegate = mapViewProxy;
                        if (mapViewProxy != null) {
                            var2_3.MapView.this.mMapDelegate.onResume();
                            var2_3.mapCallback.callback(mapViewProxy.getMap());
                        }
                    }
                });
            } else {
                this.mMapDelegate = wrapper.a((ViewGroup)this, options);
            }
        }
        this.mMapOptions = options;
    }

    @Override
    public TencentMap getMap() {
        if (this.mMap != null) {
            return this.mMap;
        }
        MapView mapView = this;
        return mapView.getMap(mapView.mMapOptions);
    }

    @Override
    public TencentMap getMap(TencentMapOptions options) {
        this.initMap(options);
        if (this.mMapDelegate != null) {
            return this.mMapDelegate.getMap();
        }
        return null;
    }

    private <T extends TencentMap> void getMapSync(TencentMapOptions options, final Callback<T> callback) {
        options.setGetMapAsync(new Callback<TencentMap>(){

            @Override
            public final /* synthetic */ void callback(Object object) {
                final TencentMap tencentMap = (TencentMap)object;
                2 var2_3 = this;
                tencentMap.addOnMapLoadedCallback(new TencentMap.OnMapLoadedCallback(){

                    @Override
                    public final void onMapLoaded() {
                        if (callback != null) {
                            callback.callback(tencentMap);
                        }
                        tencentMap.removeOnMapLoadedCallback(this);
                    }
                });
            }
        });
        this.initMap(options);
    }

    public final boolean onTouchEvent(MotionEvent event) {
        if (this.mMapDelegate != null && this.mMapDelegate.isTouchable()) {
            return this.mMapDelegate.onTouchEvent(event);
        }
        return super.onTouchEvent(event);
    }

    @Override
    public void onStart() {
        if (this.mMapDelegate != null) {
            this.mMapDelegate.onStart();
        }
    }

    @Override
    public void onResume() {
        if (this.mMapDelegate != null) {
            this.mMapDelegate.onResume();
        }
    }

    @Override
    public void onPause() {
        if (this.mMapDelegate != null) {
            this.mMapDelegate.onPause();
        }
    }

    @Override
    public void onRestart() {
        if (this.mMapDelegate != null) {
            this.mMapDelegate.onRestart();
        }
    }

    @Override
    public void onStop() {
        if (this.mMapDelegate != null) {
            this.mMapDelegate.onStop();
        }
    }

    @Override
    public void onDestroy() {
        if (this.mMapDelegate != null) {
            this.mMapDelegate.onDestroy();
            this.mMapDelegate = null;
        }
        this.mMapOptions = null;
        this.mMap = null;
    }

    public void setOnTop(boolean isOnTop) {
        if (this.mMapDelegate != null) {
            this.mMapDelegate.setOnTop(isOnTop);
        }
    }

    public void setMapPadding(int left, int top, int right, int bottom) {
        this.setPadding(left, top, right, bottom);
    }

    public int[] getMapPadding() {
        return new int[]{this.getPaddingLeft(), this.getPaddingTop(), this.getPaddingRight(), this.getPaddingBottom()};
    }

    public void onSizeChanged(int w2, int h2, int oldw, int oldh) {
        super.onSizeChanged(w2, h2, oldw, oldh);
        if (this.mMapDelegate != null) {
            this.mMapDelegate.onSizeChanged(w2, h2, oldw, oldh);
        }
    }

    public void onSurfaceChanged(Object surfaceTexture, int width, int height) {
        if (!(surfaceTexture instanceof Surface || surfaceTexture instanceof SurfaceTexture || surfaceTexture instanceof SurfaceHolder)) {
            return;
        }
        if (this.mMapDelegate != null) {
            this.mMapDelegate.onSurfaceChanged(surfaceTexture, width, height);
        }
    }

    static {
        System.loadLibrary("txmapengine");
    }
}

