/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.map.tools;

import android.annotation.SuppressLint;
import android.app.ActivityManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.ConfigurationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLEncoder;

public class Util {
    private static final boolean DEBUG = false;
    private static final String TAG = "Util";
    private static final int DEFAUlT_GlEsVersion = 65537;
    public static final int SMALL_SCREEN_THRESHOLD = 400;
    public static final String META_NAME_API_KEY = "TencentMapSDK";

    public static float getDensity(Context context) {
        if (context == null) {
            return 1.0f;
        }
        return context.getResources().getDisplayMetrics().density;
    }

    public static int getWindowWidth(Context context) {
        return context.getResources().getDisplayMetrics().widthPixels;
    }

    public static int getWindowHeight(Context context) {
        return context.getResources().getDisplayMetrics().heightPixels;
    }

    public static int getOpenglesVersion(Context context) {
        ConfigurationInfo info = ((ActivityManager)context.getSystemService("activity")).getDeviceConfigurationInfo();
        if (info != null) {
            return info.reqGlEsVersion;
        }
        return 65537;
    }

    public static String getAppVersion(Context context) {
        if (context == null) {
            return "";
        }
        String version = "";
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            String versionName = packageInfo.versionName;
            int versionCode = packageInfo.versionCode;
            version = versionName + versionCode;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return version;
    }

    public static String getMetaKey(Context context, String metaName) {
        if (context == null) {
            return "";
        }
        String strPackagename = context.getPackageName();
        ApplicationInfo appInfo = null;
        try {
            appInfo = context.getPackageManager().getApplicationInfo(strPackagename, 128);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        if (appInfo == null) {
            return "";
        }
        if (appInfo.metaData == null) {
            return "";
        }
        return appInfo.metaData.getString(metaName);
    }

    @SuppressLint(value={"HardwareIds"})
    public static String getMacAddress(Context context) {
        WifiManager wifi = (WifiManager)context.getApplicationContext().getSystemService("wifi");
        if (wifi == null) {
            return "";
        }
        WifiInfo info = wifi.getConnectionInfo();
        if (info == null) {
            return "";
        }
        String strMac = info.getMacAddress();
        if (strMac == null) {
            strMac = "";
        }
        return strMac;
    }

    @SuppressLint(value={"HardwareIds", "MissingPermission"})
    public static String getIMei(Context context) {
        if (context == null) {
            return "";
        }
        TelephonyManager telManager = (TelephonyManager)context.getSystemService("phone");
        if (telManager == null) {
            return "";
        }
        int phoneType = telManager.getPhoneType();
        String imei = null;
        if (Build.VERSION.SDK_INT >= 23) {
            if (context.checkSelfPermission("android.permission.READ_PHONE_STATE") == 0) {
                if (Build.VERSION.SDK_INT >= 29) {
                    if (phoneType == 1) {
                        try {
                            imei = telManager.getImei();
                        }
                        catch (Exception e2) {
                            Log.w((String)"mapsdk", (String)"need permission android.Manifest.permission.READ_PRIVILEGED_PHONE_STATE", (Throwable)e2);
                        }
                    } else if (phoneType == 2) {
                        try {
                            imei = telManager.getMeid();
                        }
                        catch (Exception e3) {
                            Log.w((String)"mapsdk", (String)"need permission android.Manifest.permission.READ_PRIVILEGED_PHONE_STATE", (Throwable)e3);
                        }
                    }
                } else {
                    imei = telManager.getDeviceId();
                }
            }
        } else {
            try {
                imei = telManager.getDeviceId();
            }
            catch (Exception exception) {}
        }
        if (TextUtils.isEmpty((CharSequence)imei)) {
            imei = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        }
        if (TextUtils.isEmpty((CharSequence)imei)) {
            imei = "";
        }
        return imei;
    }

    public static String getAppName(Context context) {
        if (context == null) {
            return "";
        }
        PackageManager packageManager = context.getPackageManager();
        ApplicationInfo appInfo = null;
        try {
            appInfo = packageManager.getApplicationInfo(context.getPackageName(), 128);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            nameNotFoundException.printStackTrace();
        }
        CharSequence appName = "can't find app name";
        if (appInfo != null) {
            appName = appInfo.loadLabel(packageManager);
        }
        String resAppName = "";
        try {
            resAppName = URLEncoder.encode(appName.toString(), "utf-8");
        }
        catch (Exception exception) {}
        return resAppName;
    }

    public static String getResolution(Context context) {
        if (context == null) {
            return "";
        }
        String resolution = "";
        try {
            DisplayMetrics dm = context.getResources().getDisplayMetrics();
            resolution = dm.widthPixels + "*" + dm.heightPixels;
        }
        catch (Exception exception) {}
        return resolution;
    }

    public static String filterBuilder(String ... values) {
        String filter = "";
        if (values != null) {
            filter = "category=";
            for (int i2 = 0; i2 < values.length; ++i2) {
                filter = i2 == 0 ? filter + values[i2] : filter + "," + values[i2];
            }
        }
        return filter;
    }

    public static <T> T newInstance(Class<T> clz, Object ... paramsObj) {
        if (clz == null || clz.isEnum() || clz.isInterface() || clz.isAnnotation() || clz.isArray()) {
            return null;
        }
        Constructor<?>[] constructors = clz.getDeclaredConstructors();
        for (int i2 = 0; i2 < constructors.length; ++i2) {
            if (!Util.isMatchClassTypes(constructors[i2].getParameterTypes(), paramsObj)) continue;
            try {
                constructors[i2].setAccessible(true);
                return (T)constructors[i2].newInstance(paramsObj);
            }
            catch (IllegalAccessException illegalAccessException) {
                continue;
            }
            catch (InstantiationException instantiationException) {
                continue;
            }
            catch (InvocationTargetException e2) {
                throw new RuntimeException(e2.getTargetException());
            }
        }
        try {
            return clz.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException e3) {
            throw new RuntimeException(e3);
        }
        return null;
    }

    private static boolean isMatchClassTypes(Class<?>[] classes, Object[] objects) {
        if (classes.length != objects.length) {
            return false;
        }
        int matchedCount = 0;
        for (int i2 = 0; i2 < classes.length; ++i2) {
            if (classes[i2] != objects[i2].getClass() && !classes[i2].isAssignableFrom(objects[i2].getClass())) continue;
            ++matchedCount;
        }
        return matchedCount == classes.length;
    }

    public static void setField(Object object, String fieldName, Object value) {
        if (object == null) {
            return;
        }
        try {
            Field field = object.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(object, value);
            return;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
            return;
        }
    }

    public static Object getField(Object object, String fieldName) {
        if (object == null) {
            return null;
        }
        try {
            Field field = object.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            return field.get(object);
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (IllegalAccessException illegalAccessException) {}
        return null;
    }

    public static Object invokeMethod(Object object, String methodName, Object ... parameters) {
        if (object == null) {
            return null;
        }
        Class[] classes = new Class[parameters.length];
        for (int i2 = 0; i2 < classes.length; ++i2) {
            classes[i2] = parameters[i2].getClass();
        }
        try {
            Method method = Util.findMethod(object.getClass(), methodName, classes);
            if (method != null) {
                method.setAccessible(true);
                return method.invoke(object, parameters);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException e2) {
            throw new RuntimeException(e2.getTargetException());
        }
        return null;
    }

    public static Object invokeMethod(Object object, String methodName, Class[] classes, Object[] parameters) {
        if (object == null) {
            return null;
        }
        try {
            Method method = Util.findMethod(object.getClass(), methodName, classes);
            if (method != null) {
                method.setAccessible(true);
                return method.invoke(object, parameters);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException e2) {
            throw new RuntimeException(e2.getTargetException());
        }
        return null;
    }

    public static Object invokeStaticMethod(Class clazz, String methodName, Class[] classes, Object[] parameters) {
        if (clazz == null) {
            return null;
        }
        try {
            Method method = Util.findMethod(clazz, methodName, classes);
            if (method != null) {
                method.setAccessible(true);
                return method.invoke((Object)clazz, parameters);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException e2) {
            throw new RuntimeException(e2.getTargetException());
        }
        return null;
    }

    public static Method findMethod(Class clz, String methodName, Class[] paramTypes) {
        Method method;
        block2: {
            method = null;
            try {
                method = clz.getDeclaredMethod(methodName, paramTypes);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (clz.getSuperclass() == Object.class) break block2;
                method = Util.findMethod(clz.getSuperclass(), methodName, paramTypes);
            }
        }
        return method;
    }

    public static Class findClass(String classPath, ClassLoader classLoader) {
        try {
            return Class.forName(classPath, false, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public static <T> Class<? extends T> findClass(String classPath, Class<T> parentClz, ClassLoader classLoader) {
        try {
            Class<?> c2 = Class.forName(classPath, false, classLoader);
            if (parentClz.isAssignableFrom(c2)) {
                return c2;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {}
        return null;
    }
}

