/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.lbssearch.object.param;

import android.text.TextUtils;
import com.tencent.lbssearch.object.RequestParams;
import com.tencent.lbssearch.object.param.CoordTypeEnum;
import com.tencent.lbssearch.object.param.ParamObject;
import com.tencent.tencentmap.mapsdk.maps.model.LatLng;

public class Geo2AddressParam
implements ParamObject {
    private static final String LOCATION = "location";
    private static final String GET_POI = "get_poi";
    private static final String POI_OPTIONS = "poi_options";
    private LatLng latLng;
    private PoiOptions poiOptions;
    private boolean isGetPoi = false;

    public Geo2AddressParam() {
    }

    public Geo2AddressParam(LatLng latLng) {
        this.latLng = latLng;
    }

    public Geo2AddressParam location(LatLng latLng) {
        this.latLng = latLng;
        return this;
    }

    public Geo2AddressParam get_poi(boolean isGetPoi) {
        this.isGetPoi = isGetPoi;
        return this;
    }

    public Geo2AddressParam coord_type(CoordTypeEnum coordTypeEnum) {
        return this;
    }

    public Geo2AddressParam getPoi(boolean isGetPoi) {
        this.isGetPoi = isGetPoi;
        return this;
    }

    public Geo2AddressParam setPoiOptions(PoiOptions poiOptions) {
        this.poiOptions = poiOptions;
        return this;
    }

    @Override
    public boolean checkParams() {
        return this.latLng != null;
    }

    @Override
    public RequestParams buildParameters() {
        RequestParams params = new RequestParams();
        if (this.latLng != null) {
            params.add(LOCATION, this.latLng.latitude + "," + this.latLng.longitude);
        }
        params.add(GET_POI, this.isGetPoi ? "1" : "0");
        if (this.poiOptions != null) {
            params.add(POI_OPTIONS, this.poiOptions.toString());
        }
        return params;
    }

    public static class PoiOptions {
        public static final String ADDRESS_FORMAT_DEFAULT = "";
        public static final String ADDRESS_FORMAT_SHORT = "short";
        public static final int POLICY_DEFAULT = 1;
        public static final int POLICY_O2O = 2;
        public static final int POLICY_TRIP = 3;
        public static final int POLICY_SOCIAL = 4;
        public static final int POLICY_SHARE = 5;
        private String addressFormat;
        private int radius;
        private int pageSize;
        private int pageIndex;
        private int policy;
        private String[] categorys;

        public PoiOptions setAddressFormat(String addressFormat) {
            this.addressFormat = addressFormat;
            return this;
        }

        public PoiOptions setRadius(int radius) {
            this.radius = radius;
            return this;
        }

        public PoiOptions setPageSize(int pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public PoiOptions setPageIndex(int pageIndex) {
            this.pageIndex = pageIndex;
            return this;
        }

        public PoiOptions setPolicy(int policy) {
            this.policy = policy;
            return this;
        }

        public PoiOptions setCategorys(String ... category) {
            this.categorys = category;
            return this;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            if (!TextUtils.isEmpty((CharSequence)this.addressFormat)) {
                stringBuilder.append(";address_format=").append(this.addressFormat);
            }
            if (this.radius > 0 && this.radius <= 5000) {
                stringBuilder.append(";radius=").append(this.radius);
            }
            if (this.pageIndex > 0 && this.pageIndex <= 20 && this.pageSize > 0 && this.pageSize <= 20) {
                stringBuilder.append(";page_index=").append(this.pageIndex);
                stringBuilder.append(";page_size=").append(this.pageSize);
            }
            if (this.policy > 0) {
                stringBuilder.append(";policy=").append(this.policy);
            }
            if (this.categorys != null && this.categorys.length > 0) {
                int lastIndex;
                StringBuilder builder = new StringBuilder();
                String[] stringArray = this.categorys;
                int n2 = this.categorys.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    String category = stringArray[i2];
                    builder.append(category).append(",");
                }
                int n3 = lastIndex = builder.lastIndexOf(",");
                builder.delete(n3, n3 + 1);
                stringBuilder.append(";category=").append(builder.toString());
            }
            if (stringBuilder.indexOf(";") == 0) {
                stringBuilder.delete(0, 1);
            }
            return stringBuilder.toString();
        }
    }
}

