/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.map.geolocation;

import android.os.SystemClock;
import android.text.TextUtils;
import java.util.Locale;

public final class TencentGeofence {
    private final int a;
    private final double b;
    private final double c;
    private final float d;
    private final long e;
    private final String f;
    private final long g;

    private TencentGeofence(double d2, double d3, float f2, long l, String string) {
        this.a = 0;
        this.b = d2;
        this.c = d3;
        this.d = f2;
        this.g = l;
        this.e = SystemClock.elapsedRealtime() + l;
        this.f = string;
    }

    public final double getLatitude() {
        return this.b;
    }

    public final double getLongitude() {
        return this.c;
    }

    public final float getRadius() {
        return this.d;
    }

    public final long getExpireAt() {
        return this.e;
    }

    public final long getDuration() {
        return this.g;
    }

    public final String getTag() {
        return this.f;
    }

    public final int hashCode() {
        long l;
        long l2 = l = Double.doubleToLongBits(this.b);
        int n = 31 + (int)(l2 ^ l2 >>> 32);
        long l3 = l = Double.doubleToLongBits(this.c);
        n = 31 * n + (int)(l3 ^ l3 >>> 32);
        return 31 * n + (this.f == null ? 0 : this.f.hashCode());
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (TencentGeofence)object;
        if (Double.doubleToLongBits(this.b) != Double.doubleToLongBits(((TencentGeofence)object).b)) {
            return false;
        }
        if (Double.doubleToLongBits(this.c) != Double.doubleToLongBits(((TencentGeofence)object).c)) {
            return false;
        }
        return !(this.f == null ? ((TencentGeofence)object).f != null : !this.f.equals(((TencentGeofence)object).f));
    }

    public final String toString() {
        String string;
        Object[] objectArray = new Object[6];
        objectArray[0] = this.f;
        int n = this.a;
        switch (n) {
            case 0: {
                string = "CIRCLE";
                break;
            }
            default: {
                if (n != 0) {
                    throw new IllegalArgumentException("invalid type: ".concat(String.valueOf(n)));
                }
                string = null;
            }
        }
        objectArray[1] = string;
        objectArray[2] = this.b;
        objectArray[3] = this.c;
        objectArray[4] = Float.valueOf(this.d);
        objectArray[5] = (double)(this.e - SystemClock.elapsedRealtime()) / 1000.0;
        return String.format(Locale.US, "TencentGeofence[tag=%s, type=%s, loc=(%.6f, %.6f), radius=%.2fm life=%.2fs]", objectArray);
    }

    /* synthetic */ TencentGeofence(double d2, double d3, float f2, long l, String string, byte by) {
        this(d2, d3, f2, l, string);
    }

    public static class Builder {
        private double a;
        private double b;
        private float c;
        private long d;
        private String e;

        public Builder setCircularRegion(double d2, double d3, float f2) {
            if (f2 <= 0.0f) {
                throw new IllegalArgumentException("invalid radius: ".concat(String.valueOf(f2)));
            }
            if (d2 > 90.0 || d2 < -90.0) {
                throw new IllegalArgumentException("invalid latitude: ".concat(String.valueOf(d2)));
            }
            if (d3 > 180.0 || d3 < -180.0) {
                throw new IllegalArgumentException("invalid longitude: ".concat(String.valueOf(d3)));
            }
            this.a = d2;
            this.b = d3;
            this.c = f2;
            return this;
        }

        public Builder setExpirationDuration(long l) {
            if (l < 0L) {
                throw new IllegalArgumentException("invalid duration: ".concat(String.valueOf(l)));
            }
            this.d = l;
            return this;
        }

        public Builder setTag(String string) {
            if (TextUtils.isEmpty((CharSequence)string)) {
                throw new NullPointerException();
            }
            this.e = string;
            return this;
        }

        public TencentGeofence build() {
            return new TencentGeofence(this.a, this.b, this.c, this.d, this.e, 0);
        }
    }
}

