/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.trtc.impl;

import android.content.Context;
import android.content.SharedPreferences;
import java.util.concurrent.TimeUnit;

public class TRTCAudioServerConfig {
    public static final boolean DEFAULT_ENABLE_OPENSL = false;
    public static final boolean DEFAULT_ENABLE_AUTO_RESTART_DEVICE = false;
    public static final int DEFAULT_DEVICE_AUTO_RESTART_MIN_INTERVAL = 5000;
    public static final int DEFAULT_16K_PACKAGE_STRATEGY = 0;
    public static final int DEFAULT_MAX_SELECTED_PLAY_STREAMS = 0;
    private static final boolean DEFAULT_IS_LOW_LATENCY_SAMPLERATE_SUPPORTED = false;
    private static final long DEFAULT_LOW_LATENCY_SAMPLERATE_BLOCK_TIME = TimeUnit.DAYS.toMillis(7L);
    public static final int DEFAULT_IS_ENABLE_INBAND_FEC = 0;
    private static final String AUDIO_SERVER_CONFIG = "trtc_audio_server_config";
    private static final String KEY_ENABLE_OPENSL = "enable_opensl";
    private static final String KEY_ENABLE_AUTO_RESTART_DEVICE = "enable_auto_restart_device";
    private static final String KEY_DEVICE_AUTO_RESTART_MIN_INTERVAL = "device_auto_restart_interval";
    private static final String KEY_16K_PACKAGE_STRATEGY = "16k_package_strategy";
    private static final String KEY_MAX_SELECTED_PLAY_STREAMS = "max_selected_play_streams";
    private static final String KEY_IS_LOW_LATENCY_SAMPLERATE_SUPPORTED = "is_low_latency_samplerate_supported";
    private static final String KEY_LOW_LATENCY_SAMPLERATE_BLOCK_TIME = "low_latency_samplerate_block_time";
    private static final String KEY_ENABLE_INBAND_FEC = "enable_inband_fec";
    public boolean enableOpenSL = false;
    public boolean enableAutoRestartDevice = false;
    public int deviceAutoRestartMinInterval = 5000;
    public int audio16KPackageStrategy = 0;
    public int maxSelectedPlayStreams = 0;
    public boolean isLowLatencySampleRateSupported = false;
    public long lowLatencySampleRateBlockTime = DEFAULT_LOW_LATENCY_SAMPLERATE_BLOCK_TIME;
    public int enableInbandFEC = 0;

    public String toString() {
        return "enableOpenSL: " + this.enableOpenSL + ", enableAutoRestartDevice: " + this.enableAutoRestartDevice + ", deviceAutoRestartMinInterval: " + this.deviceAutoRestartMinInterval + ", audio16KPackageStrategy: " + this.audio16KPackageStrategy + ", isLowLatencySampleRateSupported: " + this.isLowLatencySampleRateSupported + ", lowLatencySampleRateBlockTime: " + this.lowLatencySampleRateBlockTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveToSharedPreferences(Context context, TRTCAudioServerConfig tRTCAudioServerConfig) {
        Class<TRTCAudioServerConfig> clazz = TRTCAudioServerConfig.class;
        synchronized (TRTCAudioServerConfig.class) {
            SharedPreferences sharedPreferences = context.getSharedPreferences(AUDIO_SERVER_CONFIG, 0);
            SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.putBoolean(KEY_ENABLE_OPENSL, tRTCAudioServerConfig.enableOpenSL);
            editor.putBoolean(KEY_ENABLE_AUTO_RESTART_DEVICE, tRTCAudioServerConfig.enableAutoRestartDevice);
            editor.putInt(KEY_DEVICE_AUTO_RESTART_MIN_INTERVAL, tRTCAudioServerConfig.deviceAutoRestartMinInterval);
            editor.putInt(KEY_16K_PACKAGE_STRATEGY, tRTCAudioServerConfig.audio16KPackageStrategy);
            editor.putInt(KEY_MAX_SELECTED_PLAY_STREAMS, tRTCAudioServerConfig.maxSelectedPlayStreams);
            editor.putBoolean(KEY_IS_LOW_LATENCY_SAMPLERATE_SUPPORTED, tRTCAudioServerConfig.isLowLatencySampleRateSupported);
            editor.putLong(KEY_LOW_LATENCY_SAMPLERATE_BLOCK_TIME, tRTCAudioServerConfig.lowLatencySampleRateBlockTime);
            editor.putInt(KEY_ENABLE_INBAND_FEC, tRTCAudioServerConfig.enableInbandFEC);
            editor.apply();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TRTCAudioServerConfig loadFromSharedPreferences(Context context) {
        Class<TRTCAudioServerConfig> clazz = TRTCAudioServerConfig.class;
        synchronized (TRTCAudioServerConfig.class) {
            TRTCAudioServerConfig tRTCAudioServerConfig = new TRTCAudioServerConfig();
            SharedPreferences sharedPreferences = context.getSharedPreferences(AUDIO_SERVER_CONFIG, 0);
            tRTCAudioServerConfig.enableOpenSL = sharedPreferences.getBoolean(KEY_ENABLE_OPENSL, false);
            tRTCAudioServerConfig.enableAutoRestartDevice = sharedPreferences.getBoolean(KEY_ENABLE_AUTO_RESTART_DEVICE, false);
            tRTCAudioServerConfig.deviceAutoRestartMinInterval = sharedPreferences.getInt(KEY_DEVICE_AUTO_RESTART_MIN_INTERVAL, 5000);
            tRTCAudioServerConfig.audio16KPackageStrategy = sharedPreferences.getInt(KEY_16K_PACKAGE_STRATEGY, 0);
            tRTCAudioServerConfig.maxSelectedPlayStreams = sharedPreferences.getInt(KEY_MAX_SELECTED_PLAY_STREAMS, 0);
            tRTCAudioServerConfig.isLowLatencySampleRateSupported = sharedPreferences.getBoolean(KEY_IS_LOW_LATENCY_SAMPLERATE_SUPPORTED, false);
            tRTCAudioServerConfig.lowLatencySampleRateBlockTime = sharedPreferences.getLong(KEY_LOW_LATENCY_SAMPLERATE_BLOCK_TIME, DEFAULT_LOW_LATENCY_SAMPLERATE_BLOCK_TIME);
            tRTCAudioServerConfig.enableInbandFEC = sharedPreferences.getInt(KEY_ENABLE_INBAND_FEC, 0);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return tRTCAudioServerConfig;
        }
    }
}

