/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.basic.datareport;

import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import com.tencent.liteav.basic.datareport.TXCDRExtInfo;
import com.tencent.liteav.basic.datareport.a;
import com.tencent.liteav.basic.log.TXCLog;
import com.tencent.liteav.basic.util.TXCCommonUtil;
import com.tencent.liteav.basic.util.TXCTimeUtil;
import com.tencent.liteav.basic.util.g;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.security.MessageDigest;
import java.util.UUID;

public class TXCDRApi {
    private static final String TAG = "TXCDRApi";
    private static String mDevType = "";
    private static String mNetType = "";
    private static String mDevId = "";
    private static String mDevUUID = "";
    private static String mAppName = "";
    private static String mSysVersion = "";
    private static String g_simulate_idfa = "";
    private static final char[] DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    static final int NETWORK_TYPE_UNKNOWN = 255;
    static final int NETWORK_TYPE_WIFI = 1;
    static final int NETWORK_TYPE_4G = 2;
    static final int NETWORK_TYPE_3G = 3;
    static final int NETWORK_TYPE_2G = 4;
    static boolean initRpt = false;

    public static void InitEvent(Context context, String string, int n2, int n3, TXCDRExtInfo tXCDRExtInfo) {
        TXCDRApi.setCommonInfo(context);
        if (string == null) {
            return;
        }
        TXCDRApi.nativeInitEventInternal(string, n2, n3, tXCDRExtInfo);
    }

    public static void txSetEventValue(String string, int n2, String string2, String string3) {
        TXCDRApi.nativeSetEventValueInterval(string, n2, string2, string3);
    }

    public static void txSetEventIntValue(String string, int n2, String string2, long l2) {
        TXCDRApi.nativeSetEventValueInterval(string, n2, string2, "" + l2);
    }

    public static void txReportDAU(Context context, int n2) {
        if (context != null) {
            TXCDRApi.setCommonInfo(context);
        }
        TXCDRApi.nativeReportDAUInterval(n2, 0, "");
    }

    public static void txReportDAU(Context context, int n2, int n3, String string) {
        if (context != null) {
            TXCDRApi.setCommonInfo(context);
        }
        TXCDRApi.nativeReportDAUInterval(n2, n3, string);
    }

    public static void reportEvent40003(String string, int n2, int n3, String string2, String string3) {
        TXCDRApi.nativeReportEvent40003(string, n2, n3, string2, string3);
    }

    public static void reportAVRoomEvent(int n2, long l2, String string, int n3, int n4, String string2, String string3) {
        TXCDRApi.nativeReportAVRoomEvent(n2, l2, string, n3, n4, string2, string3);
    }

    public static int getStatusReportInterval() {
        return TXCDRApi.nativeGetStatusReportInterval();
    }

    public static void setCommonInfo(Context context) {
        mDevType = Build.MODEL;
        mNetType = Integer.toString(TXCDRApi.getNetworkType(context));
        if (mDevId.isEmpty()) {
            mDevId = TXCDRApi.getSimulateIDFA(context);
        }
        if (mDevUUID.isEmpty()) {
            mDevUUID = TXCDRApi.getDevUUID(context, mDevId);
        }
        String string = TXCDRApi.getPackageName(context);
        mAppName = TXCDRApi.getApplicationNameByPackageName(context, string) + ":" + string;
        mSysVersion = String.valueOf(Build.VERSION.SDK_INT);
        TXCLog.i(TAG, "devType= " + mDevType + ", netType= " + mNetType + ", devId= " + mDevId + ", devUUID= " + mDevUUID + ", appName = " + mAppName + ", sysVersion= " + mSysVersion);
        TXCDRApi.txSetCommonInfo();
    }

    public static void txSetCommonInfo() {
        if (mDevType != null) {
            TXCDRApi.nativeSetCommonValue(a.f, mDevType);
        }
        if (mNetType != null) {
            TXCDRApi.nativeSetCommonValue(a.g, mNetType);
        }
        if (mDevId != null) {
            TXCDRApi.nativeSetCommonValue(a.h, mDevId);
        }
        if (mDevUUID != null) {
            TXCDRApi.nativeSetCommonValue(a.i, mDevUUID);
        }
        if (mAppName != null) {
            TXCDRApi.nativeSetCommonValue(a.j, mAppName);
        }
        if (mSysVersion != null) {
            TXCDRApi.nativeSetCommonValue(a.l, mSysVersion);
        }
    }

    public static void txSetAppVersion(String string) {
        if (string != null) {
            TXCDRApi.nativeSetCommonValue(a.k, string);
        }
    }

    public static String txCreateToken() {
        return UUID.randomUUID().toString();
    }

    private static String byteArrayToHexString(byte[] byArray) {
        char[] cArray = new char[byArray.length << 1];
        int n2 = 0;
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            cArray[n2++] = DIGITS_LOWER[(0xF0 & byArray[i2]) >>> 4];
            cArray[n2++] = DIGITS_LOWER[0xF & byArray[i2]];
        }
        return new String(cArray);
    }

    public static String string2Md5(String string) {
        String string2 = "";
        if (null == string) {
            return string2;
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            string2 = TXCDRApi.byteArrayToHexString(messageDigest.digest(string.getBytes("UTF-8")));
        }
        catch (Exception exception) {
            TXCLog.e(TAG, "string2Md5 failed.", exception);
        }
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    public static String getOrigAndroidID(Context context) {
        String string = "";
        try {
            string = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return TXCDRApi.string2Md5(string);
    }

    public static String getSimulateIDFA(Context context) {
        Object object;
        Object object2;
        File file;
        if (g_simulate_idfa != null && g_simulate_idfa.length() > 0) {
            return g_simulate_idfa;
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        File file2 = context.getExternalFilesDir(null);
        if (file2 == null) {
            TXCLog.e(TAG, "getSimulateIDFA sdcardDir is null");
            return g_simulate_idfa;
        }
        SharedPreferences sharedPreferences = context.getSharedPreferences("com.tencent.liteav.dev_uuid", 0);
        string2 = sharedPreferences.getString("com.tencent.liteav.key_dev_uuid", "");
        try {
            String string4 = file2.getAbsolutePath() + "/txrtmp/spuid";
            file = new File(string4);
            if (file.exists()) {
                object2 = new FileInputStream(file);
                int n2 = ((FileInputStream)object2).available();
                if (n2 > 0) {
                    object = new byte[n2];
                    ((FileInputStream)object2).read((byte[])object);
                    string3 = new String((byte[])object, "UTF-8");
                }
                ((FileInputStream)object2).close();
            }
        }
        catch (Exception exception) {
            TXCLog.e(TAG, "read UUID from file failed! reason: " + exception.getMessage());
        }
        if (string2 != null && string2.length() > 0) {
            string = string2;
        } else if (string3 != null && string3.length() > 0) {
            string = string3;
        }
        if (string == null || string.length() == 0) {
            int n3;
            string = "";
            long l2 = System.currentTimeMillis();
            long l3 = TXCTimeUtil.getTimeTick();
            object = g.c(context);
            for (n3 = 5; n3 >= 0; --n3) {
                string = string + String.format("%02x", (byte)(l2 >> n3 * 8 & 0xFFL));
            }
            for (n3 = 3; n3 >= 0; --n3) {
                string = string + String.format("%02x", (byte)(l3 >> n3 * 8 & 0xFFL));
            }
            string = string + TXCDRApi.string2Md5((String)object + UUID.randomUUID().toString());
        }
        g_simulate_idfa = string;
        TXCLog.i(TAG, "UUID:" + g_simulate_idfa);
        if (string3 == null || !string3.equals(string)) {
            try {
                File file3;
                String string5 = file2.getAbsolutePath() + "/txrtmp";
                file = new File(string5);
                if (!file.exists()) {
                    file.mkdir();
                }
                if (!(file3 = new File((String)(object2 = file2.getAbsolutePath() + "/txrtmp/spuid"))).exists()) {
                    file3.createNewFile();
                }
                object = new FileOutputStream(file3);
                byte[] byArray = string.getBytes();
                ((FileOutputStream)object).write(byArray);
                ((FileOutputStream)object).close();
            }
            catch (Exception exception) {
                TXCLog.e(TAG, "write UUID to file failed! reason: " + exception.getMessage());
            }
        }
        if (string2 == null || !string2.equals(string)) {
            SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.putString("com.tencent.liteav.key_dev_uuid", string);
            editor.commit();
        }
        return g_simulate_idfa;
    }

    public static String getDevUUID(Context context, String string) {
        return TXCDRApi.getSimulateIDFA(context);
    }

    public static int getNetworkType(Context context) {
        if (context == null) {
            return 255;
        }
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        NetworkInfo networkInfo = null;
        try {
            networkInfo = connectivityManager.getActiveNetworkInfo();
        }
        catch (Exception exception) {
            TXCLog.e(TAG, "getActiveNetworkInfo exception:", exception);
            return 255;
        }
        if (networkInfo == null) {
            return 255;
        }
        if (networkInfo.getType() == 1) {
            return 1;
        }
        if (networkInfo.getType() == 0) {
            int n2 = 255;
            try {
                n2 = telephonyManager.getNetworkType();
            }
            catch (Exception exception) {
                TXCLog.e(TAG, "TXCDRApi: get network type fail, exception occurred.", exception);
                return 2;
            }
            switch (n2) {
                case 1: 
                case 2: 
                case 4: 
                case 7: 
                case 11: {
                    return 4;
                }
                case 3: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 12: 
                case 14: 
                case 15: {
                    return 3;
                }
                case 13: {
                    return 2;
                }
            }
            return 2;
        }
        return 255;
    }

    private static String getPackageName(Context context) {
        String string = "";
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            string = packageInfo.packageName;
        }
        catch (Exception exception) {
            TXCLog.e(TAG, "get package name failed.", exception);
        }
        return string;
    }

    public static String getApplicationNameByPackageName(Context context, String string) {
        String string2;
        PackageManager packageManager = context.getPackageManager();
        try {
            string2 = packageManager.getApplicationLabel(packageManager.getApplicationInfo(string, 128)).toString();
        }
        catch (Exception exception) {
            string2 = "";
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initCrashReport(Context context) {
        try {
            Class<TXCDRApi> clazz = TXCDRApi.class;
            synchronized (TXCDRApi.class) {
                String string;
                if (!initRpt && context != null && (string = TXCCommonUtil.getSDKVersionStr()) != null) {
                    SharedPreferences sharedPreferences = context.getSharedPreferences("BuglySdkInfos", 0);
                    SharedPreferences.Editor editor = sharedPreferences.edit();
                    editor.putString("8e50744bf0", string);
                    editor.commit();
                    initRpt = true;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        }
        catch (Exception exception) {
            TXCLog.e(TAG, "init crash report failed.", exception);
        }
        {
            return;
        }
    }

    private static native void nativeInitDataReport();

    private static native void nativeUninitDataReport();

    private static native void nativeInitEventInternal(String var0, int var1, int var2, TXCDRExtInfo var3);

    private static native void nativeReportDAUInterval(int var0, int var1, String var2);

    private static native void nativeSetEventValueInterval(String var0, int var1, String var2, String var3);

    public static native void nativeSetCommonValue(String var0, String var1);

    public static native void nativeReportEvent(String var0, int var1);

    public static native int nativeGetStatusReportInterval();

    public static native void nativeReportEvent40003(String var0, int var1, int var2, String var3, String var4);

    public static native void nativeReportAVRoomEvent(int var0, long var1, String var3, int var4, int var5, String var6, String var7);

    static {
        g.f();
        TXCDRApi.nativeInitDataReport();
    }
}

