/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.audio;

import android.text.TextUtils;
import com.tencent.liteav.audio.TXAudioEffectManager;
import com.tencent.liteav.audio.TXAudioEffectManagerImpl;
import com.tencent.liteav.audio.c;
import com.tencent.liteav.basic.log.TXCLog;
import com.tencent.liteav.basic.util.TXCCommonUtil;
import com.tencent.liteav.basic.util.d;
import com.tencent.liteav.basic.util.g;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public class TXCSoundEffectPlayer
implements TXAudioEffectManager.TXMusicPlayObserver {
    private static final String TAG = "AudioCenter:TXCSoundEffectPlayer";
    private static WeakReference<c> mWeakSoundEffectListener;
    private List<Integer> mShortEffectorIDList = new ArrayList<Integer>();

    public static TXCSoundEffectPlayer getInstance() {
        return a.a;
    }

    public boolean playEffectWithId(int n2, String string, boolean bl, int n3) {
        TXCLog.i(TAG, "playEffectWithId -> effect id = " + n2 + ", path = " + string + ", loop = " + n3);
        String string2 = this.checkIfAssetsFile(string);
        TXAudioEffectManager.AudioMusicParam audioMusicParam = new TXAudioEffectManager.AudioMusicParam(n2, string2);
        audioMusicParam.publish = bl;
        audioMusicParam.loopCount = n3;
        audioMusicParam.isShortFile = true;
        boolean bl2 = TXAudioEffectManagerImpl.getCacheInstance().startPlayMusic(audioMusicParam);
        TXAudioEffectManagerImpl.getCacheInstance().setMusicObserver(n2, this);
        this.mShortEffectorIDList.add(n2);
        TXCLog.i(TAG, "playEffectWithId ->effect id = " + n2 + ", startPlayMusic result = " + bl2);
        return bl2;
    }

    public void stopEffectWithId(int n2) {
        TXCLog.i(TAG, "stopEffectWithId -> effect id = " + n2);
        TXAudioEffectManagerImpl.getCacheInstance().setMusicObserver(n2, null);
        TXAudioEffectManagerImpl.getCacheInstance().stopPlayMusic(n2);
        int n3 = this.mShortEffectorIDList.indexOf(n2);
        if (n3 >= 0) {
            this.mShortEffectorIDList.remove(n3);
        }
    }

    public void stopAllEffect() {
        TXCLog.i(TAG, "stopAllEffect -> start");
        for (int n2 : this.mShortEffectorIDList) {
            TXAudioEffectManagerImpl.getCacheInstance().stopPlayMusic(n2);
        }
        this.mShortEffectorIDList.clear();
        TXCLog.i(TAG, "stopAllEffect -> finish");
    }

    public void setEffectsVolume(float f2) {
        TXCLog.i(TAG, "setEffectsVolume -> volume = " + f2);
        for (int n2 : this.mShortEffectorIDList) {
            TXAudioEffectManagerImpl.getCacheInstance().setMusicVolume(n2, (int)(f2 * 100.0f));
        }
    }

    public void setVolumeOfEffect(int n2, float f2) {
        TXCLog.i(TAG, "setVolumeOfEffect -> effect id = " + n2 + ", volume = " + f2);
        TXAudioEffectManagerImpl.getCacheInstance().setMusicVolume(n2, (int)(f2 * 100.0f));
    }

    public void pauseEffectWithId(int n2) {
        TXCLog.i(TAG, "pauseEffectWithId -> effect id = " + n2);
        TXAudioEffectManagerImpl.getCacheInstance().pausePlayMusic(n2);
    }

    public void resumeEffectWithId(int n2) {
        TXCLog.i(TAG, "resumeEffectWithId -> effect id = " + n2);
        TXAudioEffectManagerImpl.getCacheInstance().resumePlayMusic(n2);
    }

    public void setSoundEffectListener(c c2) {
        mWeakSoundEffectListener = c2 == null ? null : new WeakReference<c>(c2);
    }

    @Override
    public void onPlayProgress(int n2, long l2, long l3) {
    }

    @Override
    public void onStart(int n2, int n3) {
        TXCLog.i(TAG, "onStart -> effect id = " + n2 + ", errCode = " + n3);
        if (mWeakSoundEffectListener != null && mWeakSoundEffectListener.get() != null) {
            ((c)mWeakSoundEffectListener.get()).onEffectPlayStart(n2, n3);
        }
    }

    @Override
    public void onComplete(int n2, int n3) {
        TXCLog.i(TAG, "onMusicPlayFinish -> effect id = " + n2);
        if (mWeakSoundEffectListener != null && mWeakSoundEffectListener.get() != null) {
            ((c)mWeakSoundEffectListener.get()).onEffectPlayFinish(n2);
        }
    }

    public void clearCache() {
        if (TXCCommonUtil.getAppContext() == null) {
            return;
        }
        try {
            int n2;
            long l2;
            File file = new File(this.getEffectCachePath());
            if (file.exists() && file.isDirectory() && (l2 = d.a(file)) > (long)(n2 = 0x3200000)) {
                File[] fileArray;
                for (File file2 : fileArray = file.listFiles()) {
                    file2.delete();
                }
            }
        }
        catch (Exception exception) {
            TXCLog.w(TAG, "clearCache error " + exception.toString());
        }
    }

    private String getEffectCachePath() {
        if (TXCCommonUtil.getAppContext() == null) {
            return "";
        }
        return TXCCommonUtil.getAppContext().getCacheDir() + File.separator + "liteav_effect";
    }

    private String checkIfAssetsFile(String string) {
        if (TextUtils.isEmpty((CharSequence)string) || TXCCommonUtil.getAppContext() == null) {
            return string;
        }
        String string2 = "/assets/";
        if (!string.startsWith("/assets/")) {
            return string;
        }
        String string3 = string;
        String string4 = string3.substring("/assets/".length());
        try {
            long l2 = 0L;
            try {
                l2 = TXCCommonUtil.getAppContext().getAssets().openFd(string4).getLength();
            }
            catch (Exception exception) {
                TXCLog.e(TAG, "playAudioEffect openFd error " + exception.toString());
                l2 = 0L;
            }
            String string5 = this.getEffectCachePath();
            File file = new File(string5);
            if (!file.exists()) {
                file.mkdirs();
            } else if (file.isFile()) {
                file.delete();
                file.mkdirs();
            }
            int n2 = string4.lastIndexOf(File.separatorChar);
            string3 = n2 != -1 ? string5 + File.separator + l2 + "_" + string4.substring(n2 + 1) : string5 + File.separator + l2 + "_" + string4;
            if (!d.a(string3)) {
                d.a(TXCCommonUtil.getAppContext(), string4, string3);
            }
        }
        catch (Exception exception) {
            TXCLog.e(TAG, "playAudioEffect error " + exception.toString());
        }
        return string3;
    }

    static {
        g.f();
    }

    private static class a {
        private static final TXCSoundEffectPlayer a = new TXCSoundEffectPlayer();
    }
}

