/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.audio;

import android.content.Context;
import com.tencent.liteav.audio.TXCAudioEngine;
import com.tencent.liteav.audio.f;
import com.tencent.liteav.audio.impl.Record.TXCAudioSysRecord;
import com.tencent.liteav.audio.impl.Record.a;
import com.tencent.liteav.audio.impl.Record.c;
import com.tencent.liteav.basic.log.TXCLog;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class TXCAudioUGCRecorder
implements c {
    private static final String TAG = "AudioCenter:TXCAudioUGCRecorder";
    private final int AAC_SAMPLE_NUM = 1024;
    private WeakReference<f> mWeakRecordListener;
    protected AtomicInteger mSampleRate = new AtomicInteger(48000);
    protected int mChannels = 1;
    protected int mBits = 16;
    protected int mAACFrameLength = 1024 * this.mChannels * this.mBits / 8;
    protected int mReverbType = 0;
    protected int mVoiceChangerType = 0;
    protected int mAECType = 0;
    protected Context mContext;
    protected boolean mIsEarphoneOn = false;
    private long mLastPTS = 0L;
    private float mVolume = 1.0f;
    private a mBGMRecorder = null;
    private boolean mEnableBGMRecord = false;
    private int mShouldClearAACDataCnt = 0;
    private boolean mCurBGMRecordFlag = false;
    private AtomicReference<Float> mSpeedRate = new AtomicReference<Float>(Float.valueOf(1.0f));
    private boolean mIsRunning = false;
    private boolean mIsPause = false;
    private boolean mIsMute = false;
    private final List<byte[]> mEncodedAudioList = new ArrayList<byte[]>();
    private static final TXCAudioUGCRecorder INSTANCE;

    public static TXCAudioUGCRecorder getInstance() {
        return INSTANCE;
    }

    private TXCAudioUGCRecorder() {
        TXCAudioSysRecord.getInstance();
        this.nativeClassInit();
    }

    public int startRecord(Context context) {
        TXCLog.i(TAG, "startRecord");
        if (context != null) {
            this.mContext = context.getApplicationContext();
        }
        this.updateAudioEffector();
        TXCAudioSysRecord.getInstance().setAudioRecordListener(this);
        this.nativeStartAudioRecord(this.mSampleRate.get(), this.mChannels, this.mBits);
        this.mIsRunning = true;
        this.mLastPTS = 0L;
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int stopRecord() {
        TXCLog.i(TAG, "stopRecord");
        TXCAudioSysRecord.getInstance().setAudioRecordListener(null);
        if (this.mBGMRecorder != null) {
            this.mBGMRecorder.a();
            this.mBGMRecorder = null;
        }
        this.nativeStopAudioRecord();
        this.nativeEnableMixMode(false);
        this.nativeSetVolume(1.0f);
        List<byte[]> list = this.mEncodedAudioList;
        synchronized (list) {
            this.mEncodedAudioList.clear();
        }
        this.mIsRunning = false;
        this.mLastPTS = 0L;
        this.mIsPause = false;
        this.mIsMute = false;
        this.mShouldClearAACDataCnt = 0;
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        TXCLog.i(TAG, "pause");
        TXCAudioEngine.getInstance().pauseLocalAudio();
        List<byte[]> list = this.mEncodedAudioList;
        synchronized (list) {
            this.mIsPause = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        TXCLog.i(TAG, "resume");
        TXCAudioEngine.getInstance().resumeLocalAudio();
        List<byte[]> list = this.mEncodedAudioList;
        synchronized (list) {
            this.mIsPause = false;
        }
        this.nativeEnableMixMode(this.mEnableBGMRecord);
        if (this.mIsMute || this.mEnableBGMRecord) {
            this.nativeSetVolume(0.0f);
        } else {
            this.nativeSetVolume(this.mVolume);
        }
    }

    public synchronized void setListener(f f2) {
        this.mWeakRecordListener = null == f2 ? null : new WeakReference<f>(f2);
    }

    public f getListener() {
        if (this.mWeakRecordListener != null) {
            return (f)this.mWeakRecordListener.get();
        }
        return null;
    }

    public void setChannels(int n2) {
        TXCLog.i(TAG, "setChannels: " + n2);
        this.mChannels = n2;
    }

    public int getChannels() {
        return this.mChannels;
    }

    public void setSampleRate(int n2) {
        TXCLog.i(TAG, "setSampleRate: " + n2);
        this.mSampleRate.set(n2);
    }

    public int getSampleRate() {
        return this.mSampleRate.get();
    }

    public synchronized void setReverbType(int n2) {
        TXCLog.i(TAG, "setReverbType: " + n2);
        this.mReverbType = n2;
        this.nativeSetReverbType(n2);
    }

    public void setAECType(int n2, Context context) {
        TXCLog.i(TAG, "setAECType: " + n2);
        this.mAECType = n2;
        if (context != null) {
            this.mContext = context.getApplicationContext();
        }
    }

    public void setMute(boolean bl) {
        TXCLog.i(TAG, "setMute: " + bl);
        this.mIsMute = bl;
        if (bl) {
            this.nativeSetVolume(0.0f);
        } else {
            this.nativeSetVolume(this.mVolume);
        }
    }

    public void enableBGMRecord(boolean bl) {
        TXCLog.i(TAG, "enableBGMRecord: " + bl);
        if (this.mEnableBGMRecord != bl && !bl) {
            this.mShouldClearAACDataCnt = 2;
        }
        this.mEnableBGMRecord = bl;
        this.updateAudioEffector();
    }

    public boolean isRecording() {
        return this.mIsRunning;
    }

    public boolean isPaused() {
        return this.mIsPause;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEncodedData(byte[] byArray) {
        List<byte[]> list = this.mEncodedAudioList;
        synchronized (list) {
            this.mEncodedAudioList.add(byArray);
        }
    }

    public synchronized void setVolume(float f2) {
        TXCLog.i(TAG, "setVolume: " + f2);
        this.mVolume = f2;
        if (this.mIsMute) {
            this.nativeSetVolume(0.0f);
        } else {
            this.nativeSetVolume(f2);
        }
    }

    public synchronized void setSpeedRate(float f2) {
        TXCLog.i(TAG, "setSpeedRate: " + f2);
        this.mSpeedRate.set(Float.valueOf(f2));
        this.nativeSetSpeedRate(this.mSpeedRate.get().floatValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clearCache() {
        TXCLog.i(TAG, "clearCache");
        List<byte[]> list = this.mEncodedAudioList;
        synchronized (list) {
            this.mEncodedAudioList.clear();
        }
    }

    @Override
    public void onAudioRecordStart() {
        TXCLog.i(TAG, "sys audio record start");
    }

    @Override
    public void onAudioRecordStop() {
        TXCLog.i(TAG, "sys audio record stop");
    }

    @Override
    public void onAudioRecordError(int n2, String string) {
        TXCLog.e(TAG, "sys audio record error: " + n2 + ", " + string);
        f f2 = this.getListener();
        if (f2 != null) {
            f2.onRecordError(n2, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onAudioRecordPCM(byte[] byArray, int n2, long l2) {
        long l3 = l2;
        if (this.mLastPTS >= l2) {
            l3 = this.mLastPTS + 2L;
        }
        byte[] byArray2 = null;
        do {
            List<byte[]> list = this.mEncodedAudioList;
            synchronized (list) {
                if (!this.mEncodedAudioList.isEmpty() && !this.mIsPause) {
                    byArray2 = this.mEncodedAudioList.get(0);
                    this.mEncodedAudioList.remove(0);
                    if (this.mShouldClearAACDataCnt > 0) {
                        byArray2 = null;
                        --this.mShouldClearAACDataCnt;
                    }
                } else {
                    byArray2 = null;
                }
                if (byArray2 != null) {
                    this.mLastPTS = l3;
                    f f2 = this.getListener();
                    if (f2 != null) {
                        f2.onRecordEncData(byArray2, l3, this.mSampleRate.get(), this.mChannels, this.mBits);
                    } else {
                        TXCLog.e(TAG, "onAudioRecordPCM listener is null");
                    }
                    int n3 = this.mSampleRate.get();
                    if (n3 > 0) {
                        l3 += (long)(1024000.0f * this.mSpeedRate.get().floatValue() / (float)n3);
                    }
                }
            }
        } while (byArray2 != null);
    }

    private synchronized void updateAudioEffector() {
        boolean bl = false;
        if (this.mEnableBGMRecord || this.mAECType == 1) {
            bl = true;
        }
        if (!bl) {
            this.nativeSetReverbType(this.mReverbType);
            this.nativeSetChangerType(this.mVoiceChangerType);
            if (this.mIsMute) {
                this.nativeSetVolume(0.0f);
            } else {
                this.nativeSetVolume(this.mVolume);
            }
        }
        if (bl) {
            this.nativeSetVolume(0.0f);
        }
        this.nativeEnableMixMode(bl);
        this.nativeSetSpeedRate(this.mSpeedRate.get().floatValue());
    }

    public synchronized void setChangerType(int n2) {
        TXCLog.i(TAG, "setChangerType: " + n2);
        this.mVoiceChangerType = n2;
        this.nativeSetChangerType(n2);
    }

    private native void nativeClassInit();

    private native void nativeEnableMixMode(boolean var1);

    private native void nativeStartAudioRecord(int var1, int var2, int var3);

    private native void nativeStopAudioRecord();

    private native void nativeSetReverbType(int var1);

    private native void nativeSetSpeedRate(float var1);

    private native void nativeSetVolume(float var1);

    private native void nativeSetChangerType(int var1);

    static {
        com.tencent.liteav.basic.util.f.f();
        INSTANCE = new TXCAudioUGCRecorder();
    }
}

