/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.multimedia.audiokit.interfaces;

import android.content.ComponentName;
import android.content.Context;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;
import com.huawei.multimedia.audioengine.IHwAudioKaraokeFeature;
import com.huawei.multimedia.audiokit.interfaces.AudioFeaturesKit;
import com.huawei.multimedia.audiokit.interfaces.FeatureKitManager;
import com.tencent.liteav.basic.log.TXCLog;

public class HwAudioKaraokeFeatureKit
extends AudioFeaturesKit {
    private static final String TAG = "HwAudioKit.HwAudioKaraokeFeatureKit";
    private static final String ENGINE_CLASS_NAME = "com.huawei.multimedia.audioengine.HwAudioKaraokeFeatureService";
    private Context mContext;
    private FeatureKitManager mFeatureKitManager = null;
    private boolean mIsServiceConnected = false;
    private IHwAudioKaraokeFeature mIHwAudioKaraokeFeatureAidl;
    private IBinder mService = null;
    private ServiceConnection mConnection = new ServiceConnection(){

        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            TXCLog.i(HwAudioKaraokeFeatureKit.TAG, "onServiceConnected");
            HwAudioKaraokeFeatureKit.this.mIHwAudioKaraokeFeatureAidl = IHwAudioKaraokeFeature.Stub.asInterface(iBinder);
            if (HwAudioKaraokeFeatureKit.this.mIHwAudioKaraokeFeatureAidl != null) {
                HwAudioKaraokeFeatureKit.this.mIsServiceConnected = true;
                HwAudioKaraokeFeatureKit.this.mFeatureKitManager.onCallBack(1000);
                HwAudioKaraokeFeatureKit.this.serviceInit(HwAudioKaraokeFeatureKit.this.mContext.getPackageName());
                HwAudioKaraokeFeatureKit.this.serviceLinkToDeath(iBinder);
            }
        }

        public void onServiceDisconnected(ComponentName componentName) {
            TXCLog.i(HwAudioKaraokeFeatureKit.TAG, "onServiceDisconnected");
            HwAudioKaraokeFeatureKit.this.mIsServiceConnected = false;
            if (HwAudioKaraokeFeatureKit.this.mFeatureKitManager != null) {
                HwAudioKaraokeFeatureKit.this.mFeatureKitManager.onCallBack(1001);
            }
        }
    };
    private IBinder.DeathRecipient mDeathRecipient = new IBinder.DeathRecipient(){

        public void binderDied() {
            TXCLog.e(HwAudioKaraokeFeatureKit.TAG, "binderDied");
            HwAudioKaraokeFeatureKit.this.mService.unlinkToDeath(HwAudioKaraokeFeatureKit.this.mDeathRecipient, 0);
            HwAudioKaraokeFeatureKit.this.mFeatureKitManager.onCallBack(1003);
            HwAudioKaraokeFeatureKit.this.mService = null;
        }
    };

    protected HwAudioKaraokeFeatureKit(Context context) {
        this.mFeatureKitManager = FeatureKitManager.getInstance();
        this.mContext = context;
    }

    private void serviceLinkToDeath(IBinder iBinder) {
        this.mService = iBinder;
        try {
            if (iBinder != null) {
                iBinder.linkToDeath(this.mDeathRecipient, 0);
            }
        }
        catch (RemoteException remoteException) {
            this.mFeatureKitManager.onCallBack(1002);
            TXCLog.e(TAG, "serviceLinkToDeath, RemoteException");
        }
    }

    protected void initialize(Context context) {
        TXCLog.i(TAG, "initialize");
        if (context == null) {
            TXCLog.i(TAG, "initialize, context is null");
            return;
        }
        if (!this.mFeatureKitManager.isAudioKitSupport(context)) {
            this.mFeatureKitManager.onCallBack(2);
            TXCLog.i(TAG, "initialize, not install AudioEngine");
            return;
        }
        this.bindService(context);
    }

    private void bindService(Context context) {
        TXCLog.i(TAG, "bindService");
        if (this.mFeatureKitManager != null && !this.mIsServiceConnected) {
            this.mFeatureKitManager.bindService(context, this.mConnection, ENGINE_CLASS_NAME);
        }
    }

    public void destroy() {
        TXCLog.i(TAG, "destroy, mIsServiceConnected = {}", this.mIsServiceConnected);
        if (this.mIsServiceConnected) {
            this.mIsServiceConnected = false;
            this.mFeatureKitManager.unbindService(this.mContext, this.mConnection);
        }
    }

    public boolean isKaraokeFeatureSupport() {
        TXCLog.i(TAG, "isKaraokeFeatureSupport");
        try {
            if (this.mIHwAudioKaraokeFeatureAidl != null && this.mIsServiceConnected) {
                return this.mIHwAudioKaraokeFeatureAidl.isKaraokeFeatureSupport();
            }
        }
        catch (RemoteException remoteException) {
            TXCLog.e(TAG, "isFeatureSupported,RemoteException ex : {}", remoteException.getMessage());
        }
        return false;
    }

    public int enableKaraokeFeature(boolean bl) {
        TXCLog.i(TAG, "enableKaraokeFeature, enable = {}", bl);
        try {
            if (this.mIHwAudioKaraokeFeatureAidl != null && this.mIsServiceConnected) {
                return this.mIHwAudioKaraokeFeatureAidl.enableKaraokeFeature(bl);
            }
        }
        catch (RemoteException remoteException) {
            TXCLog.e(TAG, "enableKaraokeFeature,RemoteException ex : {}", remoteException.getMessage());
        }
        return -2;
    }

    public int getKaraokeLatency() {
        TXCLog.i(TAG, "getKaraokeLatency");
        try {
            if (this.mIHwAudioKaraokeFeatureAidl != null && this.mIsServiceConnected) {
                return this.mIHwAudioKaraokeFeatureAidl.getKaraokeLatency();
            }
        }
        catch (RemoteException remoteException) {
            TXCLog.e(TAG, "getKaraokeLatency,RemoteException ex : {}", remoteException.getMessage());
        }
        return -1;
    }

    public int setParameter(ParameName parameName, int n2) {
        if (parameName == null) {
            return 1807;
        }
        try {
            TXCLog.i(TAG, "parame.getParameName() = {}, parameValue = {}", parameName.getParameName(), n2);
            if (this.mIHwAudioKaraokeFeatureAidl != null && this.mIsServiceConnected) {
                return this.mIHwAudioKaraokeFeatureAidl.setParameter(parameName.getParameName(), n2);
            }
        }
        catch (RemoteException remoteException) {
            TXCLog.e(TAG, "setParameter,RemoteException ex : {}", remoteException.getMessage());
        }
        return -2;
    }

    private void serviceInit(String string) {
        try {
            if (this.mIHwAudioKaraokeFeatureAidl != null && this.mIsServiceConnected) {
                this.mIHwAudioKaraokeFeatureAidl.init(string);
            }
        }
        catch (RemoteException remoteException) {
            TXCLog.e(TAG, "isFeatureSupported,RemoteException ex : {}", remoteException.getMessage());
        }
    }

    public static enum ParameName {
        CMD_SET_AUDIO_EFFECT_MODE_BASE("Karaoke_reverb_mode="),
        CMD_SET_VOCAL_VOLUME_BASE("Karaoke_volume="),
        CMD_SET_VOCAL_EQUALIZER_MODE("Karaoke_eq_mode=");

        private String mParameName;

        private ParameName(String string2) {
            this.mParameName = string2;
        }

        public String getParameName() {
            return this.mParameName;
        }
    }
}

