/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.thumbplayer.tcmedia.core.imagegenerator;

import com.tencent.thumbplayer.tcmedia.core.common.TPNativeLibraryLoader;
import com.tencent.thumbplayer.tcmedia.core.imagegenerator.ITPImageGeneratorCallback;
import com.tencent.thumbplayer.tcmedia.core.imagegenerator.TPImageGeneratorParams;
import java.util.Map;

public class TPImageGenerator {
    private String mUrl = null;
    private Map<String, String> mHttpHeader = null;
    private ITPImageGeneratorCallback mCallback = null;
    private int mFd = -1;
    private long mFdOffset;
    private long mFdLength;
    private boolean mInited = false;
    private boolean mIsLibLoaded = false;
    private long mNativeContext = 0L;

    private native int _createWithUrl(String var1, Object var2);

    private native int _createWithFd(int var1, long var2, long var4, Object var6);

    private native void _release();

    private native void _generateImageAsyncAtTime(long var1, long var3, Object var5);

    private native void _generateImagesAsyncForTimes(long[] var1, long var2, Object var4);

    private native void _cancelAllImageGenerations();

    private void loadLibrary() {
        try {
            TPNativeLibraryLoader.loadLibIfNeeded(null);
            this.mIsLibLoaded = true;
            return;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            unsupportedOperationException.printStackTrace();
            this.mIsLibLoaded = false;
            return;
        }
    }

    public TPImageGenerator(String string, ITPImageGeneratorCallback iTPImageGeneratorCallback) {
        this.loadLibrary();
        this.mUrl = string;
        this.mCallback = iTPImageGeneratorCallback;
    }

    public TPImageGenerator(String string, Map<String, String> map, ITPImageGeneratorCallback iTPImageGeneratorCallback) {
        this.loadLibrary();
        this.mUrl = string;
        this.mHttpHeader = map;
        this.mCallback = iTPImageGeneratorCallback;
    }

    public TPImageGenerator(int n2, long l2, long l3, ITPImageGeneratorCallback iTPImageGeneratorCallback) {
        this.loadLibrary();
        this.mFd = n2;
        this.mFdOffset = l2;
        this.mFdLength = l3;
        this.mCallback = iTPImageGeneratorCallback;
    }

    public void init() {
        if (!this.mIsLibLoaded) {
            throw new UnsupportedOperationException("Failed to load native library");
        }
        if (this.mInited) {
            throw new IllegalStateException("Failed to init due to invalid state.");
        }
        this.mInited = true;
        if (this.mUrl == null || this.mHttpHeader == null) {
            if (this.mUrl != null) {
                TPImageGenerator tPImageGenerator = this;
                tPImageGenerator._createWithUrl(tPImageGenerator.mUrl, this.mCallback);
                return;
            }
            TPImageGenerator tPImageGenerator = this;
            tPImageGenerator._createWithFd(tPImageGenerator.mFd, this.mFdOffset, this.mFdLength, this.mCallback);
        }
    }

    public void unInit() {
        if (!this.mIsLibLoaded) {
            throw new UnsupportedOperationException("Failed to load native library");
        }
        if (!this.mInited) {
            return;
        }
        this.mInited = false;
        this._release();
    }

    public void generateImageAsyncAtTime(long l2, long l3, TPImageGeneratorParams tPImageGeneratorParams) {
        if (!this.mIsLibLoaded) {
            throw new UnsupportedOperationException("Failed to load native library");
        }
        if (!this.mInited) {
            throw new IllegalStateException("Failed to generate image at time " + l2 + " due to invalid state.");
        }
        this._generateImageAsyncAtTime(l2, l3, tPImageGeneratorParams);
    }

    public void generateImagesAsyncForTimes(long[] lArray, long l2, TPImageGeneratorParams tPImageGeneratorParams) {
        if (!this.mIsLibLoaded) {
            throw new UnsupportedOperationException("Failed to load native library");
        }
        if (!this.mInited) {
            throw new IllegalStateException("Failed to generate images due to invalid state.");
        }
        this._generateImagesAsyncForTimes(lArray, l2, tPImageGeneratorParams);
    }

    public void cancelAllImageGenerations() {
        if (!this.mIsLibLoaded) {
            throw new UnsupportedOperationException("Failed to load native library");
        }
        if (!this.mInited) {
            return;
        }
        this._cancelAllImageGenerations();
    }
}

