/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.thumbplayer.tcmedia.core.downloadproxy.utils;

import com.tencent.thumbplayer.tcmedia.core.downloadproxy.utils.TPDLProxyLog;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class TPDLProxyUtils {
    private static final String FILE_NAME = "TPDLProxyUtils";

    public static String byteArrayToString(byte[] byteArray) {
        String string = "";
        if (byteArray == null) {
            return string;
        }
        try {
            string = new String(byteArray, "UTF-8");
        }
        catch (Throwable throwable) {
            TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "byteArrayToString failed, error:" + throwable.toString());
        }
        return string;
    }

    public static int objectToInt(Object obj, int defaultValue) {
        if (obj == null) {
            return defaultValue;
        }
        try {
            return (Integer)obj;
        }
        catch (Throwable throwable) {
            TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "object to int failed, error:" + throwable.toString());
            return defaultValue;
        }
    }

    public static long objectToLong(Object obj, long defaultValue) {
        if (obj == null) {
            return defaultValue;
        }
        try {
            return (Long)obj;
        }
        catch (Throwable throwable) {
            TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "object to long failed, error:" + throwable.toString());
            return defaultValue;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String serialize(Object obj) {
        String string;
        ObjectOutputStream objectOutputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(obj);
            string = byteArrayOutputStream.toString("ISO-8859-1");
        }
        catch (Throwable throwable) {
            try {
                TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "serialize obj, error:" + throwable.toString());
                return "";
            }
            catch (Throwable throwable2) {
                throw throwable2;
            }
            finally {
                try {
                    if (objectOutputStream != null) {
                        objectOutputStream.close();
                    }
                }
                catch (Throwable throwable3) {
                    TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "obj serialize to string  objectOutputStream close, error:" + throwable3.toString());
                }
                try {
                    byteArrayOutputStream.close();
                }
                catch (Throwable throwable4) {
                    TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "obj serialize to string byteArrayOutputStream close, error:" + throwable4.toString());
                }
            }
        }
        try {
            objectOutputStream.close();
        }
        catch (Throwable throwable) {
            TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "obj serialize to string  objectOutputStream close, error:" + throwable.toString());
        }
        try {
            byteArrayOutputStream.close();
            return string;
        }
        catch (Throwable throwable) {
            TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "obj serialize to string byteArrayOutputStream close, error:" + throwable.toString());
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object serializeToObject(String str) {
        Object object;
        ByteArrayInputStream byteArrayInputStream = null;
        ObjectInputStream objectInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(str.getBytes("ISO-8859-1"));
            objectInputStream = new ObjectInputStream(byteArrayInputStream);
            object = objectInputStream.readObject();
        }
        catch (Throwable throwable) {
            try {
                TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "serialize to obj , error:" + throwable.toString());
                return null;
            }
            catch (Throwable throwable2) {
                throw throwable2;
            }
            finally {
                try {
                    if (objectInputStream != null) {
                        objectInputStream.close();
                    }
                }
                catch (Throwable throwable3) {
                    TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "serialize to obj objectInputStream close, error:" + throwable3.toString());
                }
                try {
                    if (byteArrayInputStream != null) {
                        byteArrayInputStream.close();
                    }
                }
                catch (Throwable throwable4) {
                    TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "serialize to obj byteArrayInputStream close, error:" + throwable4.toString());
                }
            }
        }
        try {
            objectInputStream.close();
        }
        catch (Throwable throwable) {
            TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "serialize to obj objectInputStream close, error:" + throwable.toString());
        }
        try {
            byteArrayInputStream.close();
            return object;
        }
        catch (Throwable throwable) {
            TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "serialize to obj byteArrayInputStream close, error:" + throwable.toString());
        }
        return object;
    }
}

