/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.thumbplayer.tcmedia.core.downloadproxy.client;

import android.content.Context;
import android.os.RemoteException;
import android.text.TextUtils;
import com.tencent.thumbplayer.tcmedia.core.downloadproxy.aidl.ITPDownloadProxyAidl;
import com.tencent.thumbplayer.tcmedia.core.downloadproxy.aidl.ITPPlayListenerAidl;
import com.tencent.thumbplayer.tcmedia.core.downloadproxy.aidl.ITPPreLoadListenerAidl;
import com.tencent.thumbplayer.tcmedia.core.downloadproxy.aidl.TPDownloadParamAidl;
import com.tencent.thumbplayer.tcmedia.core.downloadproxy.api.ITPDLProxyLogListener;
import com.tencent.thumbplayer.tcmedia.core.downloadproxy.api.ITPDownloadProxy;
import com.tencent.thumbplayer.tcmedia.core.downloadproxy.api.ITPOfflineDownloadListener;
import com.tencent.thumbplayer.tcmedia.core.downloadproxy.api.ITPPlayListener;
import com.tencent.thumbplayer.tcmedia.core.downloadproxy.api.ITPPreLoadListener;
import com.tencent.thumbplayer.tcmedia.core.downloadproxy.api.TPDLProxyInitParam;
import com.tencent.thumbplayer.tcmedia.core.downloadproxy.api.TPDLProxyMsg;
import com.tencent.thumbplayer.tcmedia.core.downloadproxy.api.TPDownloadParam;
import com.tencent.thumbplayer.tcmedia.core.downloadproxy.utils.TPDLProxyLog;
import com.tencent.thumbplayer.tcmedia.core.downloadproxy.utils.TPDLProxyUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TPDownloadProxyClient
implements ITPDownloadProxy {
    private static final String FILE_NAME = "TPDownloadProxyClient";
    private ITPDownloadProxyAidl downloadProxyAidl = null;

    public TPDownloadProxyClient(ITPDownloadProxyAidl downloadProxyAidl) {
        this.downloadProxyAidl = downloadProxyAidl;
    }

    public void updateAidl(ITPDownloadProxyAidl downloadProxyAidl) {
        this.downloadProxyAidl = downloadProxyAidl;
    }

    @Override
    public int init(Context context, TPDLProxyInitParam tpdlProxyInitParam) {
        String string = TPDLProxyUtils.serialize(tpdlProxyInitParam);
        if (TextUtils.isEmpty((CharSequence)string)) {
            TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "param is null");
            return -1;
        }
        try {
            return this.downloadProxyAidl.init(string);
        }
        catch (Throwable throwable) {
            TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "init failed, error:" + throwable.toString());
            return -2;
        }
    }

    @Override
    public int deinit() {
        return 0;
    }

    @Override
    public void setLogListener(ITPDLProxyLogListener itpdlProxyLogListener) {
        TPDLProxyLog.setLogListener(10303, itpdlProxyLogListener);
    }

    @Override
    public int startPlay(String fileId, TPDownloadParam tpDownloadParam, final ITPPlayListener playListener) {
        if (this.downloadProxyAidl == null || tpDownloadParam == null) {
            return -1;
        }
        TPDownloadParamAidl tPDownloadParamAidl = new TPDownloadParamAidl(tpDownloadParam.getUrlList(), tpDownloadParam.getDlType(), tpDownloadParam.getExtInfoMap());
        try {
            if (playListener == null) {
                return this.downloadProxyAidl.startPlay(fileId, tPDownloadParamAidl, null);
            }
            ITPPlayListenerAidl.Stub stub = new ITPPlayListenerAidl.Stub(){

                @Override
                public void onDownloadProgressUpdate(int playableDurationMS, int downloadSpeedKBs, long currentDownloadSizeByte, long totalFileSizeByte, String exInfo) {
                    playListener.onDownloadProgressUpdate(playableDurationMS, downloadSpeedKBs, currentDownloadSizeByte, totalFileSizeByte, exInfo);
                }

                @Override
                public void onDownloadFinish() {
                    playListener.onDownloadFinish();
                }

                @Override
                public void onDownloadError(int moduleId, int errorCode, String extInfo) {
                    playListener.onDownloadError(moduleId, errorCode, extInfo);
                }

                @Override
                public int onPlayCallback(int messageType, List ext) {
                    Object object = 0;
                    if (ext != null && !ext.isEmpty()) {
                        if (ext.size() == 1) {
                            object = playListener.onPlayCallback(messageType, ext.get(0), null, null, null);
                        } else if (ext.size() == 2) {
                            object = playListener.onPlayCallback(messageType, ext.get(0), ext.get(1), null, null);
                        } else if (ext.size() == 3) {
                            object = playListener.onPlayCallback(messageType, ext.get(0), ext.get(1), ext.get(2), null);
                        }
                    }
                    if (object == null || object.getClass() != Integer.class) {
                        return -1;
                    }
                    return (Integer)object;
                }

                @Override
                public void onDownloadCdnUrlUpdate(String url) {
                    playListener.onDownloadCdnUrlUpdate(url);
                }

                @Override
                public void onDownloadCdnUrlInfoUpdate(String url, String cdnIp, String uip, String errorCodeStr) {
                    playListener.onDownloadCdnUrlInfoUpdate(url, cdnIp, uip, errorCodeStr);
                }

                @Override
                public void onDownloadCdnUrlExpired(Map info) {
                    playListener.onDownloadCdnUrlExpired(info);
                }

                @Override
                public void onDownloadStatusUpdate(int statusCode) {
                    playListener.onDownloadStatusUpdate(statusCode);
                }

                @Override
                public void onDownloadProtocolUpdate(String protocol, String protocolVer) {
                    playListener.onDownloadProtocolUpdate(protocol, protocolVer);
                }

                @Override
                public long getPlayerBufferLength() {
                    return playListener.getPlayerBufferLength();
                }

                @Override
                public long getCurrentPosition() {
                    return playListener.getCurrentPosition();
                }

                @Override
                public long[] getCurrentPlayOffset() {
                    return playListener.getCurrentPlayOffset();
                }

                @Override
                public int getCurrentPlayClipNo() {
                    return playListener.getCurrentPlayClipNo();
                }

                @Override
                public long getAdvRemainTime() {
                    return playListener.getAdvRemainTime();
                }

                @Override
                public String getPlayInfo(String keyStr) {
                    Object object = playListener.getPlayInfo(keyStr);
                    if (object != null && object.getClass() == String.class) {
                        if (object.getClass() == String.class) {
                            return (String)object;
                        }
                        if (object.getClass() == Integer.class) {
                            return Integer.toString((Integer)object);
                        }
                    }
                    return null;
                }

                @Override
                public int onStartReadData(int fileId, String fileKey, long requestStart, long requestEnd) throws RemoteException {
                    return playListener.onStartReadData(fileId, fileKey, requestStart, requestEnd);
                }

                @Override
                public int onReadData(int fileId, String fileKey, long offset, long length) throws RemoteException {
                    return playListener.onReadData(fileId, fileKey, offset, length);
                }

                @Override
                public int onStopReadData(int fileId, String fileKey, int requestId) throws RemoteException {
                    return playListener.onStopReadData(fileId, fileKey, requestId);
                }

                @Override
                public long getDataTotalSize(int fileId, String fileKey) throws RemoteException {
                    return playListener.getDataTotalSize(fileId, fileKey);
                }

                @Override
                public String getDataFilePath(int fileId, String fileKey) throws RemoteException {
                    return playListener.getDataFilePath(fileId, fileKey);
                }

                @Override
                public String getContentType(int fileId, String fileKey) throws RemoteException {
                    return playListener.getContentType(fileId, fileKey);
                }
            };
            return this.downloadProxyAidl.startPlay(fileId, tPDownloadParamAidl, stub);
        }
        catch (Throwable throwable) {
            TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "startPlay failed, error:" + throwable.toString());
            return -1;
        }
    }

    @Override
    public int startClipPlay(String fileId, int clipCount, final ITPPlayListener playListener) {
        try {
            if (playListener == null) {
                return this.downloadProxyAidl.startClipPlay(fileId, clipCount, null);
            }
            ITPPlayListenerAidl.Stub stub = new ITPPlayListenerAidl.Stub(){

                @Override
                public void onDownloadProgressUpdate(int playableDurationMS, int downloadSpeedKBs, long currentDownloadSizeByte, long totalFileSizeByte, String exInfo) {
                    playListener.onDownloadProgressUpdate(playableDurationMS, downloadSpeedKBs, currentDownloadSizeByte, totalFileSizeByte, exInfo);
                }

                @Override
                public void onDownloadFinish() {
                    playListener.onDownloadFinish();
                }

                @Override
                public void onDownloadError(int moduleId, int errorCode, String extInfo) {
                    playListener.onDownloadError(moduleId, errorCode, extInfo);
                }

                @Override
                public int onPlayCallback(int messageType, List ext) {
                    Object object = 0;
                    if (ext != null && !ext.isEmpty()) {
                        if (ext.size() == 1) {
                            object = playListener.onPlayCallback(messageType, ext.get(0), null, null, null);
                        } else if (ext.size() == 2) {
                            object = playListener.onPlayCallback(messageType, ext.get(0), ext.get(1), null, null);
                        } else if (ext.size() == 3) {
                            object = playListener.onPlayCallback(messageType, ext.get(0), ext.get(1), ext.get(2), null);
                        }
                    }
                    if (object == null || object.getClass() != Integer.class) {
                        return -1;
                    }
                    return (Integer)object;
                }

                @Override
                public void onDownloadCdnUrlUpdate(String url) {
                    playListener.onDownloadCdnUrlUpdate(url);
                }

                @Override
                public void onDownloadCdnUrlInfoUpdate(String url, String cdnIp, String uip, String errorCodeStr) {
                    playListener.onDownloadCdnUrlInfoUpdate(url, cdnIp, uip, errorCodeStr);
                }

                @Override
                public void onDownloadCdnUrlExpired(Map info) {
                    playListener.onDownloadCdnUrlExpired(info);
                }

                @Override
                public void onDownloadStatusUpdate(int statusCode) {
                    playListener.onDownloadStatusUpdate(statusCode);
                }

                @Override
                public void onDownloadProtocolUpdate(String protocol, String protocolVer) {
                    playListener.onDownloadProtocolUpdate(protocol, protocolVer);
                }

                @Override
                public long getPlayerBufferLength() {
                    return playListener.getPlayerBufferLength();
                }

                @Override
                public long getCurrentPosition() {
                    return playListener.getCurrentPosition();
                }

                @Override
                public long[] getCurrentPlayOffset() {
                    return playListener.getCurrentPlayOffset();
                }

                @Override
                public int getCurrentPlayClipNo() {
                    return playListener.getCurrentPlayClipNo();
                }

                @Override
                public long getAdvRemainTime() {
                    return playListener.getAdvRemainTime();
                }

                @Override
                public String getPlayInfo(String keyStr) {
                    Object object = playListener.getPlayInfo(keyStr);
                    if (object != null && object.getClass() == String.class) {
                        if (object.getClass() == String.class) {
                            return (String)object;
                        }
                        if (object.getClass() == Integer.class) {
                            return Integer.toString((Integer)object);
                        }
                    }
                    return null;
                }

                @Override
                public int onStartReadData(int fileId, String fileKey, long requestStart, long requestEnd) throws RemoteException {
                    return 0;
                }

                @Override
                public int onReadData(int fileId, String fileKey, long offset, long length) throws RemoteException {
                    return 0;
                }

                @Override
                public int onStopReadData(int fileId, String fileKey, int requestId) throws RemoteException {
                    return 0;
                }

                @Override
                public long getDataTotalSize(int fileId, String fileKey) throws RemoteException {
                    return 0L;
                }

                @Override
                public String getDataFilePath(int fileId, String fileKey) throws RemoteException {
                    return null;
                }

                @Override
                public String getContentType(int fileId, String fileKey) throws RemoteException {
                    return null;
                }
            };
            return this.downloadProxyAidl.startClipPlay(fileId, clipCount, stub);
        }
        catch (Throwable throwable) {
            TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "startClipPlay failed, error:" + throwable.toString());
            return -1;
        }
    }

    @Override
    public boolean setClipInfo(int playId, int clipNo, String clipFileId, TPDownloadParam tpDownloadParam) {
        TPDownloadParamAidl tPDownloadParamAidl = new TPDownloadParamAidl(tpDownloadParam.getUrlList(), tpDownloadParam.getDlType(), tpDownloadParam.getExtInfoMap());
        try {
            return this.downloadProxyAidl.setClipInfo(playId, clipNo, clipFileId, tPDownloadParamAidl);
        }
        catch (Throwable throwable) {
            TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "setClipInfo failed, error:" + throwable.toString());
            return false;
        }
    }

    @Override
    public String getPlayUrl(int playId, int urlType) {
        try {
            return this.downloadProxyAidl.getPlayUrl(playId, urlType);
        }
        catch (Throwable throwable) {
            TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "getPlayUrl failed, error:" + throwable.toString());
            return null;
        }
    }

    @Override
    public String getClipPlayUrl(int playId, int clipNo, int urlType) {
        try {
            return this.downloadProxyAidl.getClipPlayUrl(playId, clipNo, urlType);
        }
        catch (Throwable throwable) {
            TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "getClipPlayUrl failed, error:" + throwable.toString());
            return null;
        }
    }

    @Override
    public String getPlayErrorCodeStr(int playId) {
        try {
            return this.downloadProxyAidl.getPlayErrorCodeStr(playId);
        }
        catch (Throwable throwable) {
            TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "getPlayErrorCodeStr failed, error:" + throwable.toString());
            return null;
        }
    }

    @Override
    public void stopPlay(int playId) {
        try {
            this.downloadProxyAidl.stopPlay(playId);
            return;
        }
        catch (Throwable throwable) {
            TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "stopPlay failed, error:" + throwable.toString());
            return;
        }
    }

    @Override
    public int pauseDownload(int playId) {
        try {
            return this.downloadProxyAidl.pauseDownload(playId);
        }
        catch (Throwable throwable) {
            TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "pauseDownload failed, error:" + throwable.toString());
            return -1;
        }
    }

    @Override
    public int resumeDownload(int playId) {
        try {
            return this.downloadProxyAidl.resumeDownload(playId);
        }
        catch (Throwable throwable) {
            TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "resumeDownload failed, error:" + throwable.toString());
            return -1;
        }
    }

    @Override
    public int startPreload(String fileId, TPDownloadParam tpDownloadParam, final ITPPreLoadListener itpPreLoadListener) {
        TPDownloadParamAidl tPDownloadParamAidl = new TPDownloadParamAidl(tpDownloadParam.getUrlList(), tpDownloadParam.getDlType(), tpDownloadParam.getExtInfoMap());
        ITPPreLoadListenerAidl.Stub stub = new ITPPreLoadListenerAidl.Stub(){

            @Override
            public void onPrepareOK() {
                itpPreLoadListener.onPrepareOK();
            }

            @Override
            public void onPrepareError(int moduleId, int errorCode, String extInfo) {
                itpPreLoadListener.onPrepareError(moduleId, errorCode, extInfo);
            }

            @Override
            public void onPrepareDownloadProgressUpdate(int playableDurationMS, int downloadSpeedKBs, long currentDownloadSizeByte, long totalFileSizeByte, String exInfo) {
                itpPreLoadListener.onPrepareDownloadProgressUpdate(playableDurationMS, downloadSpeedKBs, currentDownloadSizeByte, totalFileSizeByte, exInfo);
            }
        };
        try {
            return this.downloadProxyAidl.startPreload(fileId, tPDownloadParamAidl, stub);
        }
        catch (Throwable throwable) {
            TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "startPreload failed, error:" + throwable.toString());
            return -1;
        }
    }

    @Override
    public int startClipPreload(String fileId, int clipCount, final ITPPreLoadListener itpPreLoadListener) {
        ITPPreLoadListenerAidl.Stub stub = new ITPPreLoadListenerAidl.Stub(){

            @Override
            public void onPrepareOK() {
                itpPreLoadListener.onPrepareOK();
            }

            @Override
            public void onPrepareError(int moduleId, int errorCode, String extInfo) {
                itpPreLoadListener.onPrepareError(moduleId, errorCode, extInfo);
            }

            @Override
            public void onPrepareDownloadProgressUpdate(int playableDurationMS, int downloadSpeedKBs, long currentDownloadSizeByte, long totalFileSizeByte, String exInfo) {
                itpPreLoadListener.onPrepareDownloadProgressUpdate(playableDurationMS, downloadSpeedKBs, currentDownloadSizeByte, totalFileSizeByte, exInfo);
            }
        };
        try {
            return this.downloadProxyAidl.startClipPreload(fileId, clipCount, stub);
        }
        catch (Throwable throwable) {
            TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "startClipPreload failed, error:" + throwable.toString());
            return -1;
        }
    }

    @Override
    public void stopPreload(int playId) {
        try {
            this.downloadProxyAidl.stopPreload(playId);
            return;
        }
        catch (Throwable throwable) {
            TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "stopPreload failed, error:" + throwable.toString());
            return;
        }
    }

    @Override
    public int startOfflineDownload(String s2, TPDownloadParam tpDownloadParam, ITPOfflineDownloadListener itpOfflineDownloadListener) {
        return -1;
    }

    @Override
    public int startClipOfflineDownload(String fileId, int clipCount, ITPOfflineDownloadListener offlineDownloadListener) {
        return -1;
    }

    @Override
    public void stopOfflineDownload(int i2) {
    }

    @Override
    public void startTask(int taskId) {
        try {
            this.downloadProxyAidl.startTask(taskId);
            return;
        }
        catch (Throwable throwable) {
            TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "startTask failed, error:" + throwable.toString());
            return;
        }
    }

    @Override
    public void updateStoragePath(String path) {
    }

    @Override
    public int removeStorageCache(String fileId) {
        return this.removeStorageCache(fileId, -1L);
    }

    @Override
    public int removeStorageCache(String fileId, long preferredResolution) {
        try {
            return this.downloadProxyAidl.removeStorageCache(fileId, preferredResolution);
        }
        catch (Throwable throwable) {
            TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "removeStorageCache failed, error:" + throwable.toString());
            return -1;
        }
    }

    @Override
    public int clearCache(String path, String fileId, int mode) {
        return this.clearCache(path, fileId, mode, -1L);
    }

    @Override
    public int clearCache(String path, String fileId, int mode, long preferredResolution) {
        try {
            return this.downloadProxyAidl.clearCache(path, fileId, mode, preferredResolution);
        }
        catch (Throwable throwable) {
            TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "clearCache failed, error:" + throwable.toString());
            return -1;
        }
    }

    @Override
    public boolean checkResourceExist(String diskPath, String resourceID, long preferredResolution) {
        try {
            return this.downloadProxyAidl.checkResourceExist(diskPath, resourceID, preferredResolution);
        }
        catch (Throwable throwable) {
            TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "checkResourceExist failed, error:" + throwable.toString());
            return false;
        }
    }

    @Override
    public float getResourceDownloadProgress(String diskPath, String resourceID, long preferredResolution) {
        try {
            return this.downloadProxyAidl.getResourceDownloadProgress(diskPath, resourceID, preferredResolution);
        }
        catch (Throwable throwable) {
            TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "getResourceDownloadProgress failed, error:" + throwable.toString());
            return -1.0f;
        }
    }

    @Override
    public void setMaxStorageSizeMB(long maxStorageSizeMB) {
        try {
            this.downloadProxyAidl.setMaxStorageSizeMB(maxStorageSizeMB);
            return;
        }
        catch (Throwable throwable) {
            TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "setMaxStorageSizeMB failed, error:" + throwable.toString());
            return;
        }
    }

    @Override
    public void setUserData(String key, Object value) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(key, value);
        try {
            this.downloadProxyAidl.setUserData(hashMap);
            return;
        }
        catch (Throwable throwable) {
            TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "setUserData failed, error:" + throwable.toString());
            return;
        }
    }

    @Override
    public String getNativeInfo(int key) {
        String string = null;
        try {
            string = this.downloadProxyAidl.getNativeInfo(key);
        }
        catch (Throwable throwable) {
            TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "getNativeInfo failed, error:" + throwable.toString());
        }
        return string;
    }

    @Override
    public int checkResourceStatus(String diskPath, String resourceID, int fileFormat) {
        int n2 = -1;
        try {
            n2 = this.downloadProxyAidl.checkResourceStatus(diskPath, resourceID, fileFormat);
        }
        catch (Throwable throwable) {
            TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "checkResourceStatus failed, error:" + throwable.toString());
        }
        return n2;
    }

    @Override
    public long getResourceSize(String diskPath, String resourceID) {
        long l2 = -1L;
        try {
            l2 = this.downloadProxyAidl.getResourceSize(diskPath, resourceID);
        }
        catch (Throwable throwable) {
            TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "getResourceSize failed, error:" + throwable.toString());
        }
        return l2;
    }

    @Override
    public void pushEvent(int event) {
        try {
            this.downloadProxyAidl.pushEvent(event);
            return;
        }
        catch (Throwable throwable) {
            TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "pushEvent failed, error:" + throwable.toString());
            return;
        }
    }

    @Override
    public void setPlayState(int playId, int state) {
        try {
            this.downloadProxyAidl.setPlayState(playId, state);
            return;
        }
        catch (Throwable throwable) {
            TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "setPlayState failed, error:" + throwable.toString());
            return;
        }
    }

    @Override
    public void updateTaskInfo(int playId, String key, Object value) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(key, value);
        try {
            this.downloadProxyAidl.updateTaskInfo(playId, hashMap);
            return;
        }
        catch (Throwable throwable) {
            TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "updateTaskInfo failed, error:" + throwable.toString());
            return;
        }
    }

    @Override
    public byte[] getOfflineLicenseKeySetId(String saveDir, String playUrl, String licenseUrl) {
        try {
            return this.downloadProxyAidl.getOfflineLicenseKeySetId(saveDir, playUrl, licenseUrl);
        }
        catch (Throwable throwable) {
            TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "getOfflineLicenseKeySetId failed, error:" + throwable.toString());
            return null;
        }
    }

    @Override
    public int deleteOfflineLicenseKeySetId(String saveDir, String playUrl, String licenseUrl) {
        try {
            return this.downloadProxyAidl.deleteOfflineLicenseKeySetId(saveDir, playUrl, licenseUrl);
        }
        catch (Throwable throwable) {
            TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "deleteOfflineLicenseKeySetId failed, error:" + throwable.toString());
            return -1;
        }
    }

    @Override
    public TPDLProxyMsg.TPPDTInfo[] getPDTInfos(int playId) {
        return new TPDLProxyMsg.TPPDTInfo[0];
    }

    @Override
    public void switchToResolution(int playId, int width, int height) {
    }
}

