/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.thumbplayer.tcmedia.core.downloadproxy.api;

import com.tencent.thumbplayer.tcmedia.core.downloadproxy.utils.TPDLProxyLog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class TPDownloadParam {
    private static final String FILE_NAME = "TPDownloadParam";
    private ArrayList<String> urlList = new ArrayList();
    private int dlType;
    private Map<String, Object> extInfoMap = new HashMap<String, Object>();

    public TPDownloadParam(ArrayList<String> urlList, int dlType, Map<String, Object> extInfoMap) {
        this.dlType = dlType;
        this.setUrlList(urlList);
        this.setExtInfoMap(extInfoMap);
    }

    public ArrayList<String> getUrlList() {
        return this.urlList;
    }

    public void setUrlList(ArrayList<String> urlList) {
        if (urlList != null) {
            this.urlList = urlList;
            return;
        }
        this.urlList.clear();
    }

    public void setDlType(int dlType) {
        this.dlType = dlType;
    }

    public Map<String, Object> getExtInfoMap() {
        return this.extInfoMap;
    }

    public void setExtInfoMap(Map<String, Object> extInfoMap) {
        if (extInfoMap != null) {
            this.extInfoMap = extInfoMap;
            return;
        }
        this.extInfoMap.clear();
    }

    public String getCdnUrls() {
        if (this.urlList == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        if (this.extInfoMap != null && this.extInfoMap.containsKey("dl_param_enable_expand_donwload_url")) {
            bl = (Boolean)this.extInfoMap.get("dl_param_enable_expand_donwload_url");
        }
        for (int i2 = 0; i2 < this.urlList.size(); ++i2) {
            stringBuffer.append(this.urlList.get(i2));
            if (bl) {
                if (this.urlList.get(i2).indexOf("?") > 0) {
                    stringBuffer.append("&cost=low");
                } else {
                    stringBuffer.append("?cost=low");
                }
            }
            stringBuffer.append(";");
        }
        if (stringBuffer.length() > 0) {
            StringBuffer stringBuffer2 = stringBuffer;
            stringBuffer2.deleteCharAt(stringBuffer2.length() - 1);
        }
        return stringBuffer.toString();
    }

    public int getDlType() {
        return this.dlType;
    }

    public String getVid() {
        if (this.extInfoMap == null || this.extInfoMap.isEmpty()) {
            return "";
        }
        String string = "";
        if (this.extInfoMap.containsKey("dl_param_vid")) {
            string = (String)this.extInfoMap.get("dl_param_vid");
        }
        return string;
    }

    public boolean isOffline() {
        if (this.extInfoMap == null || this.extInfoMap.isEmpty()) {
            return false;
        }
        boolean bl = false;
        if (this.extInfoMap.containsKey("dl_param_is_offline")) {
            bl = (Boolean)this.extInfoMap.get("dl_param_is_offline");
        }
        return bl;
    }

    public boolean isAdaptive() {
        if (this.extInfoMap == null || this.extInfoMap.isEmpty()) {
            return false;
        }
        boolean bl = false;
        if (this.extInfoMap.containsKey("dl_param_adaptive_type") && (Integer)this.extInfoMap.get("dl_param_adaptive_type") > 0) {
            bl = true;
        }
        return bl;
    }

    public Map<String, String> getOfflinePlayExtraInfo() {
        if (this.extInfoMap == null || this.extInfoMap.isEmpty()) {
            return null;
        }
        if (this.extInfoMap.containsKey("dl_param_play_extra_info")) {
            return (Map)this.extInfoMap.get("dl_param_play_extra_info");
        }
        return null;
    }

    public String getPlayDefinition() {
        if (this.extInfoMap == null || this.extInfoMap.isEmpty()) {
            return "";
        }
        String string = "";
        if (this.extInfoMap.containsKey("dl_param_play_definition")) {
            string = (String)this.extInfoMap.get("dl_param_play_definition");
        }
        return string;
    }

    public String getFormat() {
        if (this.extInfoMap == null || this.extInfoMap.isEmpty()) {
            return "";
        }
        String string = "";
        if (this.extInfoMap.containsKey("dl_param_current_format")) {
            string = (String)this.extInfoMap.get("dl_param_current_format");
        }
        return string;
    }

    public String getKeyid() {
        if (this.extInfoMap == null || this.extInfoMap.isEmpty()) {
            return "";
        }
        String string = "";
        if (this.extInfoMap.containsKey("dl_param_play_keyid")) {
            string = (String)this.extInfoMap.get("dl_param_play_keyid");
        }
        return string;
    }

    public int getClipCount() {
        if (this.extInfoMap == null || this.extInfoMap.isEmpty()) {
            return 1;
        }
        int n2 = 1;
        if (this.extInfoMap.containsKey("dl_param_play_clip_count")) {
            n2 = (Integer)this.extInfoMap.get("dl_param_play_clip_count");
        }
        return n2;
    }

    public int getClipNo() {
        if (this.extInfoMap == null || this.extInfoMap.isEmpty()) {
            return 1;
        }
        int n2 = 1;
        if (this.extInfoMap.containsKey("dl_param_play_clip_no")) {
            n2 = (Integer)this.extInfoMap.get("dl_param_play_clip_no");
        }
        return n2;
    }

    public long getTotalDurationMS() {
        if (this.extInfoMap == null || this.extInfoMap.isEmpty()) {
            return 0L;
        }
        long l2 = 0L;
        if (this.extInfoMap.containsKey("dl_param_file_duration")) {
            l2 = (Long)this.extInfoMap.get("dl_param_file_duration");
        }
        return l2;
    }

    public String getSavaPath() {
        if (this.extInfoMap == null || this.extInfoMap.isEmpty()) {
            return "";
        }
        String string = "";
        if (this.extInfoMap.containsKey("dl_param_save_path")) {
            string = (String)this.extInfoMap.get("dl_param_save_path");
        }
        return string;
    }

    public Object getExtInfo(String key) {
        if (this.extInfoMap == null) {
            return null;
        }
        return this.extInfoMap.get(key);
    }

    public String getExtraJsonInfo() {
        if (this.extInfoMap == null || this.extInfoMap.isEmpty()) {
            return "";
        }
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            for (Map.Entry<String, Object> entry : this.extInfoMap.entrySet()) {
                if (entry.getKey().equalsIgnoreCase("dl_param_is_offline") || entry.getKey().equalsIgnoreCase("dl_param_play_extra_info") || entry.getKey().equalsIgnoreCase("dl_param_play_definition") || entry.getKey().equalsIgnoreCase("dl_param_enable_expand_donwload_url")) continue;
                hashMap.put(entry.getKey(), entry.getValue());
            }
            return new JSONObject(hashMap).toString();
        }
        catch (Throwable throwable) {
            TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "getExtraJsonInfo failed, error:" + throwable.toString());
            return "";
        }
    }

    private String getExtraFormatNodesJsonInfo(ArrayList<Map<String, Object>> formatNodes) {
        if (formatNodes == null) {
            return "[]";
        }
        try {
            StringBuffer stringBuffer = new StringBuffer("[");
            for (int i2 = 0; i2 < formatNodes.size(); ++i2) {
                Map<String, Object> map = formatNodes.get(i2);
                if (i2 == formatNodes.size() - 1) {
                    stringBuffer.append(String.format("{\"dl_param_name\":\"%s\", \"dl_param_bitrate\":%s}", map.get("dl_param_name"), map.get("dl_param_bitrate")));
                    continue;
                }
                stringBuffer.append(String.format("{\"dl_param_name\":\"%s\", \"dl_param_bitrate\":%s}, ", map.get("dl_param_name"), map.get("dl_param_bitrate")));
            }
            stringBuffer.append("]");
            return stringBuffer.toString();
        }
        catch (Throwable throwable) {
            TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "getExtraJsonInfo failed, error:" + throwable.toString());
            return "[]";
        }
    }

    private String getUrlHostNodesJsonInfo(ArrayList<String> arrayListNodes) {
        if (arrayListNodes == null) {
            return "[]";
        }
        try {
            StringBuffer stringBuffer = new StringBuffer("[");
            for (int i2 = 0; i2 < arrayListNodes.size(); ++i2) {
                String string = arrayListNodes.get(i2);
                if (i2 == arrayListNodes.size() - 1) {
                    stringBuffer.append(String.format("\"%s\"", string));
                    continue;
                }
                stringBuffer.append(String.format("\"%s\", ", string));
            }
            stringBuffer.append("]");
            return stringBuffer.toString();
        }
        catch (Throwable throwable) {
            TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "getArrayListStr failed, error:" + throwable.toString());
            return "[]";
        }
    }
}

