/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.transcriber;

import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.transcriber.AITranscriberManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@JNINamespace(value="liteav::manager")
public class AITranscriberManagerImpl
implements AITranscriberManager {
    private static final String TAG = "AITranscriberManagerImpl";
    private long mNativeAITranscriberManagerJni = 0L;
    private TranscriberListenerWrapper mListenerDispatcher = new TranscriberListenerWrapper();

    public AITranscriberManagerImpl(long nativeAITranscriberManagerJni) {
        this.mNativeAITranscriberManagerJni = nativeAITranscriberManagerJni;
    }

    @Override
    public void startRealtimeTranscriber(AITranscriberManager.TranscriberParams params) {
        if (this.mNativeAITranscriberManagerJni != 0L && params != null) {
            AITranscriberManagerImpl.nativeStartRealtimeTranscriber(this.mNativeAITranscriberManagerJni, new TranscriberParamsWrapper(params));
        }
    }

    @Override
    public void stopRealtimeTranscriber(String transcriberRobotId) {
        if (this.mNativeAITranscriberManagerJni != 0L && transcriberRobotId != null) {
            AITranscriberManagerImpl.nativeStopRealtimeTranscriber(this.mNativeAITranscriberManagerJni, transcriberRobotId);
        }
    }

    @Override
    public void pauseReceivingMessage() {
        if (this.mNativeAITranscriberManagerJni != 0L) {
            AITranscriberManagerImpl.nativePauseReceivingMessage(this.mNativeAITranscriberManagerJni);
        }
    }

    @Override
    public void resumeReceivingMessage() {
        if (this.mNativeAITranscriberManagerJni != 0L) {
            AITranscriberManagerImpl.nativeResumeReceivingMessage(this.mNativeAITranscriberManagerJni);
        }
    }

    @Override
    public void addListener(AITranscriberManager.AITranscriberListener listener) {
        if (listener == null) {
            return;
        }
        if (this.mListenerDispatcher.a(listener) && this.mNativeAITranscriberManagerJni != 0L) {
            AITranscriberManagerImpl.nativeSetListener(this.mNativeAITranscriberManagerJni, this.mListenerDispatcher);
        }
    }

    @Override
    public void removeListener(AITranscriberManager.AITranscriberListener listener) {
        if (listener == null) {
            return;
        }
        if (this.mListenerDispatcher.b(listener) && this.mNativeAITranscriberManagerJni != 0L) {
            AITranscriberManagerImpl.nativeSetListener(this.mNativeAITranscriberManagerJni, null);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.mNativeAITranscriberManagerJni != 0L) {
            AITranscriberManagerImpl.nativeDestroy(this.mNativeAITranscriberManagerJni);
            this.mNativeAITranscriberManagerJni = 0L;
        }
    }

    private static native void nativeDestroy(long var0);

    private static native void nativeStartRealtimeTranscriber(long var0, TranscriberParamsWrapper var2);

    private static native void nativeStopRealtimeTranscriber(long var0, String var2);

    private static native void nativePauseReceivingMessage(long var0);

    private static native void nativeResumeReceivingMessage(long var0);

    private static native void nativeSetListener(long var0, TranscriberListenerWrapper var2);

    static class TranscriberMessageWrapper {
        TranscriberMessageWrapper() {
        }

        public static AITranscriberManager.TranscriberMessage constructor() {
            return new AITranscriberManager.TranscriberMessage();
        }

        public static void setSegmentId(AITranscriberManager.TranscriberMessage message, String segmentId) {
            message.segmentId = segmentId;
        }

        public static void setSpeakerUserId(AITranscriberManager.TranscriberMessage message, String speakerUserId) {
            message.speakerUserId = speakerUserId;
        }

        public static void setSourceText(AITranscriberManager.TranscriberMessage message, String sourceText) {
            message.sourceText = sourceText;
        }

        public static void putTranslationText(AITranscriberManager.TranscriberMessage message, String language, String translationText) {
            if (message.translationTexts == null) {
                message.translationTexts = new HashMap<String, String>();
            }
            message.translationTexts.put(language, translationText);
        }

        public static void setTimestamp(AITranscriberManager.TranscriberMessage message, long timestamp) {
            message.timestamp = timestamp;
        }

        public static void setIsCompleted(AITranscriberManager.TranscriberMessage message, boolean isCompleted) {
            message.isCompleted = isCompleted;
        }
    }

    static class TranscriberParamsWrapper {
        private AITranscriberManager.TranscriberParams a;

        public TranscriberParamsWrapper(AITranscriberManager.TranscriberParams params) {
            this.a = params;
        }

        public String getTranscriberRobotId() {
            return this.a.transcriberRobotId;
        }

        public String getSourceLanguage() {
            return this.a.sourceLanguage;
        }

        public String[] getUserIdsToTranscribe() {
            if (this.a.userIdsToTranscribe == null) {
                return null;
            }
            return this.a.userIdsToTranscribe.toArray(new String[0]);
        }

        public String[] getTranslationLanguages() {
            if (this.a.translationLanguages == null) {
                return null;
            }
            return this.a.translationLanguages.toArray(new String[0]);
        }
    }

    static class TranscriberListenerWrapper {
        private final List<AITranscriberManager.AITranscriberListener> a = new ArrayList<AITranscriberManager.AITranscriberListener>();

        TranscriberListenerWrapper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean a(AITranscriberManager.AITranscriberListener aITranscriberListener) {
            boolean bl = false;
            if (aITranscriberListener == null) {
                return false;
            }
            TranscriberListenerWrapper transcriberListenerWrapper = this;
            synchronized (transcriberListenerWrapper) {
                if (!this.a.contains(aITranscriberListener)) {
                    this.a.add(aITranscriberListener);
                }
                if (this.a.size() > 0) {
                    bl = true;
                }
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean b(AITranscriberManager.AITranscriberListener aITranscriberListener) {
            boolean bl = false;
            TranscriberListenerWrapper transcriberListenerWrapper = this;
            synchronized (transcriberListenerWrapper) {
                this.a.remove(aITranscriberListener);
                if (this.a.size() == 0) {
                    bl = true;
                }
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onRealtimeTranscriberStarted(String roomId, String transcriberRobotId) {
            ArrayList<AITranscriberManager.AITranscriberListener> listeners;
            TranscriberListenerWrapper transcriberListenerWrapper = this;
            synchronized (transcriberListenerWrapper) {
                listeners = new ArrayList<AITranscriberManager.AITranscriberListener>(this.a);
            }
            for (AITranscriberManager.AITranscriberListener aITranscriberListener : listeners) {
                if (aITranscriberListener == null) continue;
                aITranscriberListener.onRealtimeTranscriberStarted(roomId, transcriberRobotId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceiveTranscriberMessage(String roomId, AITranscriberManager.TranscriberMessage message) {
            ArrayList<AITranscriberManager.AITranscriberListener> listeners;
            TranscriberListenerWrapper transcriberListenerWrapper = this;
            synchronized (transcriberListenerWrapper) {
                listeners = new ArrayList<AITranscriberManager.AITranscriberListener>(this.a);
            }
            for (AITranscriberManager.AITranscriberListener aITranscriberListener : listeners) {
                if (aITranscriberListener == null) continue;
                aITranscriberListener.onReceiveTranscriberMessage(roomId, message);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onRealtimeTranscriberStopped(String roomId, String transcriberRobotId, int reason) {
            ArrayList<AITranscriberManager.AITranscriberListener> listeners;
            TranscriberListenerWrapper transcriberListenerWrapper = this;
            synchronized (transcriberListenerWrapper) {
                listeners = new ArrayList<AITranscriberManager.AITranscriberListener>(this.a);
            }
            for (AITranscriberManager.AITranscriberListener aITranscriberListener : listeners) {
                if (aITranscriberListener == null) continue;
                aITranscriberListener.onRealtimeTranscriberStopped(roomId, transcriberRobotId, reason);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onRealtimeTranscriberError(String roomId, String transcriberRobotId, int error, String errorInfo) {
            ArrayList<AITranscriberManager.AITranscriberListener> listeners;
            TranscriberListenerWrapper transcriberListenerWrapper = this;
            synchronized (transcriberListenerWrapper) {
                listeners = new ArrayList<AITranscriberManager.AITranscriberListener>(this.a);
            }
            for (AITranscriberManager.AITranscriberListener aITranscriberListener : listeners) {
                if (aITranscriberListener == null) continue;
                aITranscriberListener.onRealtimeTranscriberError(roomId, transcriberRobotId, error, errorInfo);
            }
        }
    }
}

