/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.base;

import java.util.Locale;

public class Log {
    public static final int ASSERT = 7;
    public static final int DEBUG = 3;
    public static final int ERROR = 6;
    public static final int INFO = 4;
    public static final int VERBOSE = 2;
    public static final int WARN = 5;
    private static final String sTagPrefix = "cr_";
    private static final String sDeprecatedTagPrefix = "cr.";
    private static final boolean useChromiumLog = true;

    private Log() {
    }

    private static String formatLog(String messageTemplate, Throwable tr, Object ... params) {
        if (params != null && (tr == null && params.length > 0 || params.length > 1)) {
            messageTemplate = String.format(Locale.US, messageTemplate, params);
        }
        return messageTemplate;
    }

    public static String normalizeTag(String tag) {
        if (tag.startsWith(sTagPrefix)) {
            return tag;
        }
        int n2 = 0;
        if (tag.startsWith(sDeprecatedTagPrefix)) {
            n2 = 3;
        }
        return sTagPrefix + tag.substring(n2, tag.length());
    }

    private static String formatLogWithStack(String messageTemplate, Throwable tr, Object ... params) {
        return "[" + Log.getCallOrigin() + "] " + Log.formatLog(messageTemplate, tr, params);
    }

    private static boolean isDebug() {
        return true;
    }

    public static boolean isLoggable(String tag, int level) {
        if (!Log.isDebug() && level <= 4) {
            return false;
        }
        return android.util.Log.isLoggable((String)tag, (int)level);
    }

    public static void v(String tag, String messageTemplate, Object ... args) {
        Throwable throwable = Log.getThrowableToLog(args);
        String string = Log.formatLogWithStack(messageTemplate, throwable, args);
        Log.nativeWriteLogToNative(2, tag, string);
    }

    public static void d(String tag, String messageTemplate, Object ... args) {
        Throwable throwable = Log.getThrowableToLog(args);
        String string = Log.formatLogWithStack(messageTemplate, throwable, args);
        Log.nativeWriteLogToNative(3, tag, string);
    }

    public static void i(String tag, String messageTemplate, Object ... args) {
        Throwable throwable = Log.getThrowableToLog(args);
        String string = Log.formatLog(messageTemplate, throwable, args);
        Log.nativeWriteLogToNative(4, tag, string);
    }

    public static void w(String tag, String messageTemplate, Object ... args) {
        Throwable throwable = Log.getThrowableToLog(args);
        String string = Log.formatLog(messageTemplate, throwable, args);
        Log.nativeWriteLogToNative(5, tag, string);
    }

    public static void e(String tag, String messageTemplate, Object ... args) {
        Throwable throwable = Log.getThrowableToLog(args);
        String string = Log.formatLog(messageTemplate, throwable, args);
        Log.nativeWriteLogToNative(6, tag, string);
    }

    public static void wtf(String tag, String messageTemplate, Object ... args) {
        Throwable throwable = Log.getThrowableToLog(args);
        String string = Log.formatLog(messageTemplate, throwable, args);
        Log.nativeWriteLogToNative(7, tag, string);
    }

    public static String getStackTraceString(Throwable tr) {
        return android.util.Log.getStackTraceString((Throwable)tr);
    }

    private static Throwable getThrowableToLog(Object[] args) {
        if (args == null || args.length == 0) {
            return null;
        }
        Object object = args[args.length - 1];
        if (!(object instanceof Throwable)) {
            return null;
        }
        return (Throwable)object;
    }

    private static String getCallOrigin() {
        int n2;
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        String string = Log.class.getName();
        for (n2 = 0; n2 < stackTraceElementArray.length; ++n2) {
            if (!stackTraceElementArray[n2].getClassName().equals(string)) continue;
            n2 += 3;
            break;
        }
        return stackTraceElementArray[n2].getFileName() + ":" + stackTraceElementArray[n2].getLineNumber();
    }

    private static native void nativeWriteLogToNative(int var0, String var1, String var2);
}

