/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.thumbplayer.tcmedia.core.common;

import android.util.Log;
import com.tencent.thumbplayer.tcmedia.core.common.ITPNativeLogCallback;

public class TPNativeLog {
    private static final String TAG = "PlayerCore";
    public static final int LEVEL_VERBOSE = 0;
    public static final int LEVEL_DEBUG = 1;
    public static final int LEVEL_INFO = 2;
    public static final int LEVEL_WARN = 3;
    public static final int LEVEL_ERROR = 4;
    private static ITPNativeLogCallback mLogCallback = null;

    public static void setLogCallback(ITPNativeLogCallback iTPNativeLogCallback) {
        mLogCallback = iTPNativeLogCallback;
    }

    public static void printLog(int n2, String string) {
        TPNativeLog.printLog(n2, TAG, string);
    }

    public static void printLog(int n2, String string, String string2) {
        if (mLogCallback != null) {
            mLogCallback.onPrintLog(n2, string, string2);
            return;
        }
        TPNativeLog.printLogDefault(n2, string, string2);
    }

    public static void printLogDefault(int n2, String string, String string2) {
        switch (n2) {
            case 0: {
                Log.v((String)string, (String)string2);
                return;
            }
            case 1: {
                Log.d((String)string, (String)string2);
                return;
            }
            case 2: {
                Log.i((String)string, (String)string2);
                return;
            }
            case 3: {
                Log.w((String)string, (String)string2);
                return;
            }
            case 4: {
                Log.e((String)string, (String)string2);
                return;
            }
        }
        Log.v((String)string, (String)string2);
    }

    private static void onPrintLog(int n2, byte[] byArray, int n3, byte[] byArray2, int n4) {
        try {
            int n5;
            String string = new String(byArray, 0, n3, "UTF-8");
            String string2 = new String(byArray2, 0, n4, "UTF-8");
            switch (n2) {
                case 0: {
                    n5 = 4;
                    break;
                }
                case 1: {
                    n5 = 3;
                    break;
                }
                case 2: {
                    n5 = 2;
                    break;
                }
                case 3: {
                    n5 = 1;
                    break;
                }
                case 4: {
                    n5 = 0;
                    break;
                }
                default: {
                    n5 = 0;
                }
            }
            TPNativeLog.printLog(n5, string, string2);
            return;
        }
        catch (Exception exception) {
            TPNativeLog.printLog(4, exception.getMessage());
            return;
        }
    }
}

