/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.thumbplayer.tcmedia.config;

import android.content.Context;
import android.content.pm.PackageManager;
import android.text.TextUtils;
import com.tencent.thumbplayer.tcmedia.core.config.TPPlayerCoreConfig;
import com.tencent.thumbplayer.tcmedia.utils.TPLogUtil;
import org.json.JSONException;
import org.json.JSONObject;

public class TPPlayerConfig {
    private static final String TAG = "TPPlayerConfig";
    public static final String VERSION = "2.32.0.573";
    public static final boolean ISOTT = false;
    private static String mGuid = "";
    private static String mProxyCacheDir;
    private static String mProxyDataDir;
    private static long mProxyMaxStorageSizeMB;
    private static long mProxyMaxUseMemoryMB;
    private static int mProxyServiceType;
    private static String mUserUin;
    private static boolean mUserIsVip;
    private static String mUserUpc;
    private static int mUserUpcState;
    private static String mOutNetIp;
    private static boolean mUseP2P;
    private static int mPlatform;
    private static String mAbUserId;
    public static String beacon_policy_host;
    public static String beacon_log_host;
    private static String host_config;
    private static boolean mEnableDataReport;
    private static boolean mEnablePlayerReport;
    private static String appVersionName;
    private static String DOT;
    private static String appVersion;
    private static long buildNum;

    public static void parseHostConfig(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            TPLogUtil.w(TAG, "parseHostConfig, config is null.");
            return;
        }
        host_config = string;
        TPLogUtil.i(TAG, "parseHostConfig:".concat(String.valueOf(string)));
        try {
            JSONObject jSONObject = new JSONObject(string);
            if (jSONObject.has("player_host_config")) {
                JSONObject jSONObject2 = jSONObject.getJSONObject("player_host_config");
                if (jSONObject2.has("beacon_policy_host")) {
                    beacon_policy_host = jSONObject2.getString("beacon_policy_host");
                }
                if (jSONObject2.has("beacon_log_host")) {
                    beacon_log_host = jSONObject2.getString("beacon_log_host");
                }
            }
            return;
        }
        catch (Throwable throwable) {
            TPLogUtil.w(TAG, "parseHostConfig exception: " + throwable.toString());
            return;
        }
    }

    public static void setDebugEnable(boolean bl) {
        TPLogUtil.setDebugEnable(bl);
    }

    public static void setP2PEnable(boolean bl) {
        mUseP2P = bl;
    }

    public static boolean isUseP2P() {
        return mUseP2P;
    }

    public static String getGuid() {
        return mGuid;
    }

    public static void setGuid(String string) {
        mGuid = string;
    }

    public static void setDataReportEnable(boolean bl) {
        mEnableDataReport = bl;
    }

    public static boolean isDataReportEnable() {
        return mEnableDataReport;
    }

    public static void setPlayerReportEnable(boolean bl) {
        mEnablePlayerReport = bl;
    }

    public static boolean isPlayerReportEnable() {
        return mEnablePlayerReport;
    }

    public static String getProxyCacheDir() {
        return mProxyCacheDir;
    }

    public static void setProxyCacheDir(String string) {
        mProxyCacheDir = string;
    }

    public static String getProxyDataDir() {
        return mProxyDataDir;
    }

    public static void setProxyDataDir(String string) {
        mProxyDataDir = string;
    }

    public static long getProxyMaxStorageSizeMB() {
        return mProxyMaxStorageSizeMB;
    }

    public static void setProxyMaxStorageSizeMB(long l2) {
        mProxyMaxStorageSizeMB = l2;
    }

    public static String getProxyConfigDir() {
        if (TextUtils.isEmpty((CharSequence)host_config)) {
            return "";
        }
        try {
            JSONObject jSONObject = new JSONObject(host_config);
            if (!jSONObject.has("httpproxy_config")) {
                return "";
            }
            return jSONObject.getString("httpproxy_config");
        }
        catch (JSONException jSONException) {
            TPLogUtil.e(TAG, jSONException);
            return "";
        }
    }

    public static String getUserUin() {
        return mUserUin;
    }

    public static void setUserUin(String string) {
        mUserUin = string;
    }

    public static void setUserUpc(String string) {
        mUserUpc = string;
    }

    public static String getUserUpc() {
        return mUserUpc;
    }

    public static void setUserUpcState(int n2) {
        mUserUpcState = n2;
    }

    public static int getUserUpcState() {
        return mUserUpcState;
    }

    public static String getOutNetIp() {
        return mOutNetIp;
    }

    public static void setOutNetIp(String string) {
        mOutNetIp = string;
    }

    public static boolean isUserIsVip() {
        return mUserIsVip;
    }

    public static void setUserIsVip(boolean bl) {
        mUserIsVip = bl;
    }

    public static void setProxyServiceType(int n2) {
        mProxyServiceType = n2;
    }

    public static int getProxyServiceType() {
        if (mProxyServiceType == -1 && mPlatform != -1) {
            return mPlatform;
        }
        return mProxyServiceType;
    }

    public static int getPlatform() {
        return mPlatform;
    }

    public static void setPlatform(int n2) {
        mPlatform = n2;
    }

    public static void setAbUserId(String string) {
        mAbUserId = string;
    }

    public static String getAbUserId() {
        if (TextUtils.isEmpty((CharSequence)mAbUserId)) {
            return "";
        }
        return mAbUserId;
    }

    public static String getAppVersionName(Context context) {
        if (!TextUtils.isEmpty((CharSequence)appVersionName)) {
            return appVersionName;
        }
        String string = "";
        if (context == null) {
            return string;
        }
        try {
            PackageManager packageManager = context.getPackageManager();
            String string2 = context.getPackageName();
            string = appVersionName = packageManager.getPackageInfo((String)string2, (int)0).versionName;
            if (appVersionName == null) {
                string = "";
            }
            return string;
        }
        catch (Throwable throwable) {
            return string;
        }
    }

    public static String getAppBigVersion(Context context) {
        if (!TextUtils.isEmpty((CharSequence)appVersion)) {
            return appVersion;
        }
        String string = TPPlayerConfig.getAppVersionName(context);
        String string2 = "0.0.0";
        if (!TextUtils.isEmpty((CharSequence)string)) {
            String[] stringArray = string.split(DOT);
            string2 = stringArray != null && stringArray.length == 4 ? string.substring(0, string.lastIndexOf(".")) : string;
        }
        appVersion = string2;
        return string2;
    }

    public static long getBuildNumber(Context context) {
        if (-1L != buildNum) {
            return buildNum;
        }
        try {
            PackageManager packageManager = context.getPackageManager();
            String string = context.getPackageName();
            buildNum = packageManager.getPackageInfo(string, 0).getLongVersionCode();
            return buildNum;
        }
        catch (Throwable throwable) {
            TPLogUtil.e(TAG, "getLongVersionCode less api 28");
            return buildNum;
        }
    }

    public static void setVideoMediaCodecCoexistMaxCnt(int n2) {
        TPPlayerCoreConfig.setVideoMediaCodecCoexistMaxCnt(n2);
    }

    public static int getVideoMediaCodecCoexistMaxCnt() {
        return TPPlayerCoreConfig.getVideoMediaCodecCoexistMaxCnt();
    }

    public static void setMediaDrmReuseEnable(boolean bl) {
        TPPlayerCoreConfig.setMediaDrmReuseEnable(bl);
    }

    public static boolean getMediaDrmReuseEnable() {
        return TPPlayerCoreConfig.getMediaDrmReuseEnable();
    }

    public static void setNewReportEnable(boolean bl) {
        TPPlayerCoreConfig.setCoreEventProcessEnable(bl);
    }

    public static boolean getNewReportEnable() {
        return TPPlayerCoreConfig.getCoreEventProcessEnable();
    }

    public static void setProxyMaxUseMemoryMB(long l2) {
        mProxyMaxUseMemoryMB = l2;
    }

    public static long getProxyMaxUseMemoryMB() {
        return mProxyMaxUseMemoryMB;
    }

    public static void setWidevineProvisioningServerUrl(String string) {
        TPPlayerCoreConfig.setWidevineProvisioningServerUrl(string);
    }

    public static String getWidevineProvisioningServerUrl() {
        return TPPlayerCoreConfig.getWidevineProvisioningServerUrl();
    }

    static {
        mProxyServiceType = -1;
        mUserUpc = "";
        mUserUpcState = 0;
        mOutNetIp = "";
        mUseP2P = true;
        mPlatform = -1;
        mAbUserId = "";
        beacon_policy_host = "";
        beacon_log_host = "";
        host_config = "";
        mEnableDataReport = false;
        mEnablePlayerReport = false;
        DOT = "\\.";
        appVersion = "";
        buildNum = -1L;
    }
}

