/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.rtmp.ui;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Point;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.Surface;
import android.view.SurfaceView;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.widget.FrameLayout;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.h;
import com.tencent.liteav.base.util.i;
import com.tencent.rtmp.ui.AndroidViewEventListener;
import com.tencent.rtmp.ui.FocusIndicatorView;
import com.tencent.rtmp.ui.c;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class TXCloudVideoView
extends FrameLayout
implements ScaleGestureDetector.OnScaleGestureListener {
    private final String mTAG = "TXCloudVideoView_" + ((Object)((Object)this)).hashCode();
    private static final int FOCUS_AREA_SIZE_IN_DP = 70;
    private final WeakReference<SurfaceView> mSurfaceView;
    private final WeakReference<Surface> mSurface;
    private TextureView mUserTextureView;
    private TextureView mCurrentInnerTextureView;
    private TextureView mFreeInnerTextureView;
    private final List<TextureView> mInactiveInnerTextureViews = new ArrayList<TextureView>();
    protected Object mGLContext;
    private FocusIndicatorView mFocusIndicatorView;
    private boolean mEnableTouchToFocus = false;
    private final a mDelayedTapRunnable = new a(0);
    private ScaleGestureDetector mScaleGestureDetector;
    private boolean mEnableZoom = false;
    private float mLastScaleFactor;
    private float mScaleFactor;
    private String mUserId = "";
    private WeakReference<b> mCallback;
    private boolean mEnableShowLog;
    private AndroidViewEventListener mViewEventListener;
    private final Runnable mHideIndicatorViewRunnable = com.tencent.rtmp.ui.a.a(this);

    public TXCloudVideoView(Context context) {
        this(context, null, null);
    }

    public TXCloudVideoView(SurfaceView surfaceView) {
        this(surfaceView.getContext(), null, surfaceView);
    }

    public TXCloudVideoView(Context context, Surface surface) {
        this(context, null, null, surface);
    }

    public TXCloudVideoView(Context context, AttributeSet attrs) {
        this(context, attrs, null);
    }

    public TXCloudVideoView(Context context, AttributeSet attrs, SurfaceView surfaceView) {
        this(context, attrs, surfaceView, null);
    }

    private TXCloudVideoView(Context context, AttributeSet attrs, SurfaceView surfaceView, Surface surface) {
        super(context, attrs);
        this.mSurfaceView = surfaceView != null ? new WeakReference<SurfaceView>(surfaceView) : null;
        WeakReference<Surface> weakReference = this.mSurface = surface != null ? new WeakReference<Surface>(surface) : null;
        if (surfaceView == null && surface == null) {
            this.mFreeInnerTextureView = new TextureView(context);
            TXCloudVideoView tXCloudVideoView = this;
            tXCloudVideoView.addView((View)tXCloudVideoView.mFreeInnerTextureView);
        }
    }

    public void addVideoView(TextureView view) {
        if (view == null) {
            LiteavLog.w(this.mTAG, "addVideoView: null");
            return;
        }
        if (i.a(this.mUserTextureView, view)) {
            LiteavLog.i(this.mTAG, "addVideoView: same view");
            return;
        }
        this.removeVideoView();
        LiteavLog.i(this.mTAG, "addVideoView: ".concat(String.valueOf(view)));
        if (view.getParent() == null) {
            this.addView((View)view);
        } else if (view.getParent() == this) {
            LiteavLog.i(this.mTAG, "addVideoView: already added.");
        } else {
            LiteavLog.w(this.mTAG, "addVideoView: has other parent:" + view.getParent());
        }
        this.mUserTextureView = view;
        this.updateZOrders();
    }

    public void removeVideoView() {
        if (this.mUserTextureView == null) {
            return;
        }
        LiteavLog.i(this.mTAG, "removeVideoView: " + this.mUserTextureView);
        TXCloudVideoView tXCloudVideoView = this;
        tXCloudVideoView.removeChildView((View)tXCloudVideoView.mUserTextureView);
        this.mUserTextureView = null;
    }

    @Deprecated
    public TextureView getVideoView() {
        if (this.mUserTextureView != null) {
            return this.mUserTextureView;
        }
        return this.mCurrentInnerTextureView;
    }

    private void setBackgroundColorForInternalView(int color) {
        LiteavLog.i(this.mTAG, "setBackgroundColorForInternalView color:".concat(String.valueOf(color)));
        if (this.mSurface != null || this.mSurfaceView != null) {
            return;
        }
        int n2 = color & 0xFF;
        int n3 = color >> 8 & 0xFF;
        int n4 = color >> 16 & 0xFF;
        int n5 = color >> 24 & 0xFF;
        TXCloudVideoView tXCloudVideoView = this;
        tXCloudVideoView.post(com.tencent.rtmp.ui.b.a(tXCloudVideoView, n2, n5, n4, n3));
    }

    @Deprecated
    public TextureView getHWVideoView() {
        return this.getVideoView();
    }

    private TextureView getTextureViewSetByUser() {
        return this.mUserTextureView;
    }

    private TextureView getFreeInnerTextureView() {
        return this.mFreeInnerTextureView;
    }

    private void addViewInternal(TextureView view) {
        if (view == null) {
            LiteavLog.w(this.mTAG, "addViewInternal: null.");
            return;
        }
        if (this.mCurrentInnerTextureView == view) {
            LiteavLog.i(this.mTAG, "addViewInternal: same view");
            return;
        }
        if (view.getParent() != null && view.getParent() != this) {
            LiteavLog.e(this.mTAG, "addViewInternal: has other parent:" + view.getParent());
            return;
        }
        LiteavLog.i(this.mTAG, "addViewInternal: " + view + ", current: " + this.mCurrentInnerTextureView + ", free: " + this.mFreeInnerTextureView);
        if (view.getParent() == null) {
            this.addView((View)view);
        }
        if (this.mFreeInnerTextureView == view) {
            this.mFreeInnerTextureView = null;
        }
        if (this.mCurrentInnerTextureView != null) {
            this.mInactiveInnerTextureViews.add(0, this.mCurrentInnerTextureView);
            LiteavLog.i(this.mTAG, "addViewInternal: keep inactive view: " + this.mCurrentInnerTextureView);
        }
        this.mCurrentInnerTextureView = view;
        this.mInactiveInnerTextureViews.remove(view);
        this.updateZOrders();
    }

    /*
     * Unable to fully structure code
     */
    private void removeViewInternal(TextureView view, boolean clearLastImage) {
        block9: {
            block7: {
                block8: {
                    if (view == null) {
                        LiteavLog.w(this.mTAG, "removeViewInternal: null.");
                        return;
                    }
                    if (this.mInactiveInnerTextureViews.contains(view)) {
                        LiteavLog.i(this.mTAG, "removeViewInternal: remove inactive view: ".concat(String.valueOf(view)));
                        this.mInactiveInnerTextureViews.remove(view);
                        this.removeChildView((View)view);
                        return;
                    }
                    if (this.mCurrentInnerTextureView != view) {
                        LiteavLog.w(this.mTAG, "removeViewInternal: not current view: ".concat(String.valueOf(view)));
                        this.removeChildView((View)view);
                        return;
                    }
                    if (!this.mInactiveInnerTextureViews.isEmpty()) {
                        this.mCurrentInnerTextureView = this.mInactiveInnerTextureViews.remove(0);
                        LiteavLog.i(this.mTAG, "removeViewInternal: use inactive view: " + this.mCurrentInnerTextureView);
                        v0 = this;
                        v0.removeChildView((View)v0.mFreeInnerTextureView);
                        this.mFreeInnerTextureView = null;
                    } else {
                        this.mCurrentInnerTextureView = null;
                    }
                    if (!clearLastImage) break block7;
                    v1 = this;
                    v1.removeChildView((View)v1.mFreeInnerTextureView);
                    if (this.mCurrentInnerTextureView != null) break block8;
                    this.resetChildView((View)view);
                    ** GOTO lbl-1000
                }
                this.removeChildView((View)view);
                this.mFreeInnerTextureView = null;
                break block9;
            }
            if (this.mFreeInnerTextureView != null) {
                this.removeChildView((View)view);
            } else lbl-1000:
            // 2 sources

            {
                this.mFreeInnerTextureView = view;
            }
        }
        this.updateZOrders();
        LiteavLog.i(this.mTAG, "removeViewInternal: " + view + ", clearLastImage: " + clearLastImage + ", current: " + this.mCurrentInnerTextureView + ", free: " + this.mFreeInnerTextureView);
    }

    private void notifyFirstFrameRendered(TextureView view) {
        if (this.mCurrentInnerTextureView == view && this.mFreeInnerTextureView != null) {
            LiteavLog.i(this.mTAG, "notifyFirstFrameRendered: remove free view: " + this.mFreeInnerTextureView);
            TXCloudVideoView tXCloudVideoView = this;
            tXCloudVideoView.removeChildView((View)tXCloudVideoView.mFreeInnerTextureView);
            this.mFreeInnerTextureView = null;
        }
    }

    private void removeChildView(View child) {
        if (child == null) {
            return;
        }
        if (child.getParent() == this) {
            try {
                LiteavLog.i(this.mTAG, "removeChildView: ".concat(String.valueOf(child)));
                this.removeView(child);
                return;
            }
            catch (Exception exception) {
                LiteavLog.e(this.mTAG, "removeChildView error: ", exception);
                return;
            }
        }
        LiteavLog.w(this.mTAG, "removeChildView: has other parent:" + child.getParent());
    }

    private void resetChildView(View child) {
        if (child == null) {
            return;
        }
        if (child.getParent() != this) {
            LiteavLog.w(this.mTAG, "resetChildView: has other parent:" + child.getParent());
            return;
        }
        try {
            LiteavLog.i(this.mTAG, "resetChildView: ".concat(String.valueOf(child)));
            this.removeView(child);
            this.addView(child);
            return;
        }
        catch (Exception exception) {
            LiteavLog.e(this.mTAG, "resetChildView error: ", exception);
            return;
        }
    }

    private void updateZOrders() {
        if (this.mCurrentInnerTextureView != null && this.mCurrentInnerTextureView.getParent() == this) {
            this.mCurrentInnerTextureView.bringToFront();
        }
        if (this.mFreeInnerTextureView != null && this.mFreeInnerTextureView.getParent() == this) {
            this.mFreeInnerTextureView.bringToFront();
        }
        if (this.mUserTextureView != null && this.mUserTextureView.getParent() == this) {
            this.mUserTextureView.bringToFront();
        }
        if (this.mFocusIndicatorView != null && this.mFocusIndicatorView.getParent() == this) {
            this.mFocusIndicatorView.bringToFront();
        }
    }

    private void setTouchToFocusEnabled(boolean enabled) {
        this.mEnableTouchToFocus = enabled;
    }

    private void setZoomEnabled(boolean enabled) {
        LiteavLog.i(this.mTAG, "setZoomEnabled: ".concat(String.valueOf(enabled)));
        this.mEnableZoom = enabled;
    }

    public SurfaceView getSurfaceView() {
        if (this.mSurfaceView == null) {
            return null;
        }
        SurfaceView surfaceView = (SurfaceView)this.mSurfaceView.get();
        if (surfaceView == null) {
            LiteavLog.w(this.mTAG, "surfaceView is null.");
        }
        return surfaceView;
    }

    public Surface getSurface() {
        if (this.mSurface == null) {
            return null;
        }
        Surface surface = (Surface)this.mSurface.get();
        if (surface == null) {
            LiteavLog.w(this.mTAG, "surface is null.");
        }
        return surface;
    }

    public void setOpenGLContext(Object glContext) {
        this.mGLContext = glContext;
    }

    public Object getOpenGLContext() {
        return this.mGLContext;
    }

    public void onResume() {
    }

    public void onPause() {
    }

    public void onDestroy() {
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        LiteavLog.i(this.mTAG, "onAttachedToWindow");
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        LiteavLog.i(this.mTAG, "onDetachedFromWindow");
    }

    public void clearLastFrame(boolean clear) {
        if (clear) {
            this.setVisibility(8);
        }
    }

    public void setUserId(String userId) {
        this.mUserId = userId;
    }

    public String getUserId() {
        return this.mUserId;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (event.getPointerCount() == 1 && event.getAction() == 0) {
            if (this.mEnableTouchToFocus) {
                int n2 = this.getHeight();
                int n3 = this.getWidth();
                int n4 = (int)event.getY();
                int n5 = (int)event.getX();
                a a2 = this.mDelayedTapRunnable;
                this.mDelayedTapRunnable.a.x = n5;
                a2.a.y = n4;
                a2.b = n3;
                a2.c = n2;
                TXCloudVideoView tXCloudVideoView = this;
                tXCloudVideoView.removeCallbacks(tXCloudVideoView.mDelayedTapRunnable);
                TXCloudVideoView tXCloudVideoView2 = this;
                tXCloudVideoView2.postDelayed(tXCloudVideoView2.mDelayedTapRunnable, 100L);
            }
        } else if (event.getPointerCount() > 1 && event.getAction() == 2 && this.mEnableZoom) {
            TXCloudVideoView tXCloudVideoView = this;
            tXCloudVideoView.removeCallbacks(tXCloudVideoView.mDelayedTapRunnable);
            this.hideIndicatorView();
            if (this.mScaleGestureDetector == null) {
                this.mScaleGestureDetector = new ScaleGestureDetector(this.getContext(), (ScaleGestureDetector.OnScaleGestureListener)this);
            }
            this.mScaleGestureDetector.onTouchEvent(event);
        }
        if (this.mEnableZoom) {
            if (event.getAction() == 0) {
                this.performClick();
            }
            return true;
        }
        return super.onTouchEvent(event);
    }

    private void showFocusView(int x2, int y2, int width, int height) {
        TXCloudVideoView tXCloudVideoView = this;
        tXCloudVideoView.post(c.a(tXCloudVideoView, x2, y2, width, height));
    }

    private void showFocusViewInternal(int x2, int y2, int width, int height) {
        int n2;
        if (width != 0 && width != this.getWidth() || height != 0 && height != this.getHeight()) {
            LiteavLog.i(this.mTAG, "ignore show indicator view when view size changed");
            return;
        }
        LiteavLog.v(this.mTAG, "show indicator view at (%d,%d)", x2, y2);
        TXCloudVideoView tXCloudVideoView = this;
        tXCloudVideoView.removeCallbacks(tXCloudVideoView.mHideIndicatorViewRunnable);
        int n3 = n2 = (int)(70.0f * this.getResources().getDisplayMetrics().density + 0.5f);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(n3, n3);
        new FrameLayout.LayoutParams(n3, n3).leftMargin = h.a(x2 - n2 / 2, this.getWidth() - n2);
        layoutParams.topMargin = h.a(y2 - n2 / 2, this.getHeight() - n2);
        if (this.mFocusIndicatorView == null) {
            this.mFocusIndicatorView = new FocusIndicatorView(this.getContext());
            TXCloudVideoView tXCloudVideoView2 = this;
            tXCloudVideoView2.addView(tXCloudVideoView2.mFocusIndicatorView, (ViewGroup.LayoutParams)layoutParams);
        } else {
            TXCloudVideoView tXCloudVideoView3 = this;
            if (tXCloudVideoView3.indexOfChild(tXCloudVideoView3.mFocusIndicatorView) != this.getChildCount() - 1) {
                try {
                    TXCloudVideoView tXCloudVideoView4 = this;
                    tXCloudVideoView4.removeView(tXCloudVideoView4.mFocusIndicatorView);
                }
                catch (Exception exception) {
                    LiteavLog.e(this.mTAG, "removeView focus indicator view error: ", exception);
                }
                TXCloudVideoView tXCloudVideoView5 = this;
                tXCloudVideoView5.addView(tXCloudVideoView5.mFocusIndicatorView, (ViewGroup.LayoutParams)layoutParams);
            } else {
                this.mFocusIndicatorView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            }
        }
        this.mFocusIndicatorView.setVisibility(0);
        FocusIndicatorView focusIndicatorView = this.mFocusIndicatorView;
        focusIndicatorView.startAnimation((Animation)focusIndicatorView.a);
        TXCloudVideoView tXCloudVideoView6 = this;
        tXCloudVideoView6.postDelayed(tXCloudVideoView6.mHideIndicatorViewRunnable, TimeUnit.SECONDS.toMillis(1L));
    }

    private void hideIndicatorView() {
        if (this.mFocusIndicatorView != null) {
            this.mFocusIndicatorView.setVisibility(8);
        }
    }

    public boolean onScale(ScaleGestureDetector detector) {
        float f2;
        if (!this.mEnableZoom) {
            return false;
        }
        float f3 = detector.getScaleFactor() - this.mLastScaleFactor;
        this.mLastScaleFactor = detector.getScaleFactor();
        float f4 = this.mScaleFactor + f3;
        float f5 = f2 < 0.0f ? 0.0f : (this.mScaleFactor = f4 > 1.0f ? 1.0f : f4);
        if (this.mViewEventListener != null) {
            this.mViewEventListener.onZoom(this.mScaleFactor);
        }
        return false;
    }

    public boolean onScaleBegin(ScaleGestureDetector detector) {
        this.mLastScaleFactor = detector.getScaleFactor();
        return this.mEnableZoom;
    }

    public void onScaleEnd(ScaleGestureDetector detector) {
    }

    public void setLogMargin(float leftMarginInDp, float rightMarginInDp, float topMarginInDp, float bottomMarginInDp) {
    }

    public void setDashBoardMarginInPx(int left, int right, int top, int bottom) {
    }

    public void setDashBoardMarginInRatio(float leftRatio, float rightRatio, float topRatio, float bottomRatio) {
    }

    public void disableLog(boolean enable) {
    }

    public void showLog(boolean enable) {
        this.mEnableShowLog = enable;
        b b2 = this.mCallback == null ? null : (b)this.mCallback.get();
        if (b2 != null) {
            b2.onShowLog(enable);
        }
    }

    public void clearLog() {
    }

    private void setShowLogCallback(WeakReference<b> callback) {
        this.mCallback = callback;
    }

    private boolean isShowLogEnabled() {
        return this.mEnableShowLog;
    }

    private void setAndroidViewEventListener(AndroidViewEventListener listener) {
        this.mViewEventListener = listener;
    }

    protected void onSizeChanged(int w2, int h2, int oldw, int oldh) {
        if (this.mViewEventListener != null) {
            this.mViewEventListener.onSizeChanged(w2, h2, oldw, oldh);
        }
        super.onSizeChanged(w2, h2, oldw, oldh);
    }

    static /* synthetic */ void lambda$showFocusView$1(TXCloudVideoView this_, int x2, int y2, int width, int height) {
        this_.showFocusViewInternal(x2, y2, width, height);
    }

    static /* synthetic */ void lambda$setBackgroundColorForInternalView$0(TXCloudVideoView this_, int alpha, int red, int green, int blue) {
        this_.setBackgroundColor(Color.argb((int)alpha, (int)red, (int)green, (int)blue));
    }

    static /* synthetic */ void access$lambda$0(TXCloudVideoView tXCloudVideoView) {
        tXCloudVideoView.hideIndicatorView();
    }

    public static interface b {
        public void onShowLog(boolean var1);
    }

    final class a
    implements Runnable {
        final Point a = new Point();
        int b = 0;
        int c = 0;

        private a() {
        }

        @Override
        public final void run() {
            if (TXCloudVideoView.this.mViewEventListener != null) {
                TXCloudVideoView.this.mViewEventListener.onTap(this.a.x, this.a.y, this.b, this.c);
            }
        }

        /* synthetic */ a(byte by) {
            this();
        }
    }
}

