/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videobase.common;

import android.content.Context;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.view.Display;
import android.view.WindowManager;
import com.tencent.liteav.base.ContextUtils;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.system.LiteavSystemInfo;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.m;
import com.tencent.liteav.videobase.common.b;
import com.tencent.liteav.videobase.common.c;

@JNINamespace(value="liteav::video")
public class HDRCapability {
    private static final String TAG = "HDRCapability";
    private static Boolean sIsHDR10Supported = null;
    private static final m sSequenceTaskRunner = new m();

    public static synchronized boolean isHDRSupported(int hdrType) {
        if (LiteavSystemInfo.getSystemOSVersionInt() < 24) {
            return false;
        }
        if (hdrType != c.b.mValue) {
            return false;
        }
        if (sIsHDR10Supported != null) {
            return sIsHDR10Supported;
        }
        sSequenceTaskRunner.a(b.a());
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkIsHDR10Supported() {
        Class<HDRCapability> clazz = HDRCapability.class;
        synchronized (HDRCapability.class) {
            if (sIsHDR10Supported != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            try {
                boolean bl = HDRCapability.isDisplaySupportHDR10();
                boolean bl2 = HDRCapability.isDecoderSupportHDR10();
                Class<HDRCapability> clazz2 = HDRCapability.class;
                synchronized (HDRCapability.class) {
                    sIsHDR10Supported = bl && bl2;
                    LiteavLog.i(TAG, "the device supports hdr10 %b", sIsHDR10Supported);
                    // ** MonitorExit[var2_5] (shouldn't be in output)
                    return;
                }
            }
            catch (Throwable throwable) {
                LiteavLog.e(TAG, "check hdr capability error ", throwable);
                return;
            }
        }
    }

    private static boolean isDisplaySupportHDR10() {
        Context context = ContextUtils.getApplicationContext();
        if (context == null) {
            return false;
        }
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        if (windowManager == null) {
            return false;
        }
        Display.HdrCapabilities hdrCapabilities = windowManager.getDefaultDisplay().getHdrCapabilities();
        if (hdrCapabilities == null) {
            return false;
        }
        int[] nArray = hdrCapabilities.getSupportedHdrTypes();
        int n2 = nArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (nArray[i2] != 2) continue;
            return true;
        }
        return false;
    }

    private static boolean isDecoderSupportHDR10() {
        for (MediaCodecInfo mediaCodecInfo : new MediaCodecList(0).getCodecInfos()) {
            String[] stringArray = mediaCodecInfo.getSupportedTypes();
            int n2 = stringArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!stringArray[i2].contains("video/hevc") || !HDRCapability.hasHDR10ProfileLevel(mediaCodecInfo.getCapabilitiesForType((String)"video/hevc").profileLevels)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean hasHDR10ProfileLevel(MediaCodecInfo.CodecProfileLevel[] profileLevels) {
        MediaCodecInfo.CodecProfileLevel[] codecProfileLevelArray = profileLevels;
        int n2 = profileLevels.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (codecProfileLevelArray[i2].profile != 4096) continue;
            return true;
        }
        return false;
    }

    static /* synthetic */ void lambda$isHDRSupported$0() {
        HDRCapability.checkIsHDR10Supported();
    }
}

