/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.live;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.Surface;
import android.view.SurfaceView;
import android.view.TextureView;
import com.tencent.liteav.base.ContextUtils;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.l;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.liteav.videobase.videobase.DisplayTarget;
import com.tencent.live2.V2TXLiveDef;
import com.tencent.live2.V2TXLivePlayer;
import com.tencent.live2.V2TXLivePlayerObserver;
import com.tencent.live2.impl.V2TXLivePlayerImpl;
import com.tencent.live2.impl.a.a;
import com.tencent.rtmp.ui.TXCloudVideoView;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import javax.microedition.khronos.egl.EGLContext;
import org.json.JSONArray;
import org.json.JSONObject;

@JNINamespace(value="liteav")
public class V2TXLivePlayerJni
extends V2TXLivePlayer {
    private static final String TAG = "V2TXLivePlayerJni";
    protected long mNativeV2TXLivePlayerJni = 0L;
    private V2TXLivePlayerImpl mProxy;
    private V2TXLivePlayerObserver mObserver;
    private boolean mClearLastImage = true;

    public V2TXLivePlayerJni(Context context, V2TXLivePlayerImpl proxy) {
        this.mProxy = proxy;
        ContextUtils.initApplicationContext(context.getApplicationContext());
        ContextUtils.setDataDirectorySuffix("liteav");
        this.mNativeV2TXLivePlayerJni = V2TXLivePlayerJni.nativeCreate(new WeakReference<V2TXLivePlayerJni>(this));
    }

    protected void finalize() {
        V2TXLivePlayerJni.nativeDestroy(this.mNativeV2TXLivePlayerJni);
    }

    public static V2TXLiveDef.V2TXLivePlayerStatistics getJavaV2TXLivePlayerStatistics(int appCpu, int systemCpu, int rtt, int width, int height, int fps, int videoBitrate, int audioBitrate, int audioPacketLoss, int videoPacketLoss, int jitterBufferDelay, int audioTotalBlockTime, int audioBlockRate, int videoTotalBlockTime, int videoBlockRate, int netSpeed) {
        V2TXLiveDef.V2TXLivePlayerStatistics v2TXLivePlayerStatistics = new V2TXLiveDef.V2TXLivePlayerStatistics();
        new V2TXLiveDef.V2TXLivePlayerStatistics().appCpu = appCpu;
        v2TXLivePlayerStatistics.systemCpu = systemCpu;
        v2TXLivePlayerStatistics.rtt = rtt;
        v2TXLivePlayerStatistics.width = width;
        v2TXLivePlayerStatistics.height = height;
        v2TXLivePlayerStatistics.fps = fps;
        v2TXLivePlayerStatistics.videoBitrate = videoBitrate;
        v2TXLivePlayerStatistics.audioBitrate = audioBitrate;
        v2TXLivePlayerStatistics.audioPacketLoss = audioPacketLoss;
        v2TXLivePlayerStatistics.videoPacketLoss = videoPacketLoss;
        v2TXLivePlayerStatistics.jitterBufferDelay = jitterBufferDelay;
        v2TXLivePlayerStatistics.audioTotalBlockTime = audioTotalBlockTime;
        v2TXLivePlayerStatistics.audioBlockRate = audioBlockRate;
        v2TXLivePlayerStatistics.videoTotalBlockTime = videoTotalBlockTime;
        v2TXLivePlayerStatistics.videoBlockRate = videoBlockRate;
        v2TXLivePlayerStatistics.netSpeed = netSpeed;
        return v2TXLivePlayerStatistics;
    }

    private static ArrayList<V2TXLiveDef.V2TXLiveStreamInfo> getStreamListFormJsonString(String str) {
        ArrayList<V2TXLiveDef.V2TXLiveStreamInfo> arrayList = new ArrayList<V2TXLiveDef.V2TXLiveStreamInfo>();
        if (str == null || str.isEmpty()) {
            return arrayList;
        }
        try {
            JSONArray jSONArray = new JSONArray(str);
            for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                JSONObject jSONObject = jSONArray.getJSONObject(i2);
                arrayList.add(new V2TXLiveDef.V2TXLiveStreamInfo(jSONObject.getInt("width"), jSONObject.getInt("height"), jSONObject.getInt("bitrate"), (float)jSONObject.getDouble("framerate"), jSONObject.getString("url")));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    private static native long nativeCreate(WeakReference<V2TXLivePlayerJni> var0);

    private static native void nativeDestroy(long var0);

    private static native void nativeEnableExtensionCallback(long var0, boolean var2);

    private static native int nativeSetRenderView(long var0, DisplayTarget var2);

    private static native int nativeSetRenderRotation(long var0, int var2);

    private static native int nativeSetRenderFillMode(long var0, int var2);

    private static native int nativeSetRenderMirrorMode(long var0, boolean var2);

    private static native int nativeStartPlay(long var0, String var2);

    private static native int nativeStopPlay(long var0, boolean var2);

    private static native int nativeIsPlaying(long var0);

    private static native int nativePauseAudio(long var0);

    private static native int nativeResumeAudio(long var0);

    private static native int nativePauseVideo(long var0);

    private static native int nativeResumeVideo(long var0);

    private static native int nativeSetPlayoutVolume(long var0, int var2);

    private static native int nativeSetCacheParams(long var0, float var2, float var3);

    private static native int nativeSwitchStream(long var0, String var2);

    private static native String nativeGetStreamList(long var0);

    private static native int nativeEnableVolumeEvaluation(long var0, int var2);

    private static native int nativeSnapshot(long var0);

    private static native int nativeEnableCustomRendering(long var0, boolean var2, int var3, int var4);

    private static native int nativeEnableObserveAudioFrame(long var0, boolean var2);

    private static native int nativeEnableReceiveSeiMessage(long var0, boolean var2, int var3);

    private static native void nativeShowDebugView(long var0, boolean var2);

    private static native void nativeSetSharedEGLContext(long var0, Object var2);

    private static native int nativeSetProperty(long var0, String var2, Object var3);

    private static native int nativeStartRecord(long var0, String var2, int var3, int var4);

    private static native void nativeStopRecord(long var0);

    public static V2TXLivePlayerJni weakToStrongReference(WeakReference<V2TXLivePlayerJni> weakReference) {
        return (V2TXLivePlayerJni)weakReference.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enableExtensionCallback(boolean enable) {
        V2TXLivePlayerJni v2TXLivePlayerJni = this;
        synchronized (v2TXLivePlayerJni) {
            V2TXLivePlayerJni.nativeEnableExtensionCallback(this.mNativeV2TXLivePlayerJni, enable);
            return;
        }
    }

    @Override
    public void setObserver(V2TXLivePlayerObserver observer) {
        this.mObserver = observer;
        if (observer != null && observer instanceof a) {
            this.enableExtensionCallback(true);
        }
    }

    @Override
    public int setRenderView(TXCloudVideoView view) {
        return V2TXLivePlayerJni.nativeSetRenderView(this.mNativeV2TXLivePlayerJni, view != null ? new DisplayTarget(view) : null);
    }

    @Override
    public int setRenderView(TextureView view) {
        return V2TXLivePlayerJni.nativeSetRenderView(this.mNativeV2TXLivePlayerJni, view != null ? new DisplayTarget(view) : null);
    }

    @Override
    public int setRenderView(SurfaceView view) {
        return V2TXLivePlayerJni.nativeSetRenderView(this.mNativeV2TXLivePlayerJni, view != null ? new DisplayTarget(view) : null);
    }

    @Override
    public int setRenderRotation(V2TXLiveDef.V2TXLiveRotation liveRotation) {
        l l2;
        switch (liveRotation) {
            case V2TXLiveRotation90: {
                l2 = l.b;
                break;
            }
            case V2TXLiveRotation180: {
                l2 = l.c;
                break;
            }
            case V2TXLiveRotation270: {
                l2 = l.d;
                break;
            }
            default: {
                l2 = l.a;
            }
        }
        return V2TXLivePlayerJni.nativeSetRenderRotation(this.mNativeV2TXLivePlayerJni, l2.mValue);
    }

    @Override
    public int setRenderFillMode(V2TXLiveDef.V2TXLiveFillMode mode) {
        GLConstants.GLScaleType gLScaleType;
        switch (mode) {
            case V2TXLiveFillModeFill: {
                gLScaleType = GLConstants.GLScaleType.a;
                break;
            }
            case V2TXLiveFillModeScaleFill: {
                gLScaleType = GLConstants.GLScaleType.c;
                break;
            }
            default: {
                gLScaleType = GLConstants.GLScaleType.b;
            }
        }
        return V2TXLivePlayerJni.nativeSetRenderFillMode(this.mNativeV2TXLivePlayerJni, gLScaleType.mValue);
    }

    @Override
    public int setRenderMirrorMode(boolean enable) {
        return V2TXLivePlayerJni.nativeSetRenderMirrorMode(this.mNativeV2TXLivePlayerJni, enable);
    }

    @Override
    public int startLivePlay(String url) {
        return V2TXLivePlayerJni.nativeStartPlay(this.mNativeV2TXLivePlayerJni, url);
    }

    @Override
    public int stopPlay() {
        return V2TXLivePlayerJni.nativeStopPlay(this.mNativeV2TXLivePlayerJni, this.mClearLastImage);
    }

    @Override
    public int isPlaying() {
        return V2TXLivePlayerJni.nativeIsPlaying(this.mNativeV2TXLivePlayerJni);
    }

    @Override
    public int pauseAudio() {
        return V2TXLivePlayerJni.nativePauseAudio(this.mNativeV2TXLivePlayerJni);
    }

    @Override
    public int resumeAudio() {
        return V2TXLivePlayerJni.nativeResumeAudio(this.mNativeV2TXLivePlayerJni);
    }

    @Override
    public int pauseVideo() {
        return V2TXLivePlayerJni.nativePauseVideo(this.mNativeV2TXLivePlayerJni);
    }

    @Override
    public int resumeVideo() {
        return V2TXLivePlayerJni.nativeResumeVideo(this.mNativeV2TXLivePlayerJni);
    }

    @Override
    public int setPlayoutVolume(int volume) {
        return V2TXLivePlayerJni.nativeSetPlayoutVolume(this.mNativeV2TXLivePlayerJni, volume);
    }

    @Override
    public int setCacheParams(float min, float max) {
        if (min < 0.0f || max < 0.0f) {
            return -2;
        }
        return V2TXLivePlayerJni.nativeSetCacheParams(this.mNativeV2TXLivePlayerJni, min, max);
    }

    @Override
    public int switchStream(String newUrl) {
        if (TextUtils.isEmpty((CharSequence)newUrl)) {
            LiteavLog.e(TAG, "Invalid params.");
            return -2;
        }
        return V2TXLivePlayerJni.nativeSwitchStream(this.mNativeV2TXLivePlayerJni, newUrl);
    }

    @Override
    public ArrayList<V2TXLiveDef.V2TXLiveStreamInfo> getStreamList() {
        return V2TXLivePlayerJni.getStreamListFormJsonString(V2TXLivePlayerJni.nativeGetStreamList(this.mNativeV2TXLivePlayerJni));
    }

    @Override
    public int enableVolumeEvaluation(int intervalMs) {
        return V2TXLivePlayerJni.nativeEnableVolumeEvaluation(this.mNativeV2TXLivePlayerJni, intervalMs);
    }

    @Override
    public int snapshot() {
        return V2TXLivePlayerJni.nativeSnapshot(this.mNativeV2TXLivePlayerJni);
    }

    @Override
    public int enableObserveVideoFrame(boolean enable, V2TXLiveDef.V2TXLivePixelFormat format, V2TXLiveDef.V2TXLiveBufferType type) {
        GLConstants.a a2;
        GLConstants.PixelFormatType pixelFormatType;
        if (format == V2TXLiveDef.V2TXLivePixelFormat.V2TXLivePixelFormatI420 && type == V2TXLiveDef.V2TXLiveBufferType.V2TXLiveBufferTypeByteArray) {
            pixelFormatType = GLConstants.PixelFormatType.a;
            a2 = GLConstants.a.d;
        } else if (format == V2TXLiveDef.V2TXLivePixelFormat.V2TXLivePixelFormatTexture2D && type == V2TXLiveDef.V2TXLiveBufferType.V2TXLiveBufferTypeTexture) {
            pixelFormatType = GLConstants.PixelFormatType.f;
            a2 = GLConstants.a.b;
        } else if (format == V2TXLiveDef.V2TXLivePixelFormat.V2TXLivePixelFormatI420 && type == V2TXLiveDef.V2TXLiveBufferType.V2TXLiveBufferTypeByteBuffer) {
            pixelFormatType = GLConstants.PixelFormatType.a;
            a2 = GLConstants.a.a;
        } else {
            LiteavLog.e(TAG, "Enable custom render failed, invalid params. format:" + (Object)((Object)format) + " type:" + (Object)((Object)type));
            return -4;
        }
        return V2TXLivePlayerJni.nativeEnableCustomRendering(this.mNativeV2TXLivePlayerJni, enable, pixelFormatType.getValue(), a2.ordinal());
    }

    @Override
    public int enableObserveAudioFrame(boolean enable) {
        return V2TXLivePlayerJni.nativeEnableObserveAudioFrame(this.mNativeV2TXLivePlayerJni, enable);
    }

    @Override
    public int enableReceiveSeiMessage(boolean enable, int payloadType) {
        return V2TXLivePlayerJni.nativeEnableReceiveSeiMessage(this.mNativeV2TXLivePlayerJni, enable, payloadType);
    }

    @Override
    public void showDebugView(boolean isShow) {
        V2TXLivePlayerJni.nativeShowDebugView(this.mNativeV2TXLivePlayerJni, isShow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setProperty(String key, Object value) {
        V2TXLivePlayerJni v2TXLivePlayerJni = this;
        synchronized (v2TXLivePlayerJni) {
            String string = key;
            int n2 = -1;
            switch (string.hashCode()) {
                case 582452376: {
                    if (!string.equals("clearLastImage")) break;
                    n2 = 0;
                    break;
                }
                case 1120433643: {
                    if (!string.equals("setSurface")) break;
                    n2 = 1;
                    break;
                }
                case 480042124: {
                    if (!string.equals("setSurfaceSize")) break;
                    n2 = 2;
                    break;
                }
                case 1615550654: {
                    if (!string.equals("setOpenGLContext")) break;
                    n2 = 3;
                }
            }
            switch (n2) {
                case 0: {
                    if (!(value instanceof Boolean)) {
                        LiteavLog.e(TAG, "setProperty error, key:" + key + ", value:" + value);
                        return -2;
                    }
                    this.mClearLastImage = (Boolean)value;
                    break;
                }
                case 1: {
                    if (value == null) {
                        return V2TXLivePlayerJni.nativeSetRenderView(this.mNativeV2TXLivePlayerJni, null);
                    }
                    if (!(value instanceof Surface)) {
                        LiteavLog.e(TAG, "setProperty error, key:" + key + ", value:" + value);
                        return -2;
                    }
                    return V2TXLivePlayerJni.nativeSetRenderView(this.mNativeV2TXLivePlayerJni, new DisplayTarget((Surface)value));
                }
                case 2: {
                    LiteavLog.i(TAG, "set surface size is unnecessary");
                    break;
                }
                case 3: {
                    if (!(value instanceof EGLContext) && !(value instanceof android.opengl.EGLContext)) {
                        LiteavLog.e(TAG, "setProperty error, key:" + key + ", value:" + value);
                        return -2;
                    }
                    V2TXLivePlayerJni.nativeSetSharedEGLContext(this.mNativeV2TXLivePlayerJni, value);
                    break;
                }
                default: {
                    return V2TXLivePlayerJni.nativeSetProperty(this.mNativeV2TXLivePlayerJni, key, value);
                }
            }
        }
        return 0;
    }

    @Override
    public int startLocalRecording(V2TXLiveDef.V2TXLiveLocalRecordingParams params) {
        if (params == null || TextUtils.isEmpty((CharSequence)params.filePath)) {
            return -2;
        }
        return V2TXLivePlayerJni.nativeStartRecord(this.mNativeV2TXLivePlayerJni, params.filePath, params.recordMode.ordinal(), params.interval);
    }

    @Override
    public void stopLocalRecording() {
        V2TXLivePlayerJni.nativeStopRecord(this.mNativeV2TXLivePlayerJni);
    }

    public void onError(int code, String msg, Bundle extraInfo) {
        V2TXLivePlayerObserver v2TXLivePlayerObserver = this.mObserver;
        if (v2TXLivePlayerObserver != null) {
            v2TXLivePlayerObserver.onError(this.mProxy, code, msg, extraInfo);
        }
    }

    public void onWarning(int code, String msg, Bundle extraInfo) {
        V2TXLivePlayerObserver v2TXLivePlayerObserver = this.mObserver;
        if (v2TXLivePlayerObserver != null) {
            v2TXLivePlayerObserver.onWarning(this.mProxy, code, msg, extraInfo);
        }
    }

    public void onVideoResolutionChanged(int width, int height) {
        V2TXLivePlayerObserver v2TXLivePlayerObserver = this.mObserver;
        if (v2TXLivePlayerObserver != null) {
            v2TXLivePlayerObserver.onVideoResolutionChanged(this.mProxy, width, height);
        }
    }

    public void onConnected(Bundle bundle) {
        V2TXLivePlayerObserver v2TXLivePlayerObserver = this.mObserver;
        if (v2TXLivePlayerObserver != null) {
            v2TXLivePlayerObserver.onConnected(this.mProxy, bundle);
        }
    }

    public void onVideoPlaying(boolean firstPlay, Bundle extraInfo) {
        V2TXLivePlayerObserver v2TXLivePlayerObserver = this.mObserver;
        if (v2TXLivePlayerObserver != null) {
            v2TXLivePlayerObserver.onVideoPlaying(this.mProxy, firstPlay, extraInfo);
        }
    }

    public void onAudioPlaying(boolean firstPlay, Bundle extraInfo) {
        V2TXLivePlayerObserver v2TXLivePlayerObserver = this.mObserver;
        if (v2TXLivePlayerObserver != null) {
            v2TXLivePlayerObserver.onAudioPlaying(this.mProxy, firstPlay, extraInfo);
        }
    }

    public void onVideoLoading(Bundle extraInfo) {
        V2TXLivePlayerObserver v2TXLivePlayerObserver = this.mObserver;
        if (v2TXLivePlayerObserver != null) {
            v2TXLivePlayerObserver.onVideoLoading(this.mProxy, extraInfo);
        }
    }

    public void onAudioLoading(Bundle extraInfo) {
        V2TXLivePlayerObserver v2TXLivePlayerObserver = this.mObserver;
        if (v2TXLivePlayerObserver != null) {
            v2TXLivePlayerObserver.onAudioLoading(this.mProxy, extraInfo);
        }
    }

    public void onPlayoutVolumeUpdate(int volume) {
        V2TXLivePlayerObserver v2TXLivePlayerObserver = this.mObserver;
        if (v2TXLivePlayerObserver != null) {
            v2TXLivePlayerObserver.onPlayoutVolumeUpdate(this.mProxy, volume);
        }
    }

    public void onStatisticsUpdate(V2TXLiveDef.V2TXLivePlayerStatistics statistics) {
        V2TXLivePlayerObserver v2TXLivePlayerObserver = this.mObserver;
        if (v2TXLivePlayerObserver != null) {
            v2TXLivePlayerObserver.onStatisticsUpdate(this.mProxy, statistics);
        }
    }

    public void onSnapshotComplete(Bitmap image) {
        V2TXLivePlayerObserver v2TXLivePlayerObserver = this.mObserver;
        if (v2TXLivePlayerObserver != null) {
            v2TXLivePlayerObserver.onSnapshotComplete(this.mProxy, image);
        }
    }

    public void onRenderVideoFrame(int format, int bufferType, Object eglContext, int textureId, int width, int height, int rotation, long pts, byte[] data, ByteBuffer buffer) {
        V2TXLiveDef.V2TXLiveVideoFrame v2TXLiveVideoFrame = new V2TXLiveDef.V2TXLiveVideoFrame();
        GLConstants.PixelFormatType pixelFormatType = GLConstants.PixelFormatType.a(format);
        switch (pixelFormatType) {
            case a: {
                v2TXLiveVideoFrame.pixelFormat = V2TXLiveDef.V2TXLivePixelFormat.V2TXLivePixelFormatI420;
                break;
            }
            case f: {
                v2TXLiveVideoFrame.pixelFormat = V2TXLiveDef.V2TXLivePixelFormat.V2TXLivePixelFormatTexture2D;
                break;
            }
            default: {
                LiteavLog.e(TAG, "Invalid pixelFormat. pixelFormat:" + (Object)((Object)pixelFormatType) + ".");
            }
        }
        GLConstants.a a2 = GLConstants.a.a(bufferType);
        switch (a2) {
            case a: {
                v2TXLiveVideoFrame.bufferType = V2TXLiveDef.V2TXLiveBufferType.V2TXLiveBufferTypeByteBuffer;
                break;
            }
            case d: {
                v2TXLiveVideoFrame.bufferType = V2TXLiveDef.V2TXLiveBufferType.V2TXLiveBufferTypeByteArray;
                break;
            }
            case b: {
                v2TXLiveVideoFrame.bufferType = V2TXLiveDef.V2TXLiveBufferType.V2TXLiveBufferTypeTexture;
                break;
            }
            default: {
                LiteavLog.e(TAG, "Invalid bufferType. bufferType:" + (Object)((Object)a2) + ".");
            }
        }
        V2TXLiveDef.V2TXLiveTexture v2TXLiveTexture = new V2TXLiveDef.V2TXLiveTexture();
        new V2TXLiveDef.V2TXLiveTexture().textureId = textureId;
        if (eglContext instanceof EGLContext) {
            v2TXLiveTexture.eglContext10 = (EGLContext)eglContext;
        } else if (Build.VERSION.SDK_INT >= 17 && eglContext instanceof android.opengl.EGLContext) {
            v2TXLiveTexture.eglContext14 = (android.opengl.EGLContext)eglContext;
        }
        v2TXLiveVideoFrame.texture = v2TXLiveTexture;
        v2TXLiveVideoFrame.data = data;
        v2TXLiveVideoFrame.buffer = buffer;
        v2TXLiveVideoFrame.width = width;
        v2TXLiveVideoFrame.height = height;
        l l2 = l.a(rotation);
        switch (l2) {
            case a: {
                v2TXLiveVideoFrame.rotation = 0;
                break;
            }
            case b: {
                v2TXLiveVideoFrame.rotation = 90;
                break;
            }
            case c: {
                v2TXLiveVideoFrame.rotation = 180;
                break;
            }
            case d: {
                v2TXLiveVideoFrame.rotation = 270;
                break;
            }
            default: {
                v2TXLiveVideoFrame.rotation = 0;
            }
        }
        V2TXLivePlayerObserver v2TXLivePlayerObserver = this.mObserver;
        if (v2TXLivePlayerObserver != null) {
            v2TXLivePlayerObserver.onRenderVideoFrame(this.mProxy, v2TXLiveVideoFrame);
        }
    }

    public void onPlayoutAudioFrame(byte[] data, long timestamp, int sampleRate, int channels) {
        V2TXLiveDef.V2TXLiveAudioFrame v2TXLiveAudioFrame = new V2TXLiveDef.V2TXLiveAudioFrame();
        new V2TXLiveDef.V2TXLiveAudioFrame().data = data;
        v2TXLiveAudioFrame.timestamp = timestamp;
        v2TXLiveAudioFrame.sampleRate = sampleRate;
        v2TXLiveAudioFrame.channel = channels;
        V2TXLivePlayerObserver v2TXLivePlayerObserver = this.mObserver;
        if (v2TXLivePlayerObserver != null) {
            v2TXLivePlayerObserver.onPlayoutAudioFrame(this.mProxy, v2TXLiveAudioFrame);
        }
    }

    public void onReceiveSeiMessage(int payloadType, byte[] data) {
        V2TXLivePlayerObserver v2TXLivePlayerObserver = this.mObserver;
        if (v2TXLivePlayerObserver != null) {
            v2TXLivePlayerObserver.onReceiveSeiMessage(this.mProxy, payloadType, data);
        }
    }

    public void onStreamSwitched(int code, String url) {
        V2TXLivePlayerObserver v2TXLivePlayerObserver = this.mObserver;
        if (v2TXLivePlayerObserver != null) {
            v2TXLivePlayerObserver.onStreamSwitched(this.mProxy, url, code);
        }
    }

    public void onRecordBegin(int code, String storagePath) {
        V2TXLivePlayerObserver v2TXLivePlayerObserver = this.mObserver;
        if (v2TXLivePlayerObserver != null) {
            v2TXLivePlayerObserver.onLocalRecordBegin(this.mProxy, code, storagePath);
        }
    }

    public void onRecordProgress(long durationMs, String storagePath) {
        V2TXLivePlayerObserver v2TXLivePlayerObserver = this.mObserver;
        if (v2TXLivePlayerObserver != null) {
            v2TXLivePlayerObserver.onLocalRecording(this.mProxy, durationMs, storagePath);
        }
    }

    public void onRecordComplete(int code, String storagePath) {
        V2TXLivePlayerObserver v2TXLivePlayerObserver = this.mObserver;
        if (v2TXLivePlayerObserver != null) {
            v2TXLivePlayerObserver.onLocalRecordComplete(this.mProxy, code, storagePath);
        }
    }

    public void onPlayEvent(int code, Bundle params) {
    }

    public void onPlayNetStatus(Bundle params) {
    }

    public void onNetworkQuality(int quality) {
    }
}

