/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.audio2.route;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.hardware.usb.UsbDevice;
import com.tencent.liteav.audio2.route.AudioDeviceProperty;
import com.tencent.liteav.base.Log;
import com.tencent.liteav.base.system.LiteavSystemInfo;

public final class a
extends BroadcastReceiver {
    private final a b;
    final Context a;

    public a(Context context, a a2) {
        this.a = context;
        this.b = a2;
    }

    public final void onReceive(Context context, Intent intent) {
        if (intent == null || context == null) {
            Log.e("AudioEventBroadcastReceiver", "Receive intent or context is null", new Object[0]);
            return;
        }
        String string = intent.getAction();
        if (string == null) {
            return;
        }
        String string2 = string;
        int n2 = -1;
        switch (string2.hashCode()) {
            case -1676458352: {
                if (!string2.equals("android.intent.action.HEADSET_PLUG")) break;
                n2 = 0;
                break;
            }
            case -1530327060: {
                if (!string2.equals("android.bluetooth.adapter.action.STATE_CHANGED")) break;
                n2 = 1;
                break;
            }
            case 545516589: {
                if (!string2.equals("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED")) break;
                n2 = 2;
                break;
            }
            case -1435586571: {
                if (!string2.equals("android.bluetooth.headset.profile.action.AUDIO_STATE_CHANGED")) break;
                n2 = 3;
                break;
            }
            case -2114103349: {
                if (!string2.equals("android.hardware.usb.action.USB_DEVICE_ATTACHED")) break;
                n2 = 4;
                break;
            }
            case -1608292967: {
                if (!string2.equals("android.hardware.usb.action.USB_DEVICE_DETACHED")) break;
                n2 = 5;
                break;
            }
            case -1940635523: {
                if (!string2.equals("android.media.VOLUME_CHANGED_ACTION")) break;
                n2 = 6;
            }
        }
        switch (n2) {
            case 0: {
                Intent intent2 = intent;
                a a2 = this;
                int n3 = com.tencent.liteav.audio2.route.a.a(intent2, "state", -1);
                Log.i("AudioEventBroadcastReceiver", "Receive ACTION_HEADSET_PLUG, EXTRA_STATE:".concat(String.valueOf(n3)), new Object[0]);
                if (n3 == -1) {
                    Log.e("AudioEventBroadcastReceiver", "Unknown headset state, ignore...", new Object[0]);
                    return;
                }
                a2.b.onWiredHeadsetConnectionChanged(n3 != 0);
                return;
            }
            case 1: {
                Intent intent3 = intent;
                a a3 = this;
                int n4 = com.tencent.liteav.audio2.route.a.a(intent3, "android.bluetooth.adapter.extra.STATE", 0);
                int n5 = com.tencent.liteav.audio2.route.a.a(intent3, "android.bluetooth.adapter.extra.PREVIOUS_STATE", 0);
                Log.i("AudioEventBroadcastReceiver", "Receive ACTION_STATE_CHANGED, EXTRA_STATE:" + com.tencent.liteav.audio2.route.a.a(n4) + " EXTRA_PREVIOUS_STATE: " + com.tencent.liteav.audio2.route.a.a(n5), new Object[0]);
                if (n4 == 10) {
                    a3.b.onBluetoothConnectionChanged(false);
                }
                return;
            }
            case 2: {
                String string3;
                Intent intent4 = intent;
                a a4 = this;
                int n6 = com.tencent.liteav.audio2.route.a.a(intent4, "android.bluetooth.profile.extra.STATE", -1);
                Object[] objectArray = new Object[1];
                switch (n6) {
                    case 0: {
                        string3 = "STATE_DISCONNECTED";
                        break;
                    }
                    case 1: {
                        string3 = "STATE_CONNECTING";
                        break;
                    }
                    case 2: {
                        string3 = "STATE_CONNECTED";
                        break;
                    }
                    case 3: {
                        string3 = "STATE_DISCONNECTING";
                        break;
                    }
                    default: {
                        string3 = "unknown";
                    }
                }
                objectArray[0] = string3;
                Log.i("AudioEventBroadcastReceiver", "Receive bluetooth headset connection state changed: %s", objectArray);
                switch (n6) {
                    case 0: {
                        a4.b.onBluetoothConnectionChanged(false);
                        return;
                    }
                    case 2: {
                        a4.b.onBluetoothConnectionChanged(true);
                    }
                }
                return;
            }
            case 3: {
                Intent intent5 = intent;
                a a5 = this;
                int n7 = com.tencent.liteav.audio2.route.a.a(intent5, "android.bluetooth.profile.extra.STATE", 10);
                if (n7 == 12) {
                    Log.i("AudioEventBroadcastReceiver", "Receive bluetooth audio state changed to STATE_AUDIO_CONNECTED", new Object[0]);
                    a5.b.onBluetoothScoConnected(true);
                    return;
                }
                if (n7 == 10) {
                    Log.i("AudioEventBroadcastReceiver", "Receive bluetooth audio state changed to STATE_AUDIO_DISCONNECTED", new Object[0]);
                    a5.b.onBluetoothScoConnected(false);
                }
                return;
            }
            case 4: 
            case 5: {
                Intent intent6 = intent;
                a a6 = this;
                UsbDevice usbDevice = (UsbDevice)intent6.getParcelableExtra("device");
                if (usbDevice != null) {
                    String string4 = "";
                    if (LiteavSystemInfo.getSystemOSVersionInt() >= 21) {
                        string4 = usbDevice.getProductName();
                        Log.i("AudioEventBroadcastReceiver", "Usb device attached " + string4 + " manufacture " + usbDevice.getManufacturerName(), new Object[0]);
                    }
                    if (!AudioDeviceProperty.isUsbHeadsetDevice(usbDevice)) {
                        Log.i("AudioEventBroadcastReceiver", "The attached usb device doesn't seem to support audio, ignore it", new Object[0]);
                        return;
                    }
                    if ("android.hardware.usb.action.USB_DEVICE_ATTACHED".equals(intent6.getAction())) {
                        a6.b.onUsbConnectionChanged(string4, true);
                        return;
                    }
                    if ("android.hardware.usb.action.USB_DEVICE_DETACHED".equals(intent6.getAction())) {
                        a6.b.onUsbConnectionChanged(string4, false);
                        return;
                    }
                    Log.i("AudioEventBroadcastReceiver", "Unknown action, ignore it " + intent6.getAction(), new Object[0]);
                }
                return;
            }
            case 6: {
                a a7 = this;
                if (a7.b != null) {
                    a7.b.onSystemVolumeChanged();
                }
                return;
            }
        }
        Log.w("AudioEventBroadcastReceiver", "Ignore unknown Action:".concat(String.valueOf(string)), new Object[0]);
    }

    private static String a(int n2) {
        switch (n2) {
            case 10: {
                return "STATE_OFF";
            }
            case 11: {
                return "STATE_TURNING_ON";
            }
            case 12: {
                return "STATE_ON";
            }
            case 13: {
                return "STATE_TURNING_OFF";
            }
        }
        return "unknown";
    }

    private static int a(Intent intent, String string, int n2) {
        int n3 = n2;
        try {
            n3 = intent.getIntExtra(string, n2);
        }
        catch (Exception exception) {
            Log.e("AudioEventBroadcastReceiver", "getIntentIntExtra ".concat(String.valueOf(exception)), new Object[0]);
        }
        return n3;
    }

    public static interface a {
        public void onWiredHeadsetConnectionChanged(boolean var1);

        public void onBluetoothConnectionChanged(boolean var1);

        public void onBluetoothScoConnected(boolean var1);

        public void onSystemVolumeChanged();

        public void onUsbConnectionChanged(String var1, boolean var2);
    }
}

