/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.imsdk.v2;

import com.tencent.imsdk.common.IMCallback;
import com.tencent.imsdk.message.DownloadParam;
import com.tencent.imsdk.message.DownloadProgressInfo;
import com.tencent.imsdk.message.MessageBaseElement;
import com.tencent.imsdk.message.MessageCenter;
import com.tencent.imsdk.message.SoundElement;
import com.tencent.imsdk.v2.V2TIMCallback;
import com.tencent.imsdk.v2.V2TIMDownloadCallback;
import com.tencent.imsdk.v2.V2TIMElem;
import com.tencent.imsdk.v2.V2TIMValueCallback;

public class V2TIMSoundElem
extends V2TIMElem {
    public String getPath() {
        if (this.getElement() == null) {
            return null;
        }
        SoundElement timSoundElem = (SoundElement)this.getElement();
        return timSoundElem.getSoundFilePath();
    }

    public String getUUID() {
        if (this.getElement() == null) {
            return null;
        }
        SoundElement timSoundElem = (SoundElement)this.getElement();
        return timSoundElem.getSoundUUID();
    }

    public int getDataSize() {
        if (this.getElement() == null) {
            return 0;
        }
        SoundElement timSoundElem = (SoundElement)this.getElement();
        return timSoundElem.getSoundFileSize();
    }

    public int getDuration() {
        if (this.getElement() == null) {
            return 0;
        }
        SoundElement timSoundElem = (SoundElement)this.getElement();
        return timSoundElem.getSoundDuration();
    }

    public void downloadSound(String path, final V2TIMDownloadCallback v2TIMDownloadCallback) {
        if (this.getElement() == null) {
            return;
        }
        SoundElement timSoundElem = (SoundElement)this.getElement();
        DownloadParam downloadParam = new DownloadParam();
        downloadParam.setDownloadUrl(timSoundElem.getSoundDownloadUrl());
        downloadParam.setUuid(this.getUUID());
        downloadParam.setUuidType(MessageBaseElement.UUID_TYPE_AUDIO);
        downloadParam.setBusinessID(timSoundElem.getSoundBusinessID());
        downloadParam.setFileSavePath(path);
        V2TIMValueCallback<DownloadProgressInfo> v2TIMValueProgressCallback = new V2TIMValueCallback<DownloadProgressInfo>(){

            @Override
            public void onSuccess(DownloadProgressInfo downloadProgressInfo) {
                V2TIMElem.V2ProgressInfo v2ProgressInfo = new V2TIMElem.V2ProgressInfo(downloadProgressInfo.getCurrentSize(), downloadProgressInfo.getTotalSize());
                if (v2TIMDownloadCallback != null) {
                    v2TIMDownloadCallback.onProgress(v2ProgressInfo);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (v2TIMDownloadCallback != null) {
                    v2TIMDownloadCallback.onError(code, desc);
                }
            }
        };
        V2TIMCallback v2TIMCallback = new V2TIMCallback(){

            @Override
            public void onSuccess() {
                if (v2TIMDownloadCallback != null) {
                    v2TIMDownloadCallback.onSuccess();
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (v2TIMDownloadCallback != null) {
                    v2TIMDownloadCallback.onError(code, desc);
                }
            }
        };
        MessageCenter.getInstance().downloadMessageElement(downloadParam, new IMCallback<DownloadProgressInfo>((V2TIMValueCallback)v2TIMValueProgressCallback){

            @Override
            public void success(DownloadProgressInfo data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        }, new IMCallback(v2TIMCallback){

            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    public void getUrl(V2TIMValueCallback<String> callback) {
        if (callback == null) {
            return;
        }
        if (this.getElement() == null) {
            callback.onError(6017, "elem is null");
            return;
        }
        SoundElement soundElement = (SoundElement)this.getElement();
        callback.onSuccess(soundElement.getSoundDownloadUrl());
    }

    public void convertVoiceToText(String language, V2TIMValueCallback<String> callback) {
        if (callback == null) {
            return;
        }
        if (this.getElement() == null) {
            return;
        }
        SoundElement timSoundElem = (SoundElement)this.getElement();
        String url = timSoundElem.getSoundDownloadUrl();
        MessageCenter.getInstance().convertVoiceToText(url, language, new IMCallback<String>(callback){

            @Override
            public void success(String data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("V2TIMSoundElem--->").append("uuid:").append(this.getUUID()).append(", sender local path:").append(this.getPath()).append(", duration:").append(this.getDuration()).append(", dataSize:").append(this.getDataSize());
        return stringBuilder.toString();
    }
}

