/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.imsdk.v2;

import android.text.TextUtils;
import com.tencent.imsdk.common.IMCallback;
import com.tencent.imsdk.common.IMLog;
import com.tencent.imsdk.manager.BaseManager;
import com.tencent.imsdk.message.MessageOfflinePushInfo;
import com.tencent.imsdk.signaling.SignalingInfo;
import com.tencent.imsdk.signaling.SignalingListener;
import com.tencent.imsdk.signaling.SignalingManager;
import com.tencent.imsdk.v2.V2TIMCallback;
import com.tencent.imsdk.v2.V2TIMMessage;
import com.tencent.imsdk.v2.V2TIMOfflinePushInfo;
import com.tencent.imsdk.v2.V2TIMSignalingInfo;
import com.tencent.imsdk.v2.V2TIMSignalingListener;
import com.tencent.imsdk.v2.V2TIMSignalingManager;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class V2TIMSignalingManagerImpl
extends V2TIMSignalingManager {
    private static final String TAG = "V2TIMSigMgrImpl";
    private SignalingListener mInternalSignalingListener;
    private CopyOnWriteArrayList<V2TIMSignalingListener> mSignalingListenerList = new CopyOnWriteArrayList();
    private boolean mHasValidSignalingListener = false;

    static V2TIMSignalingManagerImpl getInstance() {
        return V2TIMSignalingManagerImplHolder.v2TIMSignalingManagerImpl;
    }

    private V2TIMSignalingManagerImpl() {
        this.initSignalingListener();
    }

    private void initSignalingListener() {
        if (this.mInternalSignalingListener == null) {
            this.mInternalSignalingListener = new SignalingListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onReceiveNewInvitation(String inviteID, String inviter, String groupID, List<String> inviteeList, String data) {
                    V2TIMSignalingManagerImpl v2TIMSignalingManagerImpl = V2TIMSignalingManagerImpl.this;
                    synchronized (v2TIMSignalingManagerImpl) {
                        for (V2TIMSignalingListener listener : V2TIMSignalingManagerImpl.this.mSignalingListenerList) {
                            if (listener == null) continue;
                            listener.onReceiveNewInvitation(inviteID, inviter, groupID, inviteeList, data);
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onInviteeAccepted(String inviteID, String invitee, String data) {
                    V2TIMSignalingManagerImpl v2TIMSignalingManagerImpl = V2TIMSignalingManagerImpl.this;
                    synchronized (v2TIMSignalingManagerImpl) {
                        for (V2TIMSignalingListener listener : V2TIMSignalingManagerImpl.this.mSignalingListenerList) {
                            if (listener == null) continue;
                            listener.onInviteeAccepted(inviteID, invitee, data);
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onInviteeRejected(String inviteID, String invitee, String data) {
                    V2TIMSignalingManagerImpl v2TIMSignalingManagerImpl = V2TIMSignalingManagerImpl.this;
                    synchronized (v2TIMSignalingManagerImpl) {
                        for (V2TIMSignalingListener listener : V2TIMSignalingManagerImpl.this.mSignalingListenerList) {
                            if (listener == null) continue;
                            listener.onInviteeRejected(inviteID, invitee, data);
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onInvitationCancelled(String inviteID, String inviter, String data) {
                    V2TIMSignalingManagerImpl v2TIMSignalingManagerImpl = V2TIMSignalingManagerImpl.this;
                    synchronized (v2TIMSignalingManagerImpl) {
                        for (V2TIMSignalingListener listener : V2TIMSignalingManagerImpl.this.mSignalingListenerList) {
                            if (listener == null) continue;
                            listener.onInvitationCancelled(inviteID, inviter, data);
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onInvitationTimeout(String inviteID, List<String> inviteeList) {
                    V2TIMSignalingManagerImpl v2TIMSignalingManagerImpl = V2TIMSignalingManagerImpl.this;
                    synchronized (v2TIMSignalingManagerImpl) {
                        for (V2TIMSignalingListener listener : V2TIMSignalingManagerImpl.this.mSignalingListenerList) {
                            if (listener == null) continue;
                            listener.onInvitationTimeout(inviteID, inviteeList);
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onInvitationModified(String inviteID, String data) {
                    V2TIMSignalingManagerImpl v2TIMSignalingManagerImpl = V2TIMSignalingManagerImpl.this;
                    synchronized (v2TIMSignalingManagerImpl) {
                        for (V2TIMSignalingListener listener : V2TIMSignalingManagerImpl.this.mSignalingListenerList) {
                            if (listener == null) continue;
                            listener.onInvitationModified(inviteID, data);
                        }
                    }
                }
            };
        }
        SignalingManager.getInstance().setSignalingListener(this.mInternalSignalingListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unInit() {
        V2TIMSignalingManagerImpl v2TIMSignalingManagerImpl = this;
        synchronized (v2TIMSignalingManagerImpl) {
            this.mSignalingListenerList.clear();
            this.mHasValidSignalingListener = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSignalingListener(V2TIMSignalingListener listener) {
        V2TIMSignalingManagerImpl v2TIMSignalingManagerImpl = this;
        synchronized (v2TIMSignalingManagerImpl) {
            if (this.mSignalingListenerList.contains(listener)) {
                return;
            }
            this.mSignalingListenerList.add(listener);
            this.mHasValidSignalingListener = true;
            this.checkSignalingListener();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSignalingListener(V2TIMSignalingListener listener) {
        V2TIMSignalingManagerImpl v2TIMSignalingManagerImpl = this;
        synchronized (v2TIMSignalingManagerImpl) {
            this.mSignalingListenerList.remove(listener);
            if (0 == this.mSignalingListenerList.size()) {
                this.mHasValidSignalingListener = false;
            }
            this.checkSignalingListener();
        }
    }

    private void checkSignalingListener() {
        BaseManager.getInstance().enableSignaling(this.mHasValidSignalingListener);
    }

    @Override
    public String invite(String invitee, String data, boolean onlineUserOnly, V2TIMOfflinePushInfo offlinePushInfo, int timeout, V2TIMCallback callback) {
        if (TextUtils.isEmpty((CharSequence)invitee)) {
            if (callback != null) {
                callback.onError(6017, "invitee is empty");
            }
            IMLog.e(TAG, "signaling invite error, invitee is empty");
            return null;
        }
        if (timeout < 0) {
            if (callback != null) {
                IMLog.e(TAG, "signaling invite error, timeout invalid");
                callback.onError(6017, "timeout invalid");
            }
            return null;
        }
        MessageOfflinePushInfo messageOfflinePushInfo = null;
        if (offlinePushInfo != null) {
            messageOfflinePushInfo = offlinePushInfo.getMessageOfflinePushInfo();
        } else {
            messageOfflinePushInfo = new MessageOfflinePushInfo();
            messageOfflinePushInfo.setPushFlag(1);
        }
        String inviteID = SignalingManager.getInstance().invite(invitee, data, onlineUserOnly, messageOfflinePushInfo, timeout, new IMCallback(callback){

            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
        return inviteID;
    }

    @Override
    public String inviteInGroup(String groupID, List<String> inviteeList, String data, boolean onlineUserOnly, int timeout, V2TIMCallback callback) {
        if (TextUtils.isEmpty((CharSequence)groupID)) {
            if (callback != null) {
                callback.onError(6017, "groupID is empty");
            }
            IMLog.e(TAG, "signaling invite error, groupID is empty");
            return null;
        }
        if (inviteeList == null || inviteeList.size() == 0) {
            if (callback != null) {
                IMLog.e(TAG, "signaling invite error, inviteeList is empty");
                callback.onError(6017, "inviteeList is empty");
            }
            return null;
        }
        if (timeout < 0) {
            if (callback != null) {
                IMLog.e(TAG, "signaling invite error, timeout invalid");
                callback.onError(6017, "timeout invalid");
            }
            return null;
        }
        String inviteID = SignalingManager.getInstance().inviteInGroup(groupID, inviteeList, data, onlineUserOnly, timeout, new IMCallback(callback){

            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
        return inviteID;
    }

    @Override
    public void cancel(String inviteID, String data, V2TIMCallback callback) {
        if (TextUtils.isEmpty((CharSequence)inviteID)) {
            if (callback != null) {
                IMLog.e(TAG, "signaling cancel error, inviteID is empty");
                callback.onError(6017, "inviteID is empty");
            }
            return;
        }
        SignalingManager.getInstance().cancel(inviteID, data, new IMCallback(callback){

            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void accept(String inviteID, String data, V2TIMCallback callback) {
        if (TextUtils.isEmpty((CharSequence)inviteID)) {
            IMLog.e(TAG, "signaling accept failed, inviteID is empty");
            if (callback != null) {
                callback.onError(6017, "inviteID is null");
            }
            return;
        }
        SignalingManager.getInstance().accept(inviteID, data, new IMCallback(callback){

            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void reject(String inviteID, String data, V2TIMCallback callback) {
        if (TextUtils.isEmpty((CharSequence)inviteID)) {
            IMLog.e(TAG, "signaling reject invite, inviteID is empty");
            if (callback != null) {
                callback.onError(6017, "inviteID is null");
            }
            return;
        }
        SignalingManager.getInstance().reject(inviteID, data, new IMCallback(callback){

            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public V2TIMSignalingInfo getSignalingInfo(V2TIMMessage msg) {
        if (msg == null || msg.getElemType() != 2) {
            return null;
        }
        SignalingInfo signalingInfo = SignalingManager.getInstance().getSignalingInfo(msg.getMessage());
        if (signalingInfo == null || TextUtils.isEmpty((CharSequence)signalingInfo.getInviteID()) || TextUtils.isEmpty((CharSequence)signalingInfo.getInviter()) || signalingInfo.getInviteeList() == null || signalingInfo.getInviteeList().size() == 0 || signalingInfo.getActionType() == 0) {
            return null;
        }
        V2TIMSignalingInfo v2TIMSignalingInfo = new V2TIMSignalingInfo();
        v2TIMSignalingInfo.setSignalingInfo(signalingInfo);
        return v2TIMSignalingInfo;
    }

    @Override
    public void addInvitedSignaling(V2TIMSignalingInfo info, V2TIMCallback callback) {
        if (info == null || TextUtils.isEmpty((CharSequence)info.getInviteID()) || TextUtils.isEmpty((CharSequence)info.getInviter()) || info.getInviteeList() == null || info.getInviteeList().isEmpty()) {
            IMLog.e(TAG, "addInvitedSignaling, info is invalid");
            if (callback != null) {
                callback.onError(6017, "V2TIMSignalingInfo is invalid");
            }
            return;
        }
        SignalingManager.getInstance().addInvitedSignaling(info.getSignalingInfo(), new IMCallback(callback){

            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void modifyInvitation(String inviteID, String data, V2TIMCallback callback) {
        if (TextUtils.isEmpty((CharSequence)inviteID)) {
            if (callback != null) {
                IMLog.e(TAG, "modifyInvitation error, inviteID is empty");
                callback.onError(6017, "inviteID is empty");
            }
            return;
        }
        SignalingManager.getInstance().modifyInvitation(inviteID, data, new IMCallback(callback){

            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    private static class V2TIMSignalingManagerImplHolder {
        private static final V2TIMSignalingManagerImpl v2TIMSignalingManagerImpl = new V2TIMSignalingManagerImpl();

        private V2TIMSignalingManagerImplHolder() {
        }
    }
}

