/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.imsdk.message;

import com.tencent.imsdk.group.GroupMemberInfo;
import com.tencent.imsdk.message.MessageAtInfo;
import com.tencent.imsdk.message.MessageBaseElement;
import com.tencent.imsdk.message.MessageCenter;
import com.tencent.imsdk.message.MessageKey;
import com.tencent.imsdk.message.MessageOfflinePushInfo;
import com.tencent.imsdk.relationship.UserInfo;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class Message
implements Serializable {
    public static int MESSAGE_TYPE_UNKNOWN = 0;
    public static int MESSAGE_TYPE_C2C = 1;
    public static int MESSAGE_TYPE_GROUP = 2;
    public static int MESSAGE_TYPE_MULTI_SYNC = 3;
    public static int PLATFORM_OTHER = 0;
    public static int PLATFORM_WINDOWS = 1;
    public static int PLATFORM_ANDROID = 2;
    public static int PLATFORM_IOS = 3;
    public static int PLATFORM_MAC = 4;
    public static int PLATFORM_SIMULATOR = 5;
    public static final int V2TIM_MSG_STATUS_SENDING = 1;
    public static final int V2TIM_MSG_STATUS_SUCCESS = 2;
    public static final int V2TIM_MSG_STATUS_SEND_FAILED = 3;
    public static final int V2TIM_MSG_STATUS_DELETED = 4;
    public static final int V2TIM_MSG_STATUS_LOCAL_IMPORTED = 5;
    public static final int V2TIM_MSG_STATUS_REVOKED = 6;
    private String msgID = "";
    private int messageType;
    private int messageSource = 0;
    private long clientTime;
    private long serverTime;
    private String senderUserID;
    private long senderTinyID;
    private String receiverUserID;
    private long receiverTinyID;
    private String nickName;
    private String friendRemark;
    private String faceUrl;
    private String nameCard;
    private String groupID;
    private boolean isForward;
    private boolean isMessageSender = true;
    private boolean isSelfRead;
    private boolean isPeerRead;
    private boolean receiptPeerRead;
    private long receiptTime;
    private long random;
    private long seq;
    private int lifeTime = -1;
    private int messageStatus;
    private int priority;
    private MessageOfflinePushInfo offlinePushInfo;
    private int localCustomNumber;
    private String localCustomString;
    private byte[] cloudCustomBytes;
    private List<MessageBaseElement> messageBaseElements = new ArrayList<MessageBaseElement>();
    private int platform;
    private List<MessageAtInfo> messageGroupAtInfoList = new ArrayList<MessageAtInfo>();
    private boolean excludedFromUnreadCount = false;
    private boolean excludedFromLastMessage = false;
    private boolean excludedFromContentModeration = false;
    private String customModerationConfigurationID;
    private boolean disableCloudMessagePreHook = false;
    private boolean disableCloudMessagePostHook = false;
    private List<String> targetGroupMemberList = new ArrayList<String>();
    private UserInfo revokerInfo;
    private String revokeReason;
    private GroupMemberInfo pinnerInfo;
    private boolean needReadReceipt = false;
    private boolean hasSentReceipt = false;
    private int receiptReadCount = 0;
    private int receiptUnreadCount = -1;
    private boolean supportMessageExtension = false;
    private long messageVersion;
    private boolean isBroadcastMessage = false;
    private boolean hasRiskContent = false;
    private int riskTypeIdentified = 0;
    private boolean isPushMessage = false;

    public String getMsgID() {
        return this.msgID;
    }

    public int getMessageType() {
        return this.messageType;
    }

    public void setMessageType(int messageType) {
        this.messageType = messageType;
    }

    public int getMessageSource() {
        return this.messageSource;
    }

    public void setMessageSource(int messageSource) {
    }

    public long getTimestamp() {
        if (this.serverTime > 0L) {
            return this.serverTime;
        }
        return this.clientTime;
    }

    public long getClientTime() {
        return this.clientTime;
    }

    public void setClientTime(long clientTime) {
        this.clientTime = clientTime;
    }

    public String getSenderUserID() {
        return this.senderUserID;
    }

    public void setSenderUserID(String senderUserID) {
        this.senderUserID = senderUserID;
    }

    public String getReceiverUserID() {
        return this.receiverUserID;
    }

    public void setReceiverUserID(String receiverUserID) {
        this.receiverUserID = receiverUserID;
    }

    public String getNickName() {
        return this.nickName;
    }

    public String getFriendRemark() {
        return this.friendRemark;
    }

    public String getFaceUrl() {
        return this.faceUrl;
    }

    public String getNameCard() {
        return this.nameCard;
    }

    public String getGroupID() {
        return this.groupID;
    }

    public void setGroupID(String groupID) {
        this.groupID = groupID;
    }

    public boolean isForward() {
        return this.isForward;
    }

    public void setForward(boolean forward) {
        this.isForward = forward;
    }

    public boolean isMessageSender() {
        return this.isMessageSender;
    }

    public void setIsMessageSender(boolean isMessageSender) {
        this.isMessageSender = isMessageSender;
    }

    public boolean isSelfRead() {
        if (this.isSelfRead) {
            return true;
        }
        this.isSelfRead = MessageCenter.getInstance().isMessageSelfRead(this.getMessageKey());
        return this.isSelfRead;
    }

    public boolean isPeerRead() {
        if (this.isPeerRead) {
            return true;
        }
        this.isPeerRead = MessageCenter.getInstance().isMessagePeerRead(this.getMessageKey());
        return this.isPeerRead;
    }

    public boolean isReceiptPeerRead() {
        return this.receiptPeerRead;
    }

    public long getReceiptTime() {
        return this.receiptTime;
    }

    public long getRandom() {
        return this.random;
    }

    public long getSeq() {
        return this.seq;
    }

    public void setSeq(long seq) {
        this.seq = seq;
    }

    public int getLifeTime() {
        return this.lifeTime;
    }

    public void setLifeTime(int lifeTime) {
        this.lifeTime = lifeTime;
    }

    public int getMessageStatus() {
        return this.messageStatus;
    }

    public void setMessageStatus(int status) {
        this.messageStatus = status;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public MessageOfflinePushInfo getOfflinePushInfo() {
        return this.offlinePushInfo;
    }

    public void setOfflinePushInfo(MessageOfflinePushInfo offlinePushInfo) {
        this.offlinePushInfo = offlinePushInfo;
    }

    public int getLocalCustomNumber() {
        return this.localCustomNumber;
    }

    public void setLocalCustomNumber(int customNumberInfo) {
        this.localCustomNumber = customNumberInfo;
        MessageCenter.getInstance().setLocalCustomNumber(this, customNumberInfo);
    }

    public String getLocalCustomString() {
        return this.localCustomString;
    }

    public void setLocalCustomString(String customStringInfo) {
        this.localCustomString = customStringInfo;
        MessageCenter.getInstance().setLocalCustomString(this, customStringInfo);
    }

    public String getCloudCustomString() {
        String cloudCustomString = "";
        if (this.cloudCustomBytes != null && this.cloudCustomBytes.length > 0) {
            try {
                cloudCustomString = new String(this.cloudCustomBytes, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return cloudCustomString;
    }

    public void setCloudCustomString(String cloudCustomData) {
        if (cloudCustomData == null) {
            cloudCustomData = "";
        }
        try {
            this.cloudCustomBytes = cloudCustomData.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public void addElement(MessageBaseElement messageBaseElement) {
        if (messageBaseElement == null) {
            return;
        }
        this.messageBaseElements.add(messageBaseElement);
    }

    public List<MessageBaseElement> getMessageBaseElements() {
        return this.messageBaseElements;
    }

    public int getPlatform() {
        return this.platform;
    }

    public void setPlatform(int platform) {
        this.platform = platform;
    }

    public void setMessageBaseElements(List<MessageBaseElement> messageBaseElements) {
        this.messageBaseElements = messageBaseElements;
    }

    protected void addMessageGroupAtInfo(MessageAtInfo messageAtInfo) {
        this.messageGroupAtInfoList.add(messageAtInfo);
    }

    public void setMessageGroupAtInfoList(List<MessageAtInfo> messageGroupAtInfoList) {
        this.messageGroupAtInfoList = messageGroupAtInfoList;
    }

    public List<MessageAtInfo> getMessageGroupAtInfoList() {
        return this.messageGroupAtInfoList;
    }

    public boolean isExcludedFromUnreadCount() {
        return this.excludedFromUnreadCount;
    }

    public void setExcludedFromUnreadCount(boolean excludedFromUnreadCount) {
        this.excludedFromUnreadCount = excludedFromUnreadCount;
    }

    public boolean isExcludedFromLastMessage() {
        return this.excludedFromLastMessage;
    }

    public void setExcludedFromLastMessage(boolean excludedFromLastMessage) {
        this.excludedFromLastMessage = excludedFromLastMessage;
    }

    public boolean isExcludedFromContentModeration() {
        return this.excludedFromContentModeration;
    }

    public void setExcludedFromContentModeration(boolean excludedFromContentModeration) {
        this.excludedFromContentModeration = excludedFromContentModeration;
    }

    public String getCustomModerationConfigurationID() {
        return this.customModerationConfigurationID;
    }

    public void setCustomModerationConfigurationID(String customModerationConfigurationID) {
        this.customModerationConfigurationID = customModerationConfigurationID;
    }

    public void setTargetGroupMemberList(List<String> targetGroupMemberList) {
        this.targetGroupMemberList = targetGroupMemberList;
    }

    public List<String> getTargetGroupMemberList() {
        return this.targetGroupMemberList;
    }

    public boolean isNeedReadReceipt() {
        return this.needReadReceipt;
    }

    public void setNeedReadReceipt(boolean needReadReceipt) {
        this.needReadReceipt = needReadReceipt;
    }

    public boolean isHasSentReceipt() {
        return this.hasSentReceipt;
    }

    public void setHasSentReceipt(boolean hasSentReceipt) {
        this.hasSentReceipt = hasSentReceipt;
    }

    public int getReceiptReadCount() {
        return this.receiptReadCount;
    }

    public void setReceiptReadCount(int receiptReadCount) {
        this.receiptReadCount = receiptReadCount;
    }

    public int getReceiptUnreadCount() {
        return this.receiptUnreadCount;
    }

    public void setReceiptUnreadCount(int receiptUnreadCount) {
        this.receiptUnreadCount = receiptUnreadCount;
    }

    public boolean isBroadcastMessage() {
        return this.isBroadcastMessage;
    }

    public boolean isSupportMessageExtension() {
        return this.supportMessageExtension;
    }

    public void setSupportMessageExtension(boolean supportMessageExtension) {
        this.supportMessageExtension = supportMessageExtension;
    }

    public void setHasRiskContent(boolean hasRiskContent) {
        this.hasRiskContent = hasRiskContent;
    }

    public boolean isHasRiskContent() {
        return this.hasRiskContent;
    }

    public boolean isDisableCloudMessagePreHook() {
        return this.disableCloudMessagePreHook;
    }

    public void setDisableCloudMessagePreHook(boolean disableCloudMessagePreHook) {
        this.disableCloudMessagePreHook = disableCloudMessagePreHook;
    }

    public boolean isDisableCloudMessagePostHook() {
        return this.disableCloudMessagePostHook;
    }

    public void setDisableCloudMessagePostHook(boolean disableCloudMessagePostHook) {
        this.disableCloudMessagePostHook = disableCloudMessagePostHook;
    }

    public boolean isPushMessage() {
        return this.isPushMessage;
    }

    public void setPushMessage(boolean pushMessage) {
        this.isPushMessage = pushMessage;
    }

    public UserInfo getRevokerInfo() {
        return this.revokerInfo;
    }

    public String getRevokeReason() {
        return this.revokeReason;
    }

    public GroupMemberInfo getPinnerInfo() {
        return this.pinnerInfo;
    }

    public MessageKey getMessageKey() {
        MessageKey messageKey = new MessageKey();
        messageKey.setMessageID(this.msgID);
        messageKey.setMessageType(this.messageType);
        messageKey.setIsMessageSender(this.isMessageSender);
        messageKey.setSenderUserID(this.senderUserID);
        messageKey.setSenderTinyID(this.senderTinyID);
        messageKey.setReceiverUserID(this.receiverUserID);
        messageKey.setReceiverTinyID(this.receiverTinyID);
        messageKey.setGroupID(this.groupID);
        messageKey.setClientTime(this.clientTime);
        messageKey.setServerTime(this.serverTime);
        messageKey.setSeq(this.seq);
        messageKey.setRandom(this.random);
        return messageKey;
    }

    public void update(Message message) {
        this.msgID = message.msgID;
        this.messageType = message.messageType;
        this.messageSource = message.messageSource;
        this.isMessageSender = message.isMessageSender;
        this.senderUserID = message.senderUserID;
        this.senderTinyID = message.senderTinyID;
        this.receiverUserID = message.receiverUserID;
        this.receiverTinyID = message.receiverTinyID;
        this.groupID = message.groupID;
        this.clientTime = message.clientTime;
        this.serverTime = message.serverTime;
        this.seq = message.seq;
        this.random = message.random;
        this.messageStatus = message.messageStatus;
        this.riskTypeIdentified = message.riskTypeIdentified;
        this.isPushMessage = message.isPushMessage;
        for (MessageBaseElement element : this.messageBaseElements) {
            for (MessageBaseElement newElem : message.messageBaseElements) {
                if (element.update(newElem)) break;
            }
        }
    }
}

