/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.imsdk.v2;

import com.tencent.imsdk.common.IMCallback;
import com.tencent.imsdk.message.DownloadParam;
import com.tencent.imsdk.message.DownloadProgressInfo;
import com.tencent.imsdk.message.FileElement;
import com.tencent.imsdk.message.MessageBaseElement;
import com.tencent.imsdk.message.MessageCenter;
import com.tencent.imsdk.v2.V2TIMCallback;
import com.tencent.imsdk.v2.V2TIMDownloadCallback;
import com.tencent.imsdk.v2.V2TIMElem;
import com.tencent.imsdk.v2.V2TIMValueCallback;

public class V2TIMFileElem
extends V2TIMElem {
    public String getPath() {
        if (this.getElement() == null) {
            return null;
        }
        FileElement timFileElem = (FileElement)this.getElement();
        return timFileElem.getFilePath();
    }

    public String getFileName() {
        if (this.getElement() == null) {
            return null;
        }
        FileElement timFileElem = (FileElement)this.getElement();
        return timFileElem.getFileName();
    }

    public String getUUID() {
        if (this.getElement() == null) {
            return null;
        }
        FileElement timFileElem = (FileElement)this.getElement();
        return timFileElem.getFileUUID();
    }

    public int getFileSize() {
        if (this.getElement() == null) {
            return 0;
        }
        FileElement timFileElem = (FileElement)this.getElement();
        return timFileElem.getFileSize();
    }

    public void downloadFile(String path, final V2TIMDownloadCallback v2TIMDownloadCallback) {
        if (this.getElement() == null) {
            return;
        }
        FileElement fileElement = (FileElement)this.getElement();
        DownloadParam downloadParam = new DownloadParam();
        downloadParam.setDownloadUrl(fileElement.getFileDownloadUrl());
        downloadParam.setUuid(this.getUUID());
        downloadParam.setUuidType(MessageBaseElement.UUID_TYPE_FILE);
        downloadParam.setBusinessID(fileElement.getFileBusinessID());
        downloadParam.setFileSavePath(path);
        V2TIMValueCallback<DownloadProgressInfo> v2TIMValueProgressCallback = new V2TIMValueCallback<DownloadProgressInfo>(){

            @Override
            public void onSuccess(DownloadProgressInfo downloadProgressInfo) {
                V2TIMElem.V2ProgressInfo v2ProgressInfo = new V2TIMElem.V2ProgressInfo(downloadProgressInfo.getCurrentSize(), downloadProgressInfo.getTotalSize());
                if (v2TIMDownloadCallback != null) {
                    v2TIMDownloadCallback.onProgress(v2ProgressInfo);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (v2TIMDownloadCallback != null) {
                    v2TIMDownloadCallback.onError(code, desc);
                }
            }
        };
        V2TIMCallback v2TIMCallback = new V2TIMCallback(){

            @Override
            public void onSuccess() {
                if (v2TIMDownloadCallback != null) {
                    v2TIMDownloadCallback.onSuccess();
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (v2TIMDownloadCallback != null) {
                    v2TIMDownloadCallback.onError(code, desc);
                }
            }
        };
        MessageCenter.getInstance().downloadMessageElement(downloadParam, new IMCallback<DownloadProgressInfo>((V2TIMValueCallback)v2TIMValueProgressCallback){

            @Override
            public void success(DownloadProgressInfo data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        }, new IMCallback(v2TIMCallback){

            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    public void getUrl(V2TIMValueCallback<String> callback) {
        if (callback == null) {
            return;
        }
        if (this.getElement() == null) {
            callback.onError(6017, "elem is null");
            return;
        }
        FileElement fileElement = (FileElement)this.getElement();
        callback.onSuccess(fileElement.getFileDownloadUrl());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("V2TIMFileElem--->").append("uuid:").append(this.getUUID()).append(", sender local path:").append(this.getPath()).append(", file name:").append(this.getFileName()).append(", file size:").append(this.getFileSize());
        return stringBuilder.toString();
    }
}

