/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.imsdk.v2;

import com.tencent.imsdk.conversation.Conversation;
import com.tencent.imsdk.conversation.ConversationAtInfo;
import com.tencent.imsdk.group.GroupInfo;
import com.tencent.imsdk.group.GroupMemberInfo;
import com.tencent.imsdk.group.TopicInfo;
import com.tencent.imsdk.message.Message;
import com.tencent.imsdk.v2.V2TIMGroupAtInfo;
import com.tencent.imsdk.v2.V2TIMMessage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class V2TIMTopicInfo
implements Serializable {
    private TopicInfo topicInfo = new TopicInfo();
    private int modifyFlag = 0;
    private boolean needModifyDraft = false;

    protected void setTopicInfo(TopicInfo topicInfo) {
        if (topicInfo == null) {
            return;
        }
        this.topicInfo = topicInfo;
    }

    TopicInfo getTopicInfo() {
        return this.topicInfo;
    }

    int getModifyFlag() {
        return this.modifyFlag;
    }

    boolean isNeedModifyDraft() {
        return this.needModifyDraft;
    }

    GroupInfo getGroupInfo() {
        return this.topicInfo.getGroupInfo();
    }

    public String getTopicID() {
        return this.topicInfo.getGroupInfo().getGroupID();
    }

    public void setTopicID(String topicID) {
        this.topicInfo.getGroupInfo().setGroupID(topicID);
    }

    public String getTopicName() {
        return this.topicInfo.getGroupInfo().getGroupName();
    }

    public void setTopicName(String topicName) {
        this.topicInfo.getGroupInfo().setGroupName(topicName);
        this.modifyFlag = (int)((long)this.modifyFlag | GroupInfo.GROUP_INFO_MODIFY_FLAG_NAME);
    }

    public String getTopicFaceUrl() {
        return this.topicInfo.getGroupInfo().getFaceUrl();
    }

    public void setTopicFaceUrl(String faceUrl) {
        this.topicInfo.getGroupInfo().setFaceUrl(faceUrl);
        this.modifyFlag = (int)((long)this.modifyFlag | GroupInfo.GROUP_INFO_MODIFY_FLAG_FACE_URL);
    }

    public String getIntroduction() {
        return this.topicInfo.getGroupInfo().getIntroduction();
    }

    public void setIntroduction(String introduction) {
        this.topicInfo.getGroupInfo().setIntroduction(introduction);
        this.modifyFlag = (int)((long)this.modifyFlag | GroupInfo.GROUP_INFO_MODIFY_FLAG_INTRODUCTION);
    }

    public String getNotification() {
        return this.topicInfo.getGroupInfo().getNotification();
    }

    public void setNotification(String notification) {
        this.topicInfo.getGroupInfo().setNotification(notification);
        this.modifyFlag = (int)((long)this.modifyFlag | GroupInfo.GROUP_INFO_MODIFY_FLAG_NOTIFICATION);
    }

    public boolean isAllMute() {
        return this.topicInfo.getGroupInfo().isAllShutUp();
    }

    public void setAllMute(boolean allMute) {
        this.topicInfo.getGroupInfo().setAllShutUp(allMute);
        this.modifyFlag = (int)((long)this.modifyFlag | GroupInfo.GROUP_INFO_MODIFY_FLAG_SHUTUP_ALL);
    }

    public long getSelfMuteTime() {
        return this.topicInfo.getGroupInfo().getGroupSelfInfo().getShutUpTime();
    }

    public String getCustomString() {
        return this.topicInfo.getGroupInfo().getCustomString();
    }

    public void setCustomString(String customString) {
        this.topicInfo.getGroupInfo().setCustomString(customString);
        this.modifyFlag = (int)((long)this.modifyFlag | GroupInfo.TOPIC_INFO_MODIFY_FLAG_CUSTOM_STRING);
    }

    public int getRecvOpt() {
        int recvOpt = this.topicInfo.getGroupInfo().getGroupSelfInfo().getMessageReceiveOption();
        if (recvOpt == GroupMemberInfo.MESSAGE_RECEIVE_OPTION_AUTO_RECEIVE) {
            return 0;
        }
        if (recvOpt == GroupMemberInfo.MESSAGE_RECEIVE_OPTION_NOT_RECEIVE) {
            return 1;
        }
        if (recvOpt == GroupMemberInfo.MESSAGE_RECEIVE_OPTION_RECEIVE_WITH_NO_OFFLINE_PUSH) {
            return 2;
        }
        return 0;
    }

    public String getDraftText() {
        return this.topicInfo.getDraftText();
    }

    public void setDraft(String draftText) {
        this.needModifyDraft = true;
        this.topicInfo.setTempDraft(draftText);
    }

    public long getUnreadCount() {
        Conversation conversation = this.topicInfo.getConversation();
        if (conversation == null) {
            return 0L;
        }
        return conversation.getUnreadMessageCount();
    }

    public V2TIMMessage getLastMessage() {
        Conversation conversation = this.topicInfo.getConversation();
        if (conversation == null) {
            return null;
        }
        Message message = conversation.getLastMessage();
        if (message == null) {
            return null;
        }
        V2TIMMessage v2TIMMessage = new V2TIMMessage();
        v2TIMMessage.setMessage(message);
        return v2TIMMessage;
    }

    public List<V2TIMGroupAtInfo> getGroupAtInfoList() {
        if (this.topicInfo.getConversation() == null) {
            return new ArrayList<V2TIMGroupAtInfo>();
        }
        ArrayList<V2TIMGroupAtInfo> v2TIMGroupAtInfoList = new ArrayList<V2TIMGroupAtInfo>();
        List<ConversationAtInfo> conversationAtInfoList = this.topicInfo.getConversation().getConversationAtInfoList();
        for (ConversationAtInfo conversationAtInfo : conversationAtInfoList) {
            V2TIMGroupAtInfo v2TIMGroupAtInfo = new V2TIMGroupAtInfo();
            v2TIMGroupAtInfo.setConversationGroupAtInfo(conversationAtInfo);
            v2TIMGroupAtInfoList.add(v2TIMGroupAtInfo);
        }
        return v2TIMGroupAtInfoList;
    }
}

