/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.imsdk.v2;

import android.text.TextUtils;
import com.tencent.imsdk.manager.BaseManager;
import com.tencent.imsdk.message.CustomElement;
import com.tencent.imsdk.message.FaceElement;
import com.tencent.imsdk.message.FileElement;
import com.tencent.imsdk.message.GroupTipsElement;
import com.tencent.imsdk.message.ImageElement;
import com.tencent.imsdk.message.LocationElement;
import com.tencent.imsdk.message.MergerElement;
import com.tencent.imsdk.message.Message;
import com.tencent.imsdk.message.MessageAtInfo;
import com.tencent.imsdk.message.MessageBaseElement;
import com.tencent.imsdk.message.MessageOfflinePushInfo;
import com.tencent.imsdk.message.SoundElement;
import com.tencent.imsdk.message.TextElement;
import com.tencent.imsdk.message.VideoElement;
import com.tencent.imsdk.relationship.UserInfo;
import com.tencent.imsdk.v2.V2TIMCustomElem;
import com.tencent.imsdk.v2.V2TIMElem;
import com.tencent.imsdk.v2.V2TIMFaceElem;
import com.tencent.imsdk.v2.V2TIMFileElem;
import com.tencent.imsdk.v2.V2TIMGroupTipsElem;
import com.tencent.imsdk.v2.V2TIMImageElem;
import com.tencent.imsdk.v2.V2TIMLocationElem;
import com.tencent.imsdk.v2.V2TIMMergerElem;
import com.tencent.imsdk.v2.V2TIMOfflinePushInfo;
import com.tencent.imsdk.v2.V2TIMSoundElem;
import com.tencent.imsdk.v2.V2TIMTextElem;
import com.tencent.imsdk.v2.V2TIMUserFullInfo;
import com.tencent.imsdk.v2.V2TIMVideoElem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class V2TIMMessage
implements Serializable {
    public static final int V2TIM_MSG_STATUS_SENDING = 1;
    public static final int V2TIM_MSG_STATUS_SEND_SUCC = 2;
    public static final int V2TIM_MSG_STATUS_SEND_FAIL = 3;
    public static final int V2TIM_MSG_STATUS_HAS_DELETED = 4;
    public static final int V2TIM_MSG_STATUS_LOCAL_IMPORTED = 5;
    public static final int V2TIM_MSG_STATUS_LOCAL_REVOKED = 6;
    public static final int V2TIM_PRIORITY_DEFAULT = 0;
    public static final int V2TIM_PRIORITY_HIGH = 1;
    public static final int V2TIM_PRIORITY_NORMAL = 2;
    public static final int V2TIM_PRIORITY_LOW = 3;
    public static final int V2TIM_ELEM_TYPE_NONE = 0;
    public static final int V2TIM_ELEM_TYPE_TEXT = 1;
    public static final int V2TIM_ELEM_TYPE_CUSTOM = 2;
    public static final int V2TIM_ELEM_TYPE_IMAGE = 3;
    public static final int V2TIM_ELEM_TYPE_SOUND = 4;
    public static final int V2TIM_ELEM_TYPE_VIDEO = 5;
    public static final int V2TIM_ELEM_TYPE_FILE = 6;
    public static final int V2TIM_ELEM_TYPE_LOCATION = 7;
    public static final int V2TIM_ELEM_TYPE_FACE = 8;
    public static final int V2TIM_ELEM_TYPE_GROUP_TIPS = 9;
    public static final int V2TIM_ELEM_TYPE_MERGER = 10;
    public static final int V2TIM_RECEIVE_MESSAGE = 0;
    public static final int V2TIM_NOT_RECEIVE_MESSAGE = 1;
    public static final int V2TIM_RECEIVE_NOT_NOTIFY_MESSAGE = 2;
    public static final int V2TIM_GROUP_MESSAGE_READ_MEMBERS_FILTER_READ = 0;
    public static final int V2TIM_GROUP_MESSAGE_READ_MEMBERS_FILTER_UNREAD = 1;
    private Message message = new Message();

    public V2TIMMessage() {
        this.message.setClientTime(BaseManager.getInstance().getServerTime());
    }

    void setMessage(Message message) {
        if (message == null) {
            return;
        }
        this.message = message;
    }

    Message getMessage() {
        return this.message;
    }

    public String getMsgID() {
        if (this.message != null) {
            return this.message.getMsgID();
        }
        return "";
    }

    public long getTimestamp() {
        if (this.message != null) {
            return this.message.getTimestamp();
        }
        return 0L;
    }

    public String getSender() {
        if (this.message != null) {
            return this.message.getSenderUserID();
        }
        return null;
    }

    public String getNickName() {
        if (this.message != null) {
            return this.message.getNickName();
        }
        return null;
    }

    public String getFriendRemark() {
        if (this.message != null) {
            return this.message.getFriendRemark();
        }
        return null;
    }

    public String getFaceUrl() {
        if (this.message != null) {
            return this.message.getFaceUrl();
        }
        return null;
    }

    public String getNameCard() {
        if (this.message != null) {
            return this.message.getNameCard();
        }
        return null;
    }

    public String getGroupID() {
        if (this.message != null && this.message.getMessageType() == Message.MESSAGE_TYPE_GROUP) {
            return this.message.getGroupID();
        }
        return null;
    }

    public String getUserID() {
        if (this.message == null || this.message.getMessageType() != Message.MESSAGE_TYPE_C2C) {
            return null;
        }
        if (this.message.isMessageSender()) {
            return this.message.getReceiverUserID();
        }
        return this.message.getSenderUserID();
    }

    public int getStatus() {
        int status = 1;
        if (this.message == null) {
            return status;
        }
        return this.message.getMessageStatus();
    }

    public int getElemType() {
        int elemType = 0;
        if (this.message == null) {
            return elemType;
        }
        if (this.message.getMessageBaseElements().size() <= 0) {
            return elemType;
        }
        List<MessageBaseElement> messageBaseElementList = this.message.getMessageBaseElements();
        MessageBaseElement messageBaseElement = messageBaseElementList.get(0);
        if (messageBaseElement instanceof TextElement) {
            elemType = 1;
        } else if (messageBaseElement instanceof ImageElement) {
            elemType = 3;
        } else if (messageBaseElement instanceof VideoElement) {
            elemType = 5;
        } else if (messageBaseElement instanceof SoundElement) {
            elemType = 4;
        } else if (messageBaseElement instanceof FaceElement) {
            elemType = 8;
        } else if (messageBaseElement instanceof FileElement) {
            elemType = 6;
        } else if (messageBaseElement instanceof CustomElement) {
            elemType = 2;
        } else if (messageBaseElement instanceof LocationElement) {
            elemType = 7;
        } else if (messageBaseElement instanceof GroupTipsElement) {
            elemType = 9;
        } else if (messageBaseElement instanceof MergerElement) {
            elemType = 10;
        }
        return elemType;
    }

    public V2TIMTextElem getTextElem() {
        if (this.getElemType() == 0) {
            return null;
        }
        if (this.getElemType() == 1) {
            V2TIMTextElem v2TIMTextElem = new V2TIMTextElem();
            v2TIMTextElem.setMessage(this.message);
            v2TIMTextElem.setElemIndex(0);
            return v2TIMTextElem;
        }
        return null;
    }

    public V2TIMCustomElem getCustomElem() {
        if (this.getElemType() == 0) {
            return null;
        }
        if (this.getElemType() == 2) {
            V2TIMCustomElem v2TIMElem = new V2TIMCustomElem();
            v2TIMElem.setMessage(this.message);
            v2TIMElem.setElemIndex(0);
            return v2TIMElem;
        }
        return null;
    }

    public V2TIMImageElem getImageElem() {
        if (this.getElemType() == 0) {
            return null;
        }
        if (this.getElemType() == 3) {
            V2TIMImageElem v2TIMElem = new V2TIMImageElem();
            v2TIMElem.setMessage(this.message);
            v2TIMElem.setElemIndex(0);
            return v2TIMElem;
        }
        return null;
    }

    public V2TIMSoundElem getSoundElem() {
        if (this.getElemType() == 0) {
            return null;
        }
        if (this.getElemType() == 4) {
            V2TIMSoundElem v2TIMElem = new V2TIMSoundElem();
            v2TIMElem.setMessage(this.message);
            v2TIMElem.setElemIndex(0);
            return v2TIMElem;
        }
        return null;
    }

    public V2TIMVideoElem getVideoElem() {
        if (this.getElemType() == 0) {
            return null;
        }
        if (this.getElemType() == 5) {
            V2TIMVideoElem v2TIMElem = new V2TIMVideoElem();
            v2TIMElem.setMessage(this.message);
            v2TIMElem.setElemIndex(0);
            return v2TIMElem;
        }
        return null;
    }

    public V2TIMFileElem getFileElem() {
        if (this.getElemType() == 0) {
            return null;
        }
        if (this.getElemType() == 6) {
            V2TIMFileElem v2TIMElem = new V2TIMFileElem();
            v2TIMElem.setMessage(this.message);
            v2TIMElem.setElemIndex(0);
            return v2TIMElem;
        }
        return null;
    }

    public V2TIMLocationElem getLocationElem() {
        if (this.getElemType() == 0) {
            return null;
        }
        if (this.getElemType() == 7) {
            V2TIMLocationElem v2TIMElem = new V2TIMLocationElem();
            v2TIMElem.setMessage(this.message);
            v2TIMElem.setElemIndex(0);
            return v2TIMElem;
        }
        return null;
    }

    public V2TIMFaceElem getFaceElem() {
        if (this.getElemType() == 0) {
            return null;
        }
        if (this.getElemType() == 8) {
            V2TIMFaceElem v2TIMElem = new V2TIMFaceElem();
            v2TIMElem.setMessage(this.message);
            v2TIMElem.setElemIndex(0);
            return v2TIMElem;
        }
        return null;
    }

    public V2TIMMergerElem getMergerElem() {
        if (this.getElemType() == 0) {
            return null;
        }
        if (this.getElemType() == 10) {
            V2TIMMergerElem v2TIMElem = new V2TIMMergerElem();
            v2TIMElem.setMessage(this.message);
            v2TIMElem.setElemIndex(0);
            return v2TIMElem;
        }
        return null;
    }

    public V2TIMGroupTipsElem getGroupTipsElem() {
        if (this.getElemType() == 0) {
            return null;
        }
        if (this.getElemType() == 9) {
            V2TIMGroupTipsElem v2TIMElem = new V2TIMGroupTipsElem();
            v2TIMElem.setMessage(this.message);
            v2TIMElem.setElemIndex(0);
            return v2TIMElem;
        }
        return null;
    }

    public String getLocalCustomData() {
        if (this.message == null) {
            return "";
        }
        return this.message.getLocalCustomString();
    }

    public void setLocalCustomData(String localCustomData) {
        if (this.message == null) {
            return;
        }
        this.message.setLocalCustomString(localCustomData);
    }

    public int getLocalCustomInt() {
        if (this.message == null) {
            return 0;
        }
        return this.message.getLocalCustomNumber();
    }

    public void setLocalCustomInt(int localCustomInt) {
        if (this.message == null) {
            return;
        }
        this.message.setLocalCustomNumber(localCustomInt);
    }

    public void setCloudCustomData(String data) {
        if (this.message == null) {
            return;
        }
        this.message.setCloudCustomString(data);
    }

    public String getCloudCustomData() {
        if (this.message == null) {
            return "";
        }
        return this.message.getCloudCustomString();
    }

    public boolean isSelf() {
        if (this.message != null) {
            return this.message.isMessageSender();
        }
        return true;
    }

    public boolean isRead() {
        if (this.message != null) {
            return this.message.isSelfRead();
        }
        return true;
    }

    public boolean isPeerRead() {
        int status = this.getStatus();
        if (status == 1 || status == 3) {
            return false;
        }
        if (this.message != null) {
            return this.message.isPeerRead();
        }
        return false;
    }

    public boolean isNeedReadReceipt() {
        if (this.message != null) {
            return this.message.isNeedReadReceipt();
        }
        return false;
    }

    public void setNeedReadReceipt(boolean needReadReceipt) {
        if (this.message != null) {
            this.message.setNeedReadReceipt(needReadReceipt);
        }
    }

    public boolean isBroadcastMessage() {
        if (this.message != null) {
            return this.message.isBroadcastMessage();
        }
        return false;
    }

    public int getPriority() {
        if (this.message != null) {
            return this.message.getPriority();
        }
        return 0;
    }

    public V2TIMOfflinePushInfo getOfflinePushInfo() {
        if (this.message == null) {
            return null;
        }
        MessageOfflinePushInfo offlinePushInfo = this.message.getOfflinePushInfo();
        V2TIMOfflinePushInfo v2TIMOfflinePushInfo = new V2TIMOfflinePushInfo();
        v2TIMOfflinePushInfo.setMessageOfflinePushInfo(offlinePushInfo);
        return v2TIMOfflinePushInfo;
    }

    public List<String> getGroupAtUserList() {
        if (this.message == null) {
            return new ArrayList<String>();
        }
        List<MessageAtInfo> messageAtInfoList = this.message.getMessageGroupAtInfoList();
        ArrayList<String> userIDList = new ArrayList<String>();
        for (MessageAtInfo messageAtInfo : messageAtInfoList) {
            userIDList.add(messageAtInfo.getAtUserID());
        }
        return userIDList;
    }

    protected void setGroupAtUserList(List<String> userIDList) {
        if (this.message == null || userIDList == null) {
            return;
        }
        ArrayList<MessageAtInfo> messageAtInfoList = new ArrayList<MessageAtInfo>();
        for (String userID : userIDList) {
            MessageAtInfo messageAtInfo = new MessageAtInfo();
            messageAtInfo.setAtUserID(userID);
            messageAtInfoList.add(messageAtInfo);
        }
        this.message.setMessageGroupAtInfoList(messageAtInfoList);
    }

    public long getSeq() {
        if (this.message == null) {
            return 0L;
        }
        return this.message.getSeq();
    }

    public long getRandom() {
        if (this.message == null) {
            return 0L;
        }
        return this.message.getRandom();
    }

    public boolean isExcludedFromUnreadCount() {
        if (this.message == null) {
            return false;
        }
        return this.message.isExcludedFromUnreadCount();
    }

    public void setExcludedFromUnreadCount(boolean excludedFromUnreadCount) {
        if (this.message == null) {
            return;
        }
        this.message.setExcludedFromUnreadCount(excludedFromUnreadCount);
    }

    public boolean isExcludedFromLastMessage() {
        if (this.message == null) {
            return false;
        }
        return this.message.isExcludedFromLastMessage();
    }

    public void setExcludedFromLastMessage(boolean excludedFromLastMessage) {
        if (this.message == null) {
            return;
        }
        this.message.setExcludedFromLastMessage(excludedFromLastMessage);
    }

    public boolean isExcludedFromContentModeration() {
        if (this.message == null) {
            return false;
        }
        return this.message.isExcludedFromContentModeration();
    }

    public void setExcludedFromContentModeration(boolean excludedFromContentModeration) {
        if (this.message == null) {
            return;
        }
        this.message.setExcludedFromContentModeration(excludedFromContentModeration);
    }

    public boolean isSupportMessageExtension() {
        if (this.message == null) {
            return false;
        }
        return this.message.isSupportMessageExtension();
    }

    public void setSupportMessageExtension(boolean supportExtension) {
        if (this.message == null) {
            return;
        }
        this.message.setSupportMessageExtension(supportExtension);
    }

    public boolean hasRiskContent() {
        if (this.message == null) {
            return false;
        }
        return this.message.isHasRiskContent();
    }

    public V2TIMUserFullInfo getRevokerInfo() {
        if (this.message == null) {
            return null;
        }
        if (this.message.getMessageStatus() != 6) {
            return null;
        }
        UserInfo userInfo = this.message.getRevokerInfo();
        if (userInfo == null || TextUtils.isEmpty((CharSequence)userInfo.getUserID())) {
            return null;
        }
        V2TIMUserFullInfo v2TIMUserFullInfo = new V2TIMUserFullInfo();
        v2TIMUserFullInfo.setUserInfo(userInfo);
        return v2TIMUserFullInfo;
    }

    public String getRevokeReason() {
        if (this.message == null) {
            return null;
        }
        if (this.message.getMessageStatus() != 6) {
            return null;
        }
        return this.message.getRevokeReason();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("V2TIMMessage--->");
        V2TIMElem v2TIMElem = null;
        StringBuilder elemDescStringBuilder = new StringBuilder();
        for (int i = 0; i < this.message.getMessageBaseElements().size(); ++i) {
            MessageBaseElement baseElement = this.message.getMessageBaseElements().get(i);
            if (baseElement instanceof TextElement) {
                v2TIMElem = v2TIMElem == null ? this.getTextElem() : v2TIMElem.getNextElem();
                V2TIMTextElem textElement = (V2TIMTextElem)v2TIMElem;
                elemDescStringBuilder.append(textElement.toString());
            } else if (baseElement instanceof CustomElement) {
                v2TIMElem = v2TIMElem == null ? this.getCustomElem() : v2TIMElem.getNextElem();
                V2TIMCustomElem customElement = (V2TIMCustomElem)v2TIMElem;
                elemDescStringBuilder.append(customElement.toString());
            } else if (baseElement instanceof ImageElement) {
                v2TIMElem = v2TIMElem == null ? this.getImageElem() : v2TIMElem.getNextElem();
                V2TIMImageElem imageElement = (V2TIMImageElem)v2TIMElem;
                elemDescStringBuilder.append(imageElement.toString());
            } else if (baseElement instanceof SoundElement) {
                v2TIMElem = v2TIMElem == null ? this.getSoundElem() : v2TIMElem.getNextElem();
                V2TIMSoundElem soundElement = (V2TIMSoundElem)v2TIMElem;
                elemDescStringBuilder.append(soundElement.toString());
            } else if (baseElement instanceof VideoElement) {
                v2TIMElem = v2TIMElem == null ? this.getVideoElem() : v2TIMElem.getNextElem();
                V2TIMVideoElem videoElement = (V2TIMVideoElem)v2TIMElem;
                elemDescStringBuilder.append(videoElement.toString());
            } else if (baseElement instanceof FileElement) {
                v2TIMElem = v2TIMElem == null ? this.getFileElem() : v2TIMElem.getNextElem();
                V2TIMFileElem fileElem = (V2TIMFileElem)v2TIMElem;
                elemDescStringBuilder.append(fileElem.toString());
            } else if (baseElement instanceof LocationElement) {
                v2TIMElem = v2TIMElem == null ? this.getLocationElem() : v2TIMElem.getNextElem();
                V2TIMLocationElem locationElement = (V2TIMLocationElem)v2TIMElem;
                elemDescStringBuilder.append(locationElement.toString());
            } else if (baseElement instanceof FaceElement) {
                v2TIMElem = v2TIMElem == null ? this.getFaceElem() : v2TIMElem.getNextElem();
                V2TIMFaceElem faceElement = (V2TIMFaceElem)v2TIMElem;
                elemDescStringBuilder.append(faceElement.toString());
            } else if (baseElement instanceof MergerElement) {
                v2TIMElem = v2TIMElem == null ? this.getMergerElem() : v2TIMElem.getNextElem();
                V2TIMMergerElem mergerElem = (V2TIMMergerElem)v2TIMElem;
                elemDescStringBuilder.append(mergerElem.toString());
            } else if (baseElement instanceof GroupTipsElement) {
                v2TIMElem = v2TIMElem == null ? this.getGroupTipsElem() : v2TIMElem.getNextElem();
                V2TIMGroupTipsElem groupTipsElement = (V2TIMGroupTipsElem)v2TIMElem;
                elemDescStringBuilder.append(groupTipsElement.toString());
            }
            elemDescStringBuilder.append("|");
        }
        stringBuilder.append("msgID:").append(this.getMsgID()).append(", timestamp:").append(this.getTimestamp()).append(", sender:").append(this.getSender()).append(", nickname:").append(this.getNickName()).append(", faceUrl:").append(this.getFaceUrl()).append(", friendRemark:").append(this.getFriendRemark()).append(", nameCard:").append(this.getNameCard()).append(", groupID:").append(this.getGroupID()).append(", userID:").append(this.getUserID()).append(", seq:").append(this.getSeq()).append(", random:").append(this.getRandom()).append(", status:").append(this.getStatus()).append(", isSelf:").append(this.isSelf()).append(", isRead:").append(this.isRead()).append(", isPeerRead:").append(this.isPeerRead()).append(", needReadReceipt:").append(this.isNeedReadReceipt()).append(", priority:").append(this.getPriority()).append(", groupAtUserList:").append(this.getGroupAtUserList()).append(", elemType:").append(this.getElemType()).append(", localCustomData:").append(this.getLocalCustomData()).append(", localCustomInt:").append(this.getLocalCustomInt()).append(", cloudCustomData:").append(this.getCloudCustomData()).append(", isExcludeFromUnreadCount:").append(this.isExcludedFromUnreadCount()).append(", isExcludeFromLastMessage:").append(this.isExcludedFromLastMessage()).append(", offlinePushInfo:").append(this.getOfflinePushInfo()).append(", isBroadcastMessage:").append(this.isBroadcastMessage()).append(", supportMessageExtension:").append(this.isSupportMessageExtension()).append(", hasRiskContent:").append(this.hasRiskContent()).append(", elemDesc:").append(elemDescStringBuilder.toString()).append(", revokerInfo:").append(this.getRevokerInfo()).append(", revokeReason:").append(this.getRevokeReason());
        return stringBuilder.toString();
    }
}

