/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.imsdk.message;

import com.tencent.imsdk.common.IMCallback;
import com.tencent.imsdk.common.IMContext;
import com.tencent.imsdk.common.IMLog;
import com.tencent.imsdk.conversation.ConversationKey;
import com.tencent.imsdk.manager.BaseManager;
import com.tencent.imsdk.message.C2CMessageReceipt;
import com.tencent.imsdk.message.DownloadParam;
import com.tencent.imsdk.message.DownloadProgressInfo;
import com.tencent.imsdk.message.GroupMessageReceipt;
import com.tencent.imsdk.message.Message;
import com.tencent.imsdk.message.MessageExtension;
import com.tencent.imsdk.message.MessageKey;
import com.tencent.imsdk.message.MessageListGetOption;
import com.tencent.imsdk.message.MessageListener;
import com.tencent.imsdk.message.MessageReactionChangeInfo;
import com.tencent.imsdk.message.MessageSearchParam;
import com.tencent.imsdk.message.MessageUploadProgressCallback;
import com.tencent.imsdk.relationship.UserInfo;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public class MessageCenter {
    private static final String TAG = "MessageCenter";
    private Object mLockObject = new Object();
    private MessageListener mMessageListener;
    private CopyOnWriteArrayList<MessageListener> mMessageProxyListenerList = new CopyOnWriteArrayList();

    public static MessageCenter getInstance() {
        return MessageCenterHolder.messageCenter;
    }

    protected MessageCenter() {
    }

    public void init() {
        this.initMessageListener();
    }

    private void initMessageListener() {
        this.mMessageListener = new MessageListener(){

            @Override
            public void onReceiveNewMessage(final List<Message> messageList) {
                IMContext.getInstance().runOnMainThread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = MessageCenter.this.mLockObject;
                        synchronized (object) {
                            for (MessageListener messageListener : MessageCenter.this.mMessageProxyListenerList) {
                                messageListener.onReceiveNewMessage(messageList);
                            }
                        }
                    }
                });
            }

            @Override
            public void onReceiveC2CMessageReceipt(final List<C2CMessageReceipt> receiptList) {
                IMContext.getInstance().runOnMainThread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = MessageCenter.this.mLockObject;
                        synchronized (object) {
                            for (MessageListener messageListener : MessageCenter.this.mMessageProxyListenerList) {
                                messageListener.onReceiveC2CMessageReceipt(receiptList);
                            }
                        }
                    }
                });
            }

            @Override
            public void onReceiveGroupMessageReceipt(final List<GroupMessageReceipt> receiptList) {
                IMContext.getInstance().runOnMainThread(new Runnable(){

                    @Override
                    public void run() {
                        for (MessageListener messageListener : MessageCenter.this.mMessageProxyListenerList) {
                            messageListener.onReceiveGroupMessageReceipt(receiptList);
                        }
                    }
                });
            }

            @Override
            public void onReceiveMessageRevoked(final Map<MessageKey, Map<UserInfo, String>> revokeInfoMap) {
                IMContext.getInstance().runOnMainThread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = MessageCenter.this.mLockObject;
                        synchronized (object) {
                            for (MessageListener messageListener : MessageCenter.this.mMessageProxyListenerList) {
                                messageListener.onReceiveMessageRevoked(revokeInfoMap);
                            }
                        }
                    }
                });
            }

            @Override
            public void onReceiveMessageModified(final List<Message> messageList) {
                IMContext.getInstance().runOnMainThread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = MessageCenter.this.mLockObject;
                        synchronized (object) {
                            for (MessageListener messageListener : MessageCenter.this.mMessageProxyListenerList) {
                                messageListener.onReceiveMessageModified(messageList);
                            }
                        }
                    }
                });
            }

            @Override
            public void onReceiveMessageExtensionsChanged(final MessageKey messageKey, final List<MessageExtension> extensions) {
                IMContext.getInstance().runOnMainThread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = MessageCenter.this.mLockObject;
                        synchronized (object) {
                            for (MessageListener messageListener : MessageCenter.this.mMessageProxyListenerList) {
                                messageListener.onReceiveMessageExtensionsChanged(messageKey, extensions);
                            }
                        }
                    }
                });
            }

            @Override
            public void onReceiveMessageExtensionsDeleted(final MessageKey messageKey, final List<MessageExtension> extensions) {
                IMContext.getInstance().runOnMainThread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = MessageCenter.this.mLockObject;
                        synchronized (object) {
                            for (MessageListener messageListener : MessageCenter.this.mMessageProxyListenerList) {
                                messageListener.onReceiveMessageExtensionsDeleted(messageKey, extensions);
                            }
                        }
                    }
                });
            }

            @Override
            public void onReceiveMessageReactionsChanged(final List<MessageReactionChangeInfo> changeInfos) {
                IMContext.getInstance().runOnMainThread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = MessageCenter.this.mLockObject;
                        synchronized (object) {
                            for (MessageListener messageListener : MessageCenter.this.mMessageProxyListenerList) {
                                messageListener.onReceiveMessageReactionsChanged(changeInfos);
                            }
                        }
                    }
                });
            }
        };
        this.nativeSetMessageListener(this.mMessageListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessageListener(MessageListener messageListener) {
        Object object = this.mLockObject;
        synchronized (object) {
            this.mMessageProxyListenerList.add(messageListener);
        }
    }

    public String sendMessage(Message message, MessageUploadProgressCallback progressCallback, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return null;
        }
        return this.nativeSendMessage(message, progressCallback, callback);
    }

    public void revokeMessage(MessageKey messageKey, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeRevokeMessage(messageKey, callback);
    }

    public void modifyMessage(Message message, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeModifyMessage(message, callback);
    }

    public void setC2CMessageRead(String userID, long readTime, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeSetC2CMessageRead(userID, readTime, callback);
    }

    public void setGroupMessageRead(String groupID, long readSequence, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeSetGroupMessageRead(groupID, readSequence, callback);
    }

    public void getC2CHistoryMessageList(String userID, MessageListGetOption messageListGetOption, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeGetC2CHistoryMessageList(userID, messageListGetOption, callback);
    }

    public void getGroupHistoryMessageList(String groupID, MessageListGetOption messageListGetOption, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeGetGroupHistoryMessageList(groupID, messageListGetOption, callback);
    }

    public String insertLocalMessage(Message message, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return null;
        }
        return this.nativeInsertLocalMessage(message, callback);
    }

    public void setLocalCustomString(Message message, String localCustomString) {
        this.nativeSetLocalCustomString(message, localCustomString);
    }

    public void setLocalCustomNumber(Message message, int localCustomNumber) {
        this.nativeSetLocalCustomNumber(message, localCustomNumber);
    }

    public void deleteLocalMessage(MessageKey messageKey, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeDeleteLocalMessage(messageKey, callback);
    }

    public void deleteCloudMessageList(List<MessageKey> messageKeyList, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeDeleteCloudMessageList(messageKeyList, callback);
    }

    public void clearC2CHistoryMessage(String userID, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeClearC2CHistoryMessage(userID, callback);
    }

    public void clearGroupHistoryMessage(String groupID, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeClearGroupHistoryMessage(groupID, callback);
    }

    public void clearLocalHistoryMessage(ConversationKey conversationKey, long beginTime, long endTime, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeClearLocalHistoryMessage(conversationKey, beginTime, endTime, callback);
    }

    public void findMessageByMessageId(List<String> messageIDList, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeFindMessageByMessageID(messageIDList, callback);
    }

    public void searchLocalMessage(MessageSearchParam messageSearchParam, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeSearchLocalMessage(messageSearchParam, callback);
    }

    public void searchCloudMessage(MessageSearchParam messageSearchParam, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeSearchCloudMessage(messageSearchParam, callback);
    }

    public void downloadMessageElement(DownloadParam downloadParam, IMCallback<DownloadProgressInfo> progressInfoIMCallback, IMCallback completeCallback) {
        if (!BaseManager.getInstance().isInited()) {
            if (completeCallback != null) {
                completeCallback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeDownloadMessageElement(downloadParam, progressInfoIMCallback, completeCallback);
    }

    public void downloadRelayMessageList(Message message, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeDownloadRelayMessageList(message, callback);
    }

    public boolean isMessageSelfRead(MessageKey messageKey) {
        if (!BaseManager.getInstance().isInited()) {
            IMLog.e(TAG, "sdk not ini");
            return false;
        }
        return this.nativeIsMessageSelfRead(messageKey);
    }

    public boolean isMessagePeerRead(MessageKey messageKey) {
        if (!BaseManager.getInstance().isInited()) {
            IMLog.e(TAG, "sdk not ini");
            return false;
        }
        return this.nativeIsMessagePeerRead(messageKey);
    }

    public void sendMessageReceipts(List<MessageKey> messageList, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeSendMessageReceipts(messageList, callback);
    }

    public void getGroupMessageReceipts(List<MessageKey> messageList, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeGetGroupMessageReceipts(messageList, callback);
    }

    public void getGroupMessageReadMembers(Message message, int filter, long nextSeq, int count, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeGetGroupMessageReadMembers(message, filter, nextSeq, count, callback);
    }

    public void setMessageExtensions(Message message, List<MessageExtension> extensions, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeSetMessageExtensions(message, extensions, callback);
    }

    public void getMessageExtensions(Message message, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeGetMessageExtensions(message, callback);
    }

    public void deleteMessageExtensions(Message message, List<String> keys, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeDeleteMessageExtensions(message, keys, callback);
    }

    public void addMessageReaction(Message message, String reactionID, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeAddMessageReaction(message, reactionID, callback);
    }

    public void removeMessageReaction(Message message, String reactionID, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeRemoveMessageReaction(message, reactionID, callback);
    }

    public void getMessageReactions(List<MessageKey> messageKeyList, int maxUserCountPerReaction, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeGetMessageReactions(messageKeyList, maxUserCountPerReaction, callback);
    }

    public void getAllUserListOfMessageReaction(Message message, String reactionID, int nextSeq, int count, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeGetAllUserListOfMessageReaction(message, reactionID, nextSeq, count, callback);
    }

    public void translateText(List<String> sourceTextList, String sourceLanguage, String targetLanguage, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeTranslateText(sourceTextList, sourceLanguage, targetLanguage, callback);
    }

    public void convertVoiceToText(String url, String language, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeConvertVoiceToText(url, language, callback);
    }

    protected native void nativeSetMessageListener(MessageListener var1);

    protected native String nativeSendMessage(Message var1, MessageUploadProgressCallback var2, IMCallback var3);

    protected native void nativeRevokeMessage(MessageKey var1, IMCallback var2);

    protected native void nativeModifyMessage(Message var1, IMCallback var2);

    protected native void nativeSetC2CMessageRead(String var1, long var2, IMCallback var4);

    protected native void nativeSetGroupMessageRead(String var1, long var2, IMCallback var4);

    protected native void nativeGetC2CHistoryMessageList(String var1, MessageListGetOption var2, IMCallback var3);

    protected native void nativeGetGroupHistoryMessageList(String var1, MessageListGetOption var2, IMCallback var3);

    protected native void nativeFindMessageByMessageID(List<String> var1, IMCallback var2);

    protected native void nativeSearchLocalMessage(MessageSearchParam var1, IMCallback var2);

    protected native void nativeSearchCloudMessage(MessageSearchParam var1, IMCallback var2);

    protected native String nativeInsertLocalMessage(Message var1, IMCallback var2);

    protected native void nativeSetLocalCustomString(Message var1, String var2);

    protected native void nativeSetLocalCustomNumber(Message var1, int var2);

    protected native void nativeDeleteLocalMessage(MessageKey var1, IMCallback var2);

    protected native void nativeDeleteCloudMessageList(List<MessageKey> var1, IMCallback var2);

    protected native void nativeClearC2CHistoryMessage(String var1, IMCallback var2);

    protected native void nativeClearGroupHistoryMessage(String var1, IMCallback var2);

    protected native void nativeClearLocalHistoryMessage(ConversationKey var1, long var2, long var4, IMCallback var6);

    protected native void nativeDownloadMessageElement(DownloadParam var1, IMCallback var2, IMCallback var3);

    protected native void nativeDownloadRelayMessageList(Message var1, IMCallback var2);

    protected native boolean nativeIsMessageSelfRead(MessageKey var1);

    protected native boolean nativeIsMessagePeerRead(MessageKey var1);

    protected native void nativeSendMessageReceipts(List<MessageKey> var1, IMCallback var2);

    protected native void nativeGetGroupMessageReceipts(List<MessageKey> var1, IMCallback var2);

    protected native void nativeGetGroupMessageReadMembers(Message var1, int var2, long var3, int var5, IMCallback var6);

    protected native void nativeSetMessageExtensions(Message var1, List<MessageExtension> var2, IMCallback var3);

    protected native void nativeGetMessageExtensions(Message var1, IMCallback var2);

    protected native void nativeDeleteMessageExtensions(Message var1, List<String> var2, IMCallback var3);

    protected native void nativeAddMessageReaction(Message var1, String var2, IMCallback var3);

    protected native void nativeRemoveMessageReaction(Message var1, String var2, IMCallback var3);

    protected native void nativeGetMessageReactions(List<MessageKey> var1, int var2, IMCallback var3);

    protected native void nativeGetAllUserListOfMessageReaction(Message var1, String var2, int var3, int var4, IMCallback var5);

    protected native void nativeTranslateText(List<String> var1, String var2, String var3, IMCallback var4);

    protected native void nativeConvertVoiceToText(String var1, String var2, IMCallback var3);

    private static class MessageCenterHolder {
        private static final MessageCenter messageCenter = new MessageCenter();

        private MessageCenterHolder() {
        }
    }
}

