/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.imsdk.manager;

import android.content.Context;
import android.util.Log;
import com.tencent.imsdk.common.IMCallback;
import com.tencent.imsdk.common.IMContext;
import com.tencent.imsdk.common.IMLog;
import com.tencent.imsdk.common.NetworkInfoCenter;
import com.tencent.imsdk.common.SystemUtil;
import com.tencent.imsdk.conversation.ConversationManager;
import com.tencent.imsdk.group.GroupManager;
import com.tencent.imsdk.manager.CustomServerInfo;
import com.tencent.imsdk.manager.SDKConfig;
import com.tencent.imsdk.manager.SDKListener;
import com.tencent.imsdk.manager.UserPreference;
import com.tencent.imsdk.message.MessageCenter;
import com.tencent.imsdk.relationship.ReceiveMessageOptInfo;
import com.tencent.imsdk.relationship.RelationshipManager;
import com.tencent.imsdk.relationship.UserInfo;
import com.tencent.imsdk.relationship.UserStatus;
import com.tencent.imsdk.signaling.SignalingManager;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BaseManager
implements NetworkInfoCenter.INetworkChangeListener {
    private static final String TAG = BaseManager.class.getSimpleName();
    public static final long TUI_COMPONENT_UNKNOWN = 0L;
    public static final long TUI_COMPONENT_CORE = 1L;
    public static final long TUI_COMPONENT_CONVERSATION = 2L;
    public static final long TUI_COMPONENT_CHAT = 3L;
    public static final long TUI_COMPONENT_CONTACT = 4L;
    public static final long TUI_COMPONENT_GROUP = 5L;
    public static final long TUI_COMPONENT_SEARCH = 6L;
    public static final long TUI_COMPONENT_OFFLINEPUSH = 7L;
    public static final long TUI_COMPONENT_COMMUNITY = 8L;
    public static final long TUI_PLUGIN_GROUP_NOTE = 9L;
    public static final long TUI_PLUGIN_POLL = 10L;
    public static final long TUI_PLUGIN_CONVERSATION_MARK = 11L;
    public static final long TUI_PLUGIN_CONVERSATION_GROUP = 12L;
    public static final long TUI_STYLE_TYPE_CLASSIC = 0L;
    public static final long TUI_STYLE_TYPE_MINIMALIST = 1L;
    private static final int TUI_COMPONENT_CHECK_COUNT_LIMIT = 5;
    private static final int TUI_COMPONENT_STACK_LAYER_LIMIT = 10;
    private static final int UI_PLATFORM_UNKNOWN = 0;
    private static final int UI_PLATFORM_FLUTTER = 1;
    private static final int UI_PLATFORM_FLUTTER_UIKIT = 2;
    private static final int UI_PLATFORM_UNITY = 5;
    private static final int UI_PLATFORM_UNITY_UIKIT = 6;
    private static final int UI_PLATFORM_TUIKIT = 15;
    private static final int UI_PLATFORM_TUIKIT_MINIMALIST = 26;
    private boolean mInvokeFromTUIKit = false;
    private boolean mInvokeFromTUICore = false;
    private Map<Long, Long> mTUIComponentMap = new HashMap<Long, Long>();
    private HashMap<Long, Integer> mTUIComponentCheckCountMap = new HashMap();
    private SDKConfig.NetworkInfo mLastNetworkInfo = new SDKConfig.NetworkInfo();
    private SDKConfig.ProxyInfo mProxyInfo = new SDKConfig.ProxyInfo();
    private SDKConfig.DatabaseEncryptInfo mDatabaseEncryptInfo = new SDKConfig.DatabaseEncryptInfo();
    private SDKConfig.PacketRetryInfo mPacketRetryInfo = new SDKConfig.PacketRetryInfo();
    private WeakReference<SDKListener> sdkListenerWeakReference;
    private static boolean mLoadLibrarySuccess = false;
    private String mStringUIPlatform = "";
    private int mNumberUIPlatform = 0;
    private boolean isInit = false;
    private boolean isTestEnvironment = false;
    private boolean forceUseQuicChannel = false;
    private boolean isIPv6Prior = false;
    private UserPreference userPreference = new UserPreference();

    public static BaseManager getInstance() {
        return BaseManagerHolder.baseManager;
    }

    public boolean initSDK(Context context, SDKConfig sdkConfig, boolean needLogCallback, SDKListener listener) {
        if (!mLoadLibrarySuccess) {
            IMLog.e(TAG, "libimsdk.so is not loaded");
            return false;
        }
        if (sdkConfig.sdkAppId <= 0L) {
            IMLog.e(TAG, "invalid sdkAppID:" + sdkConfig.sdkAppId);
            return false;
        }
        if (null == context) {
            IMLog.e(TAG, "null context");
            return false;
        }
        if (this.isInit) {
            IMLog.w(TAG, "Has initSDK");
            return true;
        }
        IMContext.getInstance().init(context.getApplicationContext());
        NetworkInfoCenter.getInstance().init(context.getApplicationContext(), this);
        MessageCenter.getInstance().init();
        GroupManager.getInstance().init();
        ConversationManager.getInstance().init();
        RelationshipManager.getInstance().init();
        SignalingManager.getInstance().init();
        sdkConfig.sdkInitPath = SystemUtil.getSDKInitPath();
        sdkConfig.sdkInstanceType = SystemUtil.getInstanceType();
        sdkConfig.isTestEnvironment = this.isTestEnvironment;
        sdkConfig.forceUseQuicChannel = this.forceUseQuicChannel;
        sdkConfig.isIPv6Prior = this.isIPv6Prior;
        sdkConfig.deviceInfo.deviceType = SystemUtil.getDeviceType();
        sdkConfig.deviceInfo.deviceId = SystemUtil.getDeviceID();
        sdkConfig.deviceInfo.deviceBrand = SystemUtil.getInstanceType();
        sdkConfig.deviceInfo.systemVersion = SystemUtil.getSystemVersion();
        sdkConfig.networkInfo.networkType = NetworkInfoCenter.getInstance().getNetworkType();
        sdkConfig.networkInfo.ipType = NetworkInfoCenter.getInstance().getIPType();
        sdkConfig.networkInfo.networkId = NetworkInfoCenter.getInstance().getNetworkID();
        sdkConfig.networkInfo.wifiNetworkHandle = NetworkInfoCenter.getInstance().getWifiNetworkHandle();
        sdkConfig.networkInfo.xgNetworkHandle = NetworkInfoCenter.getInstance().getXgNetworkHandle();
        sdkConfig.networkInfo.initializeCostTime = NetworkInfoCenter.getInstance().getInitializeCostTime();
        sdkConfig.networkInfo.networkConnected = NetworkInfoCenter.getInstance().isNetworkConnected();
        sdkConfig.proxyInfo = this.mProxyInfo;
        sdkConfig.databaseEncryptInfo = this.mDatabaseEncryptInfo;
        sdkConfig.packetRetryInfo = this.mPacketRetryInfo;
        sdkConfig.logSetting.enableConsoleLog = true;
        sdkConfig.logSetting.logFilePath = SystemUtil.getSDKLogPath();
        sdkConfig.stringUIPlatform = this.mStringUIPlatform;
        sdkConfig.numberUIPlatform = this.getUIPlatform();
        sdkConfig.packageName = context.getPackageName();
        sdkConfig.appName = SystemUtil.getAppName();
        this.mLastNetworkInfo = sdkConfig.networkInfo;
        this.nativeInitSDK(sdkConfig, needLogCallback, listener);
        this.sdkListenerWeakReference = new WeakReference<SDKListener>(listener);
        this.reportTUIComponentUsage();
        this.isInit = true;
        return true;
    }

    public void unInitSDK() {
        this.nativeUninitSDK();
        this.mStringUIPlatform = "";
        this.mNumberUIPlatform = 0;
        this.isInit = false;
        this.isTestEnvironment = false;
        this.forceUseQuicChannel = false;
        this.isIPv6Prior = false;
        this.mLastNetworkInfo.clean();
        this.mProxyInfo.clean();
        this.mDatabaseEncryptInfo.clean();
        this.mPacketRetryInfo.clean();
        this.mInvokeFromTUIKit = false;
        this.mInvokeFromTUICore = false;
        this.mTUIComponentMap.clear();
        this.mTUIComponentCheckCountMap.clear();
    }

    private int getUIPlatform() {
        if (this.mNumberUIPlatform != 0) {
            return this.mNumberUIPlatform;
        }
        this.mInvokeFromTUIKit = this.isTUIKit();
        boolean hasFlutter = this.isFlutter();
        boolean hasUnity = this.isUnity();
        if (hasFlutter) {
            if (this.mInvokeFromTUIKit) {
                return 2;
            }
            return 1;
        }
        if (hasUnity) {
            if (this.mInvokeFromTUIKit) {
                return 6;
            }
            return 5;
        }
        if (this.mInvokeFromTUIKit) {
            if (this.hasTUIKitMinimalist()) {
                return 26;
            }
            return 15;
        }
        return 0;
    }

    private boolean isTUIKit() {
        try {
            Class<?> classTUIKit = Class.forName("com.tencent.qcloud.tim.uikit.TUIKit");
            if (classTUIKit != null) {
                return true;
            }
        }
        catch (Exception classTUIKit) {
            // empty catch block
        }
        try {
            Class<?> classTUICore = Class.forName("com.tencent.qcloud.tuicore.TUICore");
            if (classTUICore != null) {
                return true;
            }
        }
        catch (ClassNotFoundException classTUICore) {
            // empty catch block
        }
        StackTraceElement[] stacks = new Throwable().getStackTrace();
        String callName = "";
        for (int i = 0; i < stacks.length; ++i) {
            if (i > 15) {
                return false;
            }
            callName = stacks[i].getClassName();
            String lowerCaseCallName = callName.toLowerCase();
            if (!lowerCaseCallName.contains("tuikitimpl") && !lowerCaseCallName.contains("tuicore")) continue;
            return true;
        }
        return false;
    }

    private boolean isTUICore() {
        try {
            Class<?> classTUICore = Class.forName("com.tencent.qcloud.tuicore.TUICore");
            if (classTUICore != null) {
                return true;
            }
        }
        catch (ClassNotFoundException classTUICore) {
            // empty catch block
        }
        StackTraceElement[] stacks = new Throwable().getStackTrace();
        String callName = "";
        for (int i = 0; i < stacks.length; ++i) {
            if (i > 15) {
                return false;
            }
            callName = stacks[i].getClassName();
            String lowerCaseCallName = callName.toLowerCase();
            if (!lowerCaseCallName.contains("tuicore")) continue;
            return true;
        }
        return false;
    }

    private boolean isFlutter() {
        try {
            Class<?> c = Class.forName("com.qq.qcloud.tencent_im_sdk_plugin.tencent_im_sdk_plugin");
            if (c != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean isUnity() {
        try {
            Class<?> c = Class.forName("com.qcloud.tencentimsdk.TencentImSDKPluginUnity");
            if (c != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void checkTUIComponent(long componentType) {
        if (!this.isInit) {
            return;
        }
        if (!this.mInvokeFromTUICore) {
            return;
        }
        if (this.mTUIComponentMap.containsKey(componentType)) {
            return;
        }
        if (!this.mTUIComponentCheckCountMap.containsKey(componentType)) {
            return;
        }
        String keyCallName = "";
        boolean needFindStyleType = true;
        if (componentType == 2L) {
            keyCallName = "conversationprovider";
        } else if (componentType == 3L) {
            keyCallName = "chatprovider";
        } else if (componentType == 5L) {
            keyCallName = "groupInfoprovider";
        } else if (componentType == 4L) {
            keyCallName = "contactprovider";
        } else if (componentType == 6L) {
            keyCallName = "searchdataprovider";
        } else if (componentType == 7L) {
            keyCallName = "tuiofflinepushmanager";
            needFindStyleType = false;
        } else if (componentType == 8L) {
            keyCallName = "communityprovider";
            needFindStyleType = false;
        } else if (componentType == 9L) {
            keyCallName = "tuigroupnoteservice";
        } else if (componentType == 10L) {
            keyCallName = "tuipollservice";
        } else if (componentType == 11L) {
            keyCallName = "tuiconversationmarkservice";
        } else if (componentType == 12L) {
            keyCallName = "tuiconversationgroupservice";
        } else {
            IMLog.e(TAG, "unknown tui component type:" + componentType);
            return;
        }
        String minimalistUIName = "minimalist";
        String classicUIName = "classic";
        int checkIndex = this.mTUIComponentCheckCountMap.get(componentType);
        if (checkIndex < 5) {
            this.mTUIComponentCheckCountMap.put(componentType, ++checkIndex);
            StackTraceElement[] stacks = new Throwable().getStackTrace();
            String callName = "";
            boolean hasFoundKeyCallName = false;
            boolean hasFoundStyleType = false;
            long styleType = 0L;
            for (int i = 0; i < stacks.length; ++i) {
                callName = stacks[i].getClassName();
                String lowerCaseCallName = callName.toLowerCase();
                if (!hasFoundKeyCallName && lowerCaseCallName.contains(keyCallName)) {
                    hasFoundKeyCallName = true;
                }
                if (needFindStyleType && !hasFoundStyleType) {
                    if (lowerCaseCallName.contains(classicUIName)) {
                        hasFoundStyleType = true;
                    } else if (lowerCaseCallName.contains(minimalistUIName)) {
                        hasFoundStyleType = true;
                        styleType = 1L;
                    }
                }
                if (hasFoundKeyCallName && (!needFindStyleType || hasFoundStyleType)) {
                    this.mTUIComponentMap.put(componentType, styleType);
                    this.nativeReportTUIComponentUsage(this.mTUIComponentMap);
                    break;
                }
                if (i < 10) continue;
                if (!hasFoundKeyCallName) break;
                this.mTUIComponentMap.put(componentType, styleType);
                this.nativeReportTUIComponentUsage(this.mTUIComponentMap);
                break;
            }
        }
    }

    public void reportTUIComponentUsage(long componentType, long styleType) {
        HashMap<Long, Long> componentMap = new HashMap<Long, Long>();
        componentMap.put(componentType, styleType);
        this.nativeReportTUIComponentUsage(componentMap);
    }

    private void reportTUIComponentUsage() {
        this.mInvokeFromTUICore = this.isTUICore();
        this.mTUIComponentCheckCountMap.put(2L, 0);
        this.mTUIComponentCheckCountMap.put(3L, 0);
        this.mTUIComponentCheckCountMap.put(4L, 0);
        this.mTUIComponentCheckCountMap.put(5L, 0);
        this.mTUIComponentCheckCountMap.put(6L, 0);
        this.mTUIComponentCheckCountMap.put(7L, 0);
        this.mTUIComponentCheckCountMap.put(8L, 0);
        this.mTUIComponentCheckCountMap.put(9L, 0);
        this.mTUIComponentCheckCountMap.put(10L, 0);
        this.mTUIComponentCheckCountMap.put(11L, 0);
        this.mTUIComponentCheckCountMap.put(12L, 0);
        if (this.mInvokeFromTUIKit) {
            if (this.mInvokeFromTUICore) {
                this.mTUIComponentMap.put(1L, 0L);
                if (this.hasTUIConversation() && !this.mTUIComponentMap.containsKey(2L)) {
                    this.mTUIComponentMap.put(2L, this.getTUIConversationStyle());
                }
                if (this.hasTUIChat() && !this.mTUIComponentMap.containsKey(3L)) {
                    this.mTUIComponentMap.put(3L, this.getTUIChatStyle());
                }
                if (this.hasTUIContact() && !this.mTUIComponentMap.containsKey(4L)) {
                    this.mTUIComponentMap.put(4L, this.getTUIContactStyle());
                }
                if (this.hasTUIGroup() && !this.mTUIComponentMap.containsKey(5L)) {
                    this.mTUIComponentMap.put(5L, this.getTUIGroupStyle());
                }
                if (this.hasTUISearch() && !this.mTUIComponentMap.containsKey(6L)) {
                    this.mTUIComponentMap.put(6L, this.getTUISearchStyle());
                }
                if (this.hasTUIOfflinePush() && !this.mTUIComponentMap.containsKey(7L)) {
                    this.mTUIComponentMap.put(7L, 0L);
                }
                if (this.hasTUICommunity() && !this.mTUIComponentMap.containsKey(8L)) {
                    this.mTUIComponentMap.put(8L, 0L);
                }
                if (this.hasTUIGroupNote() && !this.mTUIComponentMap.containsKey(9L)) {
                    this.mTUIComponentMap.put(9L, 0L);
                }
                if (this.hasTUIPoll() && !this.mTUIComponentMap.containsKey(10L)) {
                    this.mTUIComponentMap.put(10L, 0L);
                }
                if (this.hasTUIConversationMark() && !this.mTUIComponentMap.containsKey(11L)) {
                    this.mTUIComponentMap.put(11L, 0L);
                }
                if (this.hasTUIConversationGroup() && !this.mTUIComponentMap.containsKey(12L)) {
                    this.mTUIComponentMap.put(12L, 0L);
                }
            } else {
                this.mTUIComponentMap.put(0L, 0L);
            }
            this.nativeReportTUIComponentUsage(this.mTUIComponentMap);
        }
    }

    private boolean hasTUIKitMinimalist() {
        return this.getTUIConversationStyle() == 1L || this.getTUIChatStyle() == 1L || this.getTUIContactStyle() == 1L || this.getTUIGroupStyle() == 1L || this.getTUISearchStyle() == 1L;
    }

    private boolean hasTUIConversation() {
        try {
            Class<?> c = Class.forName("com.tencent.qcloud.tuikit.tuiconversation.model.ConversationProvider");
            if (c != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private long getTUIConversationStyle() {
        try {
            Class<?> c = Class.forName("com.tencent.qcloud.tuikit.tuiconversation.minimalistui.widget.ConversationListLayout");
            if (c != null) {
                return 1L;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0L;
    }

    private boolean hasTUIChat() {
        try {
            Class<?> c = Class.forName("com.tencent.qcloud.tuikit.tuichat.model.ChatProvider");
            if (c != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private long getTUIChatStyle() {
        try {
            Class<?> c = Class.forName("com.tencent.qcloud.tuikit.tuichat.minimalistui.MinimalistUIService");
            if (c != null) {
                return 1L;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0L;
    }

    private boolean hasTUIContact() {
        try {
            Class<?> c = Class.forName("com.tencent.qcloud.tuikit.tuicontact.model.ContactProvider");
            if (c != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private long getTUIContactStyle() {
        try {
            Class<?> c = Class.forName("com.tencent.qcloud.tuikit.tuicontact.minimalistui.widget.FriendProfileLayout");
            if (c != null) {
                return 1L;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0L;
    }

    private boolean hasTUIGroup() {
        try {
            Class<?> c = Class.forName("com.tencent.qcloud.tuikit.tuigroup.model.GroupInfoProvider");
            if (c != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private long getTUIGroupStyle() {
        try {
            Class<?> c = Class.forName("com.tencent.qcloud.tuikit.tuigroup.minimalistui.widget.GroupInfoLayout");
            if (c != null) {
                return 1L;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0L;
    }

    private boolean hasTUISearch() {
        try {
            Class<?> c = Class.forName("com.tencent.qcloud.tuikit.tuisearch.model.SearchDataProvider");
            if (c != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private long getTUISearchStyle() {
        try {
            Class<?> c = Class.forName("com.tencent.qcloud.tuikit.tuisearch.minimalistui.page.SearchMainMinimalistActivity");
            if (c != null) {
                return 1L;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0L;
    }

    private boolean hasTUIOfflinePush() {
        try {
            Class<?> c = Class.forName("com.tencent.qcloud.tim.tuiofflinepush.TUIOfflinePushManager");
            if (c != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean hasTUICommunity() {
        try {
            Class<?> c = Class.forName("com.tencent.qcloud.tuikit.tuicommunity.model.CommunityProvider");
            if (c != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean hasTUIGroupNote() {
        try {
            Class<?> c = Class.forName("com.tencent.qcloud.tuikit.tuigroupnote.TUIGroupNoteService");
            if (c != null) {
                return true;
            }
            c = Class.forName("com.tencent.qcloud.tuikit.tuigroupnoteplugin.TUIGroupNoteService");
            if (c != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean hasTUIPoll() {
        try {
            Class<?> c = Class.forName("com.tencent.qcloud.tuikit.tuipoll.TUIPollService");
            if (c != null) {
                return true;
            }
            c = Class.forName("com.tencent.qcloud.tuikit.tuipollplugin.TUIPollService");
            if (c != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean hasTUIConversationMark() {
        try {
            Class<?> c = Class.forName("com.tencent.qcloud.tuikit.tuiconversationmarkplugin.TUIConversationMarkService");
            if (c != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean hasTUIConversationGroup() {
        try {
            Class<?> c = Class.forName("com.tencent.qcloud.tuikit.tuiconversationgroupplugin.TUIConversationGroupService");
            if (c != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void login(String userID, String userSig, IMCallback callback) {
        if (!this.isInit) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeLogin(userID, userSig, callback);
    }

    public void logout(IMCallback callback) {
        if (!this.isInit) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeLogout(callback);
    }

    public boolean setLibraryPath(String libraryPath) {
        mLoadLibrarySuccess = SystemUtil.loadIMLibrary(libraryPath);
        return mLoadLibrarySuccess;
    }

    public void setCustomUIPlatform(String stringUIPlatform, int numberUIPlatform) {
        this.mStringUIPlatform = stringUIPlatform;
        this.mNumberUIPlatform = numberUIPlatform;
    }

    public void setTestEnvironment(boolean testEnvironment) {
        this.isTestEnvironment = testEnvironment;
    }

    public void setForceUseQuicChannel(boolean force) {
        this.forceUseQuicChannel = force;
    }

    public void setIPv6Prior(boolean prior) {
        this.isIPv6Prior = prior;
    }

    public void setCustomServerInfo(CustomServerInfo customServerInfo) {
        this.nativeSetCustomServerInfo(customServerInfo);
    }

    public void setProxyInfo(SDKConfig.ProxyInfo proxyInfo) {
        this.mProxyInfo = proxyInfo;
    }

    public void setDatabaseEncryptInfo(SDKConfig.DatabaseEncryptInfo databaseEncryptInfo) {
        this.mDatabaseEncryptInfo = databaseEncryptInfo;
    }

    public void isCommercialAbilityEnabled(long commercialAbilityKey, IMCallback<Object> callback) {
        this.nativeIsCommercialAbilityEnabled(commercialAbilityKey, callback);
    }

    public void setPacketRetryInfo(SDKConfig.PacketRetryInfo info) {
        this.mPacketRetryInfo = info;
    }

    public String getLoginUser() {
        if (!this.isInit) {
            Log.e((String)TAG, (String)"sdk not init");
            return null;
        }
        return this.nativeGetLoginUser();
    }

    public int getLoginStatus() {
        if (!this.isInit) {
            Log.e((String)TAG, (String)"sdk not init");
            return 3;
        }
        return this.nativeGetLoginStatus();
    }

    public String getVersion() {
        if (!this.isInit) {
            Log.e((String)TAG, (String)"sdk not init");
            return null;
        }
        return this.nativeGetSDKVersion();
    }

    public boolean isInited() {
        return this.isInit;
    }

    public long getClockTickInHz() {
        if (!this.isInit) {
            Log.e((String)TAG, (String)"sdk not init");
            return 0L;
        }
        return this.nativeGetClockTickInHz();
    }

    public long getTimeTick() {
        if (!this.isInit) {
            Log.e((String)TAG, (String)"sdk not init");
            return 0L;
        }
        return this.nativeGetTimeTick();
    }

    public long getServerTime() {
        if (!this.isInit) {
            Log.e((String)TAG, (String)"sdk not init");
            return 0L;
        }
        return this.nativeGetServerTime();
    }

    public void initLocalStorage(String userID, IMCallback callback) {
        if (!this.isInit) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeInitLocalStorage(userID, callback);
    }

    @Override
    public void onNetworkChange(boolean connected, int networkType, int ipType, String networkID, long wifiNetworkHandle, long xgNetworkHandle, long initializeCostTime) {
        if (connected == this.mLastNetworkInfo.networkConnected && networkType == this.mLastNetworkInfo.networkType && ipType == this.mLastNetworkInfo.ipType && null != networkID && networkID.equals(this.mLastNetworkInfo.networkId)) {
            Log.w((String)TAG, (String)"onNetworkChange, networkinfo is same");
            return;
        }
        this.mLastNetworkInfo.networkConnected = connected;
        this.mLastNetworkInfo.networkType = networkType;
        this.mLastNetworkInfo.ipType = ipType;
        this.mLastNetworkInfo.networkId = networkID;
        this.mLastNetworkInfo.initializeCostTime = initializeCostTime;
        this.nativeNotifyNetworkChange(connected, networkType, ipType, networkID, wifiNetworkHandle, xgNetworkHandle, initializeCostTime);
    }

    public void notifySelfInfoUpdated(UserInfo selfInfo) {
        SDKListener listener;
        if (this.sdkListenerWeakReference != null && (listener = (SDKListener)this.sdkListenerWeakReference.get()) != null) {
            listener.onSelfInfoUpdated(selfInfo);
        }
    }

    public void notifyUserStatusChanged(List<UserStatus> userStatusList) {
        SDKListener listener;
        if (this.sdkListenerWeakReference != null && (listener = (SDKListener)this.sdkListenerWeakReference.get()) != null) {
            listener.onUserStatusChanged(userStatusList);
        }
    }

    public void notifyUserInfoChanged(List<UserInfo> userInfoList) {
        SDKListener listener;
        if (this.sdkListenerWeakReference != null && (listener = (SDKListener)this.sdkListenerWeakReference.get()) != null) {
            listener.onUserInfoChanged(userInfoList);
        }
    }

    public void notifyAllReceiveMessageOptChanged(ReceiveMessageOptInfo option) {
        SDKListener listener;
        if (this.sdkListenerWeakReference != null && (listener = (SDKListener)this.sdkListenerWeakReference.get()) != null) {
            listener.onAllReceiveMessageOptChanged(option);
        }
    }

    public void onExperimentalNotify(String key, Object param) {
        SDKListener listener;
        if (this.sdkListenerWeakReference != null && (listener = (SDKListener)this.sdkListenerWeakReference.get()) != null) {
            listener.onExperimentalNotify(key, param);
        }
    }

    public void enableSignaling(boolean enable) {
        this.userPreference.setEnableSignaling(enable);
        this.nativeSetUserPreference(this.userPreference);
    }

    public void getAIDenoiseSignature(IMCallback callback) {
        if (!this.isInit) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeGetAIDenoiseSignature(callback);
    }

    public void sendTRTCCustomData(byte[] data, IMCallback callback) {
        if (!this.isInit) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeSendTRTCCustomData(data, callback);
    }

    protected native void nativeInitSDK(SDKConfig var1, boolean var2, SDKListener var3);

    protected native void nativeUninitSDK();

    protected native void nativeNotifyNetworkChange(boolean var1, int var2, int var3, String var4, long var5, long var7, long var9);

    protected native void nativeLogin(String var1, String var2, IMCallback var3);

    protected native void nativeLogout(IMCallback var1);

    protected native void nativeSetCustomServerInfo(CustomServerInfo var1);

    protected native void nativeIsCommercialAbilityEnabled(long var1, IMCallback var3);

    protected native String nativeGetLoginUser();

    protected native int nativeGetLoginStatus();

    protected native String nativeGetSDKVersion();

    protected native long nativeGetClockTickInHz();

    protected native long nativeGetTimeTick();

    protected native long nativeGetServerTime();

    protected native void nativeInitLocalStorage(String var1, IMCallback var2);

    protected native void nativeReportTUIComponentUsage(Map<Long, Long> var1);

    protected native void nativeSetUserPreference(UserPreference var1);

    protected native void nativeGetAIDenoiseSignature(IMCallback var1);

    protected native void nativeSendTRTCCustomData(byte[] var1, IMCallback var2);

    static {
        try {
            mLoadLibrarySuccess = SystemUtil.loadIMLibrary();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)e.toString());
        }
    }

    private static class BaseManagerHolder {
        private static final BaseManager baseManager = new BaseManager();

        private BaseManagerHolder() {
        }
    }
}

