/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.imsdk.conversation;

import com.tencent.imsdk.common.IMCallback;
import com.tencent.imsdk.common.IMContext;
import com.tencent.imsdk.conversation.Conversation;
import com.tencent.imsdk.conversation.ConversationKey;
import com.tencent.imsdk.conversation.ConversationListFilter;
import com.tencent.imsdk.conversation.ConversationListener;
import com.tencent.imsdk.conversation.ConversationResult;
import com.tencent.imsdk.conversation.UnreadMessageCountResult;
import com.tencent.imsdk.manager.BaseManager;
import com.tencent.imsdk.message.DraftMessage;
import java.util.List;

public class ConversationManager {
    private static final String TAG = "ConversationManager";
    private ConversationListener mInternalConversationListener;
    private ConversationListener mConversationListener;

    public static ConversationManager getInstance() {
        return ConversationManagerHolder.conversationManager;
    }

    public void init() {
        this.initInternalConversationListener();
    }

    private void initInternalConversationListener() {
        if (this.mInternalConversationListener == null) {
            this.mInternalConversationListener = new ConversationListener(){

                @Override
                public void onSyncServerStart() {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (ConversationManager.this.mConversationListener != null) {
                                ConversationManager.this.mConversationListener.onSyncServerStart();
                            }
                        }
                    });
                }

                @Override
                public void onSyncServerFinish() {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (ConversationManager.this.mConversationListener != null) {
                                ConversationManager.this.mConversationListener.onSyncServerFinish();
                            }
                        }
                    });
                }

                @Override
                public void onSyncServerFailed() {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (ConversationManager.this.mConversationListener != null) {
                                ConversationManager.this.mConversationListener.onSyncServerFailed();
                            }
                        }
                    });
                }

                @Override
                public void onNewConversation(final List<Conversation> conversationList) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (ConversationManager.this.mConversationListener != null) {
                                ConversationManager.this.mConversationListener.onNewConversation(conversationList);
                            }
                        }
                    });
                }

                @Override
                public void onConversationChanged(final List<Conversation> conversationList) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (ConversationManager.this.mConversationListener != null) {
                                ConversationManager.this.mConversationListener.onConversationChanged(conversationList);
                            }
                        }
                    });
                }

                @Override
                public void onConversationDeleted(final List<String> conversationIDList) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (ConversationManager.this.mConversationListener != null) {
                                ConversationManager.this.mConversationListener.onConversationDeleted(conversationIDList);
                            }
                        }
                    });
                }

                @Override
                public void onUnreadMessageCountChanged(final UnreadMessageCountResult result) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (ConversationManager.this.mConversationListener != null) {
                                ConversationManager.this.mConversationListener.onUnreadMessageCountChanged(result);
                            }
                        }
                    });
                }

                @Override
                public void onConversationGroupCreated(final String groupName, final List<Conversation> conversationList) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (ConversationManager.this.mConversationListener != null) {
                                ConversationManager.this.mConversationListener.onConversationGroupCreated(groupName, conversationList);
                            }
                        }
                    });
                }

                @Override
                public void onConversationGroupDeleted(final String groupName) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (ConversationManager.this.mConversationListener != null) {
                                ConversationManager.this.mConversationListener.onConversationGroupDeleted(groupName);
                            }
                        }
                    });
                }

                @Override
                public void onConversationGroupNameChanged(final String oldName, final String newName) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (ConversationManager.this.mConversationListener != null) {
                                ConversationManager.this.mConversationListener.onConversationGroupNameChanged(oldName, newName);
                            }
                        }
                    });
                }

                @Override
                public void onConversationsAddedToGroup(final String groupName, final List<Conversation> conversationList) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (ConversationManager.this.mConversationListener != null) {
                                ConversationManager.this.mConversationListener.onConversationsAddedToGroup(groupName, conversationList);
                            }
                        }
                    });
                }

                @Override
                public void onConversationsDeletedFromGroup(final String groupName, final List<Conversation> conversationList) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (ConversationManager.this.mConversationListener != null) {
                                ConversationManager.this.mConversationListener.onConversationsDeletedFromGroup(groupName, conversationList);
                            }
                        }
                    });
                }

                @Override
                public void onConversationGroupOrderDataChanged(final String conversationGroupOrderData) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            BaseManager.getInstance().onExperimentalNotify("onConversationGroupOrderDataChanged", conversationGroupOrderData);
                        }
                    });
                }
            };
        }
        this.nativeSetConversationListener(this.mInternalConversationListener);
    }

    public void setConversationListener(ConversationListener conversationListener) {
        this.mConversationListener = conversationListener;
    }

    public void getConversationList(long nextSeq, int count, IMCallback<ConversationResult> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeGetConversationList(nextSeq, count, callback);
    }

    public void getConversationList(List<ConversationKey> conversationKeyList, IMCallback<List<Conversation>> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeGetConversations(conversationKeyList, callback);
    }

    public void getConversationListByFilter(ConversationListFilter filter, long nextSeq, int count, IMCallback<ConversationResult> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeGetConversationListByFilter(filter, nextSeq, count, callback);
    }

    public void getConversationInfo(ConversationKey conversationKey, IMCallback<Conversation> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeGetConversationInfo(conversationKey, callback);
    }

    public void deleteConversationList(List<ConversationKey> conversationKeyList, boolean clearMessage, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeDeleteConversationList(conversationKeyList, clearMessage, callback);
    }

    public void setConversationDraft(ConversationKey conversationKey, DraftMessage draftMessage, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeSetConversationDraft(conversationKey, draftMessage, callback);
    }

    public void pinConversation(ConversationKey conversationKey, boolean isPinned, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativePinConversation(conversationKey, isPinned, callback);
    }

    public void getTotalUnreadMessageCount(ConversationListFilter filter, IMCallback<UnreadMessageCountResult> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeGetTotalUnreadMessageCount(filter, callback);
    }

    public void subscribeUnreadMessageCountByFilter(ConversationListFilter filter) {
        if (!BaseManager.getInstance().isInited()) {
            return;
        }
        this.nativeSubscribeUnreadMessageCountByFilter(filter);
    }

    public void unsubscribeUnreadMessageCountByFilter(ConversationListFilter filter) {
        if (!BaseManager.getInstance().isInited()) {
            return;
        }
        this.nativeUnsubscribeUnreadMessageCountByFilter(filter);
    }

    public void setCosSaveRegionForConversation(ConversationKey conversationKey, String cosSaveRegion, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeSetCosSaveRegionForConversation(conversationKey, cosSaveRegion, callback);
    }

    public void clearUnreadMessage(boolean clearC2CUnreadMessage, boolean clearGroupUnreadMessage, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeClearUnreadMessage(clearC2CUnreadMessage, clearGroupUnreadMessage, callback);
    }

    public void markConversation(List<ConversationKey> conversationKeyList, long markType, boolean enableMark, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeMarkConversation(conversationKeyList, markType, enableMark, callback);
    }

    public void setConversationCustomData(List<ConversationKey> conversationKeyList, String customData, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeSetConversationCustomData(conversationKeyList, customData, callback);
    }

    public void createConversationGroup(String groupName, List<ConversationKey> conversationKeyList, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeCreateConversationGroup(groupName, conversationKeyList, callback);
    }

    public void getConversationGroupList(IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeGetConversationGroupList(callback);
    }

    public void deleteConversationGroup(String groupName, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeDeleteConversationGroup(groupName, callback);
    }

    public void renameConversationGroup(String oldName, String newName, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeRenameConversationGroup(oldName, newName, callback);
    }

    public void addConversationsToGroup(String groupName, List<ConversationKey> conversationKeyList, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeAddConversationsToGroup(groupName, conversationKeyList, callback);
    }

    public void deleteConversationsFromGroup(String groupName, List<ConversationKey> conversationKeyList, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeDeleteConversationsFromGroup(groupName, conversationKeyList, callback);
    }

    public void setConversationGroupOrderData(String conversationGroupOrderData, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeSetConversationGroupOrderData(conversationGroupOrderData, callback);
    }

    public void getConversationGroupOrderData(IMCallback<String> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeGetConversationGroupOrderData(callback);
    }

    protected native void nativeSetConversationListener(ConversationListener var1);

    protected native void nativeGetConversationList(long var1, int var3, IMCallback var4);

    protected native void nativeGetConversationListByFilter(ConversationListFilter var1, long var2, int var4, IMCallback var5);

    protected native void nativeGetConversations(List<ConversationKey> var1, IMCallback var2);

    protected native void nativeGetConversationInfo(ConversationKey var1, IMCallback var2);

    protected native void nativeDeleteConversationList(List<ConversationKey> var1, boolean var2, IMCallback var3);

    protected native void nativeSetConversationDraft(ConversationKey var1, DraftMessage var2, IMCallback var3);

    protected native void nativePinConversation(ConversationKey var1, boolean var2, IMCallback var3);

    protected native void nativeGetTotalUnreadMessageCount(ConversationListFilter var1, IMCallback var2);

    protected native void nativeSubscribeUnreadMessageCountByFilter(ConversationListFilter var1);

    protected native void nativeUnsubscribeUnreadMessageCountByFilter(ConversationListFilter var1);

    protected native void nativeSetCosSaveRegionForConversation(ConversationKey var1, String var2, IMCallback var3);

    protected native void nativeClearUnreadMessage(boolean var1, boolean var2, IMCallback var3);

    protected native void nativeMarkConversation(List<ConversationKey> var1, long var2, boolean var4, IMCallback var5);

    protected native void nativeSetConversationCustomData(List<ConversationKey> var1, String var2, IMCallback var3);

    protected native void nativeCreateConversationGroup(String var1, List<ConversationKey> var2, IMCallback var3);

    protected native void nativeGetConversationGroupList(IMCallback var1);

    protected native void nativeDeleteConversationGroup(String var1, IMCallback var2);

    protected native void nativeRenameConversationGroup(String var1, String var2, IMCallback var3);

    protected native void nativeAddConversationsToGroup(String var1, List<ConversationKey> var2, IMCallback var3);

    protected native void nativeDeleteConversationsFromGroup(String var1, List<ConversationKey> var2, IMCallback var3);

    protected native void nativeSetConversationGroupOrderData(String var1, IMCallback var2);

    protected native void nativeGetConversationGroupOrderData(IMCallback var1);

    private static class ConversationManagerHolder {
        private static final ConversationManager conversationManager = new ConversationManager();

        private ConversationManagerHolder() {
        }
    }
}

