/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.imsdk.v2;

import com.tencent.imsdk.common.IMCallback;
import com.tencent.imsdk.message.DownloadParam;
import com.tencent.imsdk.message.DownloadProgressInfo;
import com.tencent.imsdk.message.MessageBaseElement;
import com.tencent.imsdk.message.MessageCenter;
import com.tencent.imsdk.message.VideoElement;
import com.tencent.imsdk.v2.V2TIMCallback;
import com.tencent.imsdk.v2.V2TIMDownloadCallback;
import com.tencent.imsdk.v2.V2TIMElem;
import com.tencent.imsdk.v2.V2TIMValueCallback;

public class V2TIMVideoElem
extends V2TIMElem {
    public String getVideoPath() {
        if (this.getElement() == null) {
            return null;
        }
        VideoElement timVideoElem = (VideoElement)this.getElement();
        return timVideoElem.getVideoFilePath();
    }

    public String getVideoUUID() {
        if (this.getElement() == null) {
            return null;
        }
        VideoElement timVideoElem = (VideoElement)this.getElement();
        return timVideoElem.getVideoUUID();
    }

    public int getVideoSize() {
        if (this.getElement() == null) {
            return 0;
        }
        VideoElement timVideoElem = (VideoElement)this.getElement();
        return timVideoElem.getVideoFileSize();
    }

    public int getDuration() {
        if (this.getElement() == null) {
            return 0;
        }
        VideoElement timVideoElem = (VideoElement)this.getElement();
        return timVideoElem.getVideoDuration();
    }

    public void downloadVideo(String path, final V2TIMDownloadCallback v2TIMDownloadCallback) {
        if (this.getElement() == null) {
            if (v2TIMDownloadCallback != null) {
                v2TIMDownloadCallback.onError(6017, "getTIMElem is null");
            }
            return;
        }
        VideoElement videoElement = (VideoElement)this.getElement();
        DownloadParam downloadParam = new DownloadParam();
        downloadParam.setDownloadFlag(videoElement.getVideoDownloadFlag());
        downloadParam.setDownloadUrl(videoElement.getVideoDownloadUrl());
        downloadParam.setUuid(videoElement.getVideoUUID());
        downloadParam.setUuidType(MessageBaseElement.UUID_TYPE_VIDEO);
        downloadParam.setBusinessID(videoElement.getVideoBusinessID());
        downloadParam.setFileSavePath(path);
        V2TIMValueCallback<DownloadProgressInfo> v2TIMValueProgressCallback = new V2TIMValueCallback<DownloadProgressInfo>(){

            @Override
            public void onSuccess(DownloadProgressInfo downloadProgressInfo) {
                V2TIMElem.V2ProgressInfo v2ProgressInfo = new V2TIMElem.V2ProgressInfo(downloadProgressInfo.getCurrentSize(), downloadProgressInfo.getTotalSize());
                if (v2TIMDownloadCallback != null) {
                    v2TIMDownloadCallback.onProgress(v2ProgressInfo);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (v2TIMDownloadCallback != null) {
                    v2TIMDownloadCallback.onError(code, desc);
                }
            }
        };
        V2TIMCallback v2TIMCallback = new V2TIMCallback(){

            @Override
            public void onSuccess() {
                if (v2TIMDownloadCallback != null) {
                    v2TIMDownloadCallback.onSuccess();
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (v2TIMDownloadCallback != null) {
                    v2TIMDownloadCallback.onError(code, desc);
                }
            }
        };
        MessageCenter.getInstance().downloadMessageElement(downloadParam, new IMCallback<DownloadProgressInfo>((V2TIMValueCallback)v2TIMValueProgressCallback){

            @Override
            public void success(DownloadProgressInfo data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        }, new IMCallback(v2TIMCallback){

            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    public void getVideoUrl(V2TIMValueCallback<String> callback) {
        if (callback == null) {
            return;
        }
        if (this.getElement() == null) {
            callback.onError(6017, "elem is null");
            return;
        }
        VideoElement videoElement = (VideoElement)this.getElement();
        if (videoElement.getSnapshotDownloadFlag() == 2) {
            callback.onSuccess(videoElement.getVideoDownloadUrl());
        } else {
            DownloadParam downloadParam = new DownloadParam();
            downloadParam.setDownloadFlag(videoElement.getVideoDownloadFlag());
            downloadParam.setUuid(this.getVideoUUID());
            downloadParam.setUuidType(MessageBaseElement.UUID_TYPE_FILE);
            downloadParam.setBusinessID(videoElement.getVideoBusinessID());
            MessageCenter.getInstance().getDownloadUrl(downloadParam, new IMCallback<String>(callback){

                @Override
                public void success(String data) {
                    super.success(data);
                }

                @Override
                public void fail(int code, String errorMessage) {
                    super.fail(code, errorMessage);
                }
            });
        }
    }

    public String getSnapshotPath() {
        if (this.getElement() == null) {
            return null;
        }
        VideoElement timVideoElem = (VideoElement)this.getElement();
        return timVideoElem.getSnapshotFilePath();
    }

    public String getSnapshotUUID() {
        if (this.getElement() == null) {
            return null;
        }
        VideoElement timVideoElem = (VideoElement)this.getElement();
        return timVideoElem.getSnapshotUUID();
    }

    public int getSnapshotSize() {
        if (this.getElement() == null) {
            return 0;
        }
        VideoElement timVideoElem = (VideoElement)this.getElement();
        return timVideoElem.getSnapshotFileSize();
    }

    public int getSnapshotWidth() {
        if (this.getElement() == null) {
            return 0;
        }
        VideoElement timVideoElem = (VideoElement)this.getElement();
        return timVideoElem.getSnapshotWidth();
    }

    public int getSnapshotHeight() {
        if (this.getElement() == null) {
            return 0;
        }
        VideoElement timVideoElem = (VideoElement)this.getElement();
        return timVideoElem.getSnapshotHeight();
    }

    public void downloadSnapshot(String path, final V2TIMDownloadCallback v2TIMDownloadCallback) {
        if (this.getElement() == null) {
            return;
        }
        VideoElement videoElement = (VideoElement)this.getElement();
        DownloadParam downloadParam = new DownloadParam();
        downloadParam.setDownloadFlag(videoElement.getSnapshotDownloadFlag());
        downloadParam.setDownloadUrl(videoElement.getSnapshotDownloadUrl());
        downloadParam.setUuid(videoElement.getSnapshotUUID());
        downloadParam.setUuidType(MessageBaseElement.UUID_TYPE_VIDEO_THUMB);
        downloadParam.setBusinessID(videoElement.getVideoBusinessID());
        downloadParam.setFileSavePath(path);
        V2TIMValueCallback<DownloadProgressInfo> v2TIMValueProgressCallback = new V2TIMValueCallback<DownloadProgressInfo>(){

            @Override
            public void onSuccess(DownloadProgressInfo downloadProgressInfo) {
                V2TIMElem.V2ProgressInfo v2ProgressInfo = new V2TIMElem.V2ProgressInfo(downloadProgressInfo.getCurrentSize(), downloadProgressInfo.getTotalSize());
                if (v2TIMDownloadCallback != null) {
                    v2TIMDownloadCallback.onProgress(v2ProgressInfo);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (v2TIMDownloadCallback != null) {
                    v2TIMDownloadCallback.onError(code, desc);
                }
            }
        };
        V2TIMCallback v2TIMCallback = new V2TIMCallback(){

            @Override
            public void onSuccess() {
                if (v2TIMDownloadCallback != null) {
                    v2TIMDownloadCallback.onSuccess();
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (v2TIMDownloadCallback != null) {
                    v2TIMDownloadCallback.onError(code, desc);
                }
            }
        };
        MessageCenter.getInstance().downloadMessageElement(downloadParam, new IMCallback<DownloadProgressInfo>((V2TIMValueCallback)v2TIMValueProgressCallback){

            @Override
            public void success(DownloadProgressInfo data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        }, new IMCallback(v2TIMCallback){

            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    public void getSnapshotUrl(V2TIMValueCallback<String> callback) {
        if (callback == null) {
            return;
        }
        if (this.getElement() == null) {
            callback.onError(6017, "elem is null");
            return;
        }
        VideoElement videoElement = (VideoElement)this.getElement();
        if (videoElement.getSnapshotDownloadFlag() == 2) {
            callback.onSuccess(videoElement.getSnapshotDownloadUrl());
        } else {
            DownloadParam downloadParam = new DownloadParam();
            downloadParam.setDownloadFlag(videoElement.getSnapshotDownloadFlag());
            downloadParam.setUuid(this.getSnapshotUUID());
            downloadParam.setUuidType(MessageBaseElement.UUID_TYPE_FILE);
            downloadParam.setBusinessID(videoElement.getVideoBusinessID());
            MessageCenter.getInstance().getDownloadUrl(downloadParam, new IMCallback<String>(callback){

                @Override
                public void success(String data) {
                    super.success(data);
                }

                @Override
                public void fail(int code, String errorMessage) {
                    super.fail(code, errorMessage);
                }
            });
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("V2TIMVideoElem--->").append("video uuid:").append(this.getVideoUUID()).append(", snapshot uuid:").append(this.getSnapshotUUID()).append(", duration:").append(this.getDuration()).append(", sender local video path:").append(this.getVideoPath()).append(", video size:").append(this.getVideoSize()).append(", sender local snapshot path").append(this.getSnapshotPath()).append(", snapshot height:").append(this.getSnapshotHeight()).append(", snapshot width:").append(this.getSnapshotWidth()).append(", snapshot size:").append(this.getSnapshotSize());
        return stringBuilder.toString();
    }
}

