/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.imsdk.v2;

import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.tencent.imsdk.common.IMCallback;
import com.tencent.imsdk.common.IMContext;
import com.tencent.imsdk.common.IMLog;
import com.tencent.imsdk.common.SystemUtil;
import com.tencent.imsdk.manager.BaseManager;
import com.tencent.imsdk.message.CustomElement;
import com.tencent.imsdk.message.Message;
import com.tencent.imsdk.message.MessageBaseElement;
import com.tencent.imsdk.message.MessageCenter;
import com.tencent.imsdk.message.MessageUploadProgressCallback;
import com.tencent.imsdk.v2.V2TIMCallback;
import com.tencent.imsdk.v2.V2TIMManager;
import com.tencent.imsdk.v2.V2TIMMessage;
import com.tencent.imsdk.v2.V2TIMMessageManagerImpl;
import com.tencent.imsdk.v2.V2TIMOfflinePushInfo;
import com.tencent.imsdk.v2.V2TIMSignalingInfo;
import com.tencent.imsdk.v2.V2TIMSignalingListener;
import com.tencent.imsdk.v2.V2TIMSignalingManager;
import com.tencent.imsdk.v2.V2TIMValueCallback;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class V2TIMSignalingManagerImpl
extends V2TIMSignalingManager {
    private final String TAG = "V2TIMSigMgrImpl";
    private final int TIMEOUT_DELAY = 5;
    private CopyOnWriteArrayList<V2TIMSignalingListener> mSignalingListenerList;
    private boolean mHasValidSignalingListener = false;
    private List<V2TIMSignalingInfo> invitationList = new ArrayList<V2TIMSignalingInfo>();
    private Handler mTimeoutHandler;

    static V2TIMSignalingManagerImpl getInstance() {
        return V2TIMSignalingManagerImplHolder.v2TIMSignalingManagerImpl;
    }

    private V2TIMSignalingManagerImpl() {
        this.mSignalingListenerList = new CopyOnWriteArrayList();
        this.mTimeoutHandler = new Handler(Looper.getMainLooper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unInit() {
        V2TIMSignalingManagerImpl v2TIMSignalingManagerImpl = this;
        synchronized (v2TIMSignalingManagerImpl) {
            this.mSignalingListenerList.clear();
            this.mHasValidSignalingListener = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSignalingListener(V2TIMSignalingListener listener) {
        V2TIMSignalingManagerImpl v2TIMSignalingManagerImpl = this;
        synchronized (v2TIMSignalingManagerImpl) {
            if (this.mSignalingListenerList.contains(listener)) {
                return;
            }
            this.mSignalingListenerList.add(listener);
            this.mHasValidSignalingListener = true;
            this.checkSignalingListener();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSignalingListener(V2TIMSignalingListener listener) {
        V2TIMSignalingManagerImpl v2TIMSignalingManagerImpl = this;
        synchronized (v2TIMSignalingManagerImpl) {
            this.mSignalingListenerList.remove(listener);
            if (0 == this.mSignalingListenerList.size()) {
                this.mHasValidSignalingListener = false;
            }
            this.checkSignalingListener();
        }
    }

    private void checkSignalingListener() {
        BaseManager.getInstance().enableSignaling(this.mHasValidSignalingListener);
    }

    @Override
    public String invite(String invitee, String data, boolean onlineUserOnly, V2TIMOfflinePushInfo offlinePushInfo, int timeout, final V2TIMCallback callback) {
        if (TextUtils.isEmpty((CharSequence)invitee)) {
            if (callback != null) {
                callback.onError(6017, "invitee is empty");
            }
            IMLog.e("V2TIMSigMgrImpl", "signaling invite error, invitee is empty");
            return null;
        }
        String loginUser = V2TIMManager.getInstance().getLoginUser();
        if (TextUtils.isEmpty((CharSequence)loginUser)) {
            if (callback != null) {
                callback.onError(6014, "not login");
            }
            IMLog.e("V2TIMSigMgrImpl", "not login");
            return null;
        }
        final V2TIMSignalingInfo info = new V2TIMSignalingInfo();
        info.setBusinessID(1);
        info.setInviter(loginUser);
        ArrayList<String> inviteeList = new ArrayList<String>();
        inviteeList.add(invitee);
        info.setInviteeList(inviteeList);
        info.setData(data);
        info.setOnlineUserOnly(onlineUserOnly);
        info.setTimeout(timeout);
        info.setActionType(1);
        info.setOfflinePushInfo(offlinePushInfo);
        String srcInviteID = loginUser + System.currentTimeMillis() + new Random().nextInt(Integer.MAX_VALUE);
        String inviteID = SystemUtil.md5(srcInviteID);
        info.setInviteID(inviteID);
        V2TIMValueCallback<Message> v2TIMValueCallback = new V2TIMValueCallback<Message>(){

            @Override
            public void onSuccess(Message message) {
                V2TIMSignalingManagerImpl.this.invitationList.add(info);
                V2TIMSignalingManagerImpl.this.checkInviteTimeout(info);
                if (!info.isOnlineUserOnly()) {
                    V2TIMSignalingManagerImpl.this.notifyOnRecvMessage(message);
                }
                if (callback != null) {
                    callback.onSuccess();
                }
            }

            @Override
            public void onError(int code, String desc) {
                IMLog.e("V2TIMSigMgrImpl", "signaling sendSignalMessage failed code:" + code + ", desc:" + desc);
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        this.sendSignalMessage(info, v2TIMValueCallback, true);
        IMLog.i("V2TIMSigMgrImpl", "signaling invite, inviteID:" + info.getInviteID() + ", invitee:" + invitee + ", timeout:" + timeout);
        return info.getInviteID();
    }

    @Override
    public String inviteInGroup(String groupID, List<String> inviteeList, String data, boolean onlineUserOnly, int timeout, final V2TIMCallback callback) {
        if (TextUtils.isEmpty((CharSequence)groupID)) {
            if (callback != null) {
                callback.onError(6017, "groupID is empty");
            }
            IMLog.e("V2TIMSigMgrImpl", "signaling invite error, groupID is empty");
            return null;
        }
        if (inviteeList == null || inviteeList.size() == 0) {
            if (callback != null) {
                IMLog.e("V2TIMSigMgrImpl", "signaling invite error, inviteeList is empty");
                callback.onError(6017, "inviteeList is empty");
            }
            return null;
        }
        String loginUser = V2TIMManager.getInstance().getLoginUser();
        if (TextUtils.isEmpty((CharSequence)loginUser)) {
            if (callback != null) {
                callback.onError(6014, "not login");
            }
            IMLog.e("V2TIMSigMgrImpl", "not login");
            return null;
        }
        final V2TIMSignalingInfo info = new V2TIMSignalingInfo();
        info.setBusinessID(1);
        info.setInviter(loginUser);
        info.setGroupID(groupID);
        info.setInviteeList(inviteeList);
        info.setData(data);
        info.setOnlineUserOnly(onlineUserOnly);
        info.setTimeout(timeout);
        info.setActionType(1);
        String srcInviteID = loginUser + System.currentTimeMillis() + new Random().nextInt(Integer.MAX_VALUE);
        String inviteID = SystemUtil.md5(srcInviteID);
        info.setInviteID(inviteID);
        V2TIMValueCallback<Message> v2TIMValueCallback = new V2TIMValueCallback<Message>(){

            @Override
            public void onSuccess(Message message) {
                V2TIMSignalingManagerImpl.this.invitationList.add(info);
                V2TIMSignalingManagerImpl.this.checkInviteTimeout(info);
                if (!info.isOnlineUserOnly()) {
                    V2TIMSignalingManagerImpl.this.notifyOnRecvMessage(message);
                }
                if (callback != null) {
                    callback.onSuccess();
                }
            }

            @Override
            public void onError(int code, String desc) {
                IMLog.e("V2TIMSigMgrImpl", "signaling sendSignalMessage failed code:" + code + ", desc:" + desc);
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        this.sendSignalMessage(info, v2TIMValueCallback, true);
        IMLog.i("V2TIMSigMgrImpl", "signaling inviteInGroup, inviteID:" + info.getInviteID() + ", groupID:" + groupID + ", inviteeList:" + inviteeList + ", timeout:" + timeout);
        return info.getInviteID();
    }

    private void sendSignalMessage(V2TIMSignalingInfo info, V2TIMValueCallback<Message> valueCallback, boolean isInviter) {
        String signalingInfoJsonStr = this.signallingInfoToJsonString(info);
        byte[] signalingBytes = signalingInfoJsonStr.getBytes();
        CustomElement customElement = new CustomElement();
        customElement.setData(signalingBytes);
        Message message = new Message();
        if (info.isOnlineUserOnly()) {
            message.setLifeTime(0);
        }
        if (info.getOfflinePushInfo() != null) {
            message.setOfflinePushInfo(info.getOfflinePushInfo().getMessageOfflinePushInfo());
        }
        if (TextUtils.isEmpty((CharSequence)info.getGroupID())) {
            message.setMessageType(Message.MESSAGE_TYPE_C2C);
            if (isInviter) {
                message.setReceiverUserID(info.getInviteeList().get(0));
            } else {
                message.setReceiverUserID(info.getInviter());
            }
        } else {
            message.setMessageType(Message.MESSAGE_TYPE_GROUP);
            message.setGroupID(info.getGroupID());
        }
        message.addElement(customElement);
        MessageCenter.getInstance().sendMessage(message, new MessageUploadProgressCallback(){

            @Override
            public void onUploadProgress(int elemIndex, int currentSize, int totalSize) {
            }
        }, new IMCallback(valueCallback){

            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    private void checkInviteTimeout(final V2TIMSignalingInfo info) {
        if (info.getTimeout() <= 0) {
            IMLog.i("V2TIMSigMgrImpl", "signaling checkInviteTimeout timeout is <= 0, ignore to post delay task");
            return;
        }
        this.mTimeoutHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < V2TIMSignalingManagerImpl.this.invitationList.size(); ++i) {
                    final V2TIMSignalingInfo sinfo = (V2TIMSignalingInfo)V2TIMSignalingManagerImpl.this.invitationList.get(i);
                    if (!sinfo.getInviteID().equals(info.getInviteID()) || sinfo.getInviteeList().size() <= 0) continue;
                    IMLog.i("V2TIMSigMgrImpl", "signaling invite local timeout inviteID:" + info.getInviteID() + ", inviteeList:" + sinfo.getInviteeList());
                    final int originalActionType = sinfo.getActionType();
                    sinfo.setActionType(5);
                    sinfo.setOfflinePushInfo(null);
                    V2TIMSignalingManagerImpl.this.sendSignalMessage(sinfo, new V2TIMValueCallback<Message>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void onSuccess(Message message) {
                            V2TIMSignalingManagerImpl v2TIMSignalingManagerImpl = V2TIMSignalingManagerImpl.this;
                            synchronized (v2TIMSignalingManagerImpl) {
                                for (V2TIMSignalingListener listener : V2TIMSignalingManagerImpl.this.mSignalingListenerList) {
                                    if (listener == null) continue;
                                    listener.onInvitationTimeout(sinfo.getInviteID(), sinfo.getInviteeList());
                                }
                            }
                            V2TIMSignalingManagerImpl.this.invitationList.remove(sinfo);
                            if (!sinfo.isOnlineUserOnly()) {
                                V2TIMSignalingManagerImpl.this.notifyOnRecvMessage(message);
                            }
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void onError(int code, String desc) {
                            sinfo.setActionType(originalActionType);
                            V2TIMSignalingManagerImpl v2TIMSignalingManagerImpl = V2TIMSignalingManagerImpl.this;
                            synchronized (v2TIMSignalingManagerImpl) {
                                for (V2TIMSignalingListener listener : V2TIMSignalingManagerImpl.this.mSignalingListenerList) {
                                    if (listener == null) continue;
                                    listener.onInvitationTimeout(sinfo.getInviteID(), sinfo.getInviteeList());
                                }
                            }
                            V2TIMSignalingManagerImpl.this.invitationList.remove(sinfo);
                            IMLog.e("V2TIMSigMgrImpl", "signaling send timeout msg failed, inviteID: " + info.getInviteID() + ", code:" + code + ", desc:" + desc);
                        }
                    }, true);
                    break;
                }
            }
        }, (long)((info.getTimeout() + 5) * 1000));
    }

    @Override
    public void cancel(final String inviteID, final String data, final V2TIMCallback callback) {
        IMLog.i("V2TIMSigMgrImpl", "signaling cancel, inviteID:" + inviteID);
        if (TextUtils.isEmpty((CharSequence)inviteID)) {
            if (callback != null) {
                IMLog.e("V2TIMSigMgrImpl", "signaling cancel error, inviteID is empty");
                callback.onError(6017, "inviteID is empty");
            }
            return;
        }
        IMContext.getInstance().runOnMainThread(new Runnable(){

            @Override
            public void run() {
                String loginUser = V2TIMManager.getInstance().getLoginUser();
                if (TextUtils.isEmpty((CharSequence)loginUser)) {
                    if (callback != null) {
                        callback.onError(6014, "not login");
                    }
                    IMLog.e("V2TIMSigMgrImpl", "not login");
                    return;
                }
                boolean isFindFromInvitationList = false;
                for (int i = 0; i < V2TIMSignalingManagerImpl.this.invitationList.size(); ++i) {
                    final V2TIMSignalingInfo signalingInfo = (V2TIMSignalingInfo)V2TIMSignalingManagerImpl.this.invitationList.get(i);
                    if (!signalingInfo.getInviteID().equals(inviteID)) continue;
                    isFindFromInvitationList = true;
                    if (!signalingInfo.getInviter().equals(loginUser)) {
                        IMLog.e("V2TIMSigMgrImpl", "signaling cancel invite failed\uff0cthe invitation is not initiated by yourself");
                        if (callback == null) break;
                        callback.onError(8011, "the invitation is not initiated by yourself");
                        break;
                    }
                    final V2TIMSignalingInfo cancelSignalingInfo = new V2TIMSignalingInfo();
                    cancelSignalingInfo.setBusinessID(1);
                    cancelSignalingInfo.setInviteID(signalingInfo.getInviteID());
                    cancelSignalingInfo.setGroupID(signalingInfo.getGroupID());
                    cancelSignalingInfo.setInviter(signalingInfo.getInviter());
                    cancelSignalingInfo.setInviteeList(signalingInfo.getInviteeList());
                    cancelSignalingInfo.setData(data);
                    cancelSignalingInfo.setOnlineUserOnly(signalingInfo.isOnlineUserOnly());
                    cancelSignalingInfo.setActionType(2);
                    V2TIMSignalingManagerImpl.this.sendSignalMessage(cancelSignalingInfo, new V2TIMValueCallback<Message>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void onSuccess(Message message) {
                            V2TIMSignalingManagerImpl v2TIMSignalingManagerImpl = V2TIMSignalingManagerImpl.this;
                            synchronized (v2TIMSignalingManagerImpl) {
                                for (V2TIMSignalingListener listener : V2TIMSignalingManagerImpl.this.mSignalingListenerList) {
                                    if (listener == null) continue;
                                    listener.onInvitationCancelled(cancelSignalingInfo.getInviteID(), cancelSignalingInfo.getInviter(), cancelSignalingInfo.getData());
                                }
                            }
                            V2TIMSignalingManagerImpl.this.invitationList.remove(signalingInfo);
                            if (!cancelSignalingInfo.isOnlineUserOnly()) {
                                V2TIMSignalingManagerImpl.this.notifyOnRecvMessage(message);
                            }
                            if (callback != null) {
                                callback.onSuccess();
                            }
                        }

                        @Override
                        public void onError(int code, String desc) {
                            IMLog.e("V2TIMSigMgrImpl", "signaling cancel invite failed, inviteID: " + inviteID + ", code:" + code + ", desc:" + desc);
                            if (callback != null) {
                                callback.onError(code, desc);
                            }
                        }
                    }, true);
                    break;
                }
                if (!isFindFromInvitationList && callback != null) {
                    IMLog.e("V2TIMSigMgrImpl", "signaling cancel failed, inviteID is invalid or invitation has been processed inviteID:" + inviteID);
                    callback.onError(8010, "inviteID is invalid or invitation has been processed");
                }
            }
        });
    }

    @Override
    public void accept(final String inviteID, final String data, final V2TIMCallback callback) {
        IMLog.i("V2TIMSigMgrImpl", "signaling accept invite, inviteID:" + inviteID);
        if (TextUtils.isEmpty((CharSequence)inviteID)) {
            IMLog.e("V2TIMSigMgrImpl", "signaling accept failed, inviteID is empty");
            if (callback != null) {
                callback.onError(6017, "inviteID is null");
            }
            return;
        }
        IMContext.getInstance().runOnMainThread(new Runnable(){

            @Override
            public void run() {
                V2TIMSignalingManagerImpl.this.doResponse(inviteID, data, true, new V2TIMCallback(){

                    @Override
                    public void onError(int code, String desc) {
                        if (callback != null) {
                            callback.onError(code, desc);
                        }
                        IMLog.e("V2TIMSigMgrImpl", "signaling accept failed, inviteID:" + inviteID + ", code:" + code + ", desc:" + desc);
                    }

                    @Override
                    public void onSuccess() {
                        if (callback != null) {
                            callback.onSuccess();
                        }
                    }
                });
            }
        });
    }

    @Override
    public void reject(final String inviteID, final String data, final V2TIMCallback callback) {
        IMLog.i("V2TIMSigMgrImpl", "signaling reject invite, inviteID:" + inviteID);
        if (TextUtils.isEmpty((CharSequence)inviteID)) {
            IMLog.e("V2TIMSigMgrImpl", "signaling reject invite, inviteID is empty");
            if (callback != null) {
                callback.onError(6017, "inviteID is null");
            }
            return;
        }
        IMContext.getInstance().runOnMainThread(new Runnable(){

            @Override
            public void run() {
                V2TIMSignalingManagerImpl.this.doResponse(inviteID, data, false, new V2TIMCallback(){

                    @Override
                    public void onError(int code, String desc) {
                        if (callback != null) {
                            callback.onError(code, desc);
                        }
                        IMLog.e("V2TIMSigMgrImpl", "signaling reject failed, inviteID:" + inviteID + ", code:" + code + ", desc:" + desc);
                    }

                    @Override
                    public void onSuccess() {
                        if (callback != null) {
                            callback.onSuccess();
                        }
                    }
                });
            }
        });
    }

    private void doResponse(String inviteID, String data, final boolean isAccept, final V2TIMCallback callback) {
        boolean isFindFromInvitationList = false;
        final String loginUser = V2TIMManager.getInstance().getLoginUser();
        if (TextUtils.isEmpty((CharSequence)loginUser)) {
            if (callback != null) {
                callback.onError(6014, "not login");
            }
            IMLog.e("V2TIMSigMgrImpl", "not login");
            return;
        }
        for (int i = 0; i < this.invitationList.size(); ++i) {
            final V2TIMSignalingInfo sinfo = this.invitationList.get(i);
            if (!sinfo.getInviteID().equals(inviteID) || !sinfo.getInviteeList().contains(loginUser)) continue;
            isFindFromInvitationList = true;
            final V2TIMSignalingInfo rspSignalingInfo = new V2TIMSignalingInfo();
            rspSignalingInfo.setBusinessID(1);
            rspSignalingInfo.setInviteID(sinfo.getInviteID());
            rspSignalingInfo.setGroupID(sinfo.getGroupID());
            rspSignalingInfo.setInviter(sinfo.getInviter());
            rspSignalingInfo.addInvitee(loginUser);
            rspSignalingInfo.setData(data);
            rspSignalingInfo.setOnlineUserOnly(sinfo.isOnlineUserOnly());
            if (isAccept) {
                rspSignalingInfo.setActionType(3);
            } else {
                rspSignalingInfo.setActionType(4);
            }
            this.sendSignalMessage(rspSignalingInfo, new V2TIMValueCallback<Message>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onSuccess(Message message) {
                    V2TIMSignalingManagerImpl v2TIMSignalingManagerImpl = V2TIMSignalingManagerImpl.this;
                    synchronized (v2TIMSignalingManagerImpl) {
                        for (V2TIMSignalingListener listener : V2TIMSignalingManagerImpl.this.mSignalingListenerList) {
                            if (listener == null) continue;
                            if (isAccept) {
                                listener.onInviteeAccepted(rspSignalingInfo.getInviteID(), rspSignalingInfo.getInviteeList().get(0), rspSignalingInfo.getData());
                                continue;
                            }
                            listener.onInviteeRejected(rspSignalingInfo.getInviteID(), rspSignalingInfo.getInviteeList().get(0), rspSignalingInfo.getData());
                        }
                    }
                    sinfo.getInviteeList().remove(loginUser);
                    if (sinfo.getInviteeList().size() == 0) {
                        V2TIMSignalingManagerImpl.this.invitationList.remove(sinfo);
                    }
                    if (!rspSignalingInfo.isOnlineUserOnly()) {
                        V2TIMSignalingManagerImpl.this.notifyOnRecvMessage(message);
                    }
                    if (callback != null) {
                        callback.onSuccess();
                    }
                }

                @Override
                public void onError(int code, String desc) {
                    if (callback != null) {
                        callback.onError(code, desc);
                    }
                }
            }, false);
            break;
        }
        if (!isFindFromInvitationList) {
            IMLog.e("V2TIMSigMgrImpl", "signaling doResponse failed, inviteID is invalid or invitation has been processed inviteID:" + inviteID);
            if (callback != null) {
                callback.onError(8010, "inviteID is invalid or invitation has been processed");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected V2TIMSignalingInfo processSignalingMessage(V2TIMMessage v2TIMMessage) {
        if (!this.mHasValidSignalingListener) {
            return null;
        }
        final V2TIMSignalingInfo info = this.getSignalingInfo(v2TIMMessage);
        if (info == null) {
            return null;
        }
        switch (info.getActionType()) {
            case 1: {
                String loginUser;
                int timeInterval = (int)(V2TIMManager.getInstance().getServerTime() - v2TIMMessage.getTimestamp());
                if (info.getTimeout() > 0 && timeInterval > info.getTimeout()) {
                    IMLog.d("V2TIMSigMgrImpl", "signaling receive invitation but ignore to callback because timeInterval:" + timeInterval + " > timeout:" + info.getTimeout());
                    return info;
                }
                boolean isRepeatSignalingInfo = false;
                for (V2TIMSignalingInfo v2TIMSignalingInfo : this.invitationList) {
                    if (!TextUtils.equals((CharSequence)v2TIMSignalingInfo.getInviteID(), (CharSequence)info.getInviteID())) continue;
                    isRepeatSignalingInfo = true;
                    break;
                }
                if (!isRepeatSignalingInfo) {
                    this.invitationList.add(info);
                }
                if (!TextUtils.isEmpty((CharSequence)(loginUser = V2TIMManager.getInstance().getLoginUser())) && info.getInviteeList().contains(loginUser) && info.getTimeout() > 0) {
                    this.mTimeoutHandler.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            for (int i = 0; i < V2TIMSignalingManagerImpl.this.invitationList.size(); ++i) {
                                final V2TIMSignalingInfo sinfo = (V2TIMSignalingInfo)V2TIMSignalingManagerImpl.this.invitationList.get(i);
                                if (!sinfo.getInviteID().equals(info.getInviteID()) || !sinfo.getInviteeList().contains(loginUser)) continue;
                                IMLog.i("V2TIMSigMgrImpl", "signaling receive invite but local timeout, inviteID:" + info.getInviteID());
                                final V2TIMSignalingInfo timeoutInfo = new V2TIMSignalingInfo();
                                timeoutInfo.setBusinessID(1);
                                timeoutInfo.setInviteID(info.getInviteID());
                                timeoutInfo.setGroupID(info.getGroupID());
                                timeoutInfo.setInviter(info.getInviter());
                                timeoutInfo.addInvitee(loginUser);
                                timeoutInfo.setActionType(5);
                                timeoutInfo.setOnlineUserOnly(info.isOnlineUserOnly());
                                timeoutInfo.setData(info.getData());
                                V2TIMSignalingManagerImpl.this.sendSignalMessage(timeoutInfo, new V2TIMValueCallback<Message>(){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    @Override
                                    public void onSuccess(Message message) {
                                        V2TIMSignalingManagerImpl.this.notifyOnRecvMessage(message);
                                        V2TIMSignalingManagerImpl.this.invitationList.remove(sinfo);
                                        V2TIMSignalingManagerImpl v2TIMSignalingManagerImpl = V2TIMSignalingManagerImpl.this;
                                        synchronized (v2TIMSignalingManagerImpl) {
                                            for (V2TIMSignalingListener listener : V2TIMSignalingManagerImpl.this.mSignalingListenerList) {
                                                if (listener == null) continue;
                                                listener.onInvitationTimeout(timeoutInfo.getInviteID(), timeoutInfo.getInviteeList());
                                            }
                                        }
                                    }

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    @Override
                                    public void onError(int code, String desc) {
                                        V2TIMSignalingManagerImpl.this.invitationList.remove(sinfo);
                                        V2TIMSignalingManagerImpl v2TIMSignalingManagerImpl = V2TIMSignalingManagerImpl.this;
                                        synchronized (v2TIMSignalingManagerImpl) {
                                            for (V2TIMSignalingListener listener : V2TIMSignalingManagerImpl.this.mSignalingListenerList) {
                                                if (listener == null) continue;
                                                listener.onInvitationTimeout(timeoutInfo.getInviteID(), timeoutInfo.getInviteeList());
                                            }
                                        }
                                        IMLog.e("V2TIMSigMgrImpl", "signaling send timeout msg failed, inviteID:" + timeoutInfo.getInviteID() + ", code:" + code + ", desc:" + desc);
                                    }
                                }, false);
                                return;
                            }
                        }
                    }, (long)(info.getTimeout() * 1000));
                }
                IMLog.i("V2TIMSigMgrImpl", "signaling receive invitation, inviteID:" + info.getInviteID() + ", inviter:" + info.getInviter() + ", groupID:" + info.getGroupID() + ", inviteeList:" + info.getInviteeList());
                V2TIMSignalingManagerImpl v2TIMSignalingManagerImpl = this;
                synchronized (v2TIMSignalingManagerImpl) {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.addAll(info.getInviteeList());
                    for (V2TIMSignalingListener listener : this.mSignalingListenerList) {
                        if (listener == null) continue;
                        listener.onReceiveNewInvitation(info.getInviteID(), info.getInviter(), info.getGroupID(), arrayList, info.getData());
                    }
                    break;
                }
            }
            case 2: {
                IMLog.i("V2TIMSigMgrImpl", "signaling receive cancel, inviteID:" + info.getInviteID() + ", inviter:" + info.getInviter());
                for (V2TIMSignalingInfo v2TIMSignalingInfo : this.invitationList) {
                    if (!v2TIMSignalingInfo.getInviteID().equals(info.getInviteID())) continue;
                    this.invitationList.remove(v2TIMSignalingInfo);
                    break;
                }
                V2TIMSignalingManagerImpl v2TIMSignalingManagerImpl = this;
                synchronized (v2TIMSignalingManagerImpl) {
                    for (V2TIMSignalingListener v2TIMSignalingListener : this.mSignalingListenerList) {
                        if (v2TIMSignalingListener == null) continue;
                        v2TIMSignalingListener.onInvitationCancelled(info.getInviteID(), info.getInviter(), info.getData());
                    }
                    break;
                }
            }
            case 3: {
                if (info.getInviteeList().size() == 0) {
                    IMLog.e("V2TIMSigMgrImpl", "signaling receive accept but accepter is empty");
                    return info;
                }
                String string = info.getInviteeList().get(0);
                IMLog.i("V2TIMSigMgrImpl", "signaling receive accept, inviteID:" + info.getInviteID() + ", accepter:" + string);
                for (V2TIMSignalingInfo v2TIMSignalingInfo : this.invitationList) {
                    if (!v2TIMSignalingInfo.getInviteID().equals(info.getInviteID())) continue;
                    v2TIMSignalingInfo.getInviteeList().remove(string);
                    if (v2TIMSignalingInfo.getInviteeList().size() != 0) break;
                    this.invitationList.remove(v2TIMSignalingInfo);
                    break;
                }
                V2TIMSignalingManagerImpl v2TIMSignalingManagerImpl = this;
                synchronized (v2TIMSignalingManagerImpl) {
                    for (V2TIMSignalingListener listener : this.mSignalingListenerList) {
                        if (listener == null) continue;
                        listener.onInviteeAccepted(info.getInviteID(), string, info.getData());
                    }
                    break;
                }
            }
            case 4: {
                if (info.getInviteeList().size() == 0) {
                    IMLog.e("V2TIMSigMgrImpl", "signaling receive reject but rejecter is empty");
                    return info;
                }
                String string = info.getInviteeList().get(0);
                IMLog.i("V2TIMSigMgrImpl", "signaling receive reject, inviteID:" + info.getInviteID() + ", rejecter:" + string);
                for (V2TIMSignalingInfo sinfo : this.invitationList) {
                    if (!sinfo.getInviteID().equals(info.getInviteID())) continue;
                    sinfo.getInviteeList().remove(string);
                    if (sinfo.getInviteeList().size() != 0) break;
                    this.invitationList.remove(sinfo);
                    break;
                }
                V2TIMSignalingManagerImpl v2TIMSignalingManagerImpl = this;
                synchronized (v2TIMSignalingManagerImpl) {
                    for (V2TIMSignalingListener listener : this.mSignalingListenerList) {
                        if (listener == null) continue;
                        listener.onInviteeRejected(info.getInviteID(), string, info.getData());
                    }
                    break;
                }
            }
            case 5: {
                List<String> list = info.getInviteeList();
                if (list.size() == 0) {
                    IMLog.e("V2TIMSigMgrImpl", "signaling receive timeout but timeouters is empty");
                    return info;
                }
                IMLog.i("V2TIMSigMgrImpl", "signaling receive timeout, inviteID:" + info.getInviteID() + ", timeouters:" + list);
                for (V2TIMSignalingInfo sinfo : this.invitationList) {
                    if (!sinfo.getInviteID().equals(info.getInviteID())) continue;
                    sinfo.getInviteeList().removeAll(list);
                    if (sinfo.getInviteeList().size() != 0) break;
                    this.invitationList.remove(sinfo);
                    break;
                }
                V2TIMSignalingManagerImpl v2TIMSignalingManagerImpl = this;
                synchronized (v2TIMSignalingManagerImpl) {
                    for (V2TIMSignalingListener listener : this.mSignalingListenerList) {
                        if (listener == null) continue;
                        listener.onInvitationTimeout(info.getInviteID(), list);
                    }
                    break;
                }
            }
            default: {
                IMLog.e("V2TIMSigMgrImpl", "signaling unknown action type:" + info.getActionType());
            }
        }
        return info;
    }

    private void notifyOnRecvMessage(Message message) {
        V2TIMMessage v2TIMMessage = new V2TIMMessage();
        v2TIMMessage.setMessage(message);
        V2TIMMessageManagerImpl.getInstance().onRecvNewMessage(v2TIMMessage);
    }

    @Override
    public V2TIMSignalingInfo getSignalingInfo(V2TIMMessage msg) {
        if (msg == null || msg.getElemType() != 2) {
            return null;
        }
        V2TIMSignalingInfo info = null;
        Message message = msg.getMessage();
        for (int i = 0; i < message.getMessageBaseElements().size(); ++i) {
            byte[] bytes;
            MessageBaseElement elem = message.getMessageBaseElements().get(i);
            if (!(elem instanceof CustomElement) || (bytes = ((CustomElement)elem).getData()) == null) continue;
            try {
                info = this.jsonStringToSignallingInfo(new String(bytes));
            }
            catch (Exception e) {
                IMLog.i("V2TIMSigMgrImpl", "getSignalingInfo exception:" + e);
            }
            if (info != null && info.getBusinessID() == 1) break;
            return null;
        }
        return info;
    }

    @Override
    public void addInvitedSignaling(final V2TIMSignalingInfo info, final V2TIMCallback callback) {
        if (info == null || TextUtils.isEmpty((CharSequence)info.getInviteID()) || TextUtils.isEmpty((CharSequence)info.getInviter()) || info.getInviteeList() == null || info.getInviteeList().isEmpty()) {
            IMLog.e("V2TIMSigMgrImpl", "addInvitedSignaling, info is invalid");
            if (callback != null) {
                callback.onError(6017, "V2TIMSignalingInfo is invalid");
            }
            return;
        }
        for (V2TIMSignalingInfo i : this.invitationList) {
            if (!TextUtils.equals((CharSequence)i.getInviteID(), (CharSequence)info.getInviteID())) continue;
            if (callback != null) {
                callback.onError(8012, "inviteID " + info.getInviteID() + " is exist");
            }
            return;
        }
        IMContext.getInstance().runOnMainThread(new Runnable(){

            @Override
            public void run() {
                V2TIMSignalingInfo infoClone = info.clone();
                V2TIMSignalingManagerImpl.this.invitationList.add(infoClone);
                if (callback != null) {
                    callback.onSuccess();
                }
            }
        });
    }

    private String signallingInfoToJsonString(V2TIMSignalingInfo info) {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("businessID", info.getBusinessID());
            jsonObject.put("inviteID", (Object)info.getInviteID());
            jsonObject.put("groupID", (Object)info.getGroupID());
            jsonObject.put("inviter", (Object)info.getInviter());
            JSONArray jsonArray = new JSONArray();
            for (String invitee : info.getInviteeList()) {
                jsonArray.put((Object)invitee);
            }
            jsonObject.put("inviteeList", (Object)jsonArray);
            jsonObject.put("data", (Object)info.getData());
            jsonObject.put("timeout", info.getTimeout());
            jsonObject.put("actionType", info.getActionType());
            jsonObject.put("onlineUserOnly", info.isOnlineUserOnly());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return jsonObject.toString();
    }

    private V2TIMSignalingInfo jsonStringToSignallingInfo(String jsonString) {
        V2TIMSignalingInfo info = new V2TIMSignalingInfo();
        try {
            JSONObject jsonObject = new JSONObject(jsonString);
            info.setBusinessID(jsonObject.optInt("businessID"));
            info.setInviteID(jsonObject.optString("inviteID"));
            info.setGroupID(jsonObject.optString("groupID"));
            info.setInviter(jsonObject.optString("inviter"));
            JSONArray jsonArray = jsonObject.optJSONArray("inviteeList");
            if (jsonArray != null && jsonArray.length() > 0) {
                ArrayList<String> inviteeList = new ArrayList<String>();
                for (int i = 0; i < jsonArray.length(); ++i) {
                    inviteeList.add(jsonArray.optString(i));
                }
                info.setInviteeList(inviteeList);
            }
            info.setData(jsonObject.optString("data"));
            info.setTimeout(jsonObject.optInt("timeout"));
            info.setActionType(jsonObject.optInt("actionType"));
            info.setOnlineUserOnly(jsonObject.optBoolean("onlineUserOnly"));
        }
        catch (JSONException e) {
            IMLog.i("V2TIMSigMgrImpl", "custom data is not json format!");
        }
        return info;
    }

    private static class V2TIMSignalingManagerImplHolder {
        private static final V2TIMSignalingManagerImpl v2TIMSignalingManagerImpl = new V2TIMSignalingManagerImpl();

        private V2TIMSignalingManagerImplHolder() {
        }
    }
}

