/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.imsdk.v2;

import android.text.TextUtils;
import com.tencent.imsdk.common.IMCallback;
import com.tencent.imsdk.common.IMContext;
import com.tencent.imsdk.common.IMLog;
import com.tencent.imsdk.conversation.ConversationManager;
import com.tencent.imsdk.group.GroupManager;
import com.tencent.imsdk.group.GroupMemberInfo;
import com.tencent.imsdk.manager.BaseManager;
import com.tencent.imsdk.message.C2CMessageReceipt;
import com.tencent.imsdk.message.CustomElement;
import com.tencent.imsdk.message.FaceElement;
import com.tencent.imsdk.message.FileElement;
import com.tencent.imsdk.message.GroupMessageReadMembers;
import com.tencent.imsdk.message.GroupMessageReceipt;
import com.tencent.imsdk.message.ImageElement;
import com.tencent.imsdk.message.LocationElement;
import com.tencent.imsdk.message.MergerElement;
import com.tencent.imsdk.message.Message;
import com.tencent.imsdk.message.MessageCenter;
import com.tencent.imsdk.message.MessageKey;
import com.tencent.imsdk.message.MessageListGetOption;
import com.tencent.imsdk.message.MessageListener;
import com.tencent.imsdk.message.MessageSearchResult;
import com.tencent.imsdk.message.MessageUploadProgressCallback;
import com.tencent.imsdk.message.SoundElement;
import com.tencent.imsdk.message.TextElement;
import com.tencent.imsdk.message.VideoElement;
import com.tencent.imsdk.relationship.ReceiveMessageOptInfo;
import com.tencent.imsdk.relationship.RelationshipManager;
import com.tencent.imsdk.v2.V2TIMAdvancedMsgListener;
import com.tencent.imsdk.v2.V2TIMCallback;
import com.tencent.imsdk.v2.V2TIMGroupMessageReadMemberList;
import com.tencent.imsdk.v2.V2TIMMessage;
import com.tencent.imsdk.v2.V2TIMMessageListGetOption;
import com.tencent.imsdk.v2.V2TIMMessageManager;
import com.tencent.imsdk.v2.V2TIMMessageReceipt;
import com.tencent.imsdk.v2.V2TIMMessageSearchParam;
import com.tencent.imsdk.v2.V2TIMMessageSearchResult;
import com.tencent.imsdk.v2.V2TIMOfflinePushInfo;
import com.tencent.imsdk.v2.V2TIMReceiveMessageOptInfo;
import com.tencent.imsdk.v2.V2TIMSendCallback;
import com.tencent.imsdk.v2.V2TIMSignalingInfo;
import com.tencent.imsdk.v2.V2TIMSignalingManagerImpl;
import com.tencent.imsdk.v2.V2TIMValueCallback;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class V2TIMMessageManagerImpl
extends V2TIMMessageManager {
    private final String TAG = "V2TIMMessageManagerImpl";
    private final int MAX_FORWARD_COUNT = 300;
    private final int MAX_ABSTRACT_COUNT = 5;
    private final int MAX_ABSTRACT_LENGTH = 100;
    private Object mLockObject = new Object();
    private MessageListener mMessageListener;
    private List<V2TIMAdvancedMsgListener> mV2TIMMsgListenerList = new CopyOnWriteArrayList<V2TIMAdvancedMsgListener>();

    static V2TIMMessageManagerImpl getInstance() {
        return V2TIMMessageManagerImplHolder.v2TIMMessageManagerImpl;
    }

    private V2TIMMessageManagerImpl() {
    }

    void initListener() {
        this.mMessageListener = new MessageListener(){

            @Override
            public void onReceiveNewMessage(List<Message> messageList) {
                if (messageList == null || messageList.isEmpty()) {
                    return;
                }
                for (Message message : messageList) {
                    V2TIMMessage v2TIMMessage = new V2TIMMessage();
                    v2TIMMessage.setMessage(message);
                    V2TIMSignalingInfo v2TIMSignalingInfo = V2TIMSignalingManagerImpl.getInstance().processSignalingMessage(v2TIMMessage);
                    if (v2TIMSignalingInfo != null && v2TIMSignalingInfo.isOnlineUserOnly()) continue;
                    V2TIMMessageManagerImpl.this.onRecvNewMessage(v2TIMMessage);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onReceiveC2CMessageReceipt(List<C2CMessageReceipt> receiptList) {
                ArrayList<V2TIMMessageReceipt> v2TIMMessageReceiptList = new ArrayList<V2TIMMessageReceipt>();
                for (C2CMessageReceipt messageReceipt : receiptList) {
                    V2TIMMessageReceipt v2TIMMessageReceipt = new V2TIMMessageReceipt();
                    v2TIMMessageReceipt.setC2CMessageReceipt(messageReceipt);
                    v2TIMMessageReceiptList.add(v2TIMMessageReceipt);
                }
                Object object = V2TIMMessageManagerImpl.this.mLockObject;
                synchronized (object) {
                    for (V2TIMAdvancedMsgListener listener : V2TIMMessageManagerImpl.this.mV2TIMMsgListenerList) {
                        listener.onRecvC2CReadReceipt(v2TIMMessageReceiptList);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onReceiveGroupMessageReceipt(List<GroupMessageReceipt> receiptList) {
                ArrayList<V2TIMMessageReceipt> v2TIMMessageReadReceiptList = new ArrayList<V2TIMMessageReceipt>();
                for (GroupMessageReceipt messageReceipt : receiptList) {
                    V2TIMMessageReceipt v2TIMMessageReadReceipt = new V2TIMMessageReceipt();
                    v2TIMMessageReadReceipt.setGroupMessageReceipt(messageReceipt);
                    v2TIMMessageReadReceiptList.add(v2TIMMessageReadReceipt);
                }
                Object object = V2TIMMessageManagerImpl.this.mLockObject;
                synchronized (object) {
                    for (V2TIMAdvancedMsgListener listener : V2TIMMessageManagerImpl.this.mV2TIMMsgListenerList) {
                        listener.onRecvMessageReadReceipts(v2TIMMessageReadReceiptList);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onReceiveMessageRevoked(List<MessageKey> keyList) {
                if (keyList == null || keyList.isEmpty()) {
                    return;
                }
                for (MessageKey messageKey : keyList) {
                    Object object = V2TIMMessageManagerImpl.this.mLockObject;
                    synchronized (object) {
                        for (V2TIMAdvancedMsgListener listener : V2TIMMessageManagerImpl.this.mV2TIMMsgListenerList) {
                            listener.onRecvMessageRevoked(messageKey.getMessageID());
                        }
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onReceiveMessageModified(List<Message> messageList) {
                for (Message message : messageList) {
                    V2TIMMessage v2TIMMessage = new V2TIMMessage();
                    v2TIMMessage.setMessage(message);
                    Object object = V2TIMMessageManagerImpl.this.mLockObject;
                    synchronized (object) {
                        for (V2TIMAdvancedMsgListener listener : V2TIMMessageManagerImpl.this.mV2TIMMsgListenerList) {
                            listener.onRecvMessageModified(v2TIMMessage);
                        }
                    }
                }
            }
        };
        MessageCenter.getInstance().addMessageListener(this.mMessageListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onRecvNewMessage(V2TIMMessage v2TIMMessage) {
        Object object = this.mLockObject;
        synchronized (object) {
            for (V2TIMAdvancedMsgListener listener : this.mV2TIMMsgListenerList) {
                listener.onRecvNewMessage(v2TIMMessage);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAdvancedMsgListener(V2TIMAdvancedMsgListener listener) {
        if (listener == null) {
            return;
        }
        Object object = this.mLockObject;
        synchronized (object) {
            if (this.mV2TIMMsgListenerList.contains(listener)) {
                return;
            }
            this.mV2TIMMsgListenerList.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAdvancedMsgListener(V2TIMAdvancedMsgListener listener) {
        if (listener == null) {
            return;
        }
        Object object = this.mLockObject;
        synchronized (object) {
            this.mV2TIMMsgListenerList.remove(listener);
        }
    }

    @Override
    public V2TIMMessage createTextMessage(String text) {
        V2TIMMessage v2TIMMessage = new V2TIMMessage();
        Message message = v2TIMMessage.getMessage();
        TextElement textElement = new TextElement();
        textElement.setTextContent(text);
        message.addElement(textElement);
        return v2TIMMessage;
    }

    @Override
    public V2TIMMessage createTextAtMessage(String text, List<String> atUserList) {
        V2TIMMessage v2TIMMessage = new V2TIMMessage();
        Message message = v2TIMMessage.getMessage();
        TextElement textElement = new TextElement();
        textElement.setTextContent(text);
        message.addElement(textElement);
        v2TIMMessage.setGroupAtUserList(atUserList);
        return v2TIMMessage;
    }

    @Override
    public V2TIMMessage createCustomMessage(byte[] data) {
        V2TIMMessage v2TIMMessage = new V2TIMMessage();
        Message message = v2TIMMessage.getMessage();
        CustomElement customElement = new CustomElement();
        customElement.setData(data);
        message.addElement(customElement);
        return v2TIMMessage;
    }

    @Override
    public V2TIMMessage createCustomMessage(byte[] data, String description, byte[] extension) {
        V2TIMMessage v2TIMMessage = new V2TIMMessage();
        Message message = v2TIMMessage.getMessage();
        CustomElement customElement = new CustomElement();
        customElement.setData(data);
        customElement.setDescription(description);
        customElement.setExtension(extension);
        message.addElement(customElement);
        return v2TIMMessage;
    }

    @Override
    public V2TIMMessage createImageMessage(String imagePath) {
        V2TIMMessage v2TIMMessage = new V2TIMMessage();
        Message message = v2TIMMessage.getMessage();
        ImageElement imageElement = new ImageElement();
        imageElement.setOriginImageFilePath(imagePath);
        message.addElement(imageElement);
        return v2TIMMessage;
    }

    @Override
    public V2TIMMessage createSoundMessage(String soundPath, int duration) {
        V2TIMMessage v2TIMMessage = new V2TIMMessage();
        Message message = v2TIMMessage.getMessage();
        SoundElement soundElement = new SoundElement();
        if (duration < 0) {
            duration = 0;
        }
        soundElement.setSoundDuration(duration);
        soundElement.setSoundFilePath(soundPath);
        message.addElement(soundElement);
        return v2TIMMessage;
    }

    @Override
    public V2TIMMessage createVideoMessage(String videoFilePath, String type, int duration, String snapshotPath) {
        V2TIMMessage v2TIMMessage = new V2TIMMessage();
        Message message = v2TIMMessage.getMessage();
        VideoElement videoElement = new VideoElement();
        videoElement.setVideoFilePath(videoFilePath);
        videoElement.setSnapshotFilePath(snapshotPath);
        if (duration < 0) {
            duration = 0;
        }
        videoElement.setVideoDuration(duration);
        videoElement.setVideoType(type);
        message.addElement(videoElement);
        return v2TIMMessage;
    }

    @Override
    public V2TIMMessage createFileMessage(String filePath, String fileName) {
        File file = new File(filePath);
        if (file.exists()) {
            V2TIMMessage v2TIMMessage = new V2TIMMessage();
            Message message = v2TIMMessage.getMessage();
            FileElement fileElement = new FileElement();
            fileElement.setFilePath(filePath);
            fileElement.setFileName(fileName);
            message.addElement(fileElement);
            return v2TIMMessage;
        }
        return null;
    }

    @Override
    public V2TIMMessage createLocationMessage(String desc, double longitude, double latitude) {
        V2TIMMessage v2TIMMessage = new V2TIMMessage();
        Message message = v2TIMMessage.getMessage();
        LocationElement locationElement = new LocationElement();
        locationElement.setLongitude(longitude);
        locationElement.setLatitude(latitude);
        locationElement.setDescription(desc);
        message.addElement(locationElement);
        return v2TIMMessage;
    }

    @Override
    public V2TIMMessage createFaceMessage(int index, byte[] data) {
        V2TIMMessage v2TIMMessage = new V2TIMMessage();
        Message message = v2TIMMessage.getMessage();
        FaceElement faceElement = new FaceElement();
        faceElement.setFaceData(data);
        faceElement.setFaceIndex(index);
        message.addElement(faceElement);
        return v2TIMMessage;
    }

    @Override
    public V2TIMMessage createMergerMessage(List<V2TIMMessage> messageList, String title, List<String> abstractList, String compatibleText) {
        if (messageList == null || messageList.size() == 0 || messageList.size() > 300) {
            IMLog.e("V2TIMMessageManagerImpl", "messageList invalid, the number of messageList must be between 1 and 300");
            return null;
        }
        ArrayList<String> abstractListAdjust = new ArrayList<String>();
        if (abstractList != null) {
            int abstractCount = abstractList.size();
            abstractCount = abstractCount >= 5 ? 5 : abstractCount;
            for (int i = 0; i < abstractCount; ++i) {
                Object abstractItem = abstractList.get(i);
                if (abstractItem == null) continue;
                if (((String)abstractItem).length() > 100) {
                    abstractItem = ((String)abstractItem).substring(0, 100);
                }
                abstractListAdjust.add((String)abstractItem);
            }
        }
        for (V2TIMMessage v2TIMMessage : messageList) {
            if (2 != v2TIMMessage.getStatus()) {
                IMLog.e("V2TIMMessageManagerImpl", "message status must be V2TIM_MSG_STATUS_SEND_SUCC");
                return null;
            }
            if (9 != v2TIMMessage.getElemType()) continue;
            IMLog.e("V2TIMMessageManagerImpl", "group tips message is not support");
            return null;
        }
        if (null == compatibleText) {
            IMLog.e("V2TIMMessageManagerImpl", "compatibleText invalid, compatibleText cannot be null");
            return null;
        }
        MergerElement mergerElement = new MergerElement();
        mergerElement.setTitle(title);
        mergerElement.setAbstractList(abstractListAdjust);
        mergerElement.setCompatibleText(compatibleText);
        ArrayList<Message> nativeMessageList = new ArrayList<Message>();
        for (V2TIMMessage v2TIMMessage : messageList) {
            nativeMessageList.add(v2TIMMessage.getMessage());
        }
        mergerElement.setMessageList(nativeMessageList);
        V2TIMMessage v2TIMMessage = new V2TIMMessage();
        Message message = v2TIMMessage.getMessage();
        message.addElement(mergerElement);
        message.setForward(true);
        return v2TIMMessage;
    }

    @Override
    public V2TIMMessage createForwardMessage(V2TIMMessage message) {
        if (message == null) {
            IMLog.e("V2TIMMessageManagerImpl", "createForwardMessage, message cannot be null");
            return null;
        }
        if (2 != message.getStatus()) {
            IMLog.e("V2TIMMessageManagerImpl", "message status must be V2TIM_MSG_STATUS_SEND_SUCC");
            return null;
        }
        if (9 == message.getElemType()) {
            IMLog.e("V2TIMMessageManagerImpl", "group tips message is not support");
            return null;
        }
        V2TIMMessage v2TIMMessage = new V2TIMMessage();
        Message nativeMessage = v2TIMMessage.getMessage();
        nativeMessage.setMessageBaseElements(message.getMessage().getMessageBaseElements());
        nativeMessage.setForward(true);
        return v2TIMMessage;
    }

    @Override
    public V2TIMMessage createTargetedGroupMessage(V2TIMMessage message, List<String> receiverList) {
        if (message == null) {
            IMLog.e("V2TIMMessageManagerImpl", "createTargetedGroupMessage, message cannot be null");
            return null;
        }
        if (receiverList == null || receiverList.isEmpty()) {
            IMLog.e("V2TIMMessageManagerImpl", "receiverList cannot be empty");
            return null;
        }
        List<String> atUserList = message.getGroupAtUserList();
        if (atUserList != null && !atUserList.isEmpty()) {
            IMLog.e("V2TIMMessageManagerImpl", "targeted group message does not support at message");
            return null;
        }
        message.getMessage().setTargetGroupMemberList(receiverList);
        return message;
    }

    @Override
    public String sendMessage(final V2TIMMessage v2TIMMessage, String receiver, String groupID, int priority, boolean onlineUserOnly, V2TIMOfflinePushInfo offlinePushInfo, final V2TIMSendCallback<V2TIMMessage> sendCallback) {
        if (v2TIMMessage == null) {
            if (sendCallback != null) {
                sendCallback.onError(6017, "message is null");
            }
            return null;
        }
        if (TextUtils.isEmpty((CharSequence)receiver) && TextUtils.isEmpty((CharSequence)groupID)) {
            if (sendCallback != null) {
                sendCallback.onError(6017, "receiver and groupID cannot be empty at the same time!");
            }
            return null;
        }
        Message message = v2TIMMessage.getMessage();
        if (!TextUtils.isEmpty((CharSequence)groupID)) {
            message.setMessageType(Message.MESSAGE_TYPE_GROUP);
            message.setGroupID(groupID);
            List<String> targetGroupMemberList = message.getTargetGroupMemberList();
            if (!TextUtils.isEmpty((CharSequence)receiver) && (targetGroupMemberList == null || message.getTargetGroupMemberList().isEmpty())) {
                List<String> atUserList = v2TIMMessage.getGroupAtUserList();
                if (atUserList != null && !atUserList.isEmpty()) {
                    if (sendCallback != null) {
                        sendCallback.onError(6017, "targeted group message does not support group @ message");
                    }
                    return null;
                }
                ArrayList<String> targetList = new ArrayList<String>();
                targetList.add(receiver);
                message.setTargetGroupMemberList(targetList);
            }
        } else {
            message.setMessageType(Message.MESSAGE_TYPE_C2C);
            message.setReceiverUserID(receiver);
        }
        message.setPriority(priority);
        if (onlineUserOnly) {
            message.setLifeTime(0);
        }
        if (offlinePushInfo != null) {
            message.setOfflinePushInfo(offlinePushInfo.getMessageOfflinePushInfo());
        }
        message.setPlatform(Message.PLATFORM_ANDROID);
        MessageUploadProgressCallback progressCallback = new MessageUploadProgressCallback(){

            @Override
            public void onUploadProgress(int elemIndex, final int currentSize, final int totalSize) {
                IMContext.getInstance().runOnMainThread(new Runnable(){

                    @Override
                    public void run() {
                        if (sendCallback != null) {
                            int progress = 0;
                            if (totalSize > 0) {
                                float decimalProgress = (float)currentSize / (float)totalSize;
                                progress = (int)(decimalProgress * 100.0f);
                            }
                            sendCallback.onProgress(progress);
                        }
                    }
                });
            }
        };
        V2TIMValueCallback<Message> v2TIMValueCallback = new V2TIMValueCallback<Message>(){

            @Override
            public void onSuccess(Message message) {
                if (sendCallback != null) {
                    v2TIMMessage.setMessage(message);
                    sendCallback.onSuccess(v2TIMMessage);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (sendCallback != null) {
                    sendCallback.onError(code, desc);
                }
            }
        };
        String messageID = MessageCenter.getInstance().sendMessage(message, progressCallback, new IMCallback(v2TIMValueCallback){

            public void success(Object data) {
                Message message = v2TIMMessage.getMessage();
                message.update((Message)data);
                super.success(data);
            }

            public void fail(int code, String errorMessage, Object data) {
                Message message = v2TIMMessage.getMessage();
                message.update((Message)data);
                super.fail(code, errorMessage, data);
            }
        });
        BaseManager.getInstance().checkTUIComponent(3);
        return messageID;
    }

    @Override
    public void setC2CReceiveMessageOpt(List<String> userIDList, int opt, V2TIMCallback callback) {
        if (userIDList == null || userIDList.size() == 0) {
            if (callback != null) {
                callback.onError(6017, "invalid userIDList");
            }
            return;
        }
        int receive_option = 1;
        if (opt == 0) {
            receive_option = 1;
        } else if (opt == 1) {
            receive_option = 2;
        } else if (opt == 2) {
            receive_option = 3;
        } else {
            IMLog.e("V2TIMMessageManagerImpl", "setC2CReceiveMessageOpt error opt = " + opt);
            if (callback != null) {
                callback.onError(6017, "opt is error");
            }
            return;
        }
        RelationshipManager.getInstance().setC2CReceiveMessageOpt(userIDList, receive_option, new IMCallback(callback){

            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void getC2CReceiveMessageOpt(List<String> userIDList, final V2TIMValueCallback<List<V2TIMReceiveMessageOptInfo>> callback) {
        if (userIDList == null || userIDList.size() == 0) {
            if (callback != null) {
                callback.onError(6017, "invalid userIDList");
            }
            return;
        }
        V2TIMValueCallback<List<ReceiveMessageOptInfo>> v2Callback = new V2TIMValueCallback<List<ReceiveMessageOptInfo>>(){

            @Override
            public void onSuccess(List<ReceiveMessageOptInfo> userInfos) {
                if (callback != null) {
                    ArrayList<V2TIMReceiveMessageOptInfo> v2UserInfoList = new ArrayList<V2TIMReceiveMessageOptInfo>();
                    for (ReceiveMessageOptInfo item : userInfos) {
                        V2TIMReceiveMessageOptInfo v2UserInfo = new V2TIMReceiveMessageOptInfo();
                        v2UserInfo.setUserID(item.getUserID());
                        v2UserInfo.setC2CReceiveMessageOpt(item.getC2CReceiveMessageOpt());
                        v2UserInfoList.add(v2UserInfo);
                    }
                    callback.onSuccess(v2UserInfoList);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        RelationshipManager.getInstance().getC2CReceiveMessageOpt(userIDList, new IMCallback<List<ReceiveMessageOptInfo>>((V2TIMValueCallback)v2Callback){

            @Override
            public void success(List<ReceiveMessageOptInfo> data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void setGroupReceiveMessageOpt(String groupID, int opt, V2TIMCallback callback) {
        if (TextUtils.isEmpty((CharSequence)groupID)) {
            IMLog.e("V2TIMMessageManagerImpl", "setReceiveMessageOpt err, groupID is empty");
            if (callback != null) {
                callback.onError(6017, "groupID is empty");
            }
            return;
        }
        int receive_option = GroupMemberInfo.MESSAGE_RECEIVE_OPTION_AUTO_RECEIVE;
        if (opt == 0) {
            receive_option = GroupMemberInfo.MESSAGE_RECEIVE_OPTION_AUTO_RECEIVE;
        } else if (opt == 1) {
            receive_option = GroupMemberInfo.MESSAGE_RECEIVE_OPTION_NOT_RECEIVE;
        } else if (opt == 2) {
            receive_option = GroupMemberInfo.MESSAGE_RECEIVE_OPTION_RECEIVE_WITH_NO_OFFLINE_PUSH;
        } else {
            IMLog.e("V2TIMMessageManagerImpl", "setReceiveMessageOpt error opt = " + opt);
            if (callback != null) {
                callback.onError(6017, "opt is error");
            }
            return;
        }
        GroupManager.getInstance().setGroupReceiveMessageOpt(groupID, receive_option, new IMCallback(callback){

            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void getC2CHistoryMessageList(String userID, int count, V2TIMMessage lastMsg, final V2TIMValueCallback<List<V2TIMMessage>> callback) {
        if (TextUtils.isEmpty((CharSequence)userID) || count == 0) {
            if (callback != null) {
                callback.onError(6017, "userID is empty or count is 0");
            }
            return;
        }
        V2TIMValueCallback<List<Message>> v2TIMValueCallback = new V2TIMValueCallback<List<Message>>(){

            @Override
            public void onSuccess(List<Message> messageList) {
                ArrayList<V2TIMMessage> v2TIMMessageList = new ArrayList<V2TIMMessage>();
                for (Message message : messageList) {
                    V2TIMMessage v2TIMMessage = new V2TIMMessage();
                    v2TIMMessage.setMessage(message);
                    v2TIMMessageList.add(v2TIMMessage);
                }
                if (callback != null) {
                    callback.onSuccess(v2TIMMessageList);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        MessageKey messageKey = null;
        if (lastMsg != null) {
            messageKey = lastMsg.getMessage().getMessageKey();
        }
        MessageListGetOption messageListGetOption = new MessageListGetOption();
        messageListGetOption.setCount(count);
        messageListGetOption.setToOlderMessage(true);
        messageListGetOption.setGetCloudMessage(true);
        messageListGetOption.setMessageKey(messageKey);
        MessageCenter.getInstance().getC2CHistoryMessageList(userID, messageListGetOption, new IMCallback<List<Message>>((V2TIMValueCallback)v2TIMValueCallback){

            @Override
            public void success(List<Message> data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void getGroupHistoryMessageList(String groupID, int count, V2TIMMessage lastMsg, final V2TIMValueCallback<List<V2TIMMessage>> callback) {
        if (TextUtils.isEmpty((CharSequence)groupID) || count <= 0) {
            if (callback != null) {
                callback.onError(6017, "groupID is empty or count is 0");
            }
            return;
        }
        V2TIMValueCallback<List<Message>> v2TIMValueCallback = new V2TIMValueCallback<List<Message>>(){

            @Override
            public void onSuccess(List<Message> messageList) {
                ArrayList<V2TIMMessage> v2TIMMessageList = new ArrayList<V2TIMMessage>();
                for (Message message : messageList) {
                    V2TIMMessage v2TIMMessage = new V2TIMMessage();
                    v2TIMMessage.setMessage(message);
                    v2TIMMessageList.add(v2TIMMessage);
                }
                if (callback != null) {
                    callback.onSuccess(v2TIMMessageList);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        MessageKey messageKey = null;
        if (lastMsg != null) {
            messageKey = lastMsg.getMessage().getMessageKey();
        }
        MessageListGetOption messageListGetOption = new MessageListGetOption();
        messageListGetOption.setCount(count);
        messageListGetOption.setToOlderMessage(true);
        messageListGetOption.setGetCloudMessage(true);
        messageListGetOption.setMessageKey(messageKey);
        MessageCenter.getInstance().getGroupHistoryMessageList(groupID, messageListGetOption, new IMCallback<List<Message>>((V2TIMValueCallback)v2TIMValueCallback){

            @Override
            public void success(List<Message> data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void getHistoryMessageList(V2TIMMessageListGetOption option, final V2TIMValueCallback<List<V2TIMMessage>> callback) {
        if (option == null) {
            if (callback != null) {
                callback.onError(6017, "option is null");
            }
            return;
        }
        if (TextUtils.isEmpty((CharSequence)option.getUserID()) && TextUtils.isEmpty((CharSequence)option.getGroupID())) {
            if (callback != null) {
                callback.onError(6017, "groupID and userID cannot be null at the same time");
            }
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)option.getUserID()) && !TextUtils.isEmpty((CharSequence)option.getGroupID())) {
            if (callback != null) {
                callback.onError(6017, "groupID and userID cannot set at the same time");
            }
            return;
        }
        if (option.getCount() <= 0) {
            if (callback != null) {
                callback.onError(6017, "count less than 0");
            }
            return;
        }
        MessageListGetOption messageListGetOption = new MessageListGetOption();
        messageListGetOption.setCount(option.getCount());
        messageListGetOption.setGetTimeBegin(option.getGetTimeBegin());
        messageListGetOption.setGetTimePeriod(option.getGetTimePeriod());
        switch (option.getGetType()) {
            case 4: {
                messageListGetOption.setToOlderMessage(false);
                messageListGetOption.setGetCloudMessage(false);
                messageListGetOption.setMessageTypeList(option.getMessageTypeList());
                break;
            }
            case 3: {
                messageListGetOption.setToOlderMessage(true);
                messageListGetOption.setGetCloudMessage(false);
                messageListGetOption.setMessageTypeList(option.getMessageTypeList());
                break;
            }
            case 2: {
                messageListGetOption.setToOlderMessage(false);
                messageListGetOption.setGetCloudMessage(true);
                break;
            }
            case 1: {
                messageListGetOption.setToOlderMessage(true);
                messageListGetOption.setGetCloudMessage(true);
                break;
            }
            default: {
                if (callback != null) {
                    callback.onError(6017, "getType is invalid");
                }
                return;
            }
        }
        if (option.getLastMsg() != null) {
            messageListGetOption.setMessageKey(option.getLastMsg().getMessage().getMessageKey());
        } else if (!TextUtils.isEmpty((CharSequence)option.getGroupID()) && option.getLastMsgSeq() > 0L) {
            MessageKey messageKey = new MessageKey();
            messageKey.setSeq(option.getLastMsgSeq());
            messageListGetOption.setMessageKey(messageKey);
        }
        V2TIMValueCallback<List<Message>> v2TIMValueCallback = new V2TIMValueCallback<List<Message>>(){

            @Override
            public void onSuccess(List<Message> messageList) {
                ArrayList<V2TIMMessage> v2TIMMessageList = new ArrayList<V2TIMMessage>();
                for (Message message : messageList) {
                    V2TIMMessage v2TIMMessage = new V2TIMMessage();
                    v2TIMMessage.setMessage(message);
                    v2TIMMessageList.add(v2TIMMessage);
                }
                if (callback != null) {
                    callback.onSuccess(v2TIMMessageList);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        MessageKey messageKey = null;
        if (option.getLastMsg() != null) {
            messageKey = option.getLastMsg().getMessage().getMessageKey();
        }
        if (!TextUtils.isEmpty((CharSequence)option.getUserID())) {
            MessageCenter.getInstance().getC2CHistoryMessageList(option.getUserID(), messageListGetOption, new IMCallback<List<Message>>((V2TIMValueCallback)v2TIMValueCallback){

                @Override
                public void success(List<Message> data) {
                    super.success(data);
                }

                @Override
                public void fail(int code, String errorMessage) {
                    super.fail(code, errorMessage);
                }
            });
        } else {
            MessageCenter.getInstance().getGroupHistoryMessageList(option.getGroupID(), messageListGetOption, new IMCallback<List<Message>>((V2TIMValueCallback)v2TIMValueCallback){

                @Override
                public void success(List<Message> data) {
                    super.success(data);
                }

                @Override
                public void fail(int code, String errorMessage) {
                    super.fail(code, errorMessage);
                }
            });
        }
    }

    @Override
    public void revokeMessage(V2TIMMessage v2TIMMessage, V2TIMCallback callback) {
        if (v2TIMMessage == null) {
            if (callback != null) {
                callback.onError(6017, "msg is null");
            }
            return;
        }
        if (v2TIMMessage.getStatus() != 2) {
            if (callback != null) {
                callback.onError(6017, "msg status must be V2TIM_MSG_STATUS_SEND_SUCC");
            }
            return;
        }
        MessageCenter.getInstance().revokeMessage(v2TIMMessage.getMessage().getMessageKey(), new IMCallback(callback){

            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void markC2CMessageAsRead(String userID, V2TIMCallback callback) {
        if (TextUtils.isEmpty((CharSequence)userID)) {
            ConversationManager.getInstance().clearUnreadMessage(true, false, new IMCallback(callback){

                public void success(Object data) {
                    super.success(data);
                }

                @Override
                public void fail(int code, String errorMessage) {
                    super.fail(code, errorMessage);
                }
            });
        } else {
            MessageCenter.getInstance().setC2CMessageRead(userID, 0L, new IMCallback(callback){

                public void success(Object data) {
                    super.success(data);
                }

                @Override
                public void fail(int code, String errorMessage) {
                    super.fail(code, errorMessage);
                }
            });
        }
    }

    @Override
    public void markGroupMessageAsRead(String groupID, V2TIMCallback callback) {
        if (TextUtils.isEmpty((CharSequence)groupID)) {
            ConversationManager.getInstance().clearUnreadMessage(false, true, new IMCallback(callback){

                public void success(Object data) {
                    super.success(data);
                }

                @Override
                public void fail(int code, String errorMessage) {
                    super.fail(code, errorMessage);
                }
            });
        } else {
            MessageCenter.getInstance().setGroupMessageRead(groupID, 0L, new IMCallback(callback){

                public void success(Object data) {
                    super.success(data);
                }

                @Override
                public void fail(int code, String errorMessage) {
                    super.fail(code, errorMessage);
                }
            });
        }
    }

    @Override
    public void markAllMessageAsRead(V2TIMCallback callback) {
        ConversationManager.getInstance().clearUnreadMessage(true, true, new IMCallback(callback){

            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void deleteMessageFromLocalStorage(V2TIMMessage v2TIMMessage, V2TIMCallback callback) {
        if (v2TIMMessage == null) {
            if (callback != null) {
                callback.onError(6017, "message is null");
            }
            return;
        }
        MessageCenter.getInstance().deleteLocalMessage(v2TIMMessage.getMessage().getMessageKey(), new IMCallback(callback){

            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void deleteMessages(List<V2TIMMessage> messages, V2TIMCallback callback) {
        if (messages == null || messages.isEmpty()) {
            if (callback != null) {
                callback.onError(6017, "messages is invalid");
            }
            return;
        }
        ArrayList<MessageKey> messageKeyList = new ArrayList<MessageKey>();
        for (V2TIMMessage v2TIMMessage : messages) {
            messageKeyList.add(v2TIMMessage.getMessage().getMessageKey());
        }
        MessageCenter.getInstance().deleteCloudMessageList(messageKeyList, new IMCallback(callback){

            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void clearC2CHistoryMessage(String userID, V2TIMCallback callback) {
        if (TextUtils.isEmpty((CharSequence)userID)) {
            if (callback != null) {
                callback.onError(6017, "userID is empty");
            }
            return;
        }
        MessageCenter.getInstance().clearC2CHistoryMessage(userID, new IMCallback(callback){

            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void clearGroupHistoryMessage(String groupID, V2TIMCallback callback) {
        if (TextUtils.isEmpty((CharSequence)groupID)) {
            if (callback != null) {
                callback.onError(6017, "groupID is empty");
            }
            return;
        }
        MessageCenter.getInstance().clearGroupHistoryMessage(groupID, new IMCallback(callback){

            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public String insertGroupMessageToLocalStorage(final V2TIMMessage v2TIMMessage, String groupID, String sender, final V2TIMValueCallback<V2TIMMessage> callback) {
        if (v2TIMMessage == null) {
            if (callback != null) {
                callback.onError(6017, "message is null!");
            }
            return "";
        }
        if (TextUtils.isEmpty((CharSequence)groupID)) {
            if (callback != null) {
                callback.onError(6017, "groupID is empty");
            }
            return "";
        }
        if (TextUtils.isEmpty((CharSequence)sender)) {
            if (callback != null) {
                callback.onError(6017, "sender is empty");
            }
            return "";
        }
        Message message = v2TIMMessage.getMessage();
        message.setMessageType(Message.MESSAGE_TYPE_GROUP);
        message.setSenderUserID(sender);
        message.setGroupID(groupID);
        V2TIMValueCallback<Message> v2TIMValueCallback = new V2TIMValueCallback<Message>(){

            @Override
            public void onSuccess(Message message) {
                if (callback != null) {
                    v2TIMMessage.setMessage(message);
                    callback.onSuccess(v2TIMMessage);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        String messageID = MessageCenter.getInstance().insertLocalMessage(message, new IMCallback(v2TIMValueCallback){

            public void success(Object data) {
                Message message = v2TIMMessage.getMessage();
                message.update((Message)data);
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
        return messageID;
    }

    @Override
    public String insertC2CMessageToLocalStorage(final V2TIMMessage v2TIMMessage, String userID, String sender, final V2TIMValueCallback<V2TIMMessage> callback) {
        if (v2TIMMessage == null) {
            if (callback != null) {
                callback.onError(6017, "message is null!");
            }
            return "";
        }
        if (TextUtils.isEmpty((CharSequence)userID)) {
            if (callback != null) {
                callback.onError(6017, "userID is empty");
            }
            return "";
        }
        if (TextUtils.isEmpty((CharSequence)sender)) {
            if (callback != null) {
                callback.onError(6017, "sender is empty");
            }
            return "";
        }
        Message message = v2TIMMessage.getMessage();
        message.setMessageType(Message.MESSAGE_TYPE_C2C);
        message.setSenderUserID(sender);
        message.setReceiverUserID(userID);
        V2TIMValueCallback<Message> v2TIMValueCallback = new V2TIMValueCallback<Message>(){

            @Override
            public void onSuccess(Message message) {
                if (callback != null) {
                    v2TIMMessage.setMessage(message);
                    callback.onSuccess(v2TIMMessage);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        String messageID = MessageCenter.getInstance().insertLocalMessage(message, new IMCallback(v2TIMValueCallback){

            public void success(Object data) {
                Message message = v2TIMMessage.getMessage();
                message.update((Message)data);
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
        return messageID;
    }

    @Override
    public void findMessages(List<String> messageIDList, final V2TIMValueCallback<List<V2TIMMessage>> callback) {
        if (messageIDList == null || messageIDList.isEmpty()) {
            if (callback != null) {
                callback.onError(6017, "messages is empty");
            }
            return;
        }
        V2TIMValueCallback<List<Message>> v2TIMValueCallback = new V2TIMValueCallback<List<Message>>(){

            @Override
            public void onSuccess(List<Message> messageList) {
                ArrayList<V2TIMMessage> v2TIMMessageList = new ArrayList<V2TIMMessage>();
                for (Message message : messageList) {
                    V2TIMMessage v2TIMMessage = new V2TIMMessage();
                    v2TIMMessage.setMessage(message);
                    v2TIMMessageList.add(v2TIMMessage);
                }
                if (callback != null) {
                    callback.onSuccess(v2TIMMessageList);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        MessageCenter.getInstance().findMessageByMessageId(messageIDList, new IMCallback<List<Message>>((V2TIMValueCallback)v2TIMValueCallback){

            @Override
            public void success(List<Message> data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void searchLocalMessages(V2TIMMessageSearchParam param, final V2TIMValueCallback<V2TIMMessageSearchResult> callback) {
        if (param.getSearchTimePosition() < 0L || param.getSearchTimePeriod() < 0L) {
            if (callback != null) {
                callback.onError(6017, "time < 0");
            }
            return;
        }
        if (param.getPageIndex() < 0 || param.getPageSize() < 0) {
            if (callback != null) {
                callback.onError(6017, "pageIndex or pageSize is invalid");
            }
            return;
        }
        V2TIMValueCallback<MessageSearchResult> v2TIMValueCallback = new V2TIMValueCallback<MessageSearchResult>(){

            @Override
            public void onSuccess(MessageSearchResult messageSearchResult) {
                V2TIMMessageSearchResult v2TIMMessageSearchResult = new V2TIMMessageSearchResult();
                v2TIMMessageSearchResult.setMessageSearchResult(messageSearchResult);
                if (callback != null) {
                    callback.onSuccess(v2TIMMessageSearchResult);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        MessageCenter.getInstance().findMessageBySearchKey(param.getMessageSearchParam(), new IMCallback<MessageSearchResult>((V2TIMValueCallback)v2TIMValueCallback){

            @Override
            public void success(MessageSearchResult data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
        BaseManager.getInstance().checkTUIComponent(6);
    }

    @Override
    public void sendMessageReadReceipts(final List<V2TIMMessage> messageList, final V2TIMCallback callback) {
        if (messageList == null || 0 == messageList.size()) {
            if (callback != null) {
                callback.onError(6017, "invalid messageList");
            }
            return;
        }
        ArrayList<MessageKey> messageKeyList = new ArrayList<MessageKey>();
        for (V2TIMMessage v2TIMMessage : messageList) {
            Message message;
            if (null == v2TIMMessage || null == v2TIMMessage.getGroupID() || 0 == v2TIMMessage.getGroupID().length() || v2TIMMessage.isSelf() || !v2TIMMessage.isNeedReadReceipt() || (message = v2TIMMessage.getMessage()).isHasSentReceipt()) continue;
            MessageKey messageKey = message.getMessageKey();
            messageKeyList.add(messageKey);
        }
        if (0 == messageKeyList.size()) {
            if (callback != null) {
                callback.onSuccess();
            }
            return;
        }
        V2TIMCallback v2TIMCallback = new V2TIMCallback(){

            @Override
            public void onSuccess() {
                if (callback != null) {
                    callback.onSuccess();
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        MessageCenter.getInstance().sendGroupMessageReceipts(messageKeyList, new IMCallback(v2TIMCallback){

            public void success(Object data) {
                for (V2TIMMessage v2TIMMessage : messageList) {
                    Message message = v2TIMMessage.getMessage();
                    message.setHasSentReceipt(true);
                }
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void getMessageReadReceipts(final List<V2TIMMessage> messageList, final V2TIMValueCallback<List<V2TIMMessageReceipt>> callback) {
        if (messageList == null || 0 == messageList.size()) {
            if (callback != null) {
                callback.onError(6017, "invalid message list");
            }
            return;
        }
        ArrayList<MessageKey> messageKeyList = new ArrayList<MessageKey>();
        final ArrayList<V2TIMMessageReceipt> results = new ArrayList<V2TIMMessageReceipt>();
        for (V2TIMMessage v2TIMMessage : messageList) {
            if (null == v2TIMMessage || null == v2TIMMessage.getGroupID() || 0 == v2TIMMessage.getGroupID().length() || !v2TIMMessage.isSelf() || 2 != v2TIMMessage.getStatus() || !v2TIMMessage.isNeedReadReceipt()) continue;
            Message message = v2TIMMessage.getMessage();
            if (0 == message.getReceiptUnreadCount()) {
                GroupMessageReceipt receipt = new GroupMessageReceipt();
                receipt.setGroupID(message.getGroupID());
                receipt.setMsgID(message.getMsgID());
                receipt.setReadCount(message.getReceiptReadCount());
                receipt.setUnreadCount(message.getReceiptUnreadCount());
                V2TIMMessageReceipt v2Receipt = new V2TIMMessageReceipt();
                v2Receipt.setGroupMessageReceipt(receipt);
                results.add(v2Receipt);
                continue;
            }
            MessageKey messageKey = message.getMessageKey();
            messageKeyList.add(messageKey);
        }
        if (0 == messageKeyList.size()) {
            if (results.size() > 0) {
                if (callback != null) {
                    callback.onSuccess(results);
                }
            } else if (callback != null) {
                callback.onError(6017, "invalid messages");
            }
            return;
        }
        V2TIMValueCallback<List<GroupMessageReceipt>> v2TIMValueCallback = new V2TIMValueCallback<List<GroupMessageReceipt>>(){

            @Override
            public void onSuccess(List<GroupMessageReceipt> groupMessageReceipts) {
                for (GroupMessageReceipt receipt : groupMessageReceipts) {
                    V2TIMMessageReceipt v2Receipt = new V2TIMMessageReceipt();
                    v2Receipt.setGroupMessageReceipt(receipt);
                    results.add(v2Receipt);
                }
                if (callback != null) {
                    callback.onSuccess(results);
                }
            }

            @Override
            public void onError(int code, String desc) {
                IMLog.e("V2TIMMessageManagerImpl", "get group message receipts from server failed, code:" + code + ", desc:" + desc + ", return the local group message receipts");
                results.clear();
                for (V2TIMMessage v2TIMMessage : messageList) {
                    Message message = v2TIMMessage.getMessage();
                    GroupMessageReceipt receipt = new GroupMessageReceipt();
                    receipt.setGroupID(message.getGroupID());
                    receipt.setMsgID(message.getMsgID());
                    receipt.setReadCount(message.getReceiptReadCount());
                    receipt.setUnreadCount(message.getReceiptUnreadCount());
                    V2TIMMessageReceipt v2Receipt = new V2TIMMessageReceipt();
                    v2Receipt.setGroupMessageReceipt(receipt);
                    results.add(v2Receipt);
                }
                if (callback != null) {
                    callback.onSuccess(results);
                }
            }
        };
        MessageCenter.getInstance().getGroupMessageReceipts(messageKeyList, new IMCallback<List<GroupMessageReceipt>>((V2TIMValueCallback)v2TIMValueCallback){

            @Override
            public void success(List<GroupMessageReceipt> data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void getGroupMessageReadMemberList(V2TIMMessage v2TIMMessage, final int filter, long nextSeq, int count, final V2TIMValueCallback<V2TIMGroupMessageReadMemberList> callback) {
        if (null == v2TIMMessage || null == v2TIMMessage.getGroupID() || 0 == v2TIMMessage.getGroupID().length() || !v2TIMMessage.isSelf() || 2 != v2TIMMessage.getStatus() || !v2TIMMessage.isNeedReadReceipt()) {
            if (callback != null) {
                callback.onError(6017, "invalid message");
            }
            return;
        }
        if (count > 100) {
            if (callback != null) {
                callback.onError(6017, "invalid count, maximum support 100");
            }
            return;
        }
        Message message = v2TIMMessage.getMessage();
        V2TIMValueCallback<GroupMessageReadMembers> v2TIMValueCallback = new V2TIMValueCallback<GroupMessageReadMembers>(){

            @Override
            public void onSuccess(GroupMessageReadMembers readMembers) {
                if (callback != null) {
                    V2TIMGroupMessageReadMemberList v2ReadMembers = new V2TIMGroupMessageReadMemberList();
                    v2ReadMembers.setMessageReadMembers(readMembers, filter);
                    callback.onSuccess(v2ReadMembers);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        MessageCenter.getInstance().getGroupMessageReadMembers(message, filter, nextSeq, count, new IMCallback<GroupMessageReadMembers>((V2TIMValueCallback)v2TIMValueCallback){

            @Override
            public void success(GroupMessageReadMembers data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    private static class V2TIMMessageManagerImplHolder {
        private static final V2TIMMessageManagerImpl v2TIMMessageManagerImpl = new V2TIMMessageManagerImpl();

        private V2TIMMessageManagerImplHolder() {
        }
    }
}

