/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.imsdk.v2;

import android.text.TextUtils;
import com.tencent.imsdk.common.IMCallback;
import com.tencent.imsdk.common.IMContext;
import com.tencent.imsdk.manager.BaseManager;
import com.tencent.imsdk.relationship.FriendApplication;
import com.tencent.imsdk.relationship.FriendApplicationResult;
import com.tencent.imsdk.relationship.FriendCheckResult;
import com.tencent.imsdk.relationship.FriendGroup;
import com.tencent.imsdk.relationship.FriendInfo;
import com.tencent.imsdk.relationship.FriendInfoResult;
import com.tencent.imsdk.relationship.FriendOperationResult;
import com.tencent.imsdk.relationship.FriendResponse;
import com.tencent.imsdk.relationship.FriendshipListener;
import com.tencent.imsdk.relationship.RelationshipManager;
import com.tencent.imsdk.relationship.UserInfo;
import com.tencent.imsdk.v2.V2TIMCallback;
import com.tencent.imsdk.v2.V2TIMFriendAddApplication;
import com.tencent.imsdk.v2.V2TIMFriendApplication;
import com.tencent.imsdk.v2.V2TIMFriendApplicationResult;
import com.tencent.imsdk.v2.V2TIMFriendCheckResult;
import com.tencent.imsdk.v2.V2TIMFriendGroup;
import com.tencent.imsdk.v2.V2TIMFriendInfo;
import com.tencent.imsdk.v2.V2TIMFriendInfoResult;
import com.tencent.imsdk.v2.V2TIMFriendOperationResult;
import com.tencent.imsdk.v2.V2TIMFriendSearchParam;
import com.tencent.imsdk.v2.V2TIMFriendshipListener;
import com.tencent.imsdk.v2.V2TIMFriendshipManager;
import com.tencent.imsdk.v2.V2TIMValueCallback;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class V2TIMFriendshipManagerImpl
extends V2TIMFriendshipManager {
    private final String TAG = "V2TIMFriendshipManagerImpl";
    private FriendshipListener mFriendshipInternalListener;
    private V2TIMFriendshipListener mV2TIMFriendshipListener;
    private final List<V2TIMFriendshipListener> mFriendshipListenerList = new ArrayList<V2TIMFriendshipListener>();

    static V2TIMFriendshipManagerImpl getInstance() {
        return V2TIMFriendshipManagerImplHolder.v2TIMFriendshipManagerImpl;
    }

    private V2TIMFriendshipManagerImpl() {
        this.initFriendshipListener();
    }

    @Override
    public void setFriendListener(final V2TIMFriendshipListener v2TIMFriendshipListener) {
        IMContext.getInstance().runOnMainThread(new Runnable(){

            @Override
            public void run() {
                if (V2TIMFriendshipManagerImpl.this.mV2TIMFriendshipListener != null) {
                    V2TIMFriendshipManagerImpl.this.mFriendshipListenerList.remove(V2TIMFriendshipManagerImpl.this.mV2TIMFriendshipListener);
                }
                if (v2TIMFriendshipListener != null) {
                    V2TIMFriendshipManagerImpl.this.mFriendshipListenerList.add(v2TIMFriendshipListener);
                }
                V2TIMFriendshipManagerImpl.this.mV2TIMFriendshipListener = v2TIMFriendshipListener;
            }
        });
    }

    @Override
    public void addFriendListener(final V2TIMFriendshipListener listener) {
        if (listener == null) {
            return;
        }
        IMContext.getInstance().runOnMainThread(new Runnable(){

            @Override
            public void run() {
                if (V2TIMFriendshipManagerImpl.this.mFriendshipListenerList.contains(listener)) {
                    return;
                }
                V2TIMFriendshipManagerImpl.this.mFriendshipListenerList.add(listener);
            }
        });
    }

    @Override
    public void removeFriendListener(final V2TIMFriendshipListener listener) {
        if (listener == null) {
            return;
        }
        IMContext.getInstance().runOnMainThread(new Runnable(){

            @Override
            public void run() {
                V2TIMFriendshipManagerImpl.this.mFriendshipListenerList.remove(listener);
            }
        });
    }

    @Override
    public void getFriendList(final V2TIMValueCallback<List<V2TIMFriendInfo>> callback) {
        V2TIMValueCallback<List<FriendInfo>> v2Callback = new V2TIMValueCallback<List<FriendInfo>>(){

            @Override
            public void onSuccess(List<FriendInfo> friendInfoList) {
                if (callback != null) {
                    ArrayList<V2TIMFriendInfo> v2TIMFriendInfoList = new ArrayList<V2TIMFriendInfo>();
                    for (FriendInfo friendInfo : friendInfoList) {
                        V2TIMFriendInfo v2TIMFriendInfo = new V2TIMFriendInfo();
                        v2TIMFriendInfo.setFriendInfo(friendInfo);
                        v2TIMFriendInfoList.add(v2TIMFriendInfo);
                    }
                    callback.onSuccess(v2TIMFriendInfoList);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        RelationshipManager.getInstance().getFriendList(new IMCallback<List<FriendInfo>>((V2TIMValueCallback)v2Callback){

            @Override
            public void success(List<FriendInfo> data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
        BaseManager.getInstance().checkTUIComponent(4);
    }

    @Override
    public void getFriendsInfo(List<String> userIDList, final V2TIMValueCallback<List<V2TIMFriendInfoResult>> callback) {
        if (userIDList == null || userIDList.isEmpty()) {
            if (callback != null) {
                callback.onError(6017, "userIDList is empty");
            }
            return;
        }
        V2TIMValueCallback<List<FriendInfoResult>> v2Callback = new V2TIMValueCallback<List<FriendInfoResult>>(){

            @Override
            public void onSuccess(List<FriendInfoResult> friendInfoResultList) {
                if (callback != null) {
                    ArrayList<V2TIMFriendInfoResult> v2TIMFriendInfoResultList = new ArrayList<V2TIMFriendInfoResult>();
                    for (FriendInfoResult friendInfoResult : friendInfoResultList) {
                        V2TIMFriendInfoResult v2TIMFriendInfoResult = new V2TIMFriendInfoResult();
                        v2TIMFriendInfoResult.setFriendInfoResult(friendInfoResult);
                        v2TIMFriendInfoResultList.add(v2TIMFriendInfoResult);
                    }
                    callback.onSuccess(v2TIMFriendInfoResultList);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        RelationshipManager.getInstance().getFriendsInfo(userIDList, new IMCallback<List<FriendInfoResult>>((V2TIMValueCallback)v2Callback){

            @Override
            public void success(List<FriendInfoResult> data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void setFriendInfo(V2TIMFriendInfo info, V2TIMCallback callback) {
        if (info == null) {
            if (callback != null) {
                callback.onError(6017, "info is null");
            }
            return;
        }
        RelationshipManager.getInstance().setFriendInfo(info.getUserID(), info.getModifyFriendInfo(), new IMCallback(callback){

            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void searchFriends(V2TIMFriendSearchParam searchParam, final V2TIMValueCallback<List<V2TIMFriendInfoResult>> callback) {
        if (searchParam == null) {
            if (callback != null) {
                callback.onError(6017, "searchParam is null");
            }
            return;
        }
        if (searchParam.getKeywordList() == null || searchParam.getKeywordList().size() == 0) {
            if (callback != null) {
                callback.onError(6017, "keywordList is empty");
            }
            return;
        }
        V2TIMValueCallback<List<FriendInfoResult>> v2Callback = new V2TIMValueCallback<List<FriendInfoResult>>(){

            @Override
            public void onSuccess(List<FriendInfoResult> friendInfoResultList) {
                if (callback != null) {
                    ArrayList<V2TIMFriendInfoResult> v2TIMFriendInfoResultList = new ArrayList<V2TIMFriendInfoResult>();
                    for (FriendInfoResult friendInfoResult : friendInfoResultList) {
                        V2TIMFriendInfoResult v2TIMFriendInfoResult = new V2TIMFriendInfoResult();
                        v2TIMFriendInfoResult.setFriendInfoResult(friendInfoResult);
                        v2TIMFriendInfoResultList.add(v2TIMFriendInfoResult);
                    }
                    callback.onSuccess(v2TIMFriendInfoResultList);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        RelationshipManager.getInstance().searchFriends(searchParam.getFriendSearchParam(), new IMCallback<List<FriendInfoResult>>((V2TIMValueCallback)v2Callback){

            @Override
            public void success(List<FriendInfoResult> data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
        BaseManager.getInstance().checkTUIComponent(6);
    }

    @Override
    public void addFriend(V2TIMFriendAddApplication application, final V2TIMValueCallback<V2TIMFriendOperationResult> callback) {
        if (application == null) {
            if (callback != null) {
                callback.onError(6017, "v2TIMFriendApplication is null");
            }
            return;
        }
        V2TIMValueCallback<FriendOperationResult> v2TIMValueCallback = new V2TIMValueCallback<FriendOperationResult>(){

            @Override
            public void onSuccess(FriendOperationResult friendOperationResult) {
                if (callback != null) {
                    V2TIMFriendOperationResult v2TIMFriendOperationResult = new V2TIMFriendOperationResult();
                    v2TIMFriendOperationResult.setFriendOperationResult(friendOperationResult);
                    callback.onSuccess(v2TIMFriendOperationResult);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        RelationshipManager.getInstance().addFriend(application.getFriendAddApplication(), new IMCallback<FriendOperationResult>((V2TIMValueCallback)v2TIMValueCallback){

            @Override
            public void success(FriendOperationResult data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void deleteFromFriendList(List<String> userIDList, int deleteType, final V2TIMValueCallback<List<V2TIMFriendOperationResult>> callback) {
        if (userIDList == null || userIDList.size() == 0) {
            if (callback != null) {
                callback.onError(6017, "userIDList maybe empty");
            }
            return;
        }
        if (deleteType != 1 && deleteType != 2) {
            if (callback != null) {
                callback.onError(6017, "deleteType is invalid : " + deleteType);
            }
            return;
        }
        V2TIMValueCallback<List<FriendOperationResult>> v2TIMValueCallback = new V2TIMValueCallback<List<FriendOperationResult>>(){

            @Override
            public void onSuccess(List<FriendOperationResult> friendOperationResults) {
                if (callback != null) {
                    ArrayList<V2TIMFriendOperationResult> v2TIMFriendInfoResultList = new ArrayList<V2TIMFriendOperationResult>();
                    for (FriendOperationResult friendOperationResult : friendOperationResults) {
                        V2TIMFriendOperationResult v2TIMFriendOperationResult = new V2TIMFriendOperationResult();
                        v2TIMFriendOperationResult.setFriendOperationResult(friendOperationResult);
                        v2TIMFriendInfoResultList.add(v2TIMFriendOperationResult);
                    }
                    callback.onSuccess(v2TIMFriendInfoResultList);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        RelationshipManager.getInstance().deleteFromFriendList(userIDList, deleteType, new IMCallback<List<FriendOperationResult>>((V2TIMValueCallback)v2TIMValueCallback){

            @Override
            public void success(List<FriendOperationResult> data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void checkFriend(List<String> userIDList, int checkType, final V2TIMValueCallback<List<V2TIMFriendCheckResult>> callback) {
        if (userIDList == null || userIDList.size() == 0) {
            if (callback != null) {
                callback.onError(6017, "userIDList maybe empty");
            }
            return;
        }
        if (checkType != 1 && checkType != 2) {
            if (callback != null) {
                callback.onError(6017, "checkType is invalid : " + checkType);
            }
            return;
        }
        V2TIMValueCallback<List<FriendCheckResult>> v2TIMValueCallback = new V2TIMValueCallback<List<FriendCheckResult>>(){

            @Override
            public void onSuccess(List<FriendCheckResult> friendCheckResults) {
                if (callback != null) {
                    ArrayList<V2TIMFriendCheckResult> v2FriendCheckResultList = new ArrayList<V2TIMFriendCheckResult>();
                    for (FriendCheckResult friendCheckResult : friendCheckResults) {
                        V2TIMFriendCheckResult v2TIMFriendCheckResult = new V2TIMFriendCheckResult();
                        v2TIMFriendCheckResult.setFriendCheckResult(friendCheckResult);
                        v2FriendCheckResultList.add(v2TIMFriendCheckResult);
                    }
                    callback.onSuccess(v2FriendCheckResultList);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        RelationshipManager.getInstance().checkFriend(userIDList, checkType, new IMCallback<List<FriendCheckResult>>((V2TIMValueCallback)v2TIMValueCallback){

            @Override
            public void success(List<FriendCheckResult> data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void getFriendApplicationList(final V2TIMValueCallback<V2TIMFriendApplicationResult> callback) {
        V2TIMValueCallback<FriendApplicationResult> v2TIMValueCallback = new V2TIMValueCallback<FriendApplicationResult>(){

            @Override
            public void onSuccess(FriendApplicationResult friendApplicationResult) {
                if (callback != null) {
                    V2TIMFriendApplicationResult v2TIMFriendApplicationResult = new V2TIMFriendApplicationResult();
                    v2TIMFriendApplicationResult.setFriendApplicationResult(friendApplicationResult);
                    callback.onSuccess(v2TIMFriendApplicationResult);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        RelationshipManager.getInstance().getFriendApplicationList(new IMCallback<FriendApplicationResult>((V2TIMValueCallback)v2TIMValueCallback){

            @Override
            public void success(FriendApplicationResult data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void acceptFriendApplication(V2TIMFriendApplication application, int responseType, final V2TIMValueCallback<V2TIMFriendOperationResult> callback) {
        if (responseType != 0 && responseType != 1) {
            if (callback != null) {
                callback.onError(6017, "responseType is invalid : " + responseType);
            }
            return;
        }
        if (application == null) {
            if (callback != null) {
                callback.onError(6017, "v2TIMFriendApplication is null");
            }
            return;
        }
        V2TIMValueCallback<FriendOperationResult> v2TIMValueCallback = new V2TIMValueCallback<FriendOperationResult>(){

            @Override
            public void onSuccess(FriendOperationResult friendOperationResult) {
                if (callback != null) {
                    V2TIMFriendOperationResult v2TIMFriendOperationResult = new V2TIMFriendOperationResult();
                    v2TIMFriendOperationResult.setFriendOperationResult(friendOperationResult);
                    callback.onSuccess(v2TIMFriendOperationResult);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        FriendResponse friendResponse = new FriendResponse();
        friendResponse.setUserID(application.getUserID());
        int internalResponseType = 0 == responseType ? 1 : 2;
        friendResponse.setResponseType(internalResponseType);
        RelationshipManager.getInstance().responseFriendApplication(friendResponse, new IMCallback<FriendOperationResult>((V2TIMValueCallback)v2TIMValueCallback){

            @Override
            public void success(FriendOperationResult data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void refuseFriendApplication(V2TIMFriendApplication application, final V2TIMValueCallback<V2TIMFriendOperationResult> callback) {
        if (application == null) {
            if (callback != null) {
                callback.onError(6017, "application is null");
            }
            return;
        }
        V2TIMValueCallback<FriendOperationResult> v2TIMValueCallback = new V2TIMValueCallback<FriendOperationResult>(){

            @Override
            public void onSuccess(FriendOperationResult friendOperationResult) {
                if (callback != null) {
                    V2TIMFriendOperationResult v2TIMFriendOperationResult = new V2TIMFriendOperationResult();
                    v2TIMFriendOperationResult.setFriendOperationResult(friendOperationResult);
                    callback.onSuccess(v2TIMFriendOperationResult);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        FriendResponse friendResponse = new FriendResponse();
        friendResponse.setUserID(application.getUserID());
        friendResponse.setResponseType(3);
        RelationshipManager.getInstance().responseFriendApplication(friendResponse, new IMCallback<FriendOperationResult>((V2TIMValueCallback)v2TIMValueCallback){

            @Override
            public void success(FriendOperationResult data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void deleteFriendApplication(V2TIMFriendApplication application, V2TIMCallback callback) {
        if (application == null) {
            if (callback != null) {
                callback.onError(6017, "application is null");
            }
            return;
        }
        if (TextUtils.isEmpty((CharSequence)application.getUserID())) {
            if (callback != null) {
                callback.onError(6017, "application userID is empty");
            }
            return;
        }
        RelationshipManager.getInstance().deleteFriendApplication(application.getType(), application.getUserID(), new IMCallback(callback){

            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void setFriendApplicationRead(V2TIMCallback callback) {
        RelationshipManager.getInstance().setFriendApplicationRead(new IMCallback(callback){

            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void addToBlackList(List<String> userIDList, final V2TIMValueCallback<List<V2TIMFriendOperationResult>> callback) {
        if (userIDList == null || userIDList.size() == 0) {
            if (callback != null) {
                callback.onError(6017, "userIDList is empty");
            }
            return;
        }
        V2TIMValueCallback<List<FriendOperationResult>> v2TIMValueCallback = new V2TIMValueCallback<List<FriendOperationResult>>(){

            @Override
            public void onSuccess(List<FriendOperationResult> friendOperationResultList) {
                if (callback != null) {
                    ArrayList<V2TIMFriendOperationResult> v2TIMFriendInfoResultList = new ArrayList<V2TIMFriendOperationResult>();
                    for (FriendOperationResult friendOperationResult : friendOperationResultList) {
                        V2TIMFriendOperationResult v2TIMFriendOperationResult = new V2TIMFriendOperationResult();
                        v2TIMFriendOperationResult.setFriendOperationResult(friendOperationResult);
                        v2TIMFriendInfoResultList.add(v2TIMFriendOperationResult);
                    }
                    callback.onSuccess(v2TIMFriendInfoResultList);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        RelationshipManager.getInstance().addToBlackList(userIDList, new IMCallback<List<FriendOperationResult>>((V2TIMValueCallback)v2TIMValueCallback){

            @Override
            public void success(List<FriendOperationResult> data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void deleteFromBlackList(List<String> userIDList, final V2TIMValueCallback<List<V2TIMFriendOperationResult>> callback) {
        if (userIDList == null || userIDList.size() == 0) {
            if (callback != null) {
                callback.onError(6017, "userIDList is empty");
            }
            return;
        }
        V2TIMValueCallback<List<FriendOperationResult>> v2TIMValueCallback = new V2TIMValueCallback<List<FriendOperationResult>>(){

            @Override
            public void onSuccess(List<FriendOperationResult> friendOperationResultList) {
                if (callback != null) {
                    ArrayList<V2TIMFriendOperationResult> v2TIMFriendInfoResultList = new ArrayList<V2TIMFriendOperationResult>();
                    for (FriendOperationResult friendOperationResult : friendOperationResultList) {
                        V2TIMFriendOperationResult v2TIMFriendOperationResult = new V2TIMFriendOperationResult();
                        v2TIMFriendOperationResult.setFriendOperationResult(friendOperationResult);
                        v2TIMFriendInfoResultList.add(v2TIMFriendOperationResult);
                    }
                    callback.onSuccess(v2TIMFriendInfoResultList);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        RelationshipManager.getInstance().deleteFromBlackList(userIDList, new IMCallback<List<FriendOperationResult>>((V2TIMValueCallback)v2TIMValueCallback){

            @Override
            public void success(List<FriendOperationResult> data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void getBlackList(final V2TIMValueCallback<List<V2TIMFriendInfo>> callback) {
        V2TIMValueCallback<List<FriendInfo>> v2Callback = new V2TIMValueCallback<List<FriendInfo>>(){

            @Override
            public void onSuccess(List<FriendInfo> friendInfoList) {
                if (callback != null) {
                    ArrayList<V2TIMFriendInfo> v2TIMFriendInfoList = new ArrayList<V2TIMFriendInfo>();
                    for (FriendInfo friendInfo : friendInfoList) {
                        V2TIMFriendInfo v2TIMFriendInfo = new V2TIMFriendInfo();
                        v2TIMFriendInfo.setFriendInfo(friendInfo);
                        v2TIMFriendInfoList.add(v2TIMFriendInfo);
                    }
                    callback.onSuccess(v2TIMFriendInfoList);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        RelationshipManager.getInstance().getBlackList(new IMCallback<List<FriendInfo>>((V2TIMValueCallback)v2Callback){

            @Override
            public void success(List<FriendInfo> data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void createFriendGroup(String groupName, List<String> userIDList, final V2TIMValueCallback<List<V2TIMFriendOperationResult>> callback) {
        if (groupName == null) {
            if (callback != null) {
                callback.onError(6017, "groupNames is empty");
            }
            return;
        }
        V2TIMValueCallback<List<FriendOperationResult>> v2TIMValueCallback = new V2TIMValueCallback<List<FriendOperationResult>>(){

            @Override
            public void onSuccess(List<FriendOperationResult> friendOperationResultList) {
                if (callback != null) {
                    ArrayList<V2TIMFriendOperationResult> v2TIMFriendInfoResultList = new ArrayList<V2TIMFriendOperationResult>();
                    for (FriendOperationResult friendOperationResult : friendOperationResultList) {
                        V2TIMFriendOperationResult v2TIMFriendOperationResult = new V2TIMFriendOperationResult();
                        v2TIMFriendOperationResult.setFriendOperationResult(friendOperationResult);
                        v2TIMFriendInfoResultList.add(v2TIMFriendOperationResult);
                    }
                    callback.onSuccess(v2TIMFriendInfoResultList);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        RelationshipManager.getInstance().createFriendGroup(groupName, userIDList, new IMCallback<List<FriendOperationResult>>((V2TIMValueCallback)v2TIMValueCallback){

            @Override
            public void success(List<FriendOperationResult> data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void getFriendGroups(List<String> groupNameList, final V2TIMValueCallback<List<V2TIMFriendGroup>> callback) {
        if (groupNameList != null && groupNameList.size() == 0) {
            groupNameList = null;
        }
        if (callback == null) {
            return;
        }
        V2TIMValueCallback<List<FriendGroup>> v2TIMValueCallback = new V2TIMValueCallback<List<FriendGroup>>(){

            @Override
            public void onSuccess(List<FriendGroup> friendGroupList) {
                if (callback != null) {
                    ArrayList<V2TIMFriendGroup> v2TIMFriendGroupList = new ArrayList<V2TIMFriendGroup>();
                    for (FriendGroup friendGroup : friendGroupList) {
                        V2TIMFriendGroup v2TIMFriendGroup = new V2TIMFriendGroup();
                        v2TIMFriendGroup.setFriendGroup(friendGroup);
                        v2TIMFriendGroupList.add(v2TIMFriendGroup);
                    }
                    callback.onSuccess(v2TIMFriendGroupList);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        RelationshipManager.getInstance().getFriendGroups(groupNameList, new IMCallback<List<FriendGroup>>((V2TIMValueCallback)v2TIMValueCallback){

            @Override
            public void success(List<FriendGroup> data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void deleteFriendGroup(List<String> groupNameList, V2TIMCallback callback) {
        if (groupNameList == null || groupNameList.size() == 0) {
            if (callback != null) {
                callback.onError(6017, "groupNames is empty");
            }
            return;
        }
        RelationshipManager.getInstance().deleteFriendGroup(groupNameList, new IMCallback(callback){

            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void renameFriendGroup(String oldName, String newName, V2TIMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.onError(6013, "sdk not init");
            }
            return;
        }
        if (TextUtils.isEmpty((CharSequence)newName)) {
            if (callback != null) {
                callback.onError(6017, "newName is empty");
            }
            return;
        }
        if (TextUtils.isEmpty((CharSequence)oldName)) {
            if (callback != null) {
                callback.onError(6017, "oldName is empty");
            }
            return;
        }
        RelationshipManager.getInstance().renameFriendGroup(oldName, newName, new IMCallback(callback){

            public void success(Object data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void addFriendsToFriendGroup(String groupName, List<String> userIDList, final V2TIMValueCallback<List<V2TIMFriendOperationResult>> callback) {
        if (TextUtils.isEmpty((CharSequence)groupName)) {
            if (callback != null) {
                callback.onError(6017, "groupName is empty");
            }
            return;
        }
        if (userIDList == null || userIDList.size() == 0) {
            if (callback != null) {
                callback.onError(6017, "userIDList is empty");
            }
            return;
        }
        V2TIMValueCallback<List<FriendOperationResult>> v2TIMValueCallback = new V2TIMValueCallback<List<FriendOperationResult>>(){

            @Override
            public void onSuccess(List<FriendOperationResult> friendOperationResultList) {
                if (callback != null) {
                    ArrayList<V2TIMFriendOperationResult> v2TIMFriendInfoResultList = new ArrayList<V2TIMFriendOperationResult>();
                    for (FriendOperationResult friendOperationResult : friendOperationResultList) {
                        V2TIMFriendOperationResult v2TIMFriendOperationResult = new V2TIMFriendOperationResult();
                        v2TIMFriendOperationResult.setFriendOperationResult(friendOperationResult);
                        v2TIMFriendInfoResultList.add(v2TIMFriendOperationResult);
                    }
                    callback.onSuccess(v2TIMFriendInfoResultList);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        RelationshipManager.getInstance().addFriendsToFriendGroup(groupName, userIDList, new IMCallback<List<FriendOperationResult>>((V2TIMValueCallback)v2TIMValueCallback){

            @Override
            public void success(List<FriendOperationResult> data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    @Override
    public void deleteFriendsFromFriendGroup(String groupName, List<String> userIDList, final V2TIMValueCallback<List<V2TIMFriendOperationResult>> callback) {
        if (TextUtils.isEmpty((CharSequence)groupName)) {
            if (callback != null) {
                callback.onError(6017, "groupName is empty");
            }
            return;
        }
        if (userIDList == null || userIDList.size() == 0) {
            if (callback != null) {
                callback.onError(6017, "userIDList is empty");
            }
            return;
        }
        V2TIMValueCallback<List<FriendOperationResult>> v2TIMValueCallback = new V2TIMValueCallback<List<FriendOperationResult>>(){

            @Override
            public void onSuccess(List<FriendOperationResult> friendOperationResultList) {
                if (callback != null) {
                    ArrayList<V2TIMFriendOperationResult> v2TIMFriendInfoResultList = new ArrayList<V2TIMFriendOperationResult>();
                    for (FriendOperationResult friendOperationResult : friendOperationResultList) {
                        V2TIMFriendOperationResult v2TIMFriendOperationResult = new V2TIMFriendOperationResult();
                        v2TIMFriendOperationResult.setFriendOperationResult(friendOperationResult);
                        v2TIMFriendInfoResultList.add(v2TIMFriendOperationResult);
                    }
                    callback.onSuccess(v2TIMFriendInfoResultList);
                }
            }

            @Override
            public void onError(int code, String desc) {
                if (callback != null) {
                    callback.onError(code, desc);
                }
            }
        };
        RelationshipManager.getInstance().deleteFrendsFromFriendGroup(groupName, userIDList, new IMCallback<List<FriendOperationResult>>((V2TIMValueCallback)v2TIMValueCallback){

            @Override
            public void success(List<FriendOperationResult> data) {
                super.success(data);
            }

            @Override
            public void fail(int code, String errorMessage) {
                super.fail(code, errorMessage);
            }
        });
    }

    private void initFriendshipListener() {
        this.mFriendshipInternalListener = new FriendshipListener(){

            V2TIMFriendInfo convertToV2FriendInfo(FriendInfo friendInfo) {
                V2TIMFriendInfo v2TIMFriendInfo = new V2TIMFriendInfo();
                if (friendInfo != null) {
                    v2TIMFriendInfo.setFriendInfo(friendInfo);
                }
                return v2TIMFriendInfo;
            }

            List<V2TIMFriendInfo> convertToV2FriendInfoList(List<FriendInfo> friendInfoList) {
                ArrayList<V2TIMFriendInfo> v2TIMFriendInfoList = new ArrayList<V2TIMFriendInfo>();
                for (FriendInfo friendInfo : friendInfoList) {
                    v2TIMFriendInfoList.add(this.convertToV2FriendInfo(friendInfo));
                }
                return v2TIMFriendInfoList;
            }

            @Override
            public void OnSelfInfoUpdated(UserInfo userInfo) {
            }

            @Override
            public void OnFriendInfoChanged(List<FriendInfo> friendInfoList) {
                List<V2TIMFriendInfo> v2TIMFriendInfoList = this.convertToV2FriendInfoList(friendInfoList);
                List<V2TIMFriendInfo> unmodifiableList = Collections.unmodifiableList(v2TIMFriendInfoList);
                for (V2TIMFriendshipListener listener : V2TIMFriendshipManagerImpl.this.mFriendshipListenerList) {
                    listener.onFriendInfoChanged(unmodifiableList);
                }
            }

            @Override
            public void OnFriendListAdded(List<FriendInfo> friendInfoList) {
                List<V2TIMFriendInfo> v2TIMFriendInfoList = this.convertToV2FriendInfoList(friendInfoList);
                List<V2TIMFriendInfo> unmodifiableList = Collections.unmodifiableList(v2TIMFriendInfoList);
                for (V2TIMFriendshipListener listener : V2TIMFriendshipManagerImpl.this.mFriendshipListenerList) {
                    listener.onFriendListAdded(unmodifiableList);
                }
            }

            @Override
            public void OnFriendListDeleted(List<String> userIDList) {
                List<String> unmodifiableList = Collections.unmodifiableList(userIDList);
                for (V2TIMFriendshipListener listener : V2TIMFriendshipManagerImpl.this.mFriendshipListenerList) {
                    listener.onFriendListDeleted(unmodifiableList);
                }
            }

            @Override
            public void OnBlackListAdded(List<FriendInfo> friendInfoList) {
                List<V2TIMFriendInfo> v2TIMFriendInfoList = this.convertToV2FriendInfoList(friendInfoList);
                List<V2TIMFriendInfo> unmodifiableList = Collections.unmodifiableList(v2TIMFriendInfoList);
                for (V2TIMFriendshipListener listener : V2TIMFriendshipManagerImpl.this.mFriendshipListenerList) {
                    listener.onBlackListAdd(unmodifiableList);
                }
            }

            @Override
            public void OnBlackListDeleted(List<String> userIDList) {
                List<String> unmodifiableList = Collections.unmodifiableList(userIDList);
                for (V2TIMFriendshipListener listener : V2TIMFriendshipManagerImpl.this.mFriendshipListenerList) {
                    listener.onBlackListDeleted(unmodifiableList);
                }
            }

            @Override
            public void OnFriendApplicationListAdded(List<FriendApplication> applicationList) {
                ArrayList<V2TIMFriendApplication> v2TIMFriendApplicationList = new ArrayList<V2TIMFriendApplication>();
                for (FriendApplication friendApplication : applicationList) {
                    V2TIMFriendApplication v2TIMFriendApplication = new V2TIMFriendApplication();
                    v2TIMFriendApplication.setFriendApplication(friendApplication);
                    v2TIMFriendApplicationList.add(v2TIMFriendApplication);
                }
                List<V2TIMFriendApplication> unmodifiableList = Collections.unmodifiableList(v2TIMFriendApplicationList);
                for (V2TIMFriendshipListener listener : V2TIMFriendshipManagerImpl.this.mFriendshipListenerList) {
                    listener.onFriendApplicationListAdded(unmodifiableList);
                }
            }

            @Override
            public void OnFriendApplicationListDelete(List<String> userIDList) {
                List<String> unmodifiableList = Collections.unmodifiableList(userIDList);
                for (V2TIMFriendshipListener listener : V2TIMFriendshipManagerImpl.this.mFriendshipListenerList) {
                    listener.onFriendApplicationListDeleted(unmodifiableList);
                }
            }

            @Override
            public void OnFriendApplicationListRead() {
                for (V2TIMFriendshipListener listener : V2TIMFriendshipManagerImpl.this.mFriendshipListenerList) {
                    listener.onFriendApplicationListRead();
                }
            }
        };
        RelationshipManager.getInstance().setFriendshipListener(this.mFriendshipInternalListener);
    }

    private static class V2TIMFriendshipManagerImplHolder {
        private static final V2TIMFriendshipManagerImpl v2TIMFriendshipManagerImpl = new V2TIMFriendshipManagerImpl();

        private V2TIMFriendshipManagerImplHolder() {
        }
    }
}

