/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.imsdk.manager;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import android.util.Log;
import com.tencent.imsdk.common.IMCallback;
import com.tencent.imsdk.common.IMContext;
import com.tencent.imsdk.common.IMLog;
import com.tencent.imsdk.common.NetworkInfoCenter;
import com.tencent.imsdk.common.SystemUtil;
import com.tencent.imsdk.conversation.ConversationManager;
import com.tencent.imsdk.group.GroupManager;
import com.tencent.imsdk.manager.CustomServerInfo;
import com.tencent.imsdk.manager.SDKConfig;
import com.tencent.imsdk.manager.SDKListener;
import com.tencent.imsdk.manager.UserPreference;
import com.tencent.imsdk.message.MessageCenter;
import com.tencent.imsdk.relationship.RelationshipManager;
import com.tencent.imsdk.relationship.UserInfo;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class BaseManager
implements NetworkInfoCenter.INetworkChangeListener {
    private static final String TAG = BaseManager.class.getSimpleName();
    public static final int TUI_COMPONENT_UNKNOWN = 0;
    public static final int TUI_COMPONENT_CORE = 1;
    public static final int TUI_COMPONENT_CONVERSATION = 2;
    public static final int TUI_COMPONENT_CHAT = 3;
    public static final int TUI_COMPONENT_CONTACT = 4;
    public static final int TUI_COMPONENT_GROUP = 5;
    public static final int TUI_COMPONENT_SEARCH = 6;
    private static final int TUI_COMPONENT_CHECK_COUNT_LIMIT = 5;
    private static final int TUI_COMPONENT_STACK_LAYER_LIMIT = 10;
    private boolean mInvokeFromTUIKit = false;
    private boolean mInvokeFromTUICore = false;
    List<Integer> mTUIComponentList = new ArrayList<Integer>();
    private HashMap<Integer, Integer> mTUIComponentCheckCountMap = new HashMap();
    private SDKConfig.NetworkInfo mLastNetworkInfo = new SDKConfig.NetworkInfo();
    private SDKConfig.ProxyInfo mProxyInfo = new SDKConfig.ProxyInfo();
    private WeakReference<SDKListener> sdkListenerWeakReference;
    private static boolean mLoadLibrarySuccess = false;
    private String mCustomUIPlatform = "";
    private boolean isInit = false;
    private boolean isTestEnvironment = false;
    private boolean isIPv6Prior = false;
    private UserPreference userPreference = new UserPreference();

    public static BaseManager getInstance() {
        return BaseManagerHolder.baseManager;
    }

    public boolean initSDK(Context context, SDKConfig sdkConfig, boolean needLogCallback, SDKListener listener) {
        if (!mLoadLibrarySuccess) {
            IMLog.e(TAG, "libimsdk.so is not loaded");
            return false;
        }
        if (sdkConfig.sdkAppId <= 0L) {
            IMLog.e(TAG, "invalid sdkAppID:" + sdkConfig.sdkAppId);
            return false;
        }
        if (null == context) {
            IMLog.e(TAG, "null context");
            return false;
        }
        if (this.isInit) {
            IMLog.w(TAG, "Has initSDK");
            return true;
        }
        String sdkVersion = this.nativeGetSDKVersion();
        String buglySdkAppID = "ebfa608d4d";
        SharedPreferences settings = context.getSharedPreferences("BuglySdkInfos", 0);
        SharedPreferences.Editor editor = settings.edit();
        editor.putString(buglySdkAppID, sdkVersion);
        editor.commit();
        IMContext.getInstance().init(context.getApplicationContext());
        NetworkInfoCenter.getInstance().init(context.getApplicationContext(), this);
        MessageCenter.getInstance().init();
        GroupManager.getInstance().init();
        ConversationManager.getInstance().init();
        RelationshipManager.getInstance().init();
        sdkConfig.sdkInitPath = SystemUtil.getSDKInitPath();
        sdkConfig.sdkInstanceType = SystemUtil.getInstanceType();
        sdkConfig.isTestEnvironment = this.isTestEnvironment;
        sdkConfig.isIPv6Prior = this.isIPv6Prior;
        sdkConfig.deviceInfo.deviceType = SystemUtil.getDeviceType();
        sdkConfig.deviceInfo.deviceId = SystemUtil.getDeviceID();
        sdkConfig.deviceInfo.deviceBrand = SystemUtil.getInstanceType();
        sdkConfig.deviceInfo.systemVersion = SystemUtil.getSystemVersion();
        sdkConfig.networkInfo.networkType = NetworkInfoCenter.getInstance().getNetworkType();
        sdkConfig.networkInfo.ipType = NetworkInfoCenter.getInstance().getIPType();
        sdkConfig.networkInfo.networkId = NetworkInfoCenter.getInstance().getNetworkID();
        sdkConfig.networkInfo.networkConnected = NetworkInfoCenter.getInstance().isNetworkConnected();
        sdkConfig.proxyInfo = this.mProxyInfo;
        sdkConfig.logSetting.enableConsoleLog = true;
        sdkConfig.logSetting.logFilePath = SystemUtil.getSDKLogPath();
        sdkConfig.uiPlatform = this.getUIPlatform();
        this.mLastNetworkInfo = sdkConfig.networkInfo;
        this.nativeInitSDK(sdkConfig, needLogCallback, listener);
        this.sdkListenerWeakReference = new WeakReference<SDKListener>(listener);
        this.reportTUIComponentUsage();
        this.isInit = true;
        return true;
    }

    public void unInitSDK() {
        this.nativeUninitSDK();
        this.mCustomUIPlatform = "";
        this.isInit = false;
        this.isTestEnvironment = false;
        this.isIPv6Prior = false;
        this.mLastNetworkInfo.clean();
        this.mProxyInfo.clean();
        this.mInvokeFromTUIKit = false;
        this.mInvokeFromTUICore = false;
        this.mTUIComponentList.clear();
        this.mTUIComponentCheckCountMap.clear();
    }

    private String getUIPlatform() {
        if (!TextUtils.isEmpty((CharSequence)this.mCustomUIPlatform)) {
            return this.mCustomUIPlatform;
        }
        this.mInvokeFromTUIKit = this.isTUIKit();
        boolean has_flutter = this.isFlutter();
        boolean has_unity = this.isUnity();
        if (has_flutter) {
            if (this.mInvokeFromTUIKit) {
                return "tuikit&flutter";
            }
            return "flutter";
        }
        if (has_unity) {
            if (this.mInvokeFromTUIKit) {
                return "tuikit&unity";
            }
            return "unity";
        }
        if (this.mInvokeFromTUIKit) {
            return "tuikit";
        }
        return "";
    }

    private boolean isTUIKit() {
        try {
            Class<?> classTUIKit = Class.forName("com.tencent.qcloud.tim.uikit.TUIKit");
            if (classTUIKit != null) {
                return true;
            }
        }
        catch (Exception classTUIKit) {
            // empty catch block
        }
        try {
            Class<?> classTUICore = Class.forName("com.tencent.qcloud.tuicore.TUICore");
            if (classTUICore != null) {
                return true;
            }
        }
        catch (ClassNotFoundException classTUICore) {
            // empty catch block
        }
        StackTraceElement[] stacks = Thread.currentThread().getStackTrace();
        String callName = "";
        for (int i = 0; i < stacks.length; ++i) {
            if (i > 15) {
                return false;
            }
            callName = stacks[i].getClassName();
            String lowerCaseCallName = callName.toLowerCase();
            if (!lowerCaseCallName.contains("tuikitimpl") && !lowerCaseCallName.contains("tuicore")) continue;
            return true;
        }
        return false;
    }

    private boolean isTUICore() {
        try {
            Class<?> classTUICore = Class.forName("com.tencent.qcloud.tuicore.TUICore");
            if (classTUICore != null) {
                return true;
            }
        }
        catch (ClassNotFoundException classTUICore) {
            // empty catch block
        }
        StackTraceElement[] stacks = Thread.currentThread().getStackTrace();
        String callName = "";
        for (int i = 0; i < stacks.length; ++i) {
            if (i > 15) {
                return false;
            }
            callName = stacks[i].getClassName();
            String lowerCaseCallName = callName.toLowerCase();
            if (!lowerCaseCallName.contains("tuicore")) continue;
            return true;
        }
        return false;
    }

    private boolean isFlutter() {
        try {
            Class<?> c = Class.forName("com.qq.qcloud.tencent_im_sdk_plugin.tencent_im_sdk_plugin");
            if (c != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean isUnity() {
        try {
            Class<?> c = Class.forName("com.qcloud.tencentimsdk.TencentImSDKPluginUnity");
            if (c != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void checkTUIComponent(int componentType) {
        if (!this.mInvokeFromTUICore) {
            return;
        }
        if (this.mTUIComponentList.contains(componentType)) {
            return;
        }
        if (!this.mTUIComponentCheckCountMap.containsKey(componentType)) {
            return;
        }
        String keyCallName = "";
        if (componentType == 2) {
            keyCallName = "conversationprovider";
        } else if (componentType == 3) {
            keyCallName = "chatprovider";
        } else if (componentType == 5) {
            keyCallName = "groupInfoprovider";
        } else if (componentType == 4) {
            keyCallName = "contactprovider";
        } else if (componentType == 6) {
            keyCallName = "searchdataprovider";
        } else {
            IMLog.e(TAG, "unknown tui component type:" + componentType);
            return;
        }
        int checkIndex = this.mTUIComponentCheckCountMap.get(componentType);
        if (checkIndex < 5) {
            this.mTUIComponentCheckCountMap.put(componentType, ++checkIndex);
            StackTraceElement[] stacks = Thread.currentThread().getStackTrace();
            String callName = "";
            for (int i = 0; i < stacks.length; ++i) {
                if (i >= 10) {
                    return;
                }
                callName = stacks[i].getClassName();
                String lowerCaseCallName = callName.toLowerCase();
                if (!lowerCaseCallName.contains(keyCallName)) continue;
                ArrayList<Integer> tuiComponentList = new ArrayList<Integer>();
                tuiComponentList.add(componentType);
                this.nativeReportTUIComponentUsage(tuiComponentList);
                this.mTUIComponentList.add(componentType);
                break;
            }
        }
    }

    private void reportTUIComponentUsage() {
        this.mInvokeFromTUICore = this.isTUICore();
        this.mTUIComponentCheckCountMap.put(2, 0);
        this.mTUIComponentCheckCountMap.put(3, 0);
        this.mTUIComponentCheckCountMap.put(4, 0);
        this.mTUIComponentCheckCountMap.put(5, 0);
        this.mTUIComponentCheckCountMap.put(6, 0);
        if (this.mInvokeFromTUIKit) {
            if (this.mInvokeFromTUICore) {
                this.mTUIComponentList.add(1);
                if (this.hasTUIConversation()) {
                    this.mTUIComponentList.add(2);
                }
                if (this.hasTUIChat()) {
                    this.mTUIComponentList.add(3);
                }
                if (this.hasTUIContact()) {
                    this.mTUIComponentList.add(4);
                }
                if (this.hasTUIGroup()) {
                    this.mTUIComponentList.add(5);
                }
                if (this.hasTUISearch()) {
                    this.mTUIComponentList.add(6);
                }
            } else {
                this.mTUIComponentList.add(0);
            }
            this.nativeReportTUIComponentUsage(this.mTUIComponentList);
        }
    }

    private boolean hasTUIConversation() {
        try {
            Class<?> c = Class.forName("com.tencent.qcloud.tuikit.tuiconversation.model.ConversationProvider");
            if (c != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean hasTUIChat() {
        try {
            Class<?> c = Class.forName("com.tencent.qcloud.tuikit.tuichat.model.ChatProvider");
            if (c != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean hasTUIContact() {
        try {
            Class<?> c = Class.forName("com.tencent.qcloud.tuikit.tuicontact.model.ContactProvider");
            if (c != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean hasTUIGroup() {
        try {
            Class<?> c = Class.forName("com.tencent.qcloud.tuikit.tuigroup.model.GroupInfoProvider");
            if (c != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean hasTUISearch() {
        try {
            Class<?> c = Class.forName("com.tencent.qcloud.tuikit.tuisearch.model.SearchDataProvider");
            if (c != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void login(String userID, String userSig, IMCallback callback) {
        if (!this.isInit) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeLogin(userID, userSig, callback);
    }

    public void logout(IMCallback callback) {
        if (!this.isInit) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeLogout(callback);
    }

    public boolean setLibraryPath(String libraryPath) {
        mLoadLibrarySuccess = SystemUtil.loadIMLibrary(libraryPath);
        return mLoadLibrarySuccess;
    }

    public void setCustomUIPlatform(String uiPlatform) {
        this.mCustomUIPlatform = uiPlatform;
    }

    public void setTestEnvironment(boolean testEnvironment) {
        this.isTestEnvironment = testEnvironment;
    }

    public void setIPv6Prior(boolean prior) {
        this.isIPv6Prior = prior;
    }

    public void setCustomServerInfo(CustomServerInfo customServerInfo) {
        this.nativeSetCustomServerInfo(customServerInfo);
    }

    public void setProxyInfo(SDKConfig.ProxyInfo proxyInfo) {
        this.mProxyInfo = proxyInfo;
    }

    public String getLoginUser() {
        if (!this.isInit) {
            Log.e((String)TAG, (String)"sdk not init");
            return null;
        }
        return this.nativeGetLoginUser();
    }

    public int getLoginStatus() {
        if (!this.isInit) {
            Log.e((String)TAG, (String)"sdk not init");
            return 3;
        }
        return this.nativeGetLoginStatus();
    }

    public String getVersion() {
        if (!this.isInit) {
            Log.e((String)TAG, (String)"sdk not init");
            return null;
        }
        return this.nativeGetSDKVersion();
    }

    public boolean isInited() {
        return this.isInit;
    }

    public long getClockTickInHz() {
        if (!this.isInit) {
            Log.e((String)TAG, (String)"sdk not init");
            return 0L;
        }
        return this.nativeGetClockTickInHz();
    }

    public long getTimeTick() {
        if (!this.isInit) {
            Log.e((String)TAG, (String)"sdk not init");
            return 0L;
        }
        return this.nativeGetTimeTick();
    }

    public long getServerTime() {
        if (!this.isInit) {
            Log.e((String)TAG, (String)"sdk not init");
            return 0L;
        }
        return this.nativeGetServerTime();
    }

    public void initLocalStorage(String userID, IMCallback callback) {
        if (!this.isInit) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeInitLocalStorage(userID, callback);
    }

    @Override
    public void onNetworkChange(boolean connected, int networkType, int ipType, String networkID) {
        if (connected == this.mLastNetworkInfo.networkConnected && networkType == this.mLastNetworkInfo.networkType && ipType == this.mLastNetworkInfo.ipType && null != networkID && networkID.equals(this.mLastNetworkInfo.networkId)) {
            Log.w((String)TAG, (String)"onNetworkChange, networkinfo is same");
            return;
        }
        this.mLastNetworkInfo.networkConnected = connected;
        this.mLastNetworkInfo.networkType = networkType;
        this.mLastNetworkInfo.ipType = ipType;
        this.mLastNetworkInfo.networkId = networkID;
        this.nativeNotifyNetworkChange(connected, networkType, ipType, networkID);
    }

    public void notifySelfInfoUpdated(UserInfo selfInfo) {
        SDKListener listener;
        if (this.sdkListenerWeakReference != null && (listener = (SDKListener)this.sdkListenerWeakReference.get()) != null) {
            listener.onSelfInfoUpdated(selfInfo);
        }
    }

    public void enableSignaling(boolean enable) {
        this.userPreference.setEnableSignaling(enable);
        this.nativeSetUserPreference(this.userPreference);
    }

    protected native void nativeInitSDK(SDKConfig var1, boolean var2, SDKListener var3);

    protected native void nativeUninitSDK();

    protected native void nativeNotifyNetworkChange(boolean var1, int var2, int var3, String var4);

    protected native void nativeLogin(String var1, String var2, IMCallback var3);

    protected native void nativeLogout(IMCallback var1);

    protected native void nativeSetCustomServerInfo(CustomServerInfo var1);

    protected native String nativeGetLoginUser();

    protected native int nativeGetLoginStatus();

    protected native String nativeGetSDKVersion();

    protected native long nativeGetClockTickInHz();

    protected native long nativeGetTimeTick();

    protected native long nativeGetServerTime();

    protected native void nativeInitLocalStorage(String var1, IMCallback var2);

    protected native void nativeReportTUIComponentUsage(List<Integer> var1);

    protected native void nativeSetUserPreference(UserPreference var1);

    static {
        try {
            mLoadLibrarySuccess = SystemUtil.loadIMLibrary();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)e.toString());
        }
    }

    private static class BaseManagerHolder {
        private static final BaseManager baseManager = new BaseManager();

        private BaseManagerHolder() {
        }
    }
}

