/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.transfer;

import com.tencent.cos.xml.CosXmlService;
import com.tencent.cos.xml.common.ResumeData;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.exception.CosXmlServiceException;
import com.tencent.cos.xml.model.CosXmlResult;
import com.tencent.cos.xml.model.CosXmlResultListener;
import com.tencent.cos.xml.model.object.AbortMultiUploadResult;
import com.tencent.cos.xml.transfer.MultipartUpload;
import com.tencent.qcloud.core.network.QCloudProgressListener;

public class MultipartUploadService {
    private static final String TAG = "MultipartUploadService";
    private MultipartUpload mCurrentMultipart;
    private long mSignExpiredTime = 600L;
    private CosXmlService mCosXmlService;

    public MultipartUploadService(CosXmlService cosXmlService) {
        this.mCosXmlService = cosXmlService;
        this.mCurrentMultipart = new MultipartUpload(cosXmlService, null);
    }

    public CosXmlService getCosXmlService() {
        return this.mCosXmlService;
    }

    public void setBucket(String bucket) {
        this.mCurrentMultipart.setBucket(bucket);
    }

    public String getBucket() {
        return this.mCurrentMultipart.getBucket();
    }

    public void setCosPath(String cosPath) {
        this.mCurrentMultipart.setCosPath(cosPath);
    }

    public void setSrcPath(String srcPath) {
        this.mCurrentMultipart.setSrcPath(srcPath);
    }

    public String getCosPath() {
        return this.mCurrentMultipart.getCosPath();
    }

    public String getSrcPath() {
        return this.mCurrentMultipart.getSrcPath();
    }

    public void setSliceSize(int sliceSize) {
        this.mCurrentMultipart.setSliceSize(sliceSize);
    }

    public long getSliceSize() {
        return this.mCurrentMultipart.getSliceSize();
    }

    public long getFileLength() {
        return this.mCurrentMultipart.getFileLength();
    }

    public void setProgressListener(QCloudProgressListener progressListener) {
        this.mCurrentMultipart.setProgressListener(progressListener);
    }

    public void setSign(long signExpiredTime) {
        this.mSignExpiredTime = signExpiredTime;
        this.mCurrentMultipart.setSign(signExpiredTime);
    }

    public QCloudProgressListener getProgressListener() {
        return this.mCurrentMultipart.getProgressListener();
    }

    public CosXmlResult upload() throws CosXmlClientException, CosXmlServiceException {
        return this.mCurrentMultipart.upload2();
    }

    public ResumeData cancel() {
        return this.mCurrentMultipart.cancel();
    }

    public void abortAsync(CosXmlResultListener cosXmlResultListener) {
        this.mCurrentMultipart.abortAsync(cosXmlResultListener);
    }

    public AbortMultiUploadResult abort() throws CosXmlClientException, CosXmlServiceException {
        return this.mCurrentMultipart.abort();
    }

    public CosXmlResult resume(ResumeData resumeData) throws Exception {
        if (resumeData != null) {
            MultipartUpload mNextMultipartUpload = new MultipartUpload(this.mCosXmlService, resumeData);
            mNextMultipartUpload.setProgressListener(this.mCurrentMultipart.getProgressListener());
            mNextMultipartUpload.setSign(this.mSignExpiredTime);
            this.mCurrentMultipart = mNextMultipartUpload;
            return mNextMultipartUpload.upload2();
        }
        return null;
    }

    public ResumeData getResumeDate() {
        return this.mCurrentMultipart.getResumeData();
    }
}

